/*!
  \file
  This is the header file for a CPUmaniple
*/

#ifndef SCIGPU_LEGION_CPUMANIPLE_HPP
#define SCIGPU_LEGION_CPUMANIPLE_HPP

#include "legion.hpp"

namespace SciGPU {

  namespace Legion {


    //! A Maniple for a CPU thread
    /*!
      This is a basic Maniple to perform \ref Task "Tasks"
      on a CPU.
      It implements the Maniple::ApproveType method to
      accept \ref Task "Tasks" of type AnyTask and CPUtask.
    */
    class CPUmaniple : public Maniple {
    public:
      //! Constructor
      CPUmaniple( void ) : Maniple() {};

      //! Destructor
      ~CPUmaniple( void ) {};

    protected:

      //! Method to select AnyTask and CPUtask objects
      virtual bool ApproveType( const Task& theTask );

    };

  }
}


#endif
