/*!
  \file
  File containing the CPUtask class declaration
*/

#ifndef SCIGPU_LEGION_CPUTASK_HPP
#define SCIGPU_LEGION_CPUTASK_HPP


#include "legion.hpp"

namespace SciGPU {

  namespace Legion {
    
    //! Abstract base class for tasks which will be run on a CPU
    /*!
      This abstract base class is for tasks which should only be
      run by a CPUmaniple class (or any others which decide to
      accept it).
      It does not define any extra members, and the constructor
      is a simple pass-through to the Task constructor.
    */
    class CPUtask : public Task {

    public:
      //! Constructor passes tag through to base Task
      CPUtask( TagType _tag=0 ) : Task(_tag) {} ;

      //! Destructor
      virtual ~CPUtask( void ) {};
    };

  }
}

#endif
