/*!
  \file
  This file contains documentation for the 'cudahello' example.
  It comtains some C++ code, to help Doxygen find its way around.
*/


namespace SciGPU {
  namespace Legion {


    /*!
      \page hellocuda "Hello World" for CUDA Legions

      \dontinclude cudahello.cpp

      We've considered several simple programs which perform
      work on a CPU.
      Next, we will look at \ref CUDAmaniple "CUDAmaniples"
      which control GPUs using CUDA.


      \section hellocudatask A simple CUDAtask

      We first need to define a CUDAtask which can
      print "Hello World."
      Tasks of this type will only be picked up
      by a CUDAmaniple.
      For such a simple case, this is quite straightforward:
      \skip class HelloTask
      \until };
      Apart from the change in parent class, this is
      identical to the class in the \ref hello "Hello World"
      example.


      \section cudamaniplecreate Creating the Maniples

      The CUDAmaniple class has an extra field, for the
      ID of the GPU controlled by its CUDA context.
      We have to set this when creating the \ref CUDAmaniple
      "CUDAmaniples" for the Legion
      \skip // Give the Legion some Maniples
      \until }
      This is a very simple choice - we set the IDs to be
      consecutive.
      If we create more \ref CUDAmaniple "CUDAmaniples" than
      there are GPUs available, some will fail to initialise.
      We can also have more than one CUDAmaniple controlling
      the same GPU, but each will have its own CUDA context
      (and hence be invisible to the other).
      This will not be possible if the GPU in question is set
      to \c compute-exclusive mode.


      \section cudaqueuetasks Queuing the Tasks

      We queue up the tasks as before:
      \skip // Declare the list of tasks
      \until }
      and then wait for completion.


      \section cudahellosample Sample Output
      
      Output from a sample run follows:
      \verbatim
$ ./examples/cudahello/HelloCUDA 
Legion CUDA Hello
=================

Maniple 0x3e98c40: Starting up
Maniple 0x3e989c0: Starting up
Maniple 0x3e98c40: Quadro FX 4800
Maniple 0x3e98c40: Hello from a thread!
Maniple 0x3e989c0: Tesla C1060
Maniple 0x3e989c0: Hello from a thread!
Maniple 0x3e98c40: Hello from a thread!
Maniple 0x3e989c0: Hello from a thread!
Maniple 0x3e98c40: Hello from a thread!
Maniple 0x3e989c0: Hello from a thread!
Maniple 0x3e98c40: Hello from a thread!
Maniple 0x3e989c0: Hello from a thread!
Maniple 0x3e98c40: Hello from a thread!
Maniple 0x3e989c0: Hello from a thread!
Maniple 0x3e98c40: Hello from a thread!
Maniple 0x3e989c0: Hello from a thread!
Maniple 0x3e98c40: Hello from a thread!
Maniple 0x3e989c0: Hello from a thread!
Maniple 0x3e98c40: Hello from a thread!
Maniple 0x3e989c0: Hello from a thread!
Maniple 0x3e98c40: Hello from a thread!
Maniple 0x3e989c0: Hello from a thread!
Maniple 0x3e98c40: Hello from a thread!
Maniple 0x3e989c0: Hello from a thread!
Press ENTER to exit

Maniple 0x3e98c40: Caught terminate signal
Maniple 0x3e989c0: Caught terminate signal
Maniple 0x3e98c40: Shutting down
Maniple 0x3e989c0: Shutting down
      \endverbatim
      Two \ref CUDAmaniple "CUDAmaniples" were created, along with
      a list of twenty tasks.
      Each maniple attached to a different GPU, and started running
      the list of tasks.
    */

  }
}
