/*!
  \file
  File containing the CUDAtask class declaration
*/

#ifndef SCIGPU_LEGION_CUDATASK_HPP
#define SCIGPU_LEGION_CUDATASK_HPP


#include "legion.hpp"

namespace SciGPU {

  namespace Legion {
    
    //! Abstract base class for tasks which will be run on a CUDAmaniple
    class CUDAtask : public Task {

    public:
      //! Constructor passes tag through to base Task
      CUDAtask( const TagType _tag=0,
		const boost::thread::id& _gpu = boost::thread::id() ) : Task(_tag),
									tid(_gpu) {} ;

      //! Destructor
      virtual ~CUDAtask( void ) {};

      //! Required CUDA maniple (use default for any)
      boost::thread::id tid;
    };

  }
}

#endif
