/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.cmdwin;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mde.cmdwin.CmdWinEditorKit;
import com.mathworks.mde.cmdwin.CmdWinExecuteServices;
import com.mathworks.mde.cmdwin.CmdWinMLIF;
import com.mathworks.mde.cmdwin.CmdWinPrefs;
import com.mathworks.mde.cmdwin.CmdWinSinkRegistrar;
import com.mathworks.mde.cmdwin.CmdWinStatusBar;
import com.mathworks.mde.cmdwin.CommandWindowRegistrar;
import com.mathworks.mde.cmdwin.FunctionBrowserRowHeader;
import com.mathworks.mde.cmdwin.XCaret;
import com.mathworks.mde.cmdwin.XCmdWndView;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.desk.MLMenuMergeTag;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlservices.MLExecutionListener;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.GlobalCursor;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.toolstrip.factory.ContextTargetingManager;
import com.mathworks.widgets.CloseableMessageBar;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.desk.DTClientAdapter;
import com.mathworks.widgets.desk.DTClientBase;
import com.mathworks.widgets.desk.DTClientEvent;
import com.mathworks.widgets.desk.DTClientListener;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTMenuMergeTag;
import com.mathworks.widgets.find.FindClientInterface;
import com.mathworks.widgets.find.FindDialog;
import com.mathworks.widgets.find.FindParentListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;

public class CmdWin
extends DTClientBase
implements PrefListener {
    private static XCmdWndView sCWView;
    private static CmdWinEditorKit sKit;
    private static CmdWinStatusBar sStatusBar;
    private JComponent fMsgBar;
    private final CmdWinSinkRegistrar cmdWinSinkRegistrar;
    private WindowAdapter desktopWindowListener = null;
    private static ResourceBundle sRes;
    private static ResourceBundle sMLRes;
    private static final CmdWin sCmdWin;

    private CmdWin() {
        Object object;
        sCWView = XCmdWndView.getInstance();
        MJScrollPane mJScrollPane = sCWView.getScrollPane();
        this.setLayout(new BorderLayout());
        mJScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)mJScrollPane, "Center");
        JScrollBar jScrollBar = mJScrollPane.getVerticalScrollBar();
        if (jScrollBar != null) {
            object = sCWView.getFunctionBrowserRowHeader();
            this.add((Component)object, "West");
            jScrollBar.addAdjustmentListener(new AdjustmentListener((FunctionBrowserRowHeader)object){
                final /* synthetic */ FunctionBrowserRowHeader val$functionBrowserRowHeader;
                {
                    this.val$functionBrowserRowHeader = functionBrowserRowHeader;
                }

                @Override
                public final void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                    if (sCWView.isVisible() && !adjustmentEvent.getValueIsAdjusting()) {
                        this.val$functionBrowserRowHeader.doLayout();
                    }
                }
            });
        }
        if (CmdWinPrefs.shouldShowStartingMessage()) {
            this.createInfoMessageBar();
            this.add(this.fMsgBar, "North");
        }
        Prefs.addListener((PrefListener)this, (String)"CommandWindowShowStartupMessage");
        sKit = CmdWinEditorKit.getInstance();
        sCWView.setEditorKit(sKit);
        if (CmdWinMLIF.isStudentVersion()) {
            object = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop").getString("title.CommandWindow");
            this.setShortTitle((String)object);
            this.setTitle(sRes.getString("title.StudentVersion") + " " + (String)object);
        }
        this.setHideTitleWhenSolo(true);
        if (MLDesktop.getInstance().useToolstrip()) {
            object = XCmdWndView.getCutAction();
            Action action = XCmdWndView.getCopyAction();
            Action action2 = XCmdWndView.getPasteAction();
            Action action3 = CmdWinEditorKit.getActionByName("undo");
            Action action4 = CmdWinEditorKit.getActionByName("redo");
            Action action5 = XCmdWndView.getSelectAllAction();
            Action action6 = XCmdWndView.getFindAction();
            Action action7 = CmdWinEditorKit.getActionByName("find-files");
            Action action8 = CmdWinEditorKit.getActionByName("print");
            Action action9 = CmdWinEditorKit.getActionByName("show-page-setup");
            Action action10 = XCmdWndView.getEvalSelAction();
            XCmdWndView.getOpenSelAction();
            ContextTargetingManager.setToolName((Action)object, (String)DTMenuMergeTag.CUT.toString());
            ContextTargetingManager.setToolName((Action)action, (String)DTMenuMergeTag.COPY.toString());
            ContextTargetingManager.setToolName((Action)action2, (String)DTMenuMergeTag.PASTE.toString());
            ContextTargetingManager.setToolName((Action)action3, (String)DTMenuMergeTag.UNDO.toString());
            ContextTargetingManager.setToolName((Action)action4, (String)DTMenuMergeTag.REDO.toString());
            ContextTargetingManager.setToolName((Action)action5, (String)DTMenuMergeTag.SELECT_ALL.toString());
            ContextTargetingManager.setToolName((Action)action6, (String)DTMenuMergeTag.FIND.toString());
            ContextTargetingManager.setToolName((Action)action7, (String)MLMenuMergeTag.FIND_FILES.toString());
            ContextTargetingManager.setToolName((Action)action8, (String)DTMenuMergeTag.PRINT.toString());
            ContextTargetingManager.setToolName((Action)action9, (String)DTMenuMergeTag.PAGE_SETUP.toString());
            ContextTargetingManager.setToolName((Action)action10, (String)"evaluate_selection");
            this.setContextActions(new Action[]{object, action, action2, action3, action4, action5, action6, action7, action8, action9, action10});
        } else {
            object = sCWView.getFileMenu();
            MJMenu mJMenu = sCWView.getEditMenu();
            MJMenu mJMenu2 = sCWView.getHelpMenu();
            MJMenuBar mJMenuBar = new MJMenuBar();
            mJMenuBar.setName("cw_MenuBar");
            mJMenuBar.add((JMenu)object);
            mJMenuBar.add((JMenu)mJMenu);
            mJMenuBar.add((JMenu)mJMenu2);
            this.setMenuBar((JMenuBar)mJMenuBar);
        }
        object = new MJMenu();
        ((JMenu)object).add(CmdWinEditorKit.getActionByName("clear-command-window"));
        this.setContextMenu((JMenu)object);
        sStatusBar = new CmdWinStatusBar(sCWView);
        this.setStatusBar(sStatusBar);
        sCWView.setStatusBar(sStatusBar);
        if (MLDesktop.getInstance().useToolstrip()) {
            this.setPermitUserClose(false);
        }
        this.setOnTopWhenUndocked(false);
        CmdWinMLIF.getInstance();
        CmdWinExecuteServices.createServices();
        MLExecuteServices.addMLExecutionListener((MLExecutionListener)XCaret.getInstance());
        MLExecuteServices.addMLExecutionListener((MLExecutionListener)XCmdWndView.getInstance());
        CommandWindowRegistrar.initialize();
        this.setName("cw_DTClientBase");
        this.cmdWinSinkRegistrar = new CmdWinSinkRegistrar();
        this.cmdWinSinkRegistrar.register();
        if (Matlab.isMatlabAvailable()) {
            SwingUtilities.invokeLater(new CWDTClientListener());
        }
    }

    private void createInfoMessageBar() {
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(sRes.getString("infobar.message"), new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                if (string.startsWith("matlab:demo")) {
                    Window window = SwingUtilities.windowForComponent((Component)((Object)CmdWin.this));
                    GlobalCursor.setWait((Window)window);
                    MLHelpServices.showDemos((String)"matlab");
                    GlobalCursor.clear((Window)window);
                } else {
                    new MatlabMCR().evalConsoleOutput(string.replace("matlab:", ""));
                }
            }
        });
        this.fMsgBar = new CloseableMessageBar(hyperlinkTextLabel.getComponent(), (Icon)CommonIcon.INFO.getIcon(), (ActionListener)new DemoPanelClosedListener()).getBar();
    }

    public void prefChanged(PrefEvent prefEvent) {
        if (prefEvent.getPrefKey().equals("CommandWindowShowStartupMessage")) {
            if (CmdWinPrefs.shouldShowStartingMessage()) {
                this.addMessageBar();
            } else {
                this.removeMessageBar();
            }
        }
    }

    public static CmdWin getInstance() {
        return sCmdWin;
    }

    static CmdWinStatusBar getStatusBar() {
        return sStatusBar;
    }

    public void requestFocus() {
        sCWView.requestFocus();
    }

    private void addMessageBar() {
        if (this.fMsgBar == null) {
            sCmdWin.createInfoMessageBar();
        }
        sCmdWin.add(this.fMsgBar, "North");
        sCmdWin.revalidate();
    }

    private void removeMessageBar() {
        if (this.fMsgBar != null) {
            sCmdWin.remove(this.fMsgBar);
            this.fMsgBar = null;
            sCmdWin.revalidate();
        }
    }

    public boolean hasFocus() {
        return sCWView.hasFocus();
    }

    public static void main(String[] stringArray) {
        CmdWin.getInstance();
    }

    static {
        sRes = ResourceBundle.getBundle("com.mathworks.mde.cmdwin.resources.RES_CmdWin");
        sMLRes = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop");
        sCmdWin = new CmdWin();
    }

    private static class DemoPanelClosedListener
    implements ActionListener {
        private DemoPanelClosedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CmdWinPrefs.setShouldShowStartingMessage(false);
        }
    }

    private class CWDTClientListener
    extends DTClientAdapter
    implements Runnable {
        private CWDTClientListener() {
        }

        public void clientActivated(DTClientEvent dTClientEvent) {
            FindParentListener findParentListener = sCWView.getFindParentListener();
            if (findParentListener == null) {
                FindDialog.registerComponent((FindClientInterface)sCWView.getFindClient(), (String[])new String[]{sMLRes.getString("title.CommandWindow")}, (int)2);
            }
        }

        public void clientDocked(DTClientEvent dTClientEvent) {
            FindParentListener findParentListener = sCWView.getFindParentListener();
            if (findParentListener != null) {
                findParentListener.docked(sCWView.getFindClient());
            }
        }

        public void clientUndocked(DTClientEvent dTClientEvent) {
            FindParentListener findParentListener = sCWView.getFindParentListener();
            if (findParentListener != null) {
                findParentListener.undocked(sCWView.getFindClient());
            }
        }

        public void clientClosed(DTClientEvent dTClientEvent) {
            FindParentListener findParentListener = sCWView.getFindParentListener();
            if (findParentListener != null) {
                findParentListener.closing(sCWView.getFindClient());
            }
            FindDialog.unregister((FindClientInterface)sCWView.getFindClient());
            assert (MLDesktop.getInstance() != null);
            DTFrame dTFrame = MLDesktop.getInstance().getMainFrame();
            if (dTFrame != null) {
                if (CmdWin.this.desktopWindowListener == null) {
                    CmdWin.this.desktopWindowListener = new WindowAdapter((MJFrame)dTFrame){
                        final /* synthetic */ MJFrame val$dtFrame;
                        {
                            this.val$dtFrame = mJFrame;
                        }

                        @Override
                        public void windowClosed(WindowEvent windowEvent) {
                            CmdWin.this.cmdWinSinkRegistrar.unregister();
                            this.val$dtFrame.removeWindowListener((WindowListener)CmdWin.this.desktopWindowListener);
                            CmdWin.this.desktopWindowListener = null;
                        }
                    };
                    dTFrame.addWindowListener((WindowListener)CmdWin.this.desktopWindowListener);
                }
            } else {
                CmdWin.this.cmdWinSinkRegistrar.unregister();
            }
        }

        public void clientOpened(DTClientEvent dTClientEvent) {
            CmdWin.this.cmdWinSinkRegistrar.register();
            assert (MLDesktop.getInstance() != null);
            DTFrame dTFrame = MLDesktop.getInstance().getMainFrame();
            if (dTFrame != null) {
                dTFrame.removeWindowListener((WindowListener)CmdWin.this.desktopWindowListener);
                CmdWin.this.desktopWindowListener = null;
            }
        }

        @Override
        public void run() {
            CmdWin.this.getParentDesktop().addClientListener((Component)((Object)CmdWin.this), (DTClientListener)this);
        }
    }
}

