/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.matlab.api.datamodel.StorageLocation;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.matlab.api.editor.EditorApplicationListener;
import com.mathworks.matlab.api.editor.EditorEvent;
import com.mathworks.matlab.api.editor.EditorEventListener;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mde.editor.ActionManager;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.EditorUiUtils;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.EditorViewClient;
import com.mathworks.mde.editor.MFilePathUtil;
import com.mathworks.mde.editor.codepad.Codepad;
import com.mathworks.mde.editor.codepad.CodepadActionManager;
import com.mathworks.mde.editor.plugins.matlab.MatlabMenuContributor;
import com.mathworks.mde.editor.plugins.mlint.MLintMenuContributor;
import com.mathworks.mlservices.MLEditorServices;
import com.mathworks.mlwidgets.stack.StackComboBox;
import com.mathworks.mlwidgets.util.MatlabDropTargetListener;
import com.mathworks.mwswing.MJFileChooserPerPlatform;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.util.FactoryUtils;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.desk.DTGroupAdapter;
import com.mathworks.widgets.desk.DTGroupBase;
import com.mathworks.widgets.desk.DTGroupEvent;
import com.mathworks.widgets.desk.DTGroupListener;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Component;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.SwingUtilities;

public class EditorGroup
extends DTGroupBase {
    private List<EditorApplicationListener> fEditorApplicationListeners = new ArrayList<EditorApplicationListener>();
    private List<EditorViewClient> fEditorViewClients = new ArrayList<EditorViewClient>();
    private final EditorEventListener fEditorEventListener = this.createEditorEventListener();
    private static EditorGroup sInstance = new EditorGroup();
    private boolean fRegisteredDesktopListener;

    private EditorGroup() {
        this.setIcon(EditorUtils.EDITOR_ICON);
        this.setSmallIcon(EditorUtils.SMALL_ICON);
        this.setGroupName(EditorUtils.getEditorGroupName());
        this.setTitle(EditorUtils.getEditorGroupTitle());
        if (!MLDesktop.getInstance().useToolstrip()) {
            this.setToolBarInfo(ActionManager.createGroupToolbarInfo(new StackComboBox()));
            this.setAllowToolBarRearrangement(true);
        }
        this.setMenuBar((JMenuBar)ActionManager.createGroupMenuBar());
        if (EditorUtils.getMatlab() != null) {
            this.setDropListener((DropTargetListener)((Object)new EditorDropTargetListener()));
        }
        CodepadActionManager.setCodepadModeObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                Codepad.toggleCodepadMode();
                for (EditorViewClient editorViewClient : EditorGroup.this.getOpenEditorViewClients()) {
                    editorViewClient.createToolbar();
                }
            }
        });
        ActionManager.setOpenObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                EditorGroup.doDesktopOpenFile();
            }
        });
        ActionManager.setOpenAsTextObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                EditorGroup.doOpenAsText();
            }
        });
        ActionManager.setNewFileObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                MLEditorServices.getEditorApplication().newEditor("");
            }
        });
        ActionManager.setSaveAllObserver(new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                EditorGroup.saveAll();
            }
        });
    }

    protected void setParentDesktop(Desktop desktop) {
        super.setParentDesktop(desktop);
        if (desktop != null && !this.fRegisteredDesktopListener) {
            this.fRegisteredDesktopListener = true;
            desktop.addGroupListener(EditorUtils.getEditorGroupName(), EditorGroup.createDTGroupListener());
            if (desktop.isGroupShowing(EditorUtils.getEditorGroupName())) {
                CodepadActionManager.groupOpened(EditorStartup.getParentDesktop());
            }
        }
    }

    private static void doOpenAsText() {
        MJFileChooserPerPlatform mJFileChooserPerPlatform = EditorUtils.createFileChooser(EditorGroup.getActiveDirectory());
        mJFileChooserPerPlatform.showOpenDialog(EditorGroup.getComponentToParentDialogTo());
        if (mJFileChooserPerPlatform.getState() == 0) {
            for (File file : mJFileChooserPerPlatform.getSelectedFiles()) {
                String string = MFilePathUtil.mapPFileToMFile(file.getName());
                if (string == null || string.length() <= 0) continue;
                File file2 = new File(mJFileChooserPerPlatform.getCurrentDirectory(), string);
                MLEditorServices.getEditorApplication().openEditor(file2);
            }
        }
    }

    private static void doDesktopOpenFile() {
        MLDesktop.getInstance().showOpenDialog(EditorGroup.getActiveDirectory(), EditorGroup.getComponentToParentDialogTo());
    }

    private static File getActiveDirectory() {
        File file;
        Editor editor = MLEditorServices.getEditorApplication().getActiveEditor();
        StorageLocation storageLocation = editor == null ? null : editor.getStorageLocation();
        File file2 = file = storageLocation != null && storageLocation instanceof FileStorageLocation && ((FileStorageLocation)storageLocation).getFile().getParentFile() != null ? ((FileStorageLocation)storageLocation).getFile().getParentFile() : new File(FactoryUtils.getDirectorySeed());
        assert (file != null) : "Active directory should not be null.";
        return file;
    }

    private static synchronized void saveAll() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Editor editor : MLEditorServices.getEditorApplication().getOpenEditors()) {
                    editor.negotiateSave();
                }
            }
        });
    }

    private static Component getComponentToParentDialogTo() {
        return MLEditorServices.getEditorApplication().getActiveEditor() == null ? EditorUiUtils.getEditorGroupComponent() : MLEditorServices.getEditorApplication().getActiveEditor().getComponent();
    }

    public static synchronized EditorGroup getInstance() {
        return sInstance;
    }

    static String getTitle() {
        return EditorUtils.getEditorGroupTitle();
    }

    List<EditorViewClient> getOpenEditorViewClients() {
        ArrayList<EditorViewClient> arrayList = new ArrayList<EditorViewClient>(this.fEditorViewClients);
        return Collections.unmodifiableList(arrayList);
    }

    void doEditorViewClientOpened(EditorViewClient editorViewClient) {
        this.fEditorViewClients.add(editorViewClient);
        editorViewClient.getEditor().addEventListener(this.fEditorEventListener);
        this.fireEditorOpened(editorViewClient.getEditor());
    }

    void doEditorViewClientClosed(EditorViewClient editorViewClient) {
        this.fEditorViewClients.remove((Object)editorViewClient);
        editorViewClient.getEditor().removeEventListener(this.fEditorEventListener);
        this.fireEditorClosed(editorViewClient.getEditor());
    }

    private static DTGroupListener createDTGroupListener() {
        return new DTGroupAdapter(){

            public void groupOpened(DTGroupEvent dTGroupEvent) {
                CodepadActionManager.groupOpened(EditorStartup.getParentDesktop());
            }

            public void groupClosed(DTGroupEvent dTGroupEvent) {
                CodepadActionManager.groupClosed(EditorStartup.getParentDesktop());
            }

            public void groupDocked(DTGroupEvent dTGroupEvent) {
                EditorGroup.notifyClientsGroupState(true);
            }

            public void groupUndocked(DTGroupEvent dTGroupEvent) {
                EditorGroup.notifyClientsGroupState(false);
            }
        };
    }

    private static void notifyClientsGroupState(boolean bl) {
        List<EditorViewClient> list = EditorGroup.getInstance().getOpenEditorViewClients();
        for (EditorViewClient editorViewClient : list) {
            editorViewClient.setIsDockedInDesktop(bl);
        }
    }

    public static void updateSaveAllEnablement() {
        boolean bl = false;
        for (EditorViewClient editorViewClient : EditorGroup.getInstance().getOpenEditorViewClients()) {
            if (!editorViewClient.getEditor().isDirty()) continue;
            bl = true;
            break;
        }
        ActionManager.enableSaveAll(bl);
    }

    private EditorEventListener createEditorEventListener() {
        return new EditorEventListener(){

            public void eventOccurred(EditorEvent editorEvent) {
                if (editorEvent.equals((Object)EditorEvent.DIRTY_STATE_CHANGED)) {
                    EditorGroup.updateSaveAllEnablement();
                    EditorGroup.this.updateActionsMenu();
                } else if (editorEvent == EditorEvent.ACTIVATED) {
                    EditorGroup.this.updateActionsMenu();
                }
            }
        };
    }

    private void updateActionsMenu() {
        Editor editor = MLEditorServices.getEditorApplication().getActiveEditor();
        if (editor != null && editor.isMCode()) {
            MJMenu mJMenu = new MJMenu();
            mJMenu.add(MLintMenuContributor.createShowCodeAnalyzerReportAction(editor));
            mJMenu.add(MatlabMenuContributor.createShowDependencyReportAction(editor));
            this.setContextMenu((JMenu)mJMenu);
        } else {
            this.setContextMenu(null);
        }
    }

    public void addEditorApplicationListener(EditorApplicationListener editorApplicationListener) {
        this.fEditorApplicationListeners.add(editorApplicationListener);
    }

    public void removeEditorApplicationListener(EditorApplicationListener editorApplicationListener) {
        this.fEditorApplicationListeners.remove(editorApplicationListener);
    }

    private void fireEditorOpened(Editor editor) {
        for (int i = this.fEditorApplicationListeners.size() - 1; i >= 0; --i) {
            this.fEditorApplicationListeners.get(i).editorOpened(editor);
        }
    }

    private void fireEditorClosed(Editor editor) {
        for (int i = this.fEditorApplicationListeners.size() - 1; i >= 0; --i) {
            this.fEditorApplicationListeners.get(i).editorClosed(editor);
        }
    }

    private static class EditorDropTargetListener
    extends MatlabDropTargetListener {
        private EditorDropTargetListener() {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            if (!EditorUtils.processFileDrop(dropTargetDropEvent)) {
                super.drop(dropTargetDropEvent);
            }
        }
    }
}

