/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.mde.editor.EditorStateManager;
import com.mathworks.mde.editor.EditorStateManagerFactory;
import com.mathworks.util.FileUtils;
import com.mathworks.util.Log;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.StateConstants;
import com.mathworks.widgets.StateMRUFiles;
import com.mathworks.widgets.StateManager;
import com.mathworks.widgets.text.STPInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class EditorStateManagerImpl
implements EditorStateManager {
    private static EditorStateManager sStateManager = new EditorStateManagerImpl();
    private static Document sEditorStateDocument;
    private Transformer fXMLWriter;
    private static final String STATE_FILE_NAME = "MATLAB_Editor_State.xml";
    private static final String ENCODING_STYLE = "UTF-8";
    private StateManager fSTPStateManager;
    private StateMRUFiles fStateMRUFiles;

    private EditorStateManagerImpl() {
        sEditorStateDocument = EditorStateManagerImpl.readPersistedState();
        this.fStateMRUFiles = StateMRUFiles.getInstance();
        EditorStateManagerImpl.initMRUFiles(this.fStateMRUFiles, sEditorStateDocument);
        this.fSTPStateManager = EditorStateManagerFactory.getInstance().getStateManager(StateConstants.Module.SYNTAX_TEXT_PANE);
    }

    public static EditorStateManager getInstance() {
        return sStateManager;
    }

    @Override
    public void loadState(String string) {
        Node node;
        if (string != null && (node = EditorStateManagerImpl.getFileState(string, sEditorStateDocument)) != null) {
            this.fSTPStateManager.loadState(string, node);
        }
    }

    public void loadState(String string, Node node) {
        if (string != null && node != null) {
            this.loadState(string);
        }
    }

    private static Document readPersistedState() {
        DocumentBuilder documentBuilder = EditorStateManagerImpl.createDocumentBuilder();
        if (documentBuilder == null) {
            Log.log((String)"Unable to create document builder for Editor code folding");
            return null;
        }
        Document document = EditorStateManagerImpl.parseXMLFile(documentBuilder);
        if (document == null) {
            document = documentBuilder.newDocument();
            Element element = document.createElement("Editor");
            element.setAttribute("version", "1.0");
            document.appendChild(element);
        }
        return document;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document parseXMLFile(DocumentBuilder documentBuilder) {
        assert (documentBuilder != null);
        InputStream inputStream = EditorStateManagerImpl.loadStateFile(FileUtils.getPreferencesDirectory());
        if (inputStream == null) {
            return null;
        }
        Document document = null;
        try {
            documentBuilder.setErrorHandler(new ErrorHandler(){

                @Override
                public void warning(SAXParseException sAXParseException) throws SAXException {
                }

                @Override
                public void error(SAXParseException sAXParseException) throws SAXException {
                }

                @Override
                public void fatalError(SAXParseException sAXParseException) throws SAXException {
                }
            });
            document = documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            File file = new File(EditorStateManagerImpl.getEditorStateFileAbsName());
            if (file.delete()) {
                Log.log((String)"Deleting Editor's code folding XML file because it was corrupted.");
            } else {
                Log.logThrowable((Throwable)exception);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return document;
    }

    private static DocumentBuilder createDocumentBuilder() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        assert (documentBuilderFactory != null) : "DocumentBuilderFactory.newInstance() returned null";
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Log.logThrowable((Throwable)parserConfigurationException);
        }
        return documentBuilder;
    }

    private static InputStream loadStateFile(String string) {
        String string2;
        File file;
        FileInputStream fileInputStream = null;
        if (string != null && (file = new File(string2 = EditorStateManagerImpl.getEditorStateFileAbsName())).exists() && file.canRead()) {
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.log((String)"EditorStateManagerImpl:Unable to load the editor's state xml file");
                Log.logThrowable((Throwable)fileNotFoundException);
            }
        }
        return fileInputStream;
    }

    private static String getEditorStateFileAbsName() {
        return FileUtils.getPreferencesDirectory() + System.getProperty("file.separator") + STATE_FILE_NAME;
    }

    public void updateState(STPInterface sTPInterface) {
        if (sTPInterface != null && sTPInterface.getUniqueKey() != null) {
            String string = sTPInterface.getUniqueKey();
            this.fStateMRUFiles.updateFileAsMRU(string);
            this.fSTPStateManager.updateState(sTPInterface);
        }
    }

    @Override
    public Node saveState(STPInterface sTPInterface) {
        Node node = null;
        if (sEditorStateDocument != null) {
            String string = sTPInterface.getUniqueKey();
            if (!this.fStateMRUFiles.containsFile(string)) {
                return node;
            }
            Node node2 = EditorStateManagerImpl.getFileState(string, sEditorStateDocument);
            Node node3 = EditorStateManagerImpl.getEditorNode(sEditorStateDocument);
            if (node2 != null) {
                node3.removeChild(node2);
            }
            this.removeLRUFileNode();
            Node node4 = EditorStateManagerImpl.createState(string, sEditorStateDocument);
            node = this.fSTPStateManager.saveState(sTPInterface, node4);
            EditorStateManagerImpl.removeEditorChildTextNodes();
            this.persistToXML(sEditorStateDocument);
        }
        return node;
    }

    public Node saveState(STPInterface sTPInterface, Node node) {
        return this.saveState(sTPInterface);
    }

    public void cleanup(STPInterface sTPInterface) {
        if (sTPInterface != null) {
            this.fSTPStateManager.cleanup(sTPInterface);
        }
    }

    public void clearState(String string) {
        if (string != null) {
            this.fSTPStateManager.clearState(string);
            Node node = EditorStateManagerImpl.getFileState(string, sEditorStateDocument);
            Node node2 = EditorStateManagerImpl.getEditorNode(sEditorStateDocument);
            if (node != null && node2 != null) {
                node2.removeChild(node);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistToXML(Document document) {
        FileOutputStream fileOutputStream = null;
        try {
            Object object;
            if (this.fXMLWriter == null) {
                object = TransformerFactory.newInstance();
                this.fXMLWriter = ((TransformerFactory)object).newTransformer();
                this.fXMLWriter.setOutputProperty("method", "xml");
                this.fXMLWriter.setOutputProperty("indent", "yes");
                this.fXMLWriter.setOutputProperty("encoding", ENCODING_STYLE);
            }
            if (!((File)(object = new File(EditorStateManagerImpl.getEditorStateFileAbsName()))).exists()) {
                ((File)object).createNewFile();
            }
            fileOutputStream = new FileOutputStream((File)object);
            this.fXMLWriter.transform(new DOMSource(document), new StreamResult(fileOutputStream));
        }
        catch (Exception exception) {
            EditorStateManagerImpl.logToTempDir(exception);
            Log.logThrowable((Throwable)exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    Log.logThrowable((Throwable)iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logToTempDir(Throwable throwable) {
        File file = new File(EditorStateManagerImpl.getTempDirectory() + "MATLABEditor_StatePersistence_Error.log");
        PrintStream printStream = null;
        try {
            printStream = new PrintStream(file);
            throwable.printStackTrace(printStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            if (printStream != null) {
                printStream.flush();
                printStream.close();
            }
        }
    }

    private static String getTempDirectory() {
        String string = PlatformInfo.isWindows() ? System.getProperties().getProperty("java.io.tmpdir") : System.getProperties().getProperty("user.home");
        char c = System.getProperties().getProperty("file.separator").charAt(0);
        if (string.charAt(string.length() - 1) != c) {
            string = string + c;
        }
        return string;
    }

    private static void initMRUFiles(StateMRUFiles stateMRUFiles, Document document) {
        if (stateMRUFiles != null && document != null) {
            NodeList nodeList = document.getElementsByTagName("File");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Node node = nodeList.item(i);
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string2 = namedNodeMap.getNamedItem("absPath") != null ? namedNodeMap.getNamedItem("absPath").getNodeValue() : null;
                String string3 = namedNodeMap.getNamedItem("name") != null ? namedNodeMap.getNamedItem("name").getNodeValue() : null;
                String string4 = string = string2 != null && string3 != null ? string2 + System.getProperty("file.separator") + string3 : null;
                if (string == null) continue;
                stateMRUFiles.addFile(string);
            }
        }
    }

    private static Node getFileState(String string, Document document) {
        Node node = null;
        if (document != null && string != null) {
            NodeList nodeList = document.getElementsByTagName("File");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string2;
                Node node2 = nodeList.item(i);
                NamedNodeMap namedNodeMap = node2.getAttributes();
                String string3 = namedNodeMap.getNamedItem("absPath") != null ? namedNodeMap.getNamedItem("absPath").getNodeValue() : "";
                String string4 = string2 = namedNodeMap.getNamedItem("name") != null ? namedNodeMap.getNamedItem("name").getNodeValue() : "";
                if (!string.equals(string3 + System.getProperty("file.separator") + string2)) continue;
                node = node2;
                break;
            }
        }
        return node;
    }

    private static Node createState(String string, Document document) {
        Element element = null;
        if (document != null && string != null) {
            String string2 = FilenameUtils.getName((String)string);
            String string3 = FilenameUtils.getFullPathNoEndSeparator((String)string);
            if (string2 != null && string3 != null) {
                Element element2 = document.createElement("File");
                element2.setAttribute("name", string2);
                element2.setAttribute("absPath", string3);
                element2.setAttribute("lastWrittenTime", String.valueOf(System.currentTimeMillis()));
                element = element2;
                EditorStateManagerImpl.getEditorNode(document).appendChild(element);
            }
        }
        return element;
    }

    private static Node getEditorNode(Document document) {
        NodeList nodeList;
        Node node = null;
        if (document != null && (nodeList = document.getChildNodes()) != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1 || !node2.getNodeName().equals("Editor")) continue;
                node = node2;
                break;
            }
        }
        return node;
    }

    private void removeLRUFileNode() {
        NodeList nodeList = sEditorStateDocument.getElementsByTagName("File");
        if (nodeList != null && nodeList.getLength() >= this.fStateMRUFiles.getMaxMRUFileCount()) {
            ArrayList<Node> arrayList = new ArrayList<Node>(nodeList.getLength());
            for (int i = 0; i < nodeList.getLength(); ++i) {
                arrayList.add(nodeList.item(i));
            }
            Comparator<Node> comparator = new Comparator<Node>(){

                @Override
                public int compare(Node node, Node node2) {
                    Node node3;
                    Long l = null;
                    Long l2 = null;
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    if (namedNodeMap != null) {
                        node3 = namedNodeMap.getNamedItem("lastWrittenTime");
                        l = node3.getNodeValue() != null ? Long.valueOf(node3.getNodeValue()) : -1L;
                    }
                    if ((namedNodeMap = node2.getAttributes()) != null) {
                        node3 = namedNodeMap.getNamedItem("lastWrittenTime");
                        l2 = node3.getNodeValue() != null ? Long.valueOf(node3.getNodeValue()) : -1L;
                    }
                    return l2 != null && l != null ? l2.compareTo(l) : -1;
                }
            };
            Collections.sort(arrayList, comparator);
            Node node = EditorStateManagerImpl.getEditorNode(sEditorStateDocument);
            List list = arrayList.subList(Math.min(this.fStateMRUFiles.getMaxMRUFileCount(), arrayList.size()) - 1, arrayList.size());
            for (Node node2 : list) {
                node.removeChild(node2);
            }
            list.clear();
        }
    }

    private static void removeEditorChildTextNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = sEditorStateDocument.getElementsByTagName("File");
        EditorStateManagerImpl.addToElementsList(nodeList, arrayList);
        NodeList nodeList2 = sEditorStateDocument.getElementsByTagName("CodeFolds");
        EditorStateManagerImpl.addToElementsList(nodeList2, arrayList);
        NodeList nodeList3 = sEditorStateDocument.getElementsByTagName("FoldType");
        EditorStateManagerImpl.addToElementsList(nodeList3, arrayList);
        NodeList nodeList4 = sEditorStateDocument.getElementsByTagName("Fold");
        EditorStateManagerImpl.addToElementsList(nodeList4, arrayList);
        for (Node node : arrayList) {
            EditorStateManagerImpl.removeTextNodes(node);
        }
        Element element = sEditorStateDocument.getDocumentElement();
        EditorStateManagerImpl.removeTextNodes(element);
    }

    private static void removeTextNodes(Node node) {
        NodeList nodeList = node.getChildNodes();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 3) continue;
            arrayList.add(node2);
        }
        for (Node node2 : arrayList) {
            node.removeChild(node2);
        }
    }

    private static void addToElementsList(NodeList nodeList, List<Node> list) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            list.add(nodeList.item(i));
        }
    }
}

