/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.MFilePathUtil;
import com.mathworks.mlservices.MatlabDebugAdapter;
import com.mathworks.mlservices.MatlabDebugObserver;
import com.mathworks.mlservices.MatlabDebugServices;
import com.mathworks.mlwidgets.stack.StackInfoRegistry;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.text.mcode.MExecutionDisplayAdapter;
import java.io.File;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.Validate;

public class MatlabExecutionDisplayAdapter
extends MExecutionDisplayAdapter {
    private File fFile;
    private DebugInterests fDebugObserver;

    public MatlabExecutionDisplayAdapter(Editor editor) {
        Validate.notNull((Object)editor, (String)"Editor can not be null");
        this.doBackingstoreInit(editor);
    }

    private void doBackingstoreInit(Editor editor) {
        if (editor.getStorageLocation() instanceof FileStorageLocation) {
            this.setFile(((FileStorageLocation)editor.getStorageLocation()).getFile());
            this.registerMatlabListeners();
        }
    }

    void setFile(File file) {
        this.fFile = file;
        this.setCurrentLine(-1);
        this.stackReply(StackInfoRegistry.getLastStackInfo());
        this.firePaintNeededEvent();
    }

    private void interestDebugStop(String string, int n) {
        if (this.fFile == null) {
            return;
        }
        String string2 = MFilePathUtil.mFileToSystemPathWithPFileMapping(string);
        if (IOCase.SYSTEM.checkEquals(string2, this.fFile.getPath())) {
            this.setCurrentLine(n);
            if (this.getCurrentLine() < 0) {
                this.setCurrentLine(-this.getCurrentLine());
                this.setIsAfterLine(true);
            } else {
                this.setIsAfterLine(false);
            }
        } else {
            this.setCurrentLine(-1);
        }
        this.firePaintNeededEvent();
    }

    private void stackReply(MatlabDebugServices.StackInfo stackInfo) {
        if (stackInfo == null || this.fFile == null) {
            return;
        }
        this.getStackLines().clear();
        String string = MFilePathUtil.getFullPathname(this.fFile.getPath());
        File file = new File(string);
        int n = stackInfo.getCurrentEntryIndex();
        String[] stringArray = stackInfo.getFullFilenames();
        int[] nArray = stackInfo.getLineNumbers();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = MFilePathUtil.mFileToSystemPathWithPFileMapping(stringArray[i]);
            File file2 = new File(string2);
            if (!file.equals(file2)) continue;
            if (n == i) {
                this.setCurrentLine(nArray[i]);
                continue;
            }
            this.getStackLines().add(nArray[i]);
        }
        this.firePaintNeededEvent();
    }

    private static synchronized void removeMatlabListeners(DebugInterests debugInterests) {
        if (debugInterests != null) {
            EditorStartup.removeDebugObserver((MatlabDebugObserver)debugInterests);
            StackInfoRegistry.removeListener((StackInfoRegistry.StackInfoChange)debugInterests);
        }
    }

    private void registerMatlabListeners() {
        if (Matlab.isMatlabAvailable() && this.fDebugObserver == null) {
            this.fDebugObserver = new DebugInterests();
            StackInfoRegistry.addListener((StackInfoRegistry.StackInfoChange)this.fDebugObserver);
            EditorStartup.addDebugObserver((MatlabDebugObserver)this.fDebugObserver);
            this.stackReply(StackInfoRegistry.getLastStackInfo());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.fDebugObserver != null) {
            MatlabExecutionDisplayAdapter.removeMatlabListeners(this.fDebugObserver);
            this.fDebugObserver = null;
        }
    }

    private class DebugInterests
    extends MatlabDebugAdapter
    implements StackInfoRegistry.StackInfoChange {
        private DebugInterests() {
        }

        public void doDBStop(final String string, final int n) {
            MatlabExecutionDisplayAdapter.this.setCurrentLine(-1);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MatlabExecutionDisplayAdapter.this.interestDebugStop(string, n + 1);
                }
            });
        }

        public void doDBCont() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MatlabExecutionDisplayAdapter.this.setCurrentLine(-1);
                    MatlabExecutionDisplayAdapter.this.getStackLines().clear();
                    MatlabExecutionDisplayAdapter.this.firePaintNeededEvent();
                }
            });
        }

        public void doDebugMode(boolean bl) {
            if (!bl) {
                this.doDBCont();
            }
        }

        public void doDbupDbdownChange(String string, int n) {
            MatlabExecutionDisplayAdapter.this.setCurrentLine(-1);
        }

        public void stackChanged(MatlabDebugServices.StackInfo stackInfo) {
            MatlabExecutionDisplayAdapter.this.stackReply(stackInfo);
        }
    }
}

