/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.codepad;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.editor.DialogFactory;
import com.mathworks.mde.editor.EditorUiUtils;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.EditorViewUtils;
import com.mathworks.mde.editor.PopupAction;
import com.mathworks.mde.editor.RedrawTimer;
import com.mathworks.mde.editor.codepad.CodepadAction;
import com.mathworks.mde.editor.codepad.CodepadActionManager;
import com.mathworks.mde.editor.codepad.CodepadContainer;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.MatlabHyperlinkStatusBarHandler;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.ScrollablePopupList;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import com.mathworks.util.ArrayUtils;
import com.mathworks.util.Log;
import com.mathworks.util.StringUtils;
import com.mathworks.widgets.CloseableMessageBar;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.text.DocumentUtils;
import com.mathworks.widgets.text.STPInterface;
import com.mathworks.widgets.text.mcode.cell.BaseDocumentCellInfo;
import com.mathworks.widgets.text.mcode.codepad.CodepadOptions;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.Finder;
import org.netbeans.editor.FinderFactory;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;

public class Codepad {
    private static final String TAG = "%%";
    private static final String TAG_WITHOUT_CELL_BREAK = "%%%";
    private static final String DESCRIPTIVE_START = "% ";
    public static final String ITALIC_INSERT_TEXT = "ITALIC TEXT";
    public static final String BOLD_INSERT_TEXT = "BOLD TEXT";
    public static final String MONO_INSERT_TEXT = "MONOSPACED TEXT";
    public static final String HYPERLINKED_TEXT_BEGINNING = "http://www.mathworks.com ";
    public static final String HYPERLINKED_TEXT_END = "MathWorks";
    public static final String TITLE_AND_DESCRIPTION = "SECTION TITLE\n% DESCRIPTIVE TEXT";
    public static final String DOCUMENT_TITLE = "DOCUMENT TITLE\n% INTRODUCTORY TEXT";
    public static final String PREFORMATTED_TEXT = "PREFORMATTED\n%  TEXT";
    public static final String SAMPLE_CODE = "for x = 1:10\n%       disp(x)\n%   end";
    public static final String BULLETED_LIST = "ITEM1\n% * ITEM2";
    public static final String TEX_EQ = "e^{\\pi i} + 1 = 0";
    public static final String HTML_MARKUP = "<table border=1><tr><td>one</td><td>two</td></tr></table>";
    public static final String IMAGE = "FILENAME.PNG";
    public static final String LATEX_MARKUP = "\\begin{tabular}{|c|c|} \\hline\n% $n$ & $n!$ \\\\ \\hline\n% 1 & 1 \\\\\n% 2 & 2 \\\\\n% 3 & 6 \\\\ \\hline\n% \\end{tabular}";
    public static final String INLINE_MATH_TEXT = "x^2+e^{\\pi i}";
    public static final String NUMBERED_LIST = "ITEM1\n% # ITEM2";
    public static final String FORCE_SNAPSHOT_TEXT = "snapnow;";
    static final NumberFormat NUMERIC_FORMAT;
    private STPInterface fSyntaxTextPane;
    private CodepadContainer fContainer;
    private CodepadActionManager fActionManager;
    private PrefListener fPrefListener;
    private TaggedLineManager fLineManager;
    static final double DEFAULT_INC = 1.0;
    static final double DEFAULT_MULT = 1.1;
    public static final String CODEPAD_MODE_PREF = "CodepadModeOn2";
    private static final String CODEPAD_SHOW_INTRO_DIALOG_PREF = "CodepadShowMessageBar";
    private static List<Codepad> sCodepadList;
    private static final boolean DEFAULT_CODEPAD_ON = true;
    private static boolean sCodepadOn;
    private MouseWheelListener fMouseWheelListener;
    private List<int[]> fEvalRangeQueue = new LinkedList<int[]>();
    private Component fHyperlinkDemoComp;
    private static final String SELECTION_MARK = "$%^";
    public static final String CODEPAD_PROPERTY = "Codepad";
    private static final String[] HYPERLINK_ALT_TEXT;

    public Codepad(STPInterface sTPInterface, CodepadActionManager codepadActionManager, CodepadContainer codepadContainer) {
        assert (codepadContainer != null) : "container should not be null";
        assert (codepadActionManager != null) : "actionManager should not be null";
        assert (sTPInterface != null) : "textPane should not be null";
        this.fContainer = codepadContainer;
        this.fSyntaxTextPane = sTPInterface;
        this.fActionManager = codepadActionManager;
        Observer observer = new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                ActionEvent actionEvent = (ActionEvent)object;
                int n = actionEvent.getID();
                if (n == CodepadAction.CODEPAD_EVALUATE_FILE.getId()) {
                    Codepad.this.evalAll();
                } else if (n == CodepadAction.CODEPAD_NEXT_CELL.getId()) {
                    Codepad.this.nextCell();
                } else if (n == CodepadAction.CODEPAD_PREVIOUS_CELL.getId()) {
                    Codepad.this.prevCell();
                } else if (n == CodepadAction.CODEPAD_PLUS.getId()) {
                    Codepad.this.incrementNumber();
                } else if (n == CodepadAction.CODEPAD_MINUS.getId()) {
                    Codepad.this.decrementNumber();
                } else if (n == CodepadAction.CODEPAD_MULTIPLY.getId()) {
                    Codepad.this.multiplyNumber();
                } else if (n == CodepadAction.CODEPAD_DIVIDE.getId()) {
                    Codepad.this.divideNumber();
                } else if (n == CodepadAction.CODEPAD_INCREASE_ADD.getId()) {
                    Codepad.this.fActionManager.increaseAddInc();
                } else if (n == CodepadAction.CODEPAD_DECREASE_ADD.getId()) {
                    Codepad.this.fActionManager.decreaseAddInc();
                } else if (n == CodepadAction.CODEPAD_INCREASE_MULT.getId()) {
                    Codepad.this.fActionManager.increaseMultInc();
                } else if (n == CodepadAction.CODEPAD_DECREASE_MULT.getId()) {
                    Codepad.this.fActionManager.decreaseMultInc();
                } else if (n == CodepadAction.CODEPAD_ADD_DIVIDER.getId()) {
                    Codepad.addCellDivider(Codepad.this.fSyntaxTextPane);
                } else if (n == CodepadAction.CODEPAD_CREATE_CELL.getId()) {
                    Codepad.defineCellSelection(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_SHOW_CELL_TITLES.getId()) {
                    Codepad.this.showCellTitles((Component)actionEvent.getSource());
                } else if (n == CodepadAction.CODEPAD_CREATE_TITLE.getId()) {
                    Codepad.insertCellTitle(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_CREATE_TITLE_NO_CELL_BREAK.getId()) {
                    Codepad.insertSectionTitleWithoutCell(Codepad.this.fSyntaxTextPane);
                } else if (n == CodepadAction.CODEPAD_DOCUMENT_TITLE.getId()) {
                    Codepad.insertDocumentTitle(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_FORCE_SNAPSHOT.getId()) {
                    Codepad.insertForceSnapshot(Codepad.this.fSyntaxTextPane);
                } else if (n == CodepadAction.CODEPAD_HYPERLINK.getId()) {
                    Codepad.insertHyperlink(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_BOLD_TEXT.getId()) {
                    Codepad.insertBoldText(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_ITALIC_TEXT.getId()) {
                    Codepad.insertItalicText(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_MONO_TEXT.getId()) {
                    Codepad.insertMonospacedText(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_BULLET_LIST.getId()) {
                    Codepad.insertBulletedList(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_PREFORMATTED.getId()) {
                    Codepad.insertPreformattedText(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_SAMPLE_CODE.getId()) {
                    Codepad.insertSampleCode(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_TEX_EQUATION.getId()) {
                    Codepad.insertTexEquation(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_HTML_MARKUP.getId()) {
                    Codepad.insertHtmlMarkup(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_IMAGE.getId()) {
                    Codepad.insertImage(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_LATEX_MARKUP.getId()) {
                    Codepad.insertLatexMarkup(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_LATEX_INLINE_MATH.getId()) {
                    Codepad.insertInlineMath(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_NUMBERED_LIST.getId()) {
                    Codepad.insertNumberedList(Codepad.this.fSyntaxTextPane, Codepad.this.fLineManager);
                } else if (n == CodepadAction.CODEPAD_DEMO.getId()) {
                    Codepad.showCellModeDemos((Component)actionEvent.getSource());
                }
            }
        };
        this.fActionManager.observeCodepadActions(observer);
        this.fActionManager.enableCodepadActions(sCodepadOn, !this.fSyntaxTextPane.isSelectionEmpty(), Codepad.atNumericValue(this.fSyntaxTextPane));
        this.fPrefListener = new CodepadPrefListener();
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorCodepadHighVisible");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorCodeBlockDividers");
        Prefs.addListener((PrefListener)this.fPrefListener, (String)"EditorCodepadDefaultOutputFormat");
        sCodepadList.add(this);
        this.fLineManager = Codepad.getLineManager(this.fSyntaxTextPane, this.fActionManager);
        Codepad.drawAreas(this.fLineManager, this.fSyntaxTextPane);
        this.fMouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                if (!sCodepadOn || !mouseWheelEvent.isControlDown() || mouseWheelEvent.isAltDown()) {
                    Component component = (Component)mouseWheelEvent.getSource();
                    Container container = component.getParent();
                    Point point = SwingUtilities.convertPoint(component, mouseWheelEvent.getPoint(), container);
                    container.dispatchEvent(new MouseWheelEvent((Component)container, 507, mouseWheelEvent.getWhen(), mouseWheelEvent.getModifiers(), point.x, point.y, mouseWheelEvent.getClickCount(), mouseWheelEvent.isPopupTrigger(), mouseWheelEvent.getScrollType(), mouseWheelEvent.getScrollAmount(), mouseWheelEvent.getWheelRotation()));
                }
                if (sCodepadOn && mouseWheelEvent.isControlDown() && !mouseWheelEvent.isAltDown()) {
                    mouseWheelEvent.consume();
                    if (mouseWheelEvent.isControlDown() && mouseWheelEvent.isShiftDown()) {
                        if (mouseWheelEvent.getWheelRotation() == 1) {
                            Codepad.this.fActionManager.decreaseAddInc();
                        } else if (mouseWheelEvent.getWheelRotation() == -1) {
                            Codepad.this.fActionManager.increaseAddInc();
                        }
                    } else if (mouseWheelEvent.getWheelRotation() == 1) {
                        Codepad.this.decrementNumber();
                    } else if (mouseWheelEvent.getWheelRotation() == -1) {
                        Codepad.this.incrementNumber();
                    }
                }
            }
        };
        this.fSyntaxTextPane.addMouseWheelListener(this.fMouseWheelListener);
    }

    public void cleanup() {
        this.updateCellModeMessage(false);
        this.fSyntaxTextPane.removeMouseWheelListener(this.fMouseWheelListener);
        sCodepadList.remove(this);
        Prefs.removeListener((PrefListener)this.fPrefListener);
        this.fLineManager.cleanup();
        this.fSyntaxTextPane = null;
        this.fLineManager = null;
        this.fContainer = null;
        this.fActionManager = null;
    }

    public static void toggleCodepadMode() {
        sCodepadOn = !sCodepadOn;
        CodepadActionManager.codepadModeToggled(sCodepadOn);
        Prefs.setBooleanPref((String)CODEPAD_MODE_PREF, (boolean)sCodepadOn);
        for (Codepad codepad : sCodepadList) {
            codepad.codepadModeToggled();
        }
    }

    public static boolean isCodepadEnabled() {
        return sCodepadOn;
    }

    public STPInterface getSyntaxTextPane() {
        return this.fSyntaxTextPane;
    }

    public void evalCurrentCell(boolean bl) {
        String string = this.fLineManager.getCellTextAtCaretPosition();
        if (string != null) {
            Codepad.startWaitOperation(EditorUtils.lookup("codepad.status.evalCell"), this.fContainer, this.fLineManager.getLineRange(), bl, this.fEvalRangeQueue);
            EditorUtils.getMatlab().evalConsoleOutputHonoringBreakpoints(string, new ErrorEvalObserver(this.fContainer, this.fEvalRangeQueue), 256);
        }
    }

    private static void startWaitOperation(final String string, final CodepadContainer codepadContainer, final int[] nArray, final boolean bl, final List<int[]> list) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (list.isEmpty()) {
                    codepadContainer.setStatusText(string);
                    codepadContainer.getSyntaxTextPane().setCursor(Cursor.getPredefinedCursor(3));
                    codepadContainer.getCodepad().fLineManager.setDisableHighlightRecalc(true);
                    codepadContainer.getCodepad().fLineManager.forceHighlightedLinesChange(nArray);
                }
                if (bl) {
                    try {
                        if (nArray[1] < codepadContainer.getSyntaxTextPane().getNumLines() - 1) {
                            Codepad.scrollDownToShowCell(nArray[1] + 1, codepadContainer.getSyntaxTextPane(), codepadContainer.getCodepad().fLineManager);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Log.logException((Exception)badLocationException);
                    }
                }
                list.add(nArray);
            }
        });
    }

    private static void endWaitOperation(final CodepadContainer codepadContainer, final List list) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                list.remove(0);
                if (list.isEmpty()) {
                    if (codepadContainer.getSyntaxTextPane() != null) {
                        codepadContainer.getSyntaxTextPane().setCursor(Cursor.getPredefinedCursor(2));
                        codepadContainer.getCodepad().fLineManager.setDisableHighlightRecalc(false);
                        if (Codepad.isCodepadEnabled()) {
                            Codepad.drawAreas(codepadContainer.getCodepad().fLineManager, codepadContainer.getSyntaxTextPane());
                        } else {
                            codepadContainer.getSyntaxTextPane().setHighlightedLines(null);
                        }
                    }
                    codepadContainer.setStatusText(null);
                } else if (codepadContainer.getCodepad() != null) {
                    codepadContainer.getCodepad().fLineManager.forceHighlightedLinesChange((int[])list.get(0));
                }
            }
        });
    }

    public CodepadActionManager getActionManager() {
        assert (this.fActionManager != null) : "ActionManager requested after having been cleaned up";
        return this.fActionManager;
    }

    private void codepadModeToggled() {
        this.fActionManager.enableCodepadActions(sCodepadOn, !this.fSyntaxTextPane.isSelectionEmpty(), Codepad.atNumericValue(this.fSyntaxTextPane));
        this.fLineManager.codepadModeToggled();
        if (!sCodepadOn) {
            this.updateCellModeMessage(false);
        }
    }

    static void drawAreas(TaggedLineManager taggedLineManager, STPInterface sTPInterface) {
        int[] nArray;
        if (!taggedLineManager.isHighlightRecalcDisabled()) {
            if (taggedLineManager.getShowHighlightedLines()) {
                nArray = taggedLineManager.getHighlightedLines();
                sTPInterface.setHighlightedLines(nArray);
                if (nArray.length > 0 && Codepad.isCodepadEnabled() && Prefs.getBooleanPref((String)CODEPAD_SHOW_INTRO_DIALOG_PREF, (boolean)true)) {
                    for (Codepad codepad : sCodepadList) {
                        if (codepad.fSyntaxTextPane != sTPInterface) continue;
                        codepad.updateCellModeMessage(true);
                        break;
                    }
                }
            } else {
                sTPInterface.setHighlightedLines(null);
            }
        }
        sTPInterface.setBoldLines(taggedLineManager.getLinesWithTitles());
        if (taggedLineManager.getShowCellDividers()) {
            nArray = taggedLineManager.getAllCellStartsAndEnds();
            for (int i = 1; i < nArray.length; i += 2) {
                int n = i;
                nArray[n] = nArray[n] + 1;
            }
            sTPInterface.setDrawAboveLines(nArray);
        } else {
            sTPInterface.setDrawAboveLines(null);
        }
    }

    private void updateCellModeMessage(boolean bl) {
        final JComponent jComponent = this.fContainer.getComponent();
        if (bl && this.fHyperlinkDemoComp == null) {
            Object[] objectArray = new String[]{this.createHyperlink(1, "Codepad.DemoMessage.Publishing"), this.createHyperlink(2, "Codepad.DemoMessage.Help")};
            String string = MessageFormat.format(EditorUtils.lookup("Codepad.DemoMessage"), objectArray);
            HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string, new HyperlinkTextLabel.HyperlinkHandler(){

                public void processHyperlink(String string) {
                    new DemoAction(jComponent, Integer.valueOf(string)).actionPerformed(null);
                }
            });
            hyperlinkTextLabel.setStatusBarHandler((HyperlinkTextLabel.HyperlinkStatusBarHandler)new MatlabHyperlinkStatusBarHandler(){

                protected String getStatusText(String string) {
                    return HYPERLINK_ALT_TEXT[Integer.valueOf(string)];
                }
            });
            this.fHyperlinkDemoComp = new CloseableMessageBar(hyperlinkTextLabel.getComponent(), (Icon)CommonIcon.INFO.getIcon(), (ActionListener)new DemoPanelClosedListener()).getComponent();
            jComponent.add(this.fHyperlinkDemoComp, "North");
            jComponent.revalidate();
        } else if (!bl && this.fHyperlinkDemoComp != null) {
            jComponent.remove(this.fHyperlinkDemoComp);
            this.fHyperlinkDemoComp = null;
            jComponent.revalidate();
        }
    }

    private String createHyperlink(int n, String string) {
        String string2 = "<a href=\"{0}\" alt=\"{1}\">{2}</a>";
        return MessageFormat.format(string2, n, HYPERLINK_ALT_TEXT[n], EditorUtils.lookup(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addCellDivider(STPInterface sTPInterface) {
        try {
            int n = sTPInterface.getSelectionStart();
            int n2 = sTPInterface.getLineFromPos(n);
            sTPInterface.startBlockEdit();
            if (DocumentUtils.isWithinInitialWhitespace((BaseDocument)((BaseDocument)sTPInterface.getDocument()), (int)n)) {
                Codepad.addDivider(n2, true, sTPInterface, null, null);
            } else {
                Codepad.addDivider(n2, false, sTPInterface, null, null);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPInterface.endBlockEdit();
        }
    }

    private static void addLineBeginning(int n, boolean bl, STPInterface sTPInterface, String string, String string2, String string3) throws BadLocationException {
        int n2;
        int n3;
        if (bl) {
            n2 = n3 = sTPInterface.getLineStart(n);
        } else {
            n3 = sTPInterface.getLineEndNoEOL(n);
            n2 = n3 + sTPInterface.getTerminator().length();
        }
        if (string != null && string.length() > 0) {
            string3 = string3 + " " + string;
        }
        if (string2 != null && string2.length() > 0) {
            string3 = string3 + string2;
        }
        sTPInterface.insert(n3, string3);
        int n4 = n3 + string3.length();
        if (bl) {
            n3 += string3.length();
        } else {
            n4 += sTPInterface.getTerminator().length();
        }
        sTPInterface.insert(n3, sTPInterface.getTerminator());
        Position position = sTPInterface.getDocument().createPosition(n4);
        sTPInterface.setCaretPosition(n2);
        sTPInterface.getSmartIndentAction().actionPerformed(new ActionEvent(sTPInterface.getActiveTextComponent(), 0, null));
        String string4 = DocumentUtils.getInitialWhitespaceOnLine((BaseDocument)((BaseDocument)sTPInterface.getDocument()), (int)n2);
        if (string4.length() > 0) {
            int n5 = sTPInterface.getLineFromPos(n2);
            int n6 = sTPInterface.getLineFromPos(position.getOffset());
            while (n5 < n6) {
                sTPInterface.insert(sTPInterface.getLineStart(++n5), string4);
            }
        }
        sTPInterface.setCaretPosition(position.getOffset());
    }

    private static void addDivider(int n, boolean bl, STPInterface sTPInterface, String string, String string2) throws BadLocationException {
        Codepad.addLineBeginning(n, bl, sTPInterface, string, string2, TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void defineCellSelection(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        try {
            boolean bl;
            int n = sTPInterface.getLineFromPos(sTPInterface.getSelectionStart());
            int n2 = sTPInterface.getLineFromPos(sTPInterface.getSelectionEnd());
            boolean bl2 = taggedLineManager.isCellStart(n, false);
            boolean bl3 = taggedLineManager.isCellEnd(n2);
            sTPInterface.startBlockEdit();
            boolean bl4 = bl = bl2 && !taggedLineManager.isCellStart(n, true) && taggedLineManager.getNumCells() == 1;
            if (!bl3 || bl) {
                if (sTPInterface.getSelectionEnd() == sTPInterface.getLineStart(n2)) {
                    Codepad.addDivider(n2, true, sTPInterface, null, null);
                } else {
                    Codepad.addDivider(n2, false, sTPInterface, null, null);
                }
            }
            if (!bl2 || bl) {
                Codepad.addDivider(n, true, sTPInterface, null, null);
            } else {
                sTPInterface.setCaretPosition(sTPInterface.getLineEndNoEOL(n));
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPInterface.endBlockEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertCellTitle(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        try {
            sTPInterface.startBlockEdit();
            int n = sTPInterface.getSelectionStart();
            int n2 = sTPInterface.getLineFromPos(n);
            if (taggedLineManager.isCellStart(n2, true)) {
                String string = sTPInterface.getLineTextNoEOL(n2);
                int n3 = sTPInterface.getLineStart(n2) + string.indexOf(TAG);
                if (string.indexOf("%% ") == -1) {
                    sTPInterface.insert(n3 + TAG.length(), " ");
                }
                int n4 = Math.max(n, n3 + "%% ".length());
                sTPInterface.insert(n4, "$%^SECTION TITLE\n% DESCRIPTIVE TEXT$%^");
                Codepad.selectMarkedTextAndSmartIndent(sTPInterface, n4);
            } else {
                boolean bl = DocumentUtils.isWithinInitialWhitespace((BaseDocument)((BaseDocument)sTPInterface.getDocument()), (int)n);
                Codepad.addDivider(n2, bl, sTPInterface, "$%^SECTION TITLE\n% DESCRIPTIVE TEXT$%^", null);
                Codepad.selectMarkedText(sTPInterface, n);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPInterface.endBlockEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertSectionTitleWithoutCell(STPInterface sTPInterface) {
        try {
            sTPInterface.startBlockEdit();
            int n = sTPInterface.getSelectionStart();
            int n2 = sTPInterface.getLineFromPos(n);
            String string = sTPInterface.getLineTextNoEOL(n2);
            boolean bl = string == null || Codepad.isWhitespace(string) || n == sTPInterface.getLineStart(n2);
            Codepad.addLineBeginning(n2, bl, sTPInterface, "$%^SECTION TITLE\n% DESCRIPTIVE TEXT$%^", null, TAG_WITHOUT_CELL_BREAK);
            Codepad.selectMarkedText(sTPInterface, n);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPInterface.endBlockEdit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertDocumentTitle(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        try {
            boolean bl;
            sTPInterface.startBlockEdit();
            sTPInterface.insert(0, "%% $%^DOCUMENT TITLE\n% INTRODUCTORY TEXT$%^\n");
            int n = taggedLineManager.getNextCellStart(TAG.length());
            boolean bl2 = bl = n == -1;
            if (!bl) {
                for (int i = 2; i < n && !bl; ++i) {
                    bl = !Codepad.isWhitespace(sTPInterface.getLineText(i));
                }
            }
            if (bl) {
                sTPInterface.insert(0 + "%% $%^DOCUMENT TITLE\n% INTRODUCTORY TEXT$%^\n".length(), "%%\n");
            }
            Codepad.selectMarkedText(sTPInterface, 0);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPInterface.endBlockEdit();
        }
    }

    private static void insertPreformattedText(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertBlockTextMarkup(sTPInterface, taggedLineManager, "%  ", PREFORMATTED_TEXT);
    }

    private static void insertSampleCode(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertBlockTextMarkup(sTPInterface, taggedLineManager, "%   ", SAMPLE_CODE);
    }

    private static void insertBlockTextMarkup(STPInterface sTPInterface, TaggedLineManager taggedLineManager, String string, String string2) {
        Codepad.insertBlockTextMarkup(sTPInterface, taggedLineManager, string, "", string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertBlockTextMarkup(STPInterface sTPInterface, TaggedLineManager taggedLineManager, String string, String string2, String string3) {
        string3 = SELECTION_MARK + string3 + SELECTION_MARK;
        try {
            int n;
            sTPInterface.startBlockEdit();
            int n2 = sTPInterface.getSelectionStart();
            int n3 = sTPInterface.getLineFromPos(n2);
            if (!Codepad.isInFormattedBlock(sTPInterface, n2, taggedLineManager.getPrevCellStart(n2)) && !taggedLineManager.isCellStart(n3, true)) {
                boolean bl = DocumentUtils.isWithinInitialWhitespace((BaseDocument)((BaseDocument)sTPInterface.getDocument()), (int)n2);
                Codepad.addDivider(n3, bl, sTPInterface, null, "\n% \n" + string + string3 + string2 + "\n" + DESCRIPTIVE_START);
                n = n2;
            } else {
                int n4;
                String string4 = "";
                if (taggedLineManager.isCellStart(n3, true) || !DocumentUtils.isWithinInitialWhitespace((BaseDocument)((BaseDocument)sTPInterface.getDocument()), (int)n2)) {
                    n4 = sTPInterface.getLineEndNoEOL(n3);
                    sTPInterface.insert(n4, "\n");
                    n = n4 + 1;
                } else {
                    n = sTPInterface.getLineStart(n3);
                    string4 = "\n";
                }
                n4 = sTPInterface.getLineFromPos(n) - 1;
                assert (n4 >= 0) : "There will be a previous line because we either inserted one aboveor we are NOT on a tag line and therefore we know that a previous tag line exists.";
                String string5 = DocumentUtils.getInitialWhitespaceOnLine((BaseDocument)((BaseDocument)sTPInterface.getDocument()), (int)sTPInterface.getLineStart(n4));
                sTPInterface.insert(n, Codepad.getExpandedText("% \n" + string + string3 + string2 + "\n" + DESCRIPTIVE_START, string5) + string4);
            }
            Codepad.selectMarkedText(sTPInterface, n);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPInterface.endBlockEdit();
        }
    }

    private static void selectMarkedTextAndSmartIndent(STPInterface sTPInterface, int n) throws BadLocationException {
        Codepad.selectMarkedText(sTPInterface, n);
        sTPInterface.getSmartIndentAction().actionPerformed(new ActionEvent(sTPInterface.getActiveTextComponent(), 0, null));
    }

    private static void selectMarkedText(STPInterface sTPInterface, int n) throws BadLocationException {
        BaseDocument baseDocument = (BaseDocument)sTPInterface.getDocument();
        FinderFactory.StringFwdFinder stringFwdFinder = new FinderFactory.StringFwdFinder(SELECTION_MARK, false);
        int n2 = baseDocument.find((Finder)stringFwdFinder, n, baseDocument.getLength());
        assert (n2 != -1) : "Did not find first instance of marker";
        int n3 = baseDocument.find((Finder)stringFwdFinder, n2 + 1, baseDocument.getLength());
        assert (n3 != -1) : "Did not find second instance of marker";
        sTPInterface.select(n2, n3);
        sTPInterface.delete(n3, n3 + SELECTION_MARK.length());
        sTPInterface.delete(n2, n2 + SELECTION_MARK.length());
    }

    private static String getExpandedText(String string, String string2) {
        String[] stringArray = string.split("\n");
        String string3 = "";
        for (int i = 0; i != stringArray.length; ++i) {
            string3 = string3 + string2 + stringArray[i];
            if (i == stringArray.length - 1) continue;
            string3 = string3 + "\n";
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertForceSnapshot(STPInterface sTPInterface) {
        int n = sTPInterface.getCaretPosition();
        try {
            n = sTPInterface.getLineEndNoEOL(sTPInterface.getLineFromPos(n));
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        try {
            sTPInterface.startBlockEdit();
            sTPInterface.insert(n, "$%^\nsnapnow;$%^");
            Codepad.selectMarkedTextAndSmartIndent(sTPInterface, n);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPInterface.endBlockEdit();
        }
    }

    private static void insertHyperlink(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertTextMarkup(" <", " <http://www.mathworks.com ", "> ", "http://www.mathworks.com MathWorks", sTPInterface, taggedLineManager);
    }

    private static void insertItalicText(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertTextMarkup(" _", "_ ", ITALIC_INSERT_TEXT, sTPInterface, taggedLineManager);
    }

    private static void insertBoldText(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertTextMarkup(" *", "* ", BOLD_INSERT_TEXT, sTPInterface, taggedLineManager);
    }

    private static void insertMonospacedText(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertTextMarkup(" |", "| ", MONO_INSERT_TEXT, sTPInterface, taggedLineManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertTextMarkup(String string, String string2, String string3, String string4, STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        boolean bl = !sTPInterface.isSelectionEmpty();
        string = bl ? string2 + SELECTION_MARK : string + SELECTION_MARK;
        string3 = SELECTION_MARK + string3;
        try {
            sTPInterface.startBlockEdit();
            int n = sTPInterface.getSelectionStart();
            int n2 = sTPInterface.getSelectionEnd();
            int n3 = sTPInterface.getLineFromPos(n);
            if (Codepad.isInFormattedBlock(sTPInterface, n, taggedLineManager.getPrevCellStart(n))) {
                n = Math.max(n, Math.min(sTPInterface.getFirstNonWhitespace(n3) + DESCRIPTIVE_START.length(), sTPInterface.getLineEndNoEOL(n3)));
            }
            while (n < n2 && Character.isWhitespace(sTPInterface.getCharAt(n))) {
                ++n;
            }
            while (n2 > n && Character.isWhitespace(sTPInterface.getCharAt(n2 - 1))) {
                --n2;
            }
            if (Codepad.isInFormattedBlock(sTPInterface, n2, taggedLineManager.getPrevCellStart(n2))) {
                n2 = Math.max(n2, sTPInterface.getFirstNonWhitespace(n3) + DESCRIPTIVE_START.length());
            }
            if (string.startsWith(" ") && n > 0 && Character.isWhitespace(sTPInterface.getCharAt(n - 1))) {
                string = string.substring(1);
            }
            if (string3.endsWith(" ") && n2 < sTPInterface.getLength() && Character.isWhitespace(sTPInterface.getCharAt(n2))) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            sTPInterface.setSelectionStart(n);
            sTPInterface.setSelectionEnd(n2);
            n3 = sTPInterface.getLineFromPos(n);
            int n4 = taggedLineManager.getPrevCellStart(n);
            int n5 = taggedLineManager.getPrevCellStart(n2);
            int n6 = n;
            if (n4 == n5 && Codepad.isInFormattedBlock(sTPInterface, n6, n4) && Codepad.isInFormattedBlock(sTPInterface, n2, n5)) {
                if (bl) {
                    sTPInterface.insert(n6, string);
                    sTPInterface.insert(n2 + string.length(), string3);
                } else {
                    sTPInterface.insert(n6, string + string4 + string3);
                }
            } else {
                if (Codepad.isInFormattedBlock(sTPInterface, n6, taggedLineManager.getPrevCellStart(n6))) {
                    sTPInterface.setSelectionStart(n6);
                    sTPInterface.insert(n6, string);
                } else {
                    if (string.startsWith(" ")) {
                        string = string.substring(1);
                    }
                    String string5 = "%%\n% " + string;
                    String string6 = sTPInterface.getLineTextNoEOL(n3);
                    if (!(string6.equals("") || sTPInterface.getSelectedText() == null && sTPInterface.getSelectionStart() == sTPInterface.getLineStart(n3) || sTPInterface.getSelectedText() != null && sTPInterface.getSelectedText().indexOf(string6) != -1)) {
                        sTPInterface.insert(n6, "\n");
                        ++n;
                    }
                    EditorViewUtils.insertAndSmartIndent(sTPInterface, string5, n);
                }
                for (int i = sTPInterface.getLineFromPos(sTPInterface.getSelectionStart()) + 1; i <= sTPInterface.getLineFromPos(sTPInterface.getSelectionEnd()); ++i) {
                    int n7 = Math.max(sTPInterface.getLineStart(i), sTPInterface.getFirstNonWhitespace(i));
                    if (Codepad.isInFormattedBlock(sTPInterface, n7, taggedLineManager.getPrevCellStart(n7))) continue;
                    sTPInterface.insert(n7, DESCRIPTIVE_START);
                }
                sTPInterface.insert(sTPInterface.getSelectionEnd(), bl ? string3 : string4 + string3);
            }
            Codepad.selectMarkedText(sTPInterface, n6);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        finally {
            sTPInterface.endBlockEdit();
        }
    }

    private static void insertTextMarkup(String string, String string2, String string3, STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertTextMarkup(string, string, string2, string3, sTPInterface, taggedLineManager);
    }

    private static void insertBulletedList(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertBlockTextMarkup(sTPInterface, taggedLineManager, "% * ", BULLETED_LIST);
    }

    private static void insertTexEquation(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertBlockTextMarkup(sTPInterface, taggedLineManager, "% $$", "$$", TEX_EQ);
    }

    private static void insertHtmlMarkup(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertBlockTextMarkup(sTPInterface, taggedLineManager, "% <html>\n% ", "\n% </html>", HTML_MARKUP);
    }

    private static void insertImage(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertBlockTextMarkup(sTPInterface, taggedLineManager, "% <<", ">>", IMAGE);
    }

    private static void insertLatexMarkup(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertBlockTextMarkup(sTPInterface, taggedLineManager, "% <latex>\n% ", "\n% </latex>", LATEX_MARKUP);
    }

    private static void insertInlineMath(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertTextMarkup(" $", "$ ", INLINE_MATH_TEXT, sTPInterface, taggedLineManager);
    }

    private static void insertNumberedList(STPInterface sTPInterface, TaggedLineManager taggedLineManager) {
        Codepad.insertBlockTextMarkup(sTPInterface, taggedLineManager, "% # ", NUMBERED_LIST);
    }

    private void evalAll() {
        try {
            String string = this.fSyntaxTextPane.getText();
            Codepad.startWaitOperation(EditorUtils.lookup("codepad.status.evalAll"), this.fContainer, new int[]{0, this.fSyntaxTextPane.getNumLines() - 1}, false, this.fEvalRangeQueue);
            EditorUtils.getMatlab().evalConsoleOutputHonoringBreakpoints(string, new ErrorEvalObserver(this.fContainer, this.fEvalRangeQueue, true), 256);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            System.gc();
            System.runFinalization();
            DialogFactory.showErrorMessage(EditorUiUtils.getParentFrame(this.fSyntaxTextPane.getComponentForDialog()), EditorUtils.lookup("msg.Notenoughmemorytoeval") + outOfMemoryError.getLocalizedMessage());
        }
    }

    private void nextCell() {
        try {
            Codepad.scrollDownToShowCell(this.fLineManager.getNextCellStart(this.fSyntaxTextPane.getCaretPosition()), this.fSyntaxTextPane, this.fLineManager);
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private static void scrollDownToShowCell(int n, STPInterface sTPInterface, TaggedLineManager taggedLineManager) throws BadLocationException {
        if (n != -1 && n < sTPInterface.getNumLines()) {
            int n2 = DocumentUtils.getLineStartAfterWhitespace((BaseDocument)((BaseDocument)sTPInterface.getDocument()), (int)n);
            int n3 = taggedLineManager.getNextCellStart(n2);
            if (n3 == -1 || n3 >= sTPInterface.getNumLines()) {
                n3 = sTPInterface.getNumLines() - 1;
            }
            Codepad.scroll(false, n2, sTPInterface.getLineStart(n3), sTPInterface);
        }
    }

    private void prevCell() {
        try {
            int n = this.fSyntaxTextPane.getCaretPosition();
            int n2 = this.fLineManager.getPrevCellStart(n);
            int n3 = -1;
            if (n2 >= 0) {
                n3 = DocumentUtils.getLineStartAfterWhitespace((BaseDocument)((BaseDocument)this.fSyntaxTextPane.getDocument()), (int)n2);
                if (n3 == n) {
                    n3 = -1;
                    if (n >= 1) {
                        n2 = this.fLineManager.getPrevCellStart(n - 1);
                        if (n2 >= 0) {
                            n3 = DocumentUtils.getLineStartAfterWhitespace((BaseDocument)((BaseDocument)this.fSyntaxTextPane.getDocument()), (int)n2);
                        } else if (this.fSyntaxTextPane.getLineStart(0) != n) {
                            n3 = DocumentUtils.getLineStartAfterWhitespace((BaseDocument)((BaseDocument)this.fSyntaxTextPane.getDocument()), (int)0);
                        }
                    }
                }
            } else if (this.fSyntaxTextPane.getLineStart(0) != n) {
                n3 = DocumentUtils.getLineStartAfterWhitespace((BaseDocument)((BaseDocument)this.fSyntaxTextPane.getDocument()), (int)0);
            }
            if (n3 != -1) {
                int n4 = this.fLineManager.getNextCellStart(n3);
                if (n4 == -1 || n4 >= this.fSyntaxTextPane.getNumLines()) {
                    n4 = this.fSyntaxTextPane.getNumLines() - 1;
                }
                Codepad.scroll(true, n3, this.fSyntaxTextPane.getLineStart(n4), this.fSyntaxTextPane);
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
    }

    private static void scroll(boolean bl, int n, int n2, final STPInterface sTPInterface) {
        int n3 = (int)(100.0 * (double)sTPInterface.getLineHeight() / sTPInterface.getExtentBounds().getHeight());
        try {
            Rectangle rectangle = sTPInterface.modelToView(n);
            Rectangle rectangle2 = sTPInterface.modelToView(n2);
            Rectangle rectangle3 = new Rectangle(rectangle.createUnion(rectangle2).getBounds());
            Rectangle rectangle4 = sTPInterface.getExtentBounds();
            if (rectangle4.contains(rectangle3)) {
                sTPInterface.setCaretPosition(n);
                JumpList.checkAddEntry((JTextComponent)sTPInterface.getActiveTextComponent());
                return;
            }
            if (rectangle3.height < rectangle4.height && bl) {
                n3 = (int)(100.0 * (1.0 - rectangle3.getHeight() / rectangle4.getHeight()));
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        sTPInterface.setCaretPosition(n);
        JumpList.checkAddEntry((JTextComponent)sTPInterface.getActiveTextComponent());
        final int n4 = n3;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                sTPInterface.setCursorPercentFromTop(n4);
            }
        });
    }

    private static void showCellModeDemos(Component component) {
        Action[] actionArray = new Action[]{new DemoAction(component, 0), new DemoAction(component, 1), new DemoAction(component, 2)};
        ScrollablePopupList scrollablePopupList = new ScrollablePopupList(actionArray);
        scrollablePopupList.showPopup(component, 0, component.getHeight());
    }

    private void showCellTitles(Component component) {
        Action[] actionArray;
        int[] nArray = this.getExplicitCellStartLines();
        Object[] objectArray = this.getCellTitles(nArray);
        PopupCallback popupCallback = new PopupCallback();
        if (objectArray.length == 0) {
            actionArray = new Action[]{new PopupAction(popupCallback)};
        } else {
            actionArray = new Action[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                actionArray[i] = new PopupAction(popupCallback, objectArray[i].toString(), nArray[i]);
            }
        }
        ScrollablePopupList scrollablePopupList = new ScrollablePopupList(actionArray);
        scrollablePopupList.showPopup(component, 0, component.getHeight());
    }

    public List<Action> getGoToCellActions() {
        int[] nArray = this.getExplicitCellStartLines();
        Object[] objectArray = this.getCellTitles(nArray);
        ArrayList<Action> arrayList = new ArrayList<Action>();
        PopupCallback popupCallback = new PopupCallback();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.add((Action)((Object)new PopupAction(popupCallback, objectArray[i].toString(), nArray[i])));
        }
        return arrayList;
    }

    public int[] getExplicitCellStartLines() {
        return this.fLineManager.getLinesWithTitles();
    }

    public Object[] getCellTitles(int[] nArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 1;
        for (int i = 0; i != nArray.length; ++i) {
            try {
                String string = this.fSyntaxTextPane.getLineText(nArray[i]).trim();
                boolean bl = string.startsWith("%% ");
                if (bl) {
                    if ((string = string.substring(TAG.length()).trim()).length() > 0) {
                        arrayList.add(string);
                    } else {
                        bl = false;
                    }
                }
                if (bl) continue;
                arrayList.add(Codepad.getUntitledCellObject(n++));
                continue;
            }
            catch (BadLocationException badLocationException) {
                Log.logException((Exception)badLocationException);
            }
        }
        return arrayList.toArray();
    }

    private static Object getUntitledCellObject(int n) {
        String string = MessageFormat.format(EditorUtils.lookup("codepad.untitledName"), n);
        return new UntitledCellObject(string, n);
    }

    private static boolean isWhitespace(String string) {
        return StringUtils.isWhitespace((String)string);
    }

    public static boolean atNumericValue(STPInterface sTPInterface) {
        return Codepad.numericSelection(false, sTPInterface);
    }

    private static boolean numericSelection(boolean bl, STPInterface sTPInterface) {
        int n = sTPInterface.getSelectionStart();
        int n2 = sTPInterface.getLength();
        try {
            int n3;
            for (n3 = sTPInterface.getSelectionEnd(); n3 < n2 && Codepad.isNumeric(sTPInterface.getTextStartEnd(n, n3 + 1)); ++n3) {
            }
            while (n > 0 && Codepad.isNumeric(sTPInterface.getTextStartEnd(n - 1, n3))) {
                --n;
            }
            if (n == n3) {
                return false;
            }
            String string = sTPInterface.getTextStartEnd(n, n3);
            if (string.equals(".") || !Codepad.isNumeric(string)) {
                return false;
            }
            if (bl) {
                sTPInterface.select(n, n3);
            }
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        return true;
    }

    private static boolean isNumeric(String string) {
        if (string.equals(".")) {
            return true;
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = NUMERIC_FORMAT.parse(string, parsePosition);
        return number != null && parsePosition.getIndex() == string.length();
    }

    private void incrementNumber() {
        if (Codepad.numericSelection(true, this.fSyntaxTextPane)) {
            this.tweakNumber(107);
        }
    }

    private void decrementNumber() {
        if (Codepad.numericSelection(true, this.fSyntaxTextPane)) {
            this.tweakNumber(109);
        }
    }

    private void multiplyNumber() {
        if (Codepad.numericSelection(true, this.fSyntaxTextPane)) {
            this.tweakNumber(106);
        }
    }

    private void divideNumber() {
        if (Codepad.numericSelection(true, this.fSyntaxTextPane)) {
            this.tweakNumber(111);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tweakNumber(int n) {
        double d;
        String string = this.fSyntaxTextPane.getSelectedText();
        try {
            d = NUMERIC_FORMAT.parse(string).doubleValue();
        }
        catch (ParseException parseException) {
            return;
        }
        try {
            double d2 = n == 107 || n == 109 ? this.fActionManager.getIncrementValue() : this.fActionManager.getMultiplyValue();
            d = n == 107 || n == 109 ? (n == 107 ? (d += d2) : (d -= d2)) : (n == 106 ? (d *= d2) : (d /= d2));
            int n2 = this.fSyntaxTextPane.getSelectionStart();
            string = NUMERIC_FORMAT.format(d);
            this.fSyntaxTextPane.startBlockEdit();
            try {
                this.fSyntaxTextPane.replace(n2, this.fSyntaxTextPane.getSelectionEnd(), string);
                this.fSyntaxTextPane.select(n2, n2 + string.length());
            }
            finally {
                this.fSyntaxTextPane.endBlockEdit();
            }
            this.evalCurrentCell(false);
        }
        catch (Exception exception) {
            Log.logException((Exception)exception);
        }
    }

    private void setShowHighlightedLines(boolean bl) {
        this.fLineManager.setShowHighlightedLines(bl);
    }

    private void setShowCellDividers(boolean bl) {
        this.fLineManager.setShowCellDividers(bl);
    }

    private static boolean isInFormattedBlock(STPInterface sTPInterface, int n, int n2) {
        try {
            int n3 = sTPInterface.getLineFromPos(n);
            if (n2 + 1 > n3) {
                return false;
            }
            for (int i = n2 + 1; i <= n3; ++i) {
                String string = sTPInterface.getLineText(i).trim();
                if (string.startsWith(DESCRIPTIVE_START) || string.equals("%")) continue;
                return false;
            }
            return true;
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
            return false;
        }
    }

    public static TaggedLineManager getLineManager(STPInterface sTPInterface, CodepadActionManager codepadActionManager) {
        return new TaggedLineManager(sTPInterface, codepadActionManager, CodepadOptions.isCodepadHighlightingOn(), CodepadOptions.isCodeDividersOn());
    }

    static {
        sCodepadList = new ArrayList<Codepad>();
        sCodepadOn = Prefs.getBooleanPref((String)CODEPAD_MODE_PREF, (boolean)true);
        HYPERLINK_ALT_TEXT = new String[]{EditorUtils.lookup("Codepad.DemoMessage.acc.RapidIteration"), EditorUtils.lookup("Codepad.DemoMessage.acc.Publishing"), EditorUtils.lookup("Codepad.DemoMessage.acc.Help")};
        CodepadActionManager.codepadModeToggled(sCodepadOn);
        NUMERIC_FORMAT = NumberFormat.getNumberInstance(Locale.US);
        NUMERIC_FORMAT.setMaximumFractionDigits(5);
        NUMERIC_FORMAT.setGroupingUsed(false);
    }

    private class CodepadPrefListener
    implements PrefListener {
        private CodepadPrefListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            final String string = prefEvent.getPrefKey();
            MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (string.equals("EditorCodeBlockDividers")) {
                        Codepad.this.setShowCellDividers(CodepadOptions.isCodeDividersOn());
                    } else if (string.equals("EditorCodepadHighVisible")) {
                        Codepad.this.setShowHighlightedLines(CodepadOptions.isCodepadHighlightingOn());
                    }
                }
            });
        }
    }

    public static class TaggedLineManager {
        private boolean fShowHighlightedLines;
        private boolean fShowCellDividers;
        private DocumentListener fDocumentListener = new CodepadDocumentListener();
        private CodepadCaretListener fCaretListener = new CodepadCaretListener();
        private boolean fDisableHighlightRecalc;
        private STPInterface fPane;
        private CodepadActionManager fActionManager;
        private BaseDocumentCellInfo fCellInfo;
        private final RedrawTimer fUpdateTimer = new RedrawTimer(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TaggedLineManager.this.doRedraw();
            }
        });

        private TaggedLineManager(STPInterface sTPInterface, CodepadActionManager codepadActionManager, boolean bl, boolean bl2) {
            this.fPane = sTPInterface;
            this.fActionManager = codepadActionManager;
            this.fShowHighlightedLines = bl;
            this.fShowCellDividers = bl2;
            if (sCodepadOn) {
                this.codepadTurnedOn();
            }
        }

        void cleanup() {
            this.codepadTurnedOff();
            this.fPane = null;
            this.fActionManager = null;
        }

        private void doRedraw() {
            Codepad.drawAreas(this, this.fPane);
            if (sCodepadOn) {
                assert (this.fCellInfo != null) : "Should have a valid cell info object";
                this.fCellInfo.storeCurrentCell(this.fPane.getCaretPosition());
            }
        }

        private void codepadTurnedOn() {
            this.fPane.getDocument().addDocumentListener(this.fDocumentListener);
            this.fPane.addCaretListener((CaretListener)this.fCaretListener);
            this.fCellInfo = new BaseDocumentCellInfo((BaseDocument)this.fPane.getDocument());
        }

        private void codepadTurnedOff() {
            this.fUpdateTimer.stop();
            this.fPane.getDocument().removeDocumentListener(this.fDocumentListener);
            this.fPane.removeCaretListener((CaretListener)this.fCaretListener);
            this.fCellInfo = null;
        }

        private void codepadModeToggled() {
            if (sCodepadOn) {
                this.codepadTurnedOn();
            } else {
                this.codepadTurnedOff();
            }
            Codepad.drawAreas(this, this.fPane);
        }

        void setDisableHighlightRecalc(boolean bl) {
            this.fDisableHighlightRecalc = bl;
        }

        boolean isHighlightRecalcDisabled() {
            return this.fDisableHighlightRecalc;
        }

        int[] getHighlightedLines() {
            if (!sCodepadOn) {
                return ArrayUtils.EmptyPrimitives.INT;
            }
            this.assertCodepadOn();
            int[] nArray = this.fCellInfo.isOneImplicitCell() ? null : this.getLineRange();
            return nArray != null ? TaggedLineManager.createLinesFromRange(nArray[0], nArray[1]) : ArrayUtils.EmptyPrimitives.INT;
        }

        void setShowHighlightedLines(boolean bl) {
            boolean bl2 = this.fShowHighlightedLines;
            this.fShowHighlightedLines = bl;
            this.updateAreasIfChanged(bl2, bl);
        }

        void setShowCellDividers(boolean bl) {
            boolean bl2 = this.fShowCellDividers;
            this.fShowCellDividers = bl;
            this.updateAreasIfChanged(bl2, bl);
        }

        private void updateAreasIfChanged(boolean bl, boolean bl2) {
            if (bl != bl2) {
                Codepad.drawAreas(this, this.fPane);
            }
        }

        boolean getShowHighlightedLines() {
            return this.fShowHighlightedLines;
        }

        boolean getShowCellDividers() {
            return this.fShowCellDividers;
        }

        public boolean isCellStart(int n, boolean bl) {
            this.assertCodepadOn();
            int[] nArray = bl ? this.getLinesWithTitles() : this.getCellStartLines();
            return Arrays.binarySearch(nArray, n) >= 0;
        }

        public boolean isCellEnd(int n) {
            this.assertCodepadOn();
            int n2 = Utilities.getRowStartFromLineOffset((BaseDocument)this.fCellInfo.getDocument(), (int)n);
            int[] nArray = this.fCellInfo.getStartAndEndOfCell(n2);
            return nArray != null && nArray[1] == n;
        }

        public int getPrevCellStart(int n) {
            this.assertCodepadOn();
            return this.fCellInfo.getPrevCellStartLine(n);
        }

        public int getNextCellStart(int n) {
            this.assertCodepadOn();
            return this.fCellInfo.getNextCellStartLine(n);
        }

        private void assertCodepadOn() {
            assert (sCodepadOn) : "Should only be called if Codepad is on.";
            assert (this.fCellInfo != null) : "Should have a valid cell info object";
        }

        public int getNumCells() {
            return this.getCellStartLines().length;
        }

        int[] getCellStartLines() {
            return sCodepadOn ? this.fCellInfo.getAllCellStarts() : ArrayUtils.EmptyPrimitives.INT;
        }

        int[] getAllCellStartsAndEnds() {
            return sCodepadOn ? this.fCellInfo.getAllCellStartsAndEnds() : ArrayUtils.EmptyPrimitives.INT;
        }

        int[] getLinesWithTitles() {
            return sCodepadOn ? this.fCellInfo.getTitleLines() : ArrayUtils.EmptyPrimitives.INT;
        }

        void forceHighlightedLinesChange(int[] nArray) {
            if (nArray != null && this.getShowHighlightedLines()) {
                int n = Math.min(nArray[0], this.fPane.getNumLines() - 1);
                int n2 = Math.min(nArray[1], this.fPane.getNumLines() - 1);
                this.fPane.setHighlightedLines(TaggedLineManager.createLinesFromRange(n, n2));
            }
        }

        private static int[] createLinesFromRange(int n, int n2) {
            int[] nArray = new int[n2 - n + 1];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i + n;
            }
            return nArray;
        }

        public int[] getLineRange() {
            this.assertCodepadOn();
            return this.fCellInfo.getStartAndEndOfCell(this.fPane.getCaretPosition());
        }

        private String getCellTextAtCaretPosition() {
            return this.fCellInfo.getCellTextAtCaret(this.fPane.getCaretPosition());
        }

        private class CodepadCaretListener
        implements CaretListener {
            private CodepadCaretListener() {
            }

            @Override
            public void caretUpdate(CaretEvent caretEvent) {
                if (TaggedLineManager.this.fActionManager != null) {
                    TaggedLineManager.this.fActionManager.enableCodepadSelectionDependentActions(!TaggedLineManager.this.fPane.isSelectionEmpty());
                    TaggedLineManager.this.fActionManager.enableCodepadValueActions(Codepad.atNumericValue(TaggedLineManager.this.fPane));
                }
                TaggedLineManager.this.assertCodepadOn();
                if (!TaggedLineManager.this.fCellInfo.isCellSameAsLast(TaggedLineManager.this.fPane.getCaretPosition())) {
                    TaggedLineManager.this.fUpdateTimer.fire();
                }
            }
        }

        private class CodepadDocumentListener
        implements DocumentListener {
            private CodepadDocumentListener() {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (documentEvent instanceof BaseDocumentEvent && ((BaseDocumentEvent)documentEvent).getText().contains("\n")) {
                    TaggedLineManager.this.fUpdateTimer.fire();
                } else {
                    TaggedLineManager.this.fUpdateTimer.restart();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                TaggedLineManager.this.fUpdateTimer.restart();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        }
    }

    private static class UntitledCellObject
    implements Comparable {
        private String iName;
        private int iIndex;

        UntitledCellObject(String string, int n) {
            this.iName = string;
            this.iIndex = n;
        }

        public String toString() {
            return this.iName;
        }

        public int compareTo(Object object) {
            if (object instanceof String) {
                return this.toString().compareTo((String)object);
            }
            if (object instanceof UntitledCellObject) {
                return this.iIndex - ((UntitledCellObject)object).iIndex;
            }
            return 0;
        }

        public boolean equals(Object object) {
            if (object instanceof UntitledCellObject) {
                return this.iName.equals(((UntitledCellObject)object).iName) && this.iIndex == ((UntitledCellObject)object).iIndex;
            }
            return super.equals(object);
        }

        public int hashCode() {
            return this.iName.hashCode();
        }
    }

    private class PopupCallback
    implements PopupAction.Callback {
        private PopupCallback() {
        }

        @Override
        public void gotoLine(int n) {
            Codepad.this.fContainer.goToLine(n + 1);
        }

        @Override
        public void requestFocusInPane() {
            Codepad.this.fSyntaxTextPane.requestFocus();
        }

        @Override
        public String getDefaultLabel() {
            return EditorUtils.lookup("toolbar.CodepadNoCells");
        }
    }

    public static class DemoAction
    extends MJAbstractAction
    implements CompletionObserver {
        private final Component iErrorComp;
        private final int iType;
        public static final int RAPID_ITERATION = 0;
        public static final int PUBLISH = 1;
        public static final int DOCUMENTATION = 2;

        public DemoAction(Component component, int n) {
            assert (n == 0 || n == 1 || n == 2);
            this.iType = n;
            if (this.iType == 0) {
                this.setName(EditorUtils.lookup("toolbar.CodepadDemoRapidIteration"));
            } else if (this.iType == 1) {
                this.setName(EditorUtils.lookup("toolbar.CodepadDemoPublish"));
            } else {
                this.setName(EditorUtils.lookup("toolbar.CodepadDemoDoc"));
            }
            if (this.iType == 0 || this.iType == 1) {
                this.setButtonOnlyIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/com/mathworks/mwswing/resources/demotypeVideoSm.gif")));
            } else {
                this.setButtonOnlyIcon(CommonIcon.HELP.getIcon());
            }
            this.iErrorComp = component;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.iType == 0) {
                EditorUtils.getMatlab().evalConsoleOutput("playbackdemo('RapidCodeIterationUsingCells_viewlet_swf')", this);
            } else if (this.iType == 1) {
                EditorUtils.getMatlab().evalConsoleOutput("playbackdemo('PublishingfromtheEditor_viewlet_swf')", this);
            } else {
                MLHelpServices.displayTopic((String)MLHelpServices.getMapfileName((String)"matlab", (String)"helptargets"), (String)"matlabenvironment_cellmodeintro");
            }
        }

        public void completed(int n, Object object) {
            if (Matlab.getExecutionStatus((int)n) != 0 && object instanceof String) {
                DialogFactory.showErrorMessage(this.iErrorComp, (String)object);
            }
        }
    }

    private static class DemoPanelClosedListener
    implements ActionListener {
        private DemoPanelClosedListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Prefs.setBooleanPref((String)Codepad.CODEPAD_SHOW_INTRO_DIALOG_PREF, (boolean)false);
            for (Codepad codepad : sCodepadList) {
                codepad.updateCellModeMessage(false);
            }
        }
    }

    private static class ErrorEvalObserver
    implements CompletionObserver {
        private final CodepadContainer iContainer;
        private final boolean iCompleteFile;
        private final List iEvalRangeQueue;

        private ErrorEvalObserver(CodepadContainer codepadContainer, List list) {
            this(codepadContainer, list, false);
        }

        private ErrorEvalObserver(CodepadContainer codepadContainer, List list, boolean bl) {
            this.iContainer = codepadContainer;
            this.iCompleteFile = bl;
            this.iEvalRangeQueue = list;
        }

        public void completed(int n, Object object) {
            Codepad.endWaitOperation(this.iContainer, this.iEvalRangeQueue);
            if (Matlab.getCodeBlockStatus((int)n) != 0) {
                final String string = object != null && object instanceof String && ((CharSequence)object).length() > 0 ? (String)object : (Matlab.getCodeBlockStatus((int)n) == 1 ? (this.iCompleteFile ? EditorUtils.lookup("error.evalFile") : EditorUtils.lookup("error.eval")) : (this.iCompleteFile ? EditorUtils.lookup("error.evalInvalidFile") : EditorUtils.lookup("error.evalInvalid")));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DialogFactory.showErrorMessage(ErrorEvalObserver.this.iContainer.getSyntaxTextPane().getComponentForDialog(), string);
                    }
                });
            }
        }
    }
}

