/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.editor.plugins.matlab;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.matlab.api.editor.Editor;
import com.mathworks.mde.editor.DialogFactory;
import com.mathworks.mde.editor.EditorStartup;
import com.mathworks.mde.editor.EditorUiUtils;
import com.mathworks.mde.editor.EditorUtils;
import com.mathworks.mde.editor.plugins.matlab.MatlabPluginUtils;
import com.mathworks.mlservices.MatlabDebugAdapter;
import com.mathworks.mlservices.MatlabDebugObserver;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlservices.MatlabExecutionErrorHandler;
import com.mathworks.mlwidgets.configeditor.data.AbstractFileConfiguration;
import com.mathworks.mlwidgets.configeditor.data.ConfigurationManager;
import com.mathworks.mlwidgets.configeditor.data.PublishConfiguration;
import com.mathworks.mlwidgets.configeditor.data.RunConfiguration;
import com.mathworks.mlwidgets.configeditor.ui.ActionRequestListener;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationEditor;
import com.mathworks.mlwidgets.configeditor.ui.ConfigurationUiUtils;
import com.mathworks.mlwidgets.dialog.PathChange;
import com.mathworks.widgets.datamodel.FileStorageLocation;
import com.mathworks.widgets.desk.DTWindowCloser;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import org.apache.commons.lang.Validate;
import org.jetbrains.annotations.Nullable;

public class EditorSaveRunAndPublishUtils {
    private static final String PATH_DIALOG_HELP_PREFIX = "ml_env_ed";
    private static ConfigurationEditor sConfigurationEditor;
    private static boolean sNeedToPrime;

    private EditorSaveRunAndPublishUtils() {
    }

    public static void saveFileAndDoConfigurationAction(Editor editor, AbstractFileConfiguration abstractFileConfiguration, AbstractFileConfiguration.Type<?> type, @Nullable MatlabExecutionErrorHandler matlabExecutionErrorHandler) {
        if (editor.negotiateSave() && !EditorSaveRunAndPublishUtils.showErrorIfFileIsNotActionable(editor, type)) {
            FileStorageLocation fileStorageLocation = (FileStorageLocation)editor.getStorageLocation();
            AbstractFileConfiguration abstractFileConfiguration2 = abstractFileConfiguration == null ? ConfigurationManager.getInstance().getMostRecentlyActionedConfigurationForFileOrDefault(fileStorageLocation.getFile(), type) : abstractFileConfiguration;
            EditorSaveRunAndPublishUtils.doConfigurationActionAfterPromptingAboutPath(abstractFileConfiguration2, editor.getComponent(), matlabExecutionErrorHandler);
        }
    }

    public static void showConfigurationEditor(Editor editor, AbstractFileConfiguration.Type<?> type) {
        Validate.isTrue((editor.isBuffer() || editor.getStorageLocation() instanceof FileStorageLocation ? 1 : 0) != 0, (String)("The editor must be backed by a file: " + editor.getStorageLocation()));
        if (editor.negotiateSave() && !EditorSaveRunAndPublishUtils.showErrorIfFileIsNotActionable(editor, type)) {
            FileStorageLocation fileStorageLocation = (FileStorageLocation)editor.getStorageLocation();
            EditorSaveRunAndPublishUtils.showConfigurationEditor(fileStorageLocation.getFile(), type);
        }
    }

    public static void showConfigurationEditor(File file, AbstractFileConfiguration.Type<?> type) {
        ConfigurationEditor configurationEditor = EditorSaveRunAndPublishUtils.getConfigurationEditor();
        configurationEditor.showConfigurationsForFile(file, type);
        configurationEditor.getFrame().setVisible(true);
        configurationEditor.getFrame().toFront();
    }

    public static boolean showErrorIfFileIsNotActionable(Editor editor, AbstractFileConfiguration.Type<?> type) {
        boolean bl;
        boolean bl2 = bl = !MatlabPluginUtils.isMatlabFileEndingInDotM(editor);
        if (bl) {
            DialogFactory.showErrorMessage(EditorUiUtils.getParentFrame(editor.getComponent()), ConfigurationUiUtils.getIncorrectExtensionErrorMessage(type));
        }
        return bl;
    }

    private static void doConfigurationActionAfterPromptingAboutPath(AbstractFileConfiguration abstractFileConfiguration, Component component) {
        EditorSaveRunAndPublishUtils.doConfigurationActionAfterPromptingAboutPath(abstractFileConfiguration, component, null);
    }

    private static void doConfigurationActionAfterPromptingAboutPath(final AbstractFileConfiguration abstractFileConfiguration, final Component component, final @Nullable MatlabExecutionErrorHandler matlabExecutionErrorHandler) {
        ConfigurationManager.getInstance().setMostRecentlyActionedConfigurationForFile(abstractFileConfiguration);
        CompletionObserver completionObserver = new CompletionObserver(){

            public void completed(int n, Object object) {
                ConfigurationManager.getInstance().doConfigurationAction(abstractFileConfiguration, component, matlabExecutionErrorHandler);
            }
        };
        File file = abstractFileConfiguration.getAssociatedFile();
        new PathChange(EditorUiUtils.getParentFrame(component), EditorUtils.EDITOR_TITLE, EditorSaveRunAndPublishUtils.getPathChangeWindowTitle(abstractFileConfiguration), file.getAbsolutePath(), file, completionObserver, PATH_DIALOG_HELP_PREFIX);
    }

    private static ConfigurationEditor getConfigurationEditor() {
        if (sConfigurationEditor == null) {
            sConfigurationEditor = new ConfigurationEditor(new ActionRequestListener(){

                public void actionRequested(AbstractFileConfiguration abstractFileConfiguration, Component component) {
                    EditorSaveRunAndPublishUtils.doConfigurationActionAfterPromptingAboutPath(abstractFileConfiguration, component);
                }
            });
            sConfigurationEditor.setActionButtonEnabled(!EditorStartup.getInDebugMode());
            sConfigurationEditor.getFrame().addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent windowEvent) {
                    sConfigurationEditor = null;
                }
            });
        }
        if (sNeedToPrime) {
            EditorSaveRunAndPublishUtils.prime();
        }
        return sConfigurationEditor;
    }

    private static String getPathChangeWindowTitle(AbstractFileConfiguration abstractFileConfiguration) {
        String string = "";
        if (abstractFileConfiguration.getType().equals(RunConfiguration.TYPE)) {
            string = EditorUtils.lookup("msg.ToRun");
        } else if (abstractFileConfiguration.getType().equals(PublishConfiguration.TYPE)) {
            string = EditorUtils.lookup("msg.ToPublish");
        }
        return string;
    }

    private static void registerForMatlabDesktopCloseEvent() {
        MatlabDesktopServices.getDesktop().getWindowRegistry().addCloser(new DTWindowCloser(){

            public boolean canClose() {
                return true;
            }

            public void close() {
                ConfigurationManager.getInstance().persist(true);
            }
        });
    }

    private static void registerMatlabDebugAdapter() {
        MatlabDebugAdapter matlabDebugAdapter = new MatlabDebugAdapter(){

            public void doDebugMode(boolean bl) {
                if (sConfigurationEditor != null) {
                    sConfigurationEditor.setActionButtonEnabled(!bl);
                }
            }
        };
        EditorStartup.addDebugObserver((MatlabDebugObserver)matlabDebugAdapter);
    }

    private static void prime() {
        assert (sNeedToPrime);
        EditorSaveRunAndPublishUtils.registerForMatlabDesktopCloseEvent();
        EditorSaveRunAndPublishUtils.registerMatlabDebugAdapter();
        sNeedToPrime = false;
    }

    static {
        sNeedToPrime = true;
    }
}

