/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.functionbrowser;

import com.mathworks.mde.functionbrowser.FunctionBrowser;
import com.mathworks.mlservices.MLPrefsDialogServices;
import com.mathworks.mlwidgets.actionbrowser.FunctionReferenceUtils;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import com.mathworks.services.Prefs;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

class ProductScopePanel
extends MJPanel {
    private MJLabel fProductLabel;
    private static final String resStr = "com.mathworks.mde.functionbrowser.resources.RES_FunctionBrowser";
    private static final String key = "ProductScopePanel.";
    private static ResourceBundle resources = ResourceBundle.getBundle("com.mathworks.mde.functionbrowser.resources.RES_FunctionBrowser");
    private static Color TEXT_FORGROUND = new Color(97, 109, 126);
    private MJPanel fBorderOnHoverPanel;
    private static ResourceBundle sPrefRes = ResourceBundle.getBundle("com.mathworks.mlwidgets.prefs.resources.RES_Prefs");
    private PrefListener fProdFilterPrefListener;

    public ProductScopePanel() {
        super((LayoutManager)new BorderLayout());
        Color color;
        this.setName("ProductScopePanel");
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProductScopePanel.this.openDialog();
            }
        };
        this.fProductLabel = new MJLabel("", 0);
        this.fProductLabel.setName("ProductScopePanel:fProductLabel");
        this.fProductLabel.setTipWhenTruncatedEnabled(false);
        if (MJUtilities.isHighContrast()) {
            this.fProductLabel.setForeground(Color.white);
            color = Color.black;
        } else {
            this.fProductLabel.setForeground(TEXT_FORGROUND);
            color = FunctionBrowser.DEFAULT_BACKGROUND_COLOR;
        }
        this.setBackground(color);
        this.fProductLabel.setBackground(color);
        this.updateProductLabel();
        this.fBorderOnHoverPanel = new MJPanel();
        this.fBorderOnHoverPanel.setLayout((LayoutManager)new BoxLayout((Container)this.fBorderOnHoverPanel, 0));
        this.fBorderOnHoverPanel.setBackground(color);
        this.fBorderOnHoverPanel.add((Component)this.fProductLabel);
        this.fBorderOnHoverPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
        this.fProductLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        MJPanel mJPanel = new MJPanel();
        mJPanel.setLayout((LayoutManager)new BoxLayout((Container)mJPanel, 0));
        mJPanel.setBackground(color);
        mJPanel.add(Box.createHorizontalGlue());
        mJPanel.add((Component)this.fBorderOnHoverPanel);
        mJPanel.addMouseListener((MouseListener)mouseAdapter);
        mJPanel.add(Box.createHorizontalGlue());
        this.add((Component)mJPanel, "Center");
        this.fProdFilterPrefListener = this.createProductFilterPrefListener();
        this.addPrefsListeners(this.fProdFilterPrefListener);
        this.fProductLabel.addMouseListener((MouseListener)mouseAdapter);
        this.fProductLabel.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                ProductScopePanel.this.drawBorder();
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                ProductScopePanel.this.undrawBorder();
            }
        });
        this.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "ProductScopePanel:Enter");
        this.getActionMap().put("ProductScopePanel:Enter", (Action)new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProductScopePanel.this.openDialog();
            }
        });
        this.fProductLabel.setToolTipText(resources.getString("ProductScopePanel.ScopeLabelTooltip"));
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                ProductScopePanel.this.drawBorder();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                ProductScopePanel.this.undrawBorder();
            }
        });
    }

    private void undrawBorder() {
        this.fBorderOnHoverPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 5));
    }

    private void drawBorder() {
        this.fBorderOnHoverPanel.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(new Color(191, 205, 219)), BorderFactory.createEmptyBorder(0, 0, 0, 4)));
    }

    private void openDialog() {
        this.setCursor(new Cursor(3));
        MLPrefsDialogServices.showPrefsDialog((String)sPrefRes.getString("area.help"));
        this.setCursor(new Cursor(0));
    }

    private void updateProductLabel() {
        String string = HelpPrefs.isUsingDocCenterBrowser() ? this.getProductLabelTextForDocCenter() : this.getProductLabelTextForClassicDoc();
        this.fProductLabel.setText(string);
        this.fProductLabel.setFont(this.fProductLabel.getFont().deriveFont(1));
        this.fProductLabel.setMinimumSize(new Dimension(0, this.fProductLabel.getMinimumSize().height));
        this.fProductLabel.revalidate();
        this.fProductLabel.repaint();
    }

    private String getProductLabelTextForDocCenter() {
        List list = FunctionReferenceUtils.getToplevelProductFunctionData();
        boolean bl = HelpPrefs.isDocCenterProductFilterEnabled();
        if (!bl) {
            return this.getAllProductsText();
        }
        String string = "";
        int n = 0;
        int n2 = 0;
        for (FunctionReferenceUtils.FunctionProductData functionProductData : list) {
            ++n;
            if (!functionProductData.isSelected()) continue;
            ++n2;
            string = string + functionProductData.getProductName() + ", ";
        }
        if (n == n2) {
            return this.getAllProductsText();
        }
        if (n2 == 0) {
            return this.getNoProductsText();
        }
        if (string.length() > 2 && string.substring(string.length() - 2).equals(", ")) {
            string = string.substring(0, string.length() - 2);
        }
        return string;
    }

    private String getProductLabelTextForClassicDoc() {
        List list = FunctionReferenceUtils.getToplevelProductFunctionData();
        String string = "";
        int n = 0;
        int n2 = 0;
        boolean bl = HelpPrefs.getProductFilterEnabled();
        for (FunctionReferenceUtils.FunctionProductData functionProductData : list) {
            if ((!bl || functionProductData.isSelected()) && functionProductData.hasRefPages()) {
                string = string + functionProductData.getProductName() + ", ";
                ++n2;
            }
            if (!functionProductData.hasRefPages()) continue;
            ++n;
        }
        if (string.length() > 2 && string.substring(string.length() - 2).equals(", ")) {
            string = string.substring(0, string.length() - 2);
        }
        if (n == n2) {
            return this.getAllProductsText();
        }
        if (n2 == 0) {
            return this.getNoProductsText();
        }
        return string;
    }

    private String getAllProductsText() {
        return resources.getString("ProductScopePanel.AllProducts");
    }

    private String getNoProductsText() {
        return resources.getString("ProductScopePanel.EmptyText");
    }

    private PrefListener createProductFilterPrefListener() {
        if (HelpPrefs.isUsingDocCenterBrowser()) {
            return new DocCenterPrefListener();
        }
        return new ClassicDocPrefListener();
    }

    private void addPrefsListeners(PrefListener prefListener) {
        assert (prefListener != null);
        if (HelpPrefs.isUsingDocCenterBrowser()) {
            HelpPrefs.addPrefsListeners((PrefListener)prefListener, (String[])new String[]{"HelpDocCenterFilterEnabled", "HelpSelectedInstalledProducts"});
        } else {
            HelpPrefs.addPrefsListeners((PrefListener)prefListener, (String[])new String[]{"HelpFilterEnabled", "HelpSelectedProducts"});
        }
    }

    void cleanup() {
        Prefs.removeListener((PrefListener)this.fProdFilterPrefListener);
    }

    static String[] getSelectedProductShortNames() {
        return ProductScopePanel.getInstalledProductShortNames(true);
    }

    static String[] getInstalledProductShortNames(boolean bl) {
        List list = FunctionReferenceUtils.getInstalledProductShortNames((boolean)bl);
        return list.toArray(new String[list.size()]);
    }

    private class ClassicDocPrefListener
    extends ProductFilterPrefListener {
        private ClassicDocPrefListener() {
        }

        @Override
        boolean isProductFilterPrefEvent(PrefEvent prefEvent) {
            return prefEvent.getPrefKey().equals("HelpFilterEnabled") || prefEvent.getPrefKey().equals("HelpSelectedProducts");
        }
    }

    private class DocCenterPrefListener
    extends ProductFilterPrefListener {
        private DocCenterPrefListener() {
        }

        @Override
        boolean isProductFilterPrefEvent(PrefEvent prefEvent) {
            return prefEvent.getPrefKey().equals("HelpDocCenterFilterEnabled") || prefEvent.getPrefKey().equals("HelpSelectedInstalledProducts");
        }
    }

    private abstract class ProductFilterPrefListener
    implements PrefListener {
        private ProductFilterPrefListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            if (this.isProductFilterPrefEvent(prefEvent)) {
                if (FunctionBrowser.isInstanceShowing()) {
                    MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ProductScopePanel.this.updateProductLabel();
                            FunctionBrowser.update();
                        }
                    });
                } else {
                    FunctionBrowser.setProductFilterDirty(true);
                }
            }
        }

        abstract boolean isProductFilterPrefEvent(PrefEvent var1);
    }
}

