/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.mde.help.MLHelpBrowser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class MLHelpBrowserActiveTab {
    private static MLHelpBrowser sActiveHelpBrowserTab;
    private static Set<MLHelpBrowser> sHelpBrowserTabs;
    private static Set<ChangeListener> sListeners;

    private MLHelpBrowserActiveTab() {
    }

    static void addHelpBrowserTab(MLHelpBrowser mLHelpBrowser) {
        sHelpBrowserTabs.add(mLHelpBrowser);
    }

    static void removeHelpBrowserTab(MLHelpBrowser mLHelpBrowser) {
        sHelpBrowserTabs.remove((Object)mLHelpBrowser);
        if (sHelpBrowserTabs.isEmpty()) {
            MLHelpBrowserActiveTab.setActiveHelpBrowserTab(null);
        }
    }

    static void setActiveHelpBrowserTab(MLHelpBrowser mLHelpBrowser) {
        if (sActiveHelpBrowserTab == null || mLHelpBrowser == null || !sActiveHelpBrowserTab.getName().equalsIgnoreCase(mLHelpBrowser.getName())) {
            sActiveHelpBrowserTab = mLHelpBrowser;
            MLHelpBrowserActiveTab.notifyListeners();
        }
    }

    static MLHelpBrowser getActiveHelpBrowserTab() {
        return sActiveHelpBrowserTab;
    }

    static void addListener(ChangeListener changeListener) {
        sListeners.add(changeListener);
    }

    static void removeListener(ChangeListener changeListener) {
        sListeners.remove(changeListener);
    }

    private static void notifyListeners() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ArrayList arrayList = new ArrayList(sListeners);
                for (ChangeListener changeListener : arrayList) {
                    changeListener.stateChanged(new ChangeEvent(this));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    static {
        sHelpBrowserTabs = new HashSet<MLHelpBrowser>();
        sListeners = Collections.synchronizedSet(new HashSet());
    }
}

