/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.ProductFilterPanel;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJDialogParent;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.window.MJFullWindowRegistry;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;

public class ProductFilterWindow
extends MJDialog {
    private ProductFilterPanel fProductFilterPanel;

    public static void main(String[] stringArray) {
        ProductFilterWindow.invoke(new Frame());
    }

    private ProductFilterWindow(Frame frame) {
        super(frame, "", true);
        this.init(frame);
    }

    private ProductFilterWindow(Dialog dialog) {
        super(dialog, "", true);
        this.init(dialog);
    }

    public void addNotify() {
        super.addNotify();
        MJFullWindowRegistry.register((Window)((Object)this));
    }

    public void removeNotify() {
        MJFullWindowRegistry.unregister((Window)((Object)this));
        super.removeNotify();
    }

    private void init(Container container) {
        this.setName("Product Filter Dialog");
        this.setTitle(HelpUtils.getLocalizedString((String)"search.menu.filter_by_product"));
        this.fProductFilterPanel = new ProductFilterPanel();
        MJPanel mJPanel = new MJPanel((LayoutManager)new BorderLayout());
        mJPanel.add((Component)((Object)this.fProductFilterPanel), (Object)"Center");
        MJPanel mJPanel2 = new MJPanel((LayoutManager)new FlowLayout(1));
        ButtonActionListener buttonActionListener = new ButtonActionListener();
        MJButton mJButton = new MJButton(HelpUtils.getLocalizedString((String)"filter.ok"));
        mJButton.setName("OK");
        mJButton.setActionCommand("OK");
        mJButton.addActionListener((ActionListener)buttonActionListener);
        mJPanel2.add((Component)mJButton);
        this.getRootPane().setDefaultButton((JButton)mJButton);
        mJButton = new MJButton(HelpUtils.getLocalizedString((String)"filter.cancel"));
        mJButton.setName("Cancel");
        mJButton.setActionCommand("Cancel");
        mJButton.addActionListener((ActionListener)buttonActionListener);
        mJPanel2.add((Component)mJButton);
        mJButton = new MJButton(HelpUtils.getLocalizedString((String)"filter.help"));
        mJButton.setName("Help");
        mJButton.setActionCommand("Help");
        mJButton.addActionListener((ActionListener)buttonActionListener);
        mJPanel2.add((Component)mJButton);
        MJPanel mJPanel3 = new MJPanel((LayoutManager)new BorderLayout(5, 5));
        mJPanel3.add((Component)mJPanel, (Object)"Center");
        mJPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.getContentPane().add((Component)mJPanel3, "Center");
        this.getContentPane().add((Component)mJPanel2, "South");
        this.pack();
        Rectangle rectangle = container.getBounds();
        rectangle.x = Math.max(0, rectangle.x + rectangle.width / 2 - this.getPreferredSize().width / 2);
        rectangle.y = Math.max(0, rectangle.y + rectangle.height / 3 - this.getPreferredSize().height / 2);
        this.setBounds(rectangle.x, rectangle.y, this.getPreferredSize().width, this.getPreferredSize().height);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ProductFilterWindow.this.closeWindow(false);
            }
        });
        this.setModal(true);
    }

    public static ProductFilterWindow create() {
        return new ProductFilterWindow((Frame)new MJDialogParent());
    }

    public static ProductFilterWindow create(Dialog dialog) {
        return new ProductFilterWindow(dialog);
    }

    public void setEnableNonRefPages(boolean bl) {
        this.fProductFilterPanel.setEnableNonRefPages(bl);
    }

    private void closeWindow(boolean bl) {
        this.setVisible(false);
        if (bl) {
            this.fProductFilterPanel.saveSelectedProducts();
        } else {
            this.fProductFilterPanel.resetSelectedProducts();
        }
        this.dispose();
    }

    static void invoke(Frame frame) {
        ProductFilterWindow productFilterWindow = new ProductFilterWindow(frame);
        productFilterWindow.setVisible(true);
    }

    static {
        MJUtilities.initJIDE();
    }

    private class ButtonActionListener
    implements ActionListener {
        private ButtonActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand().equals("OK")) {
                boolean bl = ProductFilterWindow.this.fProductFilterPanel.isProductFilterEnabled();
                HelpPrefs.setProductFilterEnabled((boolean)bl);
                if (bl && ProductFilterWindow.this.fProductFilterPanel.getSelectedProducts().equals("")) {
                    MJOptionPane.showMessageDialog((Component)((Object)ProductFilterWindow.this), (Object)HelpUtils.getLocalizedString((String)"filter.selection_error"));
                } else {
                    ProductFilterWindow.this.closeWindow(true);
                }
            } else if (actionEvent.getActionCommand().equals("Cancel")) {
                ProductFilterWindow.this.closeWindow(false);
            } else if (actionEvent.getActionCommand().equals("Help")) {
                MLHelpServices.cshDisplayTopic((Object)((Object)ProductFilterWindow.this), (String)MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), (String)"matlab_env_product_filter");
            }
        }
    }
}

