/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.help;

import com.mathworks.common.icons.CommonIcon;
import com.mathworks.jmi.Matlab;
import com.mathworks.mde.help.HelpBrowser;
import com.mathworks.mde.help.HelpNavigator;
import com.mathworks.mde.help.HelpNavigatorAction;
import com.mathworks.mde.help.HelpUtils;
import com.mathworks.mde.help.search.SearchResultsPanel;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.search.OnlineSearchStringVisitor;
import com.mathworks.mlwidgets.help.search.RankedSearchResult;
import com.mathworks.mlwidgets.help.search.SearchCompletionObserver;
import com.mathworks.mlwidgets.help.search.SearchCriteria;
import com.mathworks.mlwidgets.help.search.SearchException;
import com.mathworks.mlwidgets.help.search.SearchResults;
import com.mathworks.mlwidgets.help.search.SearchStringParseException;
import com.mathworks.mlwidgets.help.search.SearchStringParser;
import com.mathworks.mlwidgets.help.search.SearchVisitor;
import com.mathworks.mlwidgets.help.search.Synonyms;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class Search
extends MJPanel {
    private SearchResultsPanel fSearchResultsPanel;
    private Component fTechSupportPanel;
    private SearchCriteria fPendingSearch = null;
    private String fCurrentSearchString;
    private MJPanel fSynonymsPanel = null;
    private static final String ONLINE_SEARCH_PATTERN = "web(''http://www.mathworks.com/search/ice.cgi?query={0}'',''-browser'');";

    public static void main(String[] stringArray) {
        Search search = new Search();
        HelpUtils.placeComponentInFrame(search);
        search.populate();
    }

    Search() {
        this.setLayout(new BorderLayout(3, 3));
        this.setName("Help Search");
        this.populate();
    }

    void clear() {
        this.setPendingSearchInfo(null, null);
        if (this.fSearchResultsPanel != null) {
            this.fSearchResultsPanel.clear();
        }
        this.removeSynonymsPanel();
        this.removeTechSupportPanel();
        HelpBrowser.getInstance().setStatusBar("");
    }

    void populate() {
        if (this.fSearchResultsPanel == null) {
            this.fSearchResultsPanel = new SearchResultsPanel();
            this.setFont(HelpNavigator.getNavigatorFont());
            this.setBackground(HelpNavigator.getBackgroundColor());
            this.setForeground(HelpNavigator.getTextColor());
            this.add(this.fSearchResultsPanel.getComponent(), "Center");
        }
    }

    void doSearch(String string, String[] stringArray) {
        this.populate();
        if (string.length() == 0) {
            this.clear();
            HelpBrowser.displayTopic(MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlabenvironment_search", false);
        } else {
            this.search(string, stringArray);
        }
    }

    public void reset() {
        this.clear();
    }

    private void search(String string, String[] stringArray) {
        Object object;
        this.setBusyState(true);
        this.removeSynonymsPanel();
        try {
            object = SearchStringParser.buildExpression((String)string);
            SearchCriteria searchCriteria = new SearchCriteria(object);
            this.setPendingSearchInfo(string, searchCriteria);
            searchCriteria.setProducts(stringArray);
            SearchPanelCompletionObserver searchPanelCompletionObserver = new SearchPanelCompletionObserver(string, searchCriteria);
            this.fSearchResultsPanel.search(searchCriteria, string, searchPanelCompletionObserver);
        }
        catch (SearchStringParseException searchStringParseException) {
            this.handleSearchException((SearchException)((Object)searchStringParseException));
            this.setPendingSearchInfo(null, null);
        }
        object = Synonyms.getAlternateSearchString((String)string);
        if (object != null) {
            this.addSynonymsPanel((String)object);
        }
    }

    private void addSynonymsPanel(String string) {
        this.fSynonymsPanel = new MJPanel();
        this.fSynonymsPanel.setOpaque(false);
        this.fSynonymsPanel.setBorder(BorderFactory.createEmptyBorder(5, 4, 3, 4));
        this.fSynonymsPanel.setLayout((LayoutManager)new BoxLayout((Container)this.fSynonymsPanel, 0));
        this.fSynonymsPanel.add((Component)new MJLabel((Icon)CommonIcon.INFO.getIcon()));
        this.fSynonymsPanel.add(Box.createHorizontalStrut(3));
        this.fSynonymsPanel.add(Search.createSynonymLink(string));
        this.add((Component)this.fSynonymsPanel, "North");
    }

    private static Component createSynonymLink(String string) {
        HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler = new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                MLHelpServices.docSearch((String)string);
            }
        };
        String string2 = "<a href=\"" + string + "\">" + string + "</a>";
        String string3 = HelpUtils.getLocalizedString((String)"search.related_search");
        string2 = MessageFormat.format(string3, string2);
        string2 = "<html><b>" + string2 + "</b></html>";
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string2, hyperlinkHandler);
        hyperlinkTextLabel.getComponent().setName("HelpRelatedSearchLink");
        return hyperlinkTextLabel.getComponent();
    }

    private void removeSynonymsPanel() {
        if (this.fSynonymsPanel != null) {
            this.remove((Component)this.fSynonymsPanel);
            this.fSynonymsPanel = null;
        }
    }

    private synchronized void setPendingSearchInfo(String string, SearchCriteria searchCriteria) {
        this.fCurrentSearchString = string;
        this.fPendingSearch = searchCriteria;
    }

    private synchronized void clearPendingSearchCriteria() {
        this.fPendingSearch = null;
    }

    private synchronized SearchCriteria getPendingSearchCriteria() {
        return this.fPendingSearch;
    }

    public synchronized String getSearchStringForDisplayedResults() {
        if (this.fPendingSearch == null) {
            return this.fCurrentSearchString;
        }
        return null;
    }

    private void handleSearchException(SearchException searchException) {
        this.clear();
        this.fSearchResultsPanel.displaySearchException(searchException);
        this.setBusyState(false);
    }

    private void addTechSupportPanel(final String string, final SearchCriteria searchCriteria) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Search.this.removeTechSupportPanel();
                Search.this.fTechSupportPanel = Search.buildTechSupportLabel(string, searchCriteria);
                if (Search.this.fTechSupportPanel != null) {
                    Search.this.add(Search.this.fTechSupportPanel, "South");
                }
            }
        });
    }

    private static Component buildTechSupportLabel(String string, SearchCriteria searchCriteria) {
        final String string2 = Search.getOnlineSearchString(searchCriteria);
        if (string2 == null || string2.trim().length() == 0 || string == null || string.trim().length() == 0 || !Matlab.isMatlabAvailable()) {
            return null;
        }
        String string3 = Search.getHyperlinkText(string);
        HyperlinkTextLabel.HyperlinkHandler hyperlinkHandler = new HyperlinkTextLabel.HyperlinkHandler(){

            public void processHyperlink(String string) {
                new Matlab().evalConsoleOutput(Search.getOnlineSearchCommand(string2));
            }
        };
        HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(string3, hyperlinkHandler);
        hyperlinkTextLabel.getComponent().setName("HelpSearchOnlineSupportLink");
        return hyperlinkTextLabel.getComponent();
    }

    private static String getOnlineSearchString(SearchCriteria searchCriteria) {
        try {
            OnlineSearchStringVisitor onlineSearchStringVisitor = new OnlineSearchStringVisitor();
            searchCriteria.getExpression().accept((SearchVisitor)onlineSearchStringVisitor);
            return onlineSearchStringVisitor.getSearchString();
        }
        catch (SearchException searchException) {
            return null;
        }
    }

    private static String getHyperlinkText(String string) {
        String string2 = string;
        if (string2.length() > 40) {
            string2 = string2.substring(0, 40);
            string2 = string2.concat("...");
        }
        String string3 = HelpUtils.getLocalizedString((String)"search.tech_support_message");
        string3 = MessageFormat.format(string3, string2);
        return "<center><a href=\"search\">" + string3 + "</a></center>";
    }

    private static String getOnlineSearchCommand(String string) {
        return MessageFormat.format(ONLINE_SEARCH_PATTERN, string);
    }

    private void removeTechSupportPanel() {
        if (this.fTechSupportPanel != null) {
            this.remove(this.fTechSupportPanel);
            this.fTechSupportPanel = null;
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fSearchResultsPanel != null) {
            this.fSearchResultsPanel.setFont(font);
        }
    }

    public void setBackground(Color color) {
        if (this.fSearchResultsPanel != null) {
            this.fSearchResultsPanel.setBackground(color);
        }
    }

    public void setForeground(Color color) {
        if (this.fSearchResultsPanel != null) {
            this.fSearchResultsPanel.setForeground(color);
        }
    }

    private void setBusyState(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public boolean requestFocusInWindow() {
        if (this.fSearchResultsPanel != null) {
            return this.fSearchResultsPanel.getComponent().requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public void updateGlobalActions() {
        if (this.fSearchResultsPanel != null) {
            this.fSearchResultsPanel.updateHelpNavigatorGlobalActions();
        } else {
            HelpNavigatorAction.COLLAPSE_ALL.updateUnderlyingAction(null);
            HelpNavigatorAction.EXPAND_ALL.updateUnderlyingAction(null);
        }
    }

    private class SearchPanelCompletionObserver
    implements SearchCompletionObserver<RankedSearchResult> {
        private final String iSearchString;
        private final SearchCriteria iCriteria;

        private SearchPanelCompletionObserver(String string, SearchCriteria searchCriteria) {
            this.iSearchString = string;
            this.iCriteria = searchCriteria;
        }

        public void searchComplete(SearchResults<RankedSearchResult> searchResults) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SearchPanelCompletionObserver.this.iCriteria.equals(Search.this.getPendingSearchCriteria())) {
                        Search.this.addTechSupportPanel(SearchPanelCompletionObserver.this.iSearchString, SearchPanelCompletionObserver.this.iCriteria);
                        Search.this.setBusyState(false);
                        Search.this.clearPendingSearchCriteria();
                    }
                }
            });
        }

        public void searchFailed(final SearchException searchException) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SearchPanelCompletionObserver.this.iCriteria.equals(Search.this.getPendingSearchCriteria())) {
                        Search.this.handleSearchException(searchException);
                        Search.this.setPendingSearchInfo(null, null);
                    }
                }
            });
        }
    }
}

