/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mde.workspace;

import com.mathworks.mlwidgets.graphics.IPlotPickerDisplayTrigger;
import com.mathworks.mlwidgets.graphics.PlotPicker;
import com.mathworks.mlwidgets.stack.StackComboBox;
import com.mathworks.mlwidgets.workspace.WorkspaceTable;
import com.mathworks.mlwidgets.workspace.graphics.GraphingActionFactory;
import com.mathworks.mlwidgets.workspace.graphics.IGraphingActionListener;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.widgets.desk.DTToolBarConfiguration;
import com.mathworks.widgets.desk.DTToolBarInfo;
import com.mathworks.widgets.desk.DTToolSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class WorkspaceToolBar {
    private static final String CREATION_ID = "new-variable";
    private static final String OPEN_ID = "open-new";
    private static final String IMPORT_FILE_ID = "import-data";
    private static final String SAVE_WORKSPACE_ID = "save-workspace";
    private static final String PRINT_ID = "print";
    private static final String DELETION_ID = "delete-next";
    private static final String PLOT_PICKER_ID = "plot-picker";
    private static final String STACK_COMBO_ID = "stack";
    private static final ResourceBundle DESKTOP_RESOURCE = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop");

    private WorkspaceToolBar() {
    }

    static DTToolBarInfo buildWorkspaceToolbar(WorkspaceTable workspaceTable) {
        DTToolSet dTToolSet = new DTToolSet();
        WorkspaceToolBar.addToolSetItem(CREATION_ID, workspaceTable.getAction(10), dTToolSet);
        WorkspaceToolBar.addToolSetItem(OPEN_ID, workspaceTable.getAction(40), dTToolSet);
        WorkspaceToolBar.addToolSetItem(IMPORT_FILE_ID, workspaceTable.getAction(110), dTToolSet);
        WorkspaceToolBar.addToolSetItem(SAVE_WORKSPACE_ID, workspaceTable.getAction(120), dTToolSet);
        WorkspaceToolBar.addToolSetItem(PRINT_ID, workspaceTable.getAction(140), dTToolSet);
        WorkspaceToolBar.addToolSetItem(DELETION_ID, workspaceTable.getAction(20), dTToolSet);
        StackComboBox stackComboBox = new StackComboBox();
        MJToolBar.markAsNonEssential((JComponent)stackComboBox);
        dTToolSet.add(STACK_COMBO_ID, StackComboBox.getStackLabel((boolean)false), (Component)stackComboBox, null);
        dTToolSet.add(PLOT_PICKER_ID, PlotPicker.getDisplayName(), (Component)WorkspaceToolBar.createPlotPicker(workspaceTable), (Icon)PlotPicker.getDefaultIcon());
        return new DTToolBarInfo("Workspace", DESKTOP_RESOURCE.getString("title.Workspace"), dTToolSet, WorkspaceToolBar.buildToolBarConfiguration());
    }

    private static void addToolSetItem(String string, MJAbstractAction mJAbstractAction, DTToolSet dTToolSet) {
        assert (mJAbstractAction != null) : "Action being added should not be null.";
        dTToolSet.add(string, (Action)mJAbstractAction);
    }

    static PlotPicker createPlotPicker(final WorkspaceTable workspaceTable) {
        final PlotPicker plotPicker = new PlotPicker((JComponent)workspaceTable, (IPlotPickerDisplayTrigger)workspaceTable);
        GraphingActionFactory.addGraphingActionListener((IGraphingActionListener)workspaceTable);
        plotPicker.setName("PlotPicker");
        workspaceTable.addChronSelectionChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                int[] nArray = workspaceTable.getSelectedRowsChron();
                plotPicker.setPlottedVars(workspaceTable.getVariableNames(nArray));
            }
        });
        return plotPicker;
    }

    private static DTToolBarConfiguration buildToolBarConfiguration() {
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(CREATION_ID, OPEN_ID, IMPORT_FILE_ID, SAVE_WORKSPACE_ID, DELETION_ID, "Tool Bar Separator Key", STACK_COMBO_ID, "Tool Bar Separator Key", PLOT_PICKER_ID));
        return new DTToolBarConfiguration(arrayList);
    }
}

