/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.dastudio.diagView;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwt.MWClipboard;
import com.mathworks.mwt.MWContainer;
import com.mathworks.mwt.MWScrollbar;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.CharBuffer;
import com.mathworks.util.IntBuffer;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MLStyledTextLabel
extends MWContainer {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int SCROLLBAR_NEVER = 0;
    public static final int SCROLLBAR_ALWAYS = 1;
    public static final int SCROLLBAR_ON_DEMAND = 2;
    private static final int SMALLCAPS = 256;
    private static final int SUPERSCRIPT = 128;
    private static final int SUBSCRIPT = 64;
    private static final int ITALIC = 32;
    private static final int BOLD = 16;
    private static final int UNDERLINE = 8;
    private static final int STRIKETHRU = 4;
    private static final int LINK = 2;
    private static final int HIDDEN = 1;
    private static final int BASE_FONT = 0;
    private static final int BACKGROUND_COLOR = 0;
    private static final int TEXT_COLOR = 1;
    private static final int LINK_COLOR = 2;
    private static final int BASE_STYLE = 0x100000;
    private static final int HIDDEN_STYLE = 1;
    private static final int LINK_STYLE = 0x20000A;
    private static final int ROLLOVER_STYLE = 0x20000A;
    private static final int MEVAL_STYLE = 65;
    private static final int HREF_STYLE = 129;
    private static final int COLOR_MASK = 63;
    private static final int FONT_MASK = 127;
    private static final int FONT_SHIFT = 13;
    private static final int FG_SHIFT = 20;
    private static final int BG_SHIFT = 26;
    private static final int STYLE_DIFF_MASK = 1048561;
    private static IntBuffer sStyleTable;
    private static Vector sColorTable;
    private static Vector sFontTable;
    private static Matlab sMatlab;
    private static final Pattern sLinkPattern;
    private static final int sLinkStartTagGroup = 1;
    private static final int sLinkTypeGroup = 2;
    private static final int sLinkTargetGroup = 5;
    private static final int sLinkTextGroup = 6;
    private static final int sLinkEndTagGroup = 7;
    private static final Pattern sMatlabLinkPattern;
    private static final int sMatlabLinkExpression = 1;
    private int fAlignment;
    private IntBuffer fLineBreaks;
    private IntBuffer fStyleRuns;
    private char[] fText;
    private Dimension fCachedSize;
    private int fLineCache;
    private int fStyleCache;
    private int fLineHeight;
    private int fVOffset;
    private int fHOffset;
    private boolean fWrap;
    private int fScrollOptions;
    private MWScrollbar fVScroll;
    private MWScrollbar fHScroll;
    private PopupMenu fContextMenu;
    private int fCachedWidth;
    private MWScrollbar fMouseTarget;
    private int fMouseX;
    private int fMouseY;
    private boolean fTrackSelection;
    private int fSelStart;
    private int fSelEnd;
    private int fSelAnchor;

    public MLStyledTextLabel(String string) {
        this(string, 0);
    }

    public MLStyledTextLabel(String string, int n) {
        if (sColorTable == null) {
            sColorTable = new Vector(4);
            sColorTable.addElement(Color.white);
            sColorTable.addElement(Color.black);
            sColorTable.addElement(Color.blue);
            sFontTable = new Vector(1);
            sFontTable.addElement(Decorations.getFont((int)0));
        }
        this.fWrap = true;
        this.fLineBreaks = new IntBuffer(8, 64);
        this.fLineBreaks.setGrowthMode(1);
        this.fStyleRuns = new IntBuffer(4, 64);
        this.fStyleRuns.setGrowthMode(1);
        this.fSelAnchor = -1;
        this.setText(string);
        this.setAlignment(n);
        this.setFont(Decorations.getFont((int)0));
        this.setLayout(null);
        if (sMatlab == null && Matlab.isMatlabAvailable()) {
            sMatlab = new Matlab();
        }
        this.enableEvents(49L);
        this.createContextMenu();
        this.addMouseListener(new MLStyledMouseAdapter());
        this.add(this.fContextMenu);
        this.addKeyListener(new KeyHandler());
    }

    public int getAlignment() {
        return this.fAlignment;
    }

    public void setAlignment(int n) {
        if (n != this.fAlignment && n >= 0 && n <= 2) {
            this.fAlignment = n;
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fCachedSize = null;
        this.fCachedWidth = 0;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        if (fontMetrics != null) {
            this.fLineHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
        }
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void select(int n, int n2) {
        if (n > n2) {
            int n3 = n2;
            n2 = n;
            n = n3;
        }
        if (n < 0) {
            n = 0;
        } else if (n > this.fText.length) {
            n = this.fText.length;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > this.fText.length) {
            n2 = this.fText.length;
        }
        if (n != this.fSelStart || n2 != this.fSelEnd) {
            this.fSelStart = n;
            this.fSelEnd = n2;
            this.repaint();
        }
    }

    public void selectAll() {
        if (this.fSelStart != 0 || this.fSelEnd != this.fText.length) {
            this.fSelStart = 0;
            this.fSelEnd = this.fText.length;
            this.repaint();
        }
    }

    public void setSelectionEnd(int n) {
        this.select(this.fSelStart, n);
    }

    public void setSelectionStart(int n) {
        this.select(n, this.fSelEnd);
    }

    public void setSelectionTracking(boolean bl) {
        if (bl != this.fTrackSelection && !bl && this.fSelEnd > this.fSelStart) {
            this.fSelStart = -1;
            this.fSelEnd = -1;
            this.fSelAnchor = -1;
            this.repaint();
        }
        this.fTrackSelection = bl;
    }

    public int getSelectionEnd() {
        return this.fSelEnd;
    }

    public int getSelectionStart() {
        return this.fSelStart;
    }

    public String getSelectedText() {
        String string = null;
        if (this.fSelEnd > this.fSelStart) {
            int n;
            int n2 = this.styleIndexAt(this.fSelStart);
            if (n2 == (n = this.styleIndexAt(this.fSelEnd))) {
                string = new String(this.fText, this.fSelStart, this.fSelEnd - this.fSelStart);
            } else {
                int n3;
                int n4;
                for (n4 = n2; n4 <= n && ((n3 = this.styleAtIndex(n4)) & 1) == 0; ++n4) {
                }
                if (n4 > n) {
                    string = new String(this.fText, this.fSelStart, this.fSelEnd - this.fSelStart);
                } else {
                    CharBuffer charBuffer = new CharBuffer(this.fSelEnd - this.fSelStart, 256);
                    for (n4 = n2; n4 <= n; ++n4) {
                        int n5 = this.fSelStart;
                        n3 = this.styleAtIndex(n4);
                        if ((n3 & 1) != 0) continue;
                        n5 = Math.max(n5, this.stylePosAtIndex(n4));
                        int n6 = Math.min(this.stylePosAtIndex(n4 + 1), this.fSelEnd);
                        charBuffer.replace(charBuffer.length(), charBuffer.length(), this.fText, n5, n6 - n5);
                    }
                    string = charBuffer.toString();
                }
            }
        }
        return string;
    }

    public String getText() {
        return new String(this.fText);
    }

    public synchronized void setText(String string) {
        this.fStyleRuns.setSize(0);
        this.setStyle(0, Integer.MAX_VALUE, 0x100000);
        if (string == null) {
            this.fText = null;
        } else {
            this.fText = string.toCharArray();
            this.convertHtmlToStyles(this.fText);
        }
        this.fCachedWidth = 0;
        this.fCachedSize = null;
        if (this.isShowing()) {
            this.repaint();
        }
    }

    public void setScrollOptions(int n) {
        if (n != this.fScrollOptions) {
            this.fScrollOptions = n;
            this.fCachedSize = null;
            this.fCachedWidth = 0;
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    public void setAutoWrap(boolean bl) {
        if (bl != this.fWrap) {
            this.fWrap = bl;
            this.fCachedSize = null;
            this.fCachedWidth = 0;
            if (this.isShowing()) {
                this.repaint();
            }
        }
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics;
        Dimension dimension = this.getMinimumSize();
        if (dimension.width < 1 && (fontMetrics = this.getFontMetrics(this.getFont())) != null) {
            IntBuffer intBuffer = this.wrapText(this.fText, 1024, fontMetrics, null);
            int n = intBuffer.length();
            int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
            int n3 = n * n2;
            if (n != 0) {
                int n4 = fontMetrics.charsWidth(this.fText, 0, this.fText.length - 1);
                int n5 = (int)Math.sqrt(n2 * n4 / 2);
                dimension.height = Math.max(n3, n5);
                dimension.width = n2 * n4 / dimension.height;
            }
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.getSize();
        if (dimension.width > 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
            this.fLineBreaks = this.wrapText(this.fText, dimension.width, fontMetrics, this.fLineBreaks);
            dimension.height = n * this.fLineBreaks.length();
        }
        return dimension;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private final FontMetrics getStyleFontMetrics(int n) {
        return this.getFontMetrics(this.getFont());
    }

    private boolean isWordChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    private boolean isWhitespace(char c) {
        return c <= ' ' || Character.isWhitespace(c);
    }

    private boolean isWordBreakChar(char c) {
        return c <= ' ' || Character.isWhitespace(c) || c == '-';
    }

    private final void setStyleBackground(Graphics graphics, int n) {
        int n2 = n >>> 26 & 0x3F;
        if (n2 == 0) {
            graphics.setColor(this.getBackground());
        } else {
            graphics.setColor((Color)sColorTable.elementAt(n2));
        }
    }

    private final void setStyleForeground(Graphics graphics, int n) {
        int n2 = n >>> 20 & 0x3F;
        if (n2 == 1) {
            graphics.setColor(this.getForeground());
        } else {
            graphics.setColor((Color)sColorTable.elementAt(n2));
        }
    }

    private final void setStyleColor(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        Color color = n == 20 ? (this.isEnabled() ? ((n4 = n2 >>> 20 & 0x3F) == 1 ? this.getForeground() : (Color)sColorTable.elementAt(n4)) : Decorations.getColor((int)15)) : ((n3 = n2 >>> 26 & 0x3F) == 0 ? this.getBackground() : (Color)sColorTable.elementAt(n3));
        graphics.setColor(color);
    }

    private final void setStyleFont(Graphics graphics, int n) {
        int n2 = n >>> 13 & 0x7F;
        if (n2 == 0) {
            graphics.setFont(this.getFont());
        } else {
            graphics.setFont((Font)sFontTable.elementAt(n2));
        }
    }

    public synchronized void paint(Graphics graphics) {
        if (this.isShowing()) {
            Dimension dimension = this.getSize();
            if (!dimension.equals(this.fCachedSize)) {
                graphics.setFont(this.getFont());
                FontMetrics fontMetrics = graphics.getFontMetrics();
                if (this.fScrollOptions != 0) {
                    this.doResize(graphics, fontMetrics, (Component)((Object)this));
                } else {
                    this.fLineBreaks = this.wrapText(this.fText, dimension.width, fontMetrics, this.fLineBreaks);
                }
                this.fCachedSize = dimension;
                this.fLineHeight = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
                this.invalidate();
            }
            Rectangle rectangle = graphics.getClipBounds();
            int n = 0;
            if (this.fVScroll != null && this.fVScroll.isVisible() && rectangle.y + rectangle.height > dimension.height - this.fVScroll.getPreferredWidth()) {
                n = rectangle.y + rectangle.height - dimension.height - this.fVScroll.getPreferredWidth();
                rectangle.height -= n;
            }
            int n2 = 0;
            if (this.fHScroll != null && this.fHScroll.isVisible() && rectangle.x + rectangle.width > dimension.width - this.fHScroll.getPreferredWidth()) {
                n2 = rectangle.x + rectangle.width - dimension.width - this.fHScroll.getPreferredWidth();
                rectangle.width -= n2;
            }
            int n3 = -(rectangle.y % this.fLineHeight);
            int n4 = this.lineFromPixel(rectangle.y);
            int n5 = this.lineFromPixel(rectangle.y + rectangle.height);
            if (n5 >= this.fLineBreaks.length()) {
                n5 = this.fLineBreaks.length() - 1;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            for (int i = n4; i <= n5; ++i) {
                n3 += this.renderLine(graphics, i, rectangle, this.fAlignment);
            }
            if (n3 < rectangle.height) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(rectangle.x, rectangle.y + n3, rectangle.width, rectangle.height - n3);
            }
            rectangle.width += n2;
            rectangle.height += n;
            this.paintScrollbars(graphics, rectangle, dimension);
        }
    }

    private void paintScrollbars(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        if (this.fVScroll != null && this.fVScroll.isVisible()) {
            graphics.translate(dimension.width - this.fVScroll.getPreferredWidth(), 0);
            this.fVScroll.paint(graphics);
            graphics.translate(this.fVScroll.getPreferredWidth() - dimension.width, 0);
        }
        if (this.fHScroll != null && this.fHScroll.isVisible()) {
            graphics.translate(0, dimension.height - this.fHScroll.getPreferredWidth());
            this.fHScroll.paint(graphics);
            graphics.translate(0, this.fHScroll.getPreferredWidth() - dimension.height);
            if (this.fVScroll != null && this.fVScroll.isVisible()) {
                int n = this.fHScroll.getPreferredWidth();
                graphics.setColor(Decorations.getColor((int)6));
                graphics.fillRect(dimension.width - n, dimension.height - n, n, n);
            }
        }
    }

    private void removeScrollbar(MWScrollbar mWScrollbar) {
        if (this.fScrollOptions != 1 && mWScrollbar != null && mWScrollbar.isVisible()) {
            if (mWScrollbar.getOrientation() == 0) {
                this.fVOffset = 0;
                this.remove((Component)this.fVScroll);
                this.fVScroll = null;
            } else {
                this.fHOffset = 0;
                this.remove((Component)this.fHScroll);
                this.fHScroll = null;
            }
        }
    }

    private MWScrollbar createScrollbar(int n) {
        MWScrollbar mWScrollbar;
        MWScrollbar mWScrollbar2 = mWScrollbar = n == 1 ? this.fHScroll : this.fVScroll;
        if (mWScrollbar == null) {
            mWScrollbar = new MWScrollbar(n, 0, 0, 0, 0);
            mWScrollbar.addAdjustmentListener((AdjustmentListener)new ScrollListener());
            this.add((Component)mWScrollbar);
        }
        return mWScrollbar;
    }

    private void layoutScrollbars(Graphics graphics, Dimension dimension, int n) {
        int n2;
        int n3;
        int n4;
        boolean bl;
        if (this.fScrollOptions == 1) {
            if (this.fVScroll == null) {
                this.fVScroll = this.createScrollbar(0);
            }
            if (this.fHScroll == null) {
                this.fHScroll = this.createScrollbar(1);
            }
        }
        boolean bl2 = this.fVScroll != null && this.fVScroll.isVisible();
        boolean bl3 = bl = this.fHScroll != null && this.fHScroll.isVisible();
        if (bl2) {
            n4 = bl ? dimension.height - this.fHScroll.getPreferredWidth() : dimension.height;
            n3 = n4 / this.fLineHeight;
            n2 = this.fVScroll.getValue() + this.fVScroll.getVisibleAmount() < this.fLineBreaks.length() ? this.fVScroll.getValue() : this.fVScroll.getValue() + (this.fVScroll.getVisibleAmount() - n3);
            this.fVOffset = n2 * this.fLineHeight;
            this.fVScroll.setValues(n2, n3, 0, this.fLineBreaks.length() - n3);
            this.fVScroll.setBlockIncrement(Math.max(1, n3 - 1));
            this.fVScroll.setBounds(dimension.width - this.fVScroll.getPreferredWidth(), 0, this.fVScroll.getPreferredWidth(), n4);
            this.fVScroll.setVisible(true);
        }
        if (bl) {
            n4 = bl2 ? dimension.width - this.fVScroll.getPreferredWidth() : dimension.width;
            n3 = this.calcMaxWidth(graphics, -1);
            n2 = this.fHScroll.getValue() + this.fHScroll.getVisibleAmount() < n3 ? this.fHScroll.getValue() : this.fHScroll.getValue() + (this.fHScroll.getVisibleAmount() - n4);
            this.fHOffset = n2;
            this.fHScroll.setValues(n2, n4, 0, n3 - n4);
            this.fHScroll.setUnitIncrement(n);
            this.fHScroll.setBlockIncrement(dimension.width);
            this.fHScroll.setBounds(0, dimension.height - this.fHScroll.getPreferredWidth(), n4, this.fHScroll.getPreferredWidth());
            this.fHScroll.setVisible(true);
        }
    }

    private void doResize(Graphics graphics, FontMetrics fontMetrics, Component component) {
        boolean bl;
        boolean bl2 = bl = graphics == null;
        if (this.fScrollOptions != 0) {
            if (graphics == null) {
                graphics = component.getGraphics();
                graphics.setFont(this.getFont());
                fontMetrics = graphics.getFontMetrics();
            }
            Dimension dimension = component.getSize();
            this.fLineBreaks = this.wrapText(this.fText, dimension.width, fontMetrics, this.fLineBreaks);
            int n = this.fLineBreaks.length() * this.fLineHeight;
            if (this.fWrap) {
                if (n > dimension.height) {
                    this.fVScroll = this.createScrollbar(0);
                    this.fLineBreaks = this.wrapText(this.fText, dimension.width - this.fVScroll.getPreferredWidth(), fontMetrics, this.fLineBreaks);
                } else {
                    this.removeScrollbar(this.fVScroll);
                }
            } else {
                int n2 = this.calcMaxWidth(graphics, dimension.width);
                if (n2 > dimension.width) {
                    if (n + 16 > dimension.height) {
                        this.fVScroll = this.createScrollbar(0);
                        this.fLineBreaks = this.wrapText(this.fText, dimension.width - this.fVScroll.getPreferredWidth(), fontMetrics, this.fLineBreaks);
                    } else {
                        this.removeScrollbar(this.fVScroll);
                    }
                    this.fHScroll = this.createScrollbar(1);
                } else if (n > dimension.height) {
                    this.fVScroll = this.createScrollbar(0);
                    this.fLineBreaks = this.wrapText(this.fText, dimension.width - this.fVScroll.getPreferredWidth(), fontMetrics, this.fLineBreaks);
                    if (n2 + 16 > dimension.width) {
                        this.fHScroll = this.createScrollbar(1);
                    } else {
                        this.removeScrollbar(this.fHScroll);
                    }
                } else {
                    this.removeScrollbar(this.fVScroll);
                    this.removeScrollbar(this.fHScroll);
                }
            }
            this.layoutScrollbars(graphics, dimension, fontMetrics.charWidth('M'));
            if (bl && graphics != null) {
                graphics.dispose();
            }
        }
    }

    protected void processComponentEvent(ComponentEvent componentEvent) {
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() == 101 && componentEvent.getComponent() == this && componentEvent.getComponent().isShowing()) {
            this.doResize(null, null, componentEvent.getComponent());
        }
    }

    public void clearSelection() {
        this.fSelStart = -1;
        this.fSelEnd = -1;
        this.fSelAnchor = -1;
        this.repaint();
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        int n;
        if ((mouseEvent.getModifiers() & 0x10) != 0) {
            int n2;
            if (mouseEvent.getID() == 501 && (this.styleAtIndex(n2 = this.styleIndexAt(mouseEvent.getX(), mouseEvent.getY())) & 2) != 0) {
                if (this.fSelEnd > this.fSelStart) {
                    this.clearSelection();
                }
                mouseEvent.consume();
                this.processLink(n2);
            }
            if (this.fScrollOptions != 0 && !mouseEvent.isConsumed()) {
                if (mouseEvent.getID() == 501) {
                    if (this.fVScroll != null && this.fVScroll.isVisible()) {
                        this.fMouseX = this.getSize().width - this.fVScroll.getPreferredWidth();
                        this.fMouseY = 0;
                        mouseEvent.translatePoint(-this.fMouseX, this.fMouseY);
                        if (mouseEvent.getX() >= 0 && mouseEvent.getX() < this.fVScroll.getPreferredWidth()) {
                            this.fMouseTarget = this.fVScroll;
                            this.fMouseTarget.processMouseEvent(mouseEvent);
                            mouseEvent.consume();
                        }
                        mouseEvent.translatePoint(this.fMouseX, -this.fMouseY);
                    }
                    if (!mouseEvent.isConsumed() && this.fHScroll != null && this.fHScroll.isVisible()) {
                        this.fMouseX = 0;
                        this.fMouseY = this.getSize().height - this.fHScroll.getPreferredWidth();
                        mouseEvent.translatePoint(-this.fMouseX, this.fMouseY);
                        if (mouseEvent.getY() >= 0 && mouseEvent.getY() < this.fHScroll.getPreferredWidth()) {
                            this.fMouseTarget = this.fHScroll;
                            this.fMouseTarget.processMouseEvent(mouseEvent);
                            mouseEvent.consume();
                        }
                        mouseEvent.translatePoint(this.fMouseX, -this.fMouseY);
                    }
                } else if (mouseEvent.getID() == 502 && this.fMouseTarget != null) {
                    mouseEvent.translatePoint(-this.fMouseX, this.fMouseY);
                    this.fMouseTarget.processMouseEvent(mouseEvent);
                    this.fMouseTarget = null;
                    mouseEvent.consume();
                }
            }
            if (this.fTrackSelection && !mouseEvent.isConsumed()) {
                if (mouseEvent.getID() == 501) {
                    n2 = this.posFromPixel(mouseEvent.getX(), mouseEvent.getY());
                    if (n2 != -1) {
                        if (this.fSelEnd > this.fSelStart) {
                            this.repaint();
                        }
                        this.setCursor(Cursor.getPredefinedCursor(2));
                        this.fSelAnchor = n2;
                        this.fSelStart = n2;
                        this.fSelEnd = n2;
                        mouseEvent.consume();
                    } else if (this.fSelEnd > this.fSelStart) {
                        this.clearSelection();
                    }
                } else if (mouseEvent.getID() == 502) {
                    n2 = this.styleIndexAt(mouseEvent.getX(), mouseEvent.getY());
                    if ((this.styleAtIndex(n2) & 2) != 0) {
                        this.setCursor(Cursor.getPredefinedCursor(12));
                    } else {
                        this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                } else if (mouseEvent.getID() == 505 || mouseEvent.getID() == 504) {
                    // empty if block
                }
            }
            if (mouseEvent.getID() == 502) {
                this.fSelAnchor = -1;
            }
        } else if (this.fSelEnd > this.fSelStart && mouseEvent.getID() == 501 && ((n = this.posFromPixel(mouseEvent.getX(), mouseEvent.getY())) < this.fSelStart || n > this.fSelEnd)) {
            this.clearSelection();
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.fTrackSelection && mouseEvent.getID() == 506 && this.fMouseTarget == null && this.fSelAnchor >= 0) {
            this.trackSelection(mouseEvent);
            mouseEvent.consume();
        } else {
            int n = this.styleIndexAt(mouseEvent.getX(), mouseEvent.getY());
            if ((this.styleAtIndex(n) & 2) != 0) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            if (this.fMouseTarget != null && mouseEvent.getID() == 506) {
                mouseEvent.translatePoint(-this.fMouseX, this.fMouseY);
                this.fMouseTarget.processMouseEvent(mouseEvent);
                mouseEvent.consume();
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    private void processLink(int n) {
        if (n > 2) {
            String string;
            Matcher matcher;
            int n2 = this.styleAtIndex(n -= 2);
            int n3 = this.stylePosAtIndex(n);
            int n4 = this.stylePosAtIndex(n + 1) - n3;
            string = n2 == 65 ? new String(this.fText, n3, n4) : (n2 == 129 ? ((matcher = sMatlabLinkPattern.matcher(string = new String(this.fText, n3, n4))).matches() ? string.substring(matcher.start(1), matcher.end(1)) : "web " + string) : null);
            if (string != null && sMatlab != null) {
                sMatlab.evalConsoleOutput(string);
            }
        }
    }

    private void trackSelection(MouseEvent mouseEvent) {
        int n = this.posFromPixel(mouseEvent.getX(), mouseEvent.getY());
        if (n > -1 && n != this.fSelStart && n != this.fSelEnd) {
            int n2 = this.fSelStart;
            int n3 = this.fSelEnd;
            if (n > this.fSelAnchor) {
                this.fSelStart = this.fSelAnchor;
                this.fSelEnd = n;
            } else {
                this.fSelStart = n;
                this.fSelEnd = this.fSelAnchor;
            }
            this.repaintRegion(n2, n3, this.fSelStart, this.fSelEnd);
        }
    }

    private void repaintRegion(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        Dimension dimension;
        int n7 = Math.min(n, n3);
        int n8 = Math.max(n2, n4);
        int n9 = this.lineFromPos(n7);
        int n10 = this.lineFromPos(n8);
        if (n2 != n4) {
            if (n == n3) {
                n7 = n2 < n4 ? n2 : n4;
                n9 = this.lineFromPos(n7);
            }
        } else if (n != n3 && n2 == n4) {
            n8 = n > n3 ? n : n3;
            n10 = this.lineFromPos(n8);
        }
        Dimension dimension2 = dimension = this.fCachedSize != null ? this.fCachedSize : this.getSize();
        if (n9 == n10) {
            n6 = this.pixelFromPosX(n9, n7) - this.fHOffset;
            n5 = this.pixelFromPosX(n10, n8) - this.fHOffset;
            n8 = dimension.width;
            if (this.fVScroll != null && this.fVScroll.isVisible()) {
                n8 -= this.fVScroll.getPreferredWidth();
            }
            if (n5 > n8) {
                n5 = n8;
            }
            n5 -= n6;
        } else {
            n6 = 0;
            n5 = dimension.width;
            if (this.fVScroll != null && this.fVScroll.isVisible()) {
                n5 -= this.fVScroll.getPreferredWidth();
            }
        }
        int n11 = this.pixelFromLineY(n9) - this.fVOffset;
        int n12 = this.pixelFromLineY(n10 + 1) - this.fVOffset;
        n8 = dimension.height;
        if (this.fHScroll != null && this.fHScroll.isVisible()) {
            n8 -= this.fHScroll.getPreferredWidth();
        }
        if (n12 > n8) {
            n12 = n8;
        }
        this.repaint(n6, n11, n5, n12 -= n11);
    }

    private void setEraseColor(Graphics graphics, int n, int n2, int n3, boolean bl) {
        if (n > n2 && n < n3) {
            graphics.setColor(Decorations.getColor((int)4, (boolean)bl, (Color)this.getBackground()));
        } else {
            graphics.setColor(this.getBackground());
        }
    }

    private int drawSegment(Graphics graphics, FontMetrics fontMetrics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        int n7 = fontMetrics.charsWidth(this.fText, n, n2);
        if (bl) {
            graphics.setColor(Decorations.getColor((int)4, (boolean)bl2, (Color)this.getBackground()));
            graphics.fillRect(n3, n4, n7, n5);
            graphics.setColor(Decorations.getColor((int)5, (boolean)bl2, null));
        } else {
            this.setStyleColor(graphics, 26, n6);
            graphics.fillRect(n3, n4, n7, n5);
            this.setStyleColor(graphics, 20, n6);
        }
        graphics.drawChars(this.fText, n, n2, n3, n4 + fontMetrics.getMaxAscent() + fontMetrics.getLeading());
        return n7;
    }

    private int renderLine(Graphics graphics, int n, Rectangle rectangle, int n2) {
        FontMetrics fontMetrics;
        int n3 = 0;
        int n4 = rectangle.y;
        int n5 = this.getLineEndNoEOL(n);
        int n6 = this.getLineStart(n);
        int n7 = this.styleIndexAt(n6);
        int n8 = this.fSelEnd;
        int n9 = this.fSelStart;
        boolean bl = n8 > n9;
        int n10 = 0;
        while (n6 < n5 && n10 < this.fCachedSize.width) {
            int n11;
            int n12 = this.styleAtIndex(n7);
            if ((n11 = this.stylePosAtIndex(++n7)) > n5) {
                n11 = n5;
            }
            if ((n12 & 1) == 0) {
                int n13 = n11 - n6;
                this.setStyleFont(graphics, n12);
                fontMetrics = graphics.getFontMetrics();
                int n14 = fontMetrics.charsWidth(this.fText, n6, n13);
                n3 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
                n4 = n * n3 - this.fVOffset;
                if (n10 == 0) {
                    switch (n2) {
                        case 0: {
                            n10 = -this.fHOffset;
                            break;
                        }
                        case 1: {
                            n10 = n11 == n5 ? this.fCachedSize.width - n14 >> 1 : this.fCachedSize.width - this.calcWidth(graphics, this.fText, n6, n5) >> 1;
                            if ((n10 -= this.fHOffset) <= 0) break;
                            this.setEraseColor(graphics, n6, n9, n8, bl);
                            graphics.fillRect(0, n4, n10, n3);
                            break;
                        }
                        case 2: {
                            n10 = n11 == n5 ? this.fCachedSize.width - n14 : this.fCachedSize.width - this.calcWidth(graphics, this.fText, n6, n5);
                            if ((n10 -= this.fHOffset) <= 0) break;
                            this.setEraseColor(graphics, n6, n9, n8, bl);
                            graphics.fillRect(0, n4, n10, n3);
                        }
                    }
                }
                if (n10 + n14 > 0) {
                    int n15;
                    if (n8 > n9 && n6 < n8 && n11 > n9) {
                        int n16;
                        n15 = n10;
                        if (n6 < n9) {
                            n16 = n9 - n6;
                            n15 += this.drawSegment(graphics, fontMetrics, n6, n16, n15, n4, n3, n12, false, bl);
                            n6 = n9;
                            n13 -= n16;
                        }
                        n16 = n8 < n11 ? n8 - n6 : n13;
                        n15 += this.drawSegment(graphics, fontMetrics, n6, n16, n15, n4, n3, n12, true, bl);
                        if ((n6 += n16) < n11) {
                            n16 = n11 - n6;
                            n15 += this.drawSegment(graphics, fontMetrics, n6, n16, n15, n4, n3, n12, false, bl);
                        }
                    } else {
                        this.setStyleColor(graphics, 26, n12);
                        graphics.fillRect(n10, n4, n14, n3);
                        this.setStyleColor(graphics, 20, n12);
                        graphics.drawChars(this.fText, n6, n13, n10, n4 + fontMetrics.getMaxAscent() + fontMetrics.getLeading());
                    }
                    if ((n12 & 4) != 0) {
                        n15 = (n3 + 1 >> 1) + 1;
                        graphics.drawLine(n10, n15, n10 + n14, n15);
                    }
                    if ((n12 & 8) != 0) {
                        n15 = n4 + fontMetrics.getMaxAscent() + fontMetrics.getLeading() + 1;
                        graphics.drawLine(n10, n15, n10 + n14, n15);
                    }
                }
                n10 += n14;
            }
            n6 = n11;
        }
        if (n3 == 0) {
            n6 = this.getLineStart(n);
            n7 = this.styleIndexAt(n6);
            n10 = this.styleAtIndex(n7);
            this.setStyleFont(graphics, n10);
            fontMetrics = graphics.getFontMetrics();
            n3 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + fontMetrics.getLeading();
            n4 = n * n3 - this.fVOffset;
        }
        if (n10 < this.fCachedSize.width) {
            this.setEraseColor(graphics, n5, n9, n8, bl);
            graphics.fillRect(n10, n4, this.fCachedSize.width - n10, n3);
        }
        return n3;
    }

    private int calcHeight(Graphics graphics, char[] cArray, int n, int n2) {
        return this.fLineHeight;
    }

    private int calcWidth(Graphics graphics, char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = -1;
        Font font = graphics.getFont();
        int n5 = n;
        while (n5 < n2) {
            int n6;
            int n7 = this.styleIndexAt(n5);
            int n8 = this.styleAtIndex(n7);
            if ((n6 = this.stylePosAtIndex(++n7)) > n2) {
                n6 = n2;
            } else {
                int n9 = this.styleAtIndex(n7);
                while (n6 < n2 && ((n8 ^ n9) & 0xFFFF1) == 0) {
                    if ((n6 = this.stylePosAtIndex(++n7)) > n2) {
                        n6 = n2;
                    }
                    n9 = this.styleAtIndex(n7);
                }
            }
            if ((n8 & 1) == 0) {
                if (n4 != (n8 >>> 13 & 0x7F)) {
                    n4 = n8 >>> 13 & 0x7F;
                    this.setStyleFont(graphics, n8);
                }
                n3 += graphics.getFontMetrics().charsWidth(cArray, n5, n6 - n5);
            }
            n5 = n6;
        }
        graphics.setFont(font);
        return n3;
    }

    private int calcMaxWidth(Graphics graphics, int n) {
        if (this.fCachedWidth > 0) {
            return this.fCachedWidth;
        }
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        int n2 = 0;
        int n3 = this.fLineBreaks.length();
        for (int i = 0; i < n3; ++i) {
            int n4 = this.calcWidth(graphics, this.fText, this.getLineStart(i), this.getLineEndNoEOL(i));
            if (n4 > n2) {
                n2 = n4;
            }
            if (n2 > n) break;
        }
        if (n == Integer.MAX_VALUE) {
            this.fCachedWidth = n2;
        }
        return n2;
    }

    private int calcMaxWidth(Graphics graphics, char[] cArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = cArray.length;
        int n5 = 0;
        int n6 = 0;
        if (n < 0) {
            n = Integer.MAX_VALUE;
        }
        while (n2 < n4) {
            if (cArray[n2] == '\n') {
                n5 = this.calcWidth(graphics, cArray, n3, n2 - 1);
                if (n5 > n6) {
                    n6 = n5;
                }
                n3 = n2 + 1;
            } else if (cArray[n2] == '\r') {
                n5 = this.calcWidth(graphics, cArray, n3, n2 - 1);
                if (n5 > n6) {
                    n6 = n5;
                }
                if (n2 + 1 < n4 && cArray[n2 + 1] == '\n') {
                    ++n2;
                }
                n3 = n2 + 1;
            }
            if (n5 > n) break;
            ++n2;
        }
        if (n2 == n4 && n3 < n4 && (n5 = this.calcWidth(graphics, cArray, n3, n2 - 1)) > n6) {
            n6 = n5;
        }
        return n6;
    }

    private int findStyleExtent(char[] cArray, int n, int n2) {
        int n3;
        int n4 = this.styleIndexAt(n);
        int n5 = this.styleAtIndex(n4);
        int n6 = this.stylePosAtIndex(++n4);
        while (n6 <= n2 && ((n5 ^ (n3 = this.styleAtIndex(n4))) & 0xFFFF1) == 0) {
            n6 = this.stylePosAtIndex(++n4);
        }
        if (n6 > n2) {
            n6 = n2;
        }
        return n6;
    }

    private int findPreviousStyleExtent(char[] cArray, int n, int n2) {
        int n3;
        int n4 = this.styleIndexAt(n);
        int n5 = this.styleAtIndex(n4);
        int n6 = this.stylePosAtIndex(n4);
        while (n6 >= n2 && ((n5 ^ (n3 = this.styleAtIndex(--n4))) & 0xFFFF1) == 0) {
            n6 = this.stylePosAtIndex(n4);
        }
        if (n6 < n2) {
            n6 = n2;
        }
        return n6;
    }

    private IntBuffer wrapText(char[] cArray, int n, FontMetrics fontMetrics, IntBuffer intBuffer) {
        if (intBuffer == null) {
            intBuffer = new IntBuffer();
        }
        if (!this.fWrap) {
            n = Integer.MAX_VALUE;
        }
        intBuffer.setSize(0);
        if (cArray != null && cArray.length > 0) {
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = n4;
            int n9 = n4;
            int n10 = cArray.length;
            IntBuffer intBuffer2 = new IntBuffer(24, 24);
            while (n4 < n10) {
                if (n4 >= n7) {
                    if (n4 > 0 && n5 < n2) {
                        n6 += fontMetrics.charsWidth(cArray, n8, n4 - n8);
                    }
                    while (n4 >= n7 && n4 < n10) {
                        n7 = this.findStyleExtent(cArray, n4, n10);
                        n3 = this.styleAt(n4);
                        if ((n3 & 1) != 0) {
                            n4 = n7;
                            continue;
                        }
                        intBuffer2.append(n4);
                        intBuffer2.append(n7);
                        intBuffer2.append(n3);
                    }
                    if (n4 >= n10) continue;
                    n8 = n4;
                    fontMetrics = this.getStyleFontMetrics(n3);
                    n2 = n5 + (n - n6) / fontMetrics.charWidth('a');
                }
                if (cArray[n4] < ' ') {
                    if (cArray[n4] == '\n') {
                        if (n5 < n2) {
                            n6 += fontMetrics.charsWidth(cArray, n8, n4 - n8);
                        }
                        if (n6 > n) {
                            n5 = 0x7FFFFFFE;
                        } else {
                            intBuffer.append(n9);
                            if (n4 < n7) {
                                intBuffer2.delete(0, intBuffer2.length() - 3);
                                intBuffer2.setAt(0, n4 + 1);
                            } else {
                                intBuffer2.setSize(0);
                            }
                            n6 = 0;
                            n5 = -1;
                            n9 = n8 = n4 + 1;
                        }
                    } else if (cArray[n4] == '\r') {
                        if (n5 < n2) {
                            n6 += fontMetrics.charsWidth(cArray, n8, n4 - n8);
                        }
                        if (n4 + 1 < n10 && cArray[n4 + 1] == '\n') {
                            ++n4;
                        }
                        if (n6 > n) {
                            n5 = 0x7FFFFFFE;
                        } else {
                            intBuffer.append(n9);
                            if (n4 < n7) {
                                intBuffer2.delete(0, intBuffer2.length() - 3);
                                intBuffer2.setAt(0, n4 + 1);
                            } else {
                                intBuffer2.setSize(0);
                            }
                            n6 = 0;
                            n5 = -1;
                            n9 = n8 = n4 + 1;
                        }
                    }
                }
                if (++n5 >= n2) {
                    if (n6 == 0) {
                        n6 = fontMetrics.charsWidth(cArray, n8, n4 - n8 + 1);
                    } else if (n5 != Integer.MAX_VALUE) {
                        n6 = n5 > n2 ? (n6 += fontMetrics.charWidth(cArray[n4])) : (n6 += fontMetrics.charsWidth(cArray, n8, n4 - n8 + 1));
                    }
                    if (n6 > n) {
                        int n11 = n4;
                        int n12 = n4;
                        int n13 = intBuffer2.length();
                        while (n6 > n) {
                            boolean bl;
                            if (this.isWhitespace(cArray[n11])) {
                                do {
                                    --n11;
                                    while (n11 >= n8 && this.isWhitespace(cArray[n11])) {
                                        --n11;
                                    }
                                    bl = true;
                                    if (n11 <= n9) {
                                        n6 = 0;
                                        n11 = n9;
                                        continue;
                                    }
                                    n6 = n11 + 1 >= cArray.length ? (n6 -= fontMetrics.charsWidth(cArray, cArray.length - 1, n12 - n11)) : (n6 -= fontMetrics.charsWidth(cArray, n11 + 1, n12 - n11));
                                    if (n6 > n && n11 < n8) {
                                        n3 = intBuffer2.getAt(--n13);
                                        n11 = intBuffer2.getAt(--n13);
                                        n8 = intBuffer2.getAt(--n13);
                                        fontMetrics = this.getStyleFontMetrics(n3);
                                        bl = false;
                                    }
                                    n12 = n11;
                                } while (!bl);
                            }
                            if (n6 <= n) continue;
                            int n14 = n11;
                            while (true) {
                                if (n11 >= n8 && !this.isWordBreakChar(cArray[n11])) {
                                    --n11;
                                    continue;
                                }
                                bl = true;
                                if (n11 <= n9) {
                                    n11 = n9;
                                } else {
                                    if ((n6 -= fontMetrics.charsWidth(cArray, n11 + 1, n12 - n11)) > n && n11 < n8) {
                                        n3 = intBuffer2.getAt(--n13);
                                        n11 = intBuffer2.getAt(--n13) - 1;
                                        n8 = intBuffer2.getAt(--n13);
                                        fontMetrics = this.getStyleFontMetrics(n3);
                                        bl = false;
                                    }
                                    n12 = n11;
                                }
                                if (bl) break;
                            }
                            if (n11 == n9) {
                                while (true) {
                                    if (n14 > n8 && n6 > n) {
                                        n6 -= fontMetrics.charWidth(cArray[n14--]);
                                        continue;
                                    }
                                    bl = true;
                                    if (n14 > n9 && n6 > n) {
                                        n3 = intBuffer2.getAt(--n13);
                                        n14 = intBuffer2.getAt(--n13) - 1;
                                        n8 = intBuffer2.getAt(--n13);
                                        fontMetrics = this.getStyleFontMetrics(n3);
                                        bl = false;
                                    }
                                    if (bl) break;
                                }
                                if (n14 == n9) {
                                    n4 = n9 + 1;
                                    continue;
                                }
                                n4 = n14 + 1;
                                continue;
                            }
                            n6 -= fontMetrics.charsWidth(cArray, n11, n12 - n11 + 1);
                            n4 = n11;
                        }
                    } else {
                        ++n4;
                        continue;
                    }
                    n6 = 0;
                    intBuffer.append(n9);
                    while (n4 < n10 && this.isWhitespace(cArray[n4])) {
                        if (cArray[n4] == '\n') {
                            ++n4;
                            break;
                        }
                        if (cArray[n4] == '\r') {
                            if (++n4 >= n10 || cArray[n4] != '\n') break;
                            ++n4;
                            break;
                        }
                        ++n4;
                    }
                    if (n4 < (n7 = intBuffer2.getAt(n5 = intBuffer2.length() - 2))) {
                        intBuffer2.delete(0, n5 - 1);
                        intBuffer2.setAt(0, n4);
                        fontMetrics = this.getStyleFontMetrics(intBuffer2.getAt(2));
                    } else {
                        intBuffer2.setSize(0);
                    }
                    n9 = n4;
                    n8 = n4--;
                    n5 = 0;
                }
                ++n4;
            }
            if (n4 > n8) {
                intBuffer.append(n9);
            }
        }
        return intBuffer;
    }

    private void convertHtmlToStyles(char[] cArray) {
        if (cArray != null) {
            String string = new String(cArray).toLowerCase();
            Matcher matcher = sLinkPattern.matcher(string);
            while (matcher.find()) {
                this.setStyle(matcher.start(1), matcher.end(1), 1);
                int n = string.substring(matcher.start(2), matcher.end(2)).equals("meval") ? 65 : 129;
                this.setStyle(matcher.start(5), matcher.end(5), n);
                this.setStyle(matcher.start(6), matcher.end(6), 0x20000A);
                this.setStyle(matcher.start(7), matcher.end(7), 1);
            }
        }
    }

    private int pixelFromLineY(int n) {
        int n2 = n * this.fLineHeight;
        return n2;
    }

    private int pixelFromPosX(int n, int n2) {
        int n3 = 0;
        int n4 = this.getLineStart(n);
        int n5 = this.styleIndexAt(n4);
        int n6 = this.styleIndexAt(n2);
        for (int i = n5; i <= n6; ++i) {
            int n7 = this.styleAtIndex(i);
            if ((n7 & 1) == 0) {
                FontMetrics fontMetrics = this.getStyleFontMetrics(n7);
                int n8 = Math.max(n4, this.stylePosAtIndex(i));
                int n9 = Math.min(this.stylePosAtIndex(i + 1), n2);
                n3 += fontMetrics.charsWidth(this.fText, n8, n9 - n8);
            }
            n4 = 0;
        }
        return n3;
    }

    private int posFromPixel(int n, int n2) {
        int n3 = this.lineFromPixel(n2);
        if (n3 >= 0 && n3 < this.fLineBreaks.length()) {
            if ((n3 = this.posFromPixelX(n3, n)) == -1) {
                n3 = this.getLineEnd(this.lineFromPixel(n2));
            }
        } else {
            n3 = -1;
        }
        return n3;
    }

    private int posFromPixelX(int n, int n2) {
        if ((n2 += this.fHOffset) < 0) {
            return -1;
        }
        int n3 = 0;
        int n4 = this.getLineStart(n);
        int n5 = this.getLineEndNoEOL(n);
        int n6 = this.styleIndexAt(n4);
        int n7 = this.styleIndexAt(n5);
        for (int i = n6; i <= n7; ++i) {
            int n8 = this.styleAtIndex(i);
            if ((n8 & 1) != 0) continue;
            FontMetrics fontMetrics = this.getStyleFontMetrics(n8);
            int n9 = Math.max(n4, this.stylePosAtIndex(i));
            int n10 = Math.min(this.stylePosAtIndex(i + 1), n5);
            for (int j = n9; j < n10; ++j) {
                int n11 = n3 + fontMetrics.charWidth(this.fText[j]);
                if (n3 <= n2 && n2 < n11) {
                    return j;
                }
                n3 = n11;
            }
        }
        return -1;
    }

    protected void setStyle(int n, int n2, int n3) {
        int n4;
        int n5;
        if (this.fStyleRuns.length() == 0) {
            n5 = 0;
            n4 = n3;
        } else {
            n5 = this.styleIndexAt(n);
            n4 = this.styleAtIndex(n5);
            if (this.stylePosAtIndex(n5) == n) {
                this.fStyleRuns.delete(n5 <<= 1, n5 + 2);
            } else if (this.stylePosAtIndex(n5 + 1) == n2) {
                this.fStyleRuns.delete((n5 <<= 1) + 2, n5 + 4);
                if (n5 < this.fStyleRuns.length()) {
                    n5 += 2;
                }
            } else if ((n5 <<= 1) < this.fStyleRuns.length()) {
                n5 += 2;
            }
        }
        this.fStyleRuns.insertSpace(n5, 4);
        this.fStyleRuns.setAt(n5++, n);
        this.fStyleRuns.setAt(n5++, n3);
        this.fStyleRuns.setAt(n5++, n2);
        this.fStyleRuns.setAt(n5, n4);
        this.fStyleCache = Integer.MAX_VALUE;
    }

    private int styleAt(int n, int n2) {
        int n3 = this.lineFromPixel(n2);
        n3 = n3 >= 0 && n3 < this.fLineBreaks.length() ? this.posFromPixelX(n3, n) : 0;
        return this.styleAt(n3);
    }

    private int styleAt(int n) {
        n = this.styleIndexAt(n);
        n = this.checkStyleRun((n << 1) + 1);
        return this.fStyleRuns.getAt(n);
    }

    private int styleAtIndex(int n) {
        n = this.checkStyleRun((n << 1) + 1);
        return this.fStyleRuns.getAt(n);
    }

    int stylePosAtIndex(int n) {
        n = this.checkStyleRun(n << 1);
        return this.fStyleRuns.getAt(n);
    }

    private int styleIndexAt(int n, int n2) {
        int n3 = this.lineFromPixel(n2);
        n3 = n3 >= 0 && n3 < this.fLineBreaks.length() ? this.posFromPixelX(n3, n) : -1;
        if (n3 < 0) {
            return 0;
        }
        return this.styleIndexAt(n3);
    }

    int styleIndexAt(int n) {
        int n2;
        int n3;
        int n4;
        if (this.fStyleCache < this.fStyleRuns.length()) {
            if (n >= this.stylePosAtIndex(this.fStyleCache)) {
                n4 = (this.fStyleRuns.length() >> 1) - 1;
                if (this.fStyleCache == n4 || n < this.stylePosAtIndex(this.fStyleCache + 1)) {
                    return this.fStyleCache;
                }
                n3 = this.fStyleCache;
                n2 = this.fStyleRuns.length() >> 1;
            } else {
                n3 = 0;
                n2 = this.fStyleCache;
            }
        } else {
            n3 = 0;
            n2 = this.fStyleRuns.length() >> 1;
        }
        int n5 = -1;
        n4 = n2 - 1;
        while (n3 < n2) {
            n5 = n3 + n2 >> 1;
            int n6 = this.stylePosAtIndex(n5);
            if (n >= n6) {
                if (n5 == n4 || n < this.stylePosAtIndex(n5 + 1)) break;
                n3 = n5 + 1;
                continue;
            }
            n2 = n5;
        }
        this.fStyleCache = n5;
        return n5;
    }

    private int checkStyleRun(int n) {
        if (n < 0 || n >= this.fStyleRuns.length()) {
            System.out.println("MLStyleTextLabel: Style run index out of range, " + (n >> 1) + " must be >= 0 and < " + (this.fStyleRuns.length() >> 1));
            Thread.dumpStack();
            n = n < 0 ? (((n = -n) & 1) == 0 ? 0 : 1) : ((n & 1) == 0 ? this.fStyleRuns.length() - 2 : this.fStyleRuns.length() - 1);
        }
        return n;
    }

    private int checkStyleIndex(int n) {
        if (n < 0 || n >= sStyleTable.length()) {
            System.out.println("MLStyleTextLabel: Style index out of range, " + n + " must be >= 0 and < " + sStyleTable.length());
            Thread.dumpStack();
            n = n < 0 ? 0 : sStyleTable.length() - 1;
        }
        return n;
    }

    private int getLineStart(int n) {
        n = this.checkLine(n);
        return this.fLineBreaks.getAt(n);
    }

    private int getLineEnd(int n) {
        if ((n = this.checkLine(n)) < this.fLineBreaks.length() - 1) {
            return this.getLineStart(n + 1);
        }
        return this.fText.length;
    }

    private int getLineEndNoEOL(int n) {
        int n2 = this.getLineEnd(n) - 1;
        if (n2 >= 0 && this.fText[n2] == '\n') {
            --n2;
        }
        if (n2 >= 0 && this.fText[n2] == '\r') {
            --n2;
        }
        return n2 + 1;
    }

    private int lineFromPixel(int n) {
        return (n + this.fVOffset) / this.fLineHeight;
    }

    private int lineFromPos(int n) {
        int n2;
        int n3;
        int n4;
        if (this.fLineCache < this.fLineBreaks.length()) {
            if (n >= this.getLineStart(this.fLineCache)) {
                n4 = this.fLineBreaks.length() - 1;
                if (this.fLineCache == n4 || n < this.getLineStart(this.fLineCache + 1)) {
                    return this.fLineCache;
                }
                n3 = this.fLineCache;
                n2 = this.fLineBreaks.length();
            } else {
                n3 = 0;
                n2 = this.fLineCache;
            }
        } else {
            n3 = 0;
            n2 = this.fLineBreaks.length();
        }
        int n5 = -1;
        n4 = n2 - 1;
        while (n3 < n2) {
            n5 = n3 + n2 >> 1;
            int n6 = this.getLineStart(n5);
            if (n >= n6) {
                if (n5 == n4 || n < this.getLineStart(n5 + 1)) break;
                n3 = n5 + 1;
                continue;
            }
            n2 = n5;
        }
        this.fLineCache = n5;
        return n5;
    }

    private int checkLine(int n) {
        if (n < 0 || n >= this.fLineBreaks.length()) {
            System.out.println("MLStyleTextLabel: Line number out of range, " + n + " must be >= 0 and < " + this.fLineBreaks.length());
            Thread.dumpStack();
            n = n < 0 ? 0 : this.fLineBreaks.length() - 1;
        }
        return n;
    }

    private void dumpLineBreaks() {
        if (this.fLineBreaks != null) {
            System.out.println("fLineBreaks.length:" + this.fLineBreaks.length());
            System.out.print("[");
            for (int i = 0; i < this.fLineBreaks.length(); ++i) {
                if (i > 0) {
                    System.out.print(" ");
                }
                System.out.print(this.fLineBreaks.getAt(i));
            }
            System.out.println("]");
        } else {
            System.out.println("fLineBreaks is null");
        }
    }

    private void createContextMenu() {
        this.fContextMenu = new PopupMenu();
        MenuItem menuItem = new MenuItem("Copy");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MLStyledTextLabel.this.doCopy(false);
            }
        });
        this.fContextMenu.add(menuItem);
        menuItem = new MenuItem("SelectAll");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MLStyledTextLabel.this.doCopy(true);
            }
        });
        this.fContextMenu.add(menuItem);
    }

    private void doContextMenu(MouseEvent mouseEvent) {
        this.fContextMenu.show((Component)((Object)this), mouseEvent.getX(), mouseEvent.getY());
    }

    private void doCopy(boolean bl) {
        String string;
        if (bl) {
            this.selectAll();
        }
        if ((string = this.getSelectedText()) != null) {
            if (PlatformInfo.isUnix() && !PlatformInfo.isMacintosh()) {
                MWClipboard.getMWClipboard().setXSelectionContents(string);
            } else {
                StringSelection stringSelection = new StringSelection(string);
                this.getToolkit().getSystemClipboard().setContents(stringSelection, null);
            }
        }
    }

    private void dumpStyleRuns() {
        if (this.fStyleRuns != null) {
            System.out.println("fStyleRuns.length:" + (this.fStyleRuns.length() >> 1));
            for (int i = 0; i < this.fStyleRuns.length(); i += 2) {
                System.out.print("[" + this.fStyleRuns.getAt(i) + " " + Integer.toHexString(this.fStyleRuns.getAt(i + 1)) + "] ");
            }
            System.out.println();
        } else {
            System.out.println("fStyleRuns is null");
        }
    }

    static {
        sLinkPattern = Pattern.compile("(<a\\s*((meval)|(href))\\s*=\\s*\"(.*?)\"\\s*>)(.*?)(</a>)");
        sMatlabLinkPattern = Pattern.compile("^matlab:(.*?)$");
    }

    private class ScrollListener
    implements AdjustmentListener {
        private ScrollListener() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            if (adjustmentEvent.getID() == 601) {
                if (adjustmentEvent.getSource() == MLStyledTextLabel.this.fVScroll) {
                    MLStyledTextLabel.this.fVOffset = adjustmentEvent.getValue() * MLStyledTextLabel.this.fLineHeight;
                    MLStyledTextLabel.this.repaint();
                } else if (adjustmentEvent.getSource() == MLStyledTextLabel.this.fHScroll) {
                    MLStyledTextLabel.this.fHOffset = adjustmentEvent.getValue();
                    MLStyledTextLabel.this.repaint();
                }
            }
        }
    }

    private class MLStyledMouseAdapter
    extends MouseAdapter {
        private MLStyledMouseAdapter() {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MLStyledTextLabel.this.doContextMenu(mouseEvent);
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            MLStyledTextLabel.this.requestFocus();
            if (mouseEvent.isPopupTrigger()) {
                MLStyledTextLabel.this.doContextMenu(mouseEvent);
            }
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            int n = keyEvent.getModifiers();
            int n2 = keyEvent.getKeyCode();
            boolean bl2 = n2 == 67 && n == MLStyledTextLabel.this.getToolkit().getMenuShortcutKeyMask();
            boolean bl3 = bl = n2 == 65 && n == MLStyledTextLabel.this.getToolkit().getMenuShortcutKeyMask();
            if (bl2) {
                MLStyledTextLabel.this.doCopy(false);
            } else if (bl) {
                MLStyledTextLabel.this.doCopy(true);
            }
        }
    }
}

