/*
 * Decompiled with CFR 0.152.
 */
package ice.util;

import ice.util.AbstractVersion;
import ice.util.Defs;
import java.util.StringTokenizer;

public class JavaVersion
extends AbstractVersion {
    public static final int MAJOR_PART = 0;
    public static final int MINOR_PART = 1;
    public static final int BUILD_PART_ONE = 2;
    public static final int BUILD_PART_TWO = 3;
    public static final int VERSION_FULL_LENGTH = 4;
    public static final int MAJOR_MINOR_LENGTH = 2;
    private static JavaVersion OEAB = new JavaVersion(JavaVersion._versionParts(Defs.sysProperty("java.version")));

    private JavaVersion(int[] nArray) {
        super(nArray);
    }

    public static JavaVersion getVMVersion() {
        return OEAB;
    }

    public static JavaVersion getVersion(String string) {
        return new JavaVersion(JavaVersion._versionParts(string));
    }

    public static JavaVersion getVersionFromHex(String string) {
        return new JavaVersion(JavaVersion.charAt(string));
    }

    public static boolean isV12orGreater() {
        return JavaVersion.OEAB(2);
    }

    public static boolean isV13orGreater() {
        return JavaVersion.OEAB(3);
    }

    public static boolean isV14orGreater() {
        return JavaVersion.OEAB(4);
    }

    public static boolean isV15orGreater() {
        return JavaVersion.OEAB(5);
    }

    private static boolean OEAB(int n) {
        if (JavaVersion.OEAB._versionParts[0] > 1) {
            return true;
        }
        return JavaVersion.OEAB._versionParts[0] >= 1 && JavaVersion.OEAB._versionParts[1] >= n;
    }

    private static int[] _versionParts(String string) {
        int[] nArray = new int[4];
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            nArray[0] = Integer.parseInt(JavaVersion.append(string2));
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            nArray[1] = Integer.parseInt(JavaVersion.append(string2));
        }
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("_");
            if (n > -1) {
                nArray[2] = Integer.parseInt(JavaVersion.append(string2.substring(0, n)));
                nArray[3] = Integer.parseInt(JavaVersion.append(string2.substring(n + 1)));
            } else {
                nArray[2] = Integer.parseInt(JavaVersion.append(string2));
            }
        }
        return nArray;
    }

    private static String append(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c >= '0' && c <= '9') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private static int[] charAt(String string) {
        int[] nArray = new int[4];
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            nArray[0] = Integer.parseInt(string2.substring(0, 3), 16);
            nArray[1] = Integer.parseInt(string2.substring(3), 16);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NumberFormatException("Illegal Version format");
        }
        string2 = stringTokenizer.nextToken();
        nArray[2] = Integer.parseInt(string2, 16);
        if (!stringTokenizer.hasMoreTokens()) {
            throw new NumberFormatException("Illegal Version format");
        }
        string2 = stringTokenizer.nextToken();
        nArray[3] = Integer.parseInt(string2, 16);
        return nArray;
    }

    public String toString() {
        return this._versionParts[0] + "." + this._versionParts[1] + "." + this._versionParts[2] + "_" + this._versionParts[3];
    }
}

