/*
 * Decompiled with CFR 0.152.
 */
package ice.util.security.jdk11;

import ice.debug.Debug;
import ice.util.io.IOKit;
import ice.util.security.BoxedCode;
import ice.util.security.ProxyException;
import ice.util.security.SecurityKit;
import ice.util.security.jdk11.JarCache_jdk11;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

final class URLClassLoader_jdk11
extends ClassLoader {
    private URL[] OEAB;
    private boolean[] Z;
    ThreadGroup _threadGroup;

    URLClassLoader_jdk11(URL[] uRLArray) {
        int n = uRLArray.length;
        this.OEAB = uRLArray;
        this.Z = new boolean[n];
        int n2 = 0;
        while (n2 != n) {
            if (!uRLArray[n2].toString().endsWith("/")) {
                this.Z[n2] = true;
            }
            ++n2;
        }
        JarCache_jdk11 jarCache_jdk11 = JarCache_jdk11.instance;
        int n3 = 0;
        while (n3 != n) {
            if (this.Z[n3]) {
                jarCache_jdk11.addJarFile(uRLArray[n3]);
            }
            ++n3;
        }
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        block8: {
            clazz = this.findLoadedClass(string);
            if (clazz == null) {
                try {
                    return this.findSystemClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        String string2 = string.replace('.', '/') + ".class";
                        byte[] byArray = this.getResourceAsByteArray(string2);
                        if (byArray != null) {
                            clazz = this.defineClass(string, byArray, 0, byArray.length);
                        }
                    }
                    catch (Exception exception) {
                        if (!Debug.ex) break block8;
                        Debug.ex(exception);
                    }
                }
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException("Class <" + string + "> not found anywhere");
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public byte[] getResourceAsByteArray(String string) {
        byte[] byArray = null;
        JarCache_jdk11 jarCache_jdk11 = JarCache_jdk11.instance;
        int n = 0;
        int n2 = this.OEAB.length;
        while (n != n2 && byArray == null) {
            block5: {
                URL uRL = this.OEAB[n];
                if (this.Z[n]) {
                    byArray = jarCache_jdk11.getJarData(uRL.toString(), string);
                } else {
                    try {
                        URL uRL2 = new URL(uRL, string);
                        byArray = this.OEAB(uRL2);
                    }
                    catch (IOException iOException) {
                        if (!Debug.ex) break block5;
                        Debug.ex(iOException);
                    }
                }
            }
            ++n;
        }
        return byArray;
    }

    public URL getResource(String string) {
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            return uRL;
        }
        JarCache_jdk11 jarCache_jdk11 = JarCache_jdk11.instance;
        int n = 0;
        int n2 = this.OEAB.length;
        while (n != n2) {
            block11: {
                Object object;
                uRL = this.OEAB[n];
                if (this.Z[n]) {
                    object = uRL.toString();
                    if (null != jarCache_jdk11.getJarData((String)object, string)) {
                        try {
                            return new URL("jar:" + (String)object + "!/" + string);
                        }
                        catch (IOException iOException) {
                            if (Debug.ex) {
                                Debug.ex(iOException);
                            }
                            return null;
                        }
                    }
                } else {
                    try {
                        object = new URL(uRL, string);
                        if (null != this.OEAB((URL)object)) {
                            return object;
                        }
                    }
                    catch (IOException iOException) {
                        if (!Debug.ex) break block11;
                        Debug.ex(iOException);
                    }
                }
            }
            ++n;
        }
        return null;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = ClassLoader.getSystemResourceAsStream(string);
        if (inputStream != null) {
            return inputStream;
        }
        byte[] byArray = this.getResourceAsByteArray(string);
        if (byArray != null) {
            inputStream = new ByteArrayInputStream(byArray);
        }
        return inputStream;
    }

    private byte[] OEAB(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = null;
        try {
            inputStream = (InputStream)SecurityKit.doPrivileged(new BoxedCode(this, uRLConnection){
                private final URLConnection val$uc;
                private final URLClassLoader_jdk11 this$0;
                {
                    this.this$0 = uRLClassLoader_jdk11;
                    this.val$uc = uRLConnection;
                }

                public Object run() {
                    return URLClassLoader_jdk11.access$000(this.val$uc);
                }
            });
        }
        catch (ProxyException proxyException) {
            throw (IOException)proxyException.getTarget();
        }
        if (inputStream != null) {
            byte[] byArray;
            try {
                byArray = IOKit.readAll(inputStream);
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                inputStream.close();
                throw throwable;
            }
            inputStream.close();
            return byArray;
        }
        return null;
    }

    private static InputStream Z(URLConnection uRLConnection) {
        InputStream inputStream;
        try {
            HttpURLConnection httpURLConnection;
            int n;
            inputStream = uRLConnection.getInputStream();
            if (uRLConnection instanceof HttpURLConnection && (n = (httpURLConnection = (HttpURLConnection)uRLConnection).getResponseCode()) >= 400) {
                inputStream = null;
            }
        }
        catch (IOException iOException) {
            throw new ProxyException(iOException);
        }
        return inputStream;
    }

    URL getSecurityContext() {
        return this.OEAB.length != 0 ? this.OEAB[this.OEAB.length - 1] : null;
    }

    static InputStream access$000(URLConnection uRLConnection) {
        return URLClassLoader_jdk11.Z(uRLConnection);
    }
}

