/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.actionbrowser.AbstractActionTable;
import com.mathworks.mlwidgets.actionbrowser.HelpPopupLauncher;
import com.mathworks.mlwidgets.help.HelpPopup;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.mwswing.binding.ActionData;
import com.mathworks.mwswing.binding.DefaultKeyBindingSet;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.services.binding.MatlabKeyBindings;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.net.URL;
import java.util.List;
import javax.swing.JComponent;

public final class ActionBrowserUtils {
    public static String[] getKeywordArray(String string) {
        String string2;
        String[] stringArray = string.matches("^\".*\"$") ? ((string2 = string.substring(1, string.length() - 1)).matches(".*\\p{Punct}+.*") ? new String[]{string2, string2.replaceAll("\\p{Punct}", " ")} : new String[]{string2}) : (string.matches(".*\\p{Punct}+.*") ? new String[]{string, string.replaceAll("\\p{Punct}", " ")} : string.toLowerCase().split(" "));
        return stringArray;
    }

    public static String hiliteKeyword(String string, String string2) {
        String[] stringArray;
        if (string == null || string2 == null || string2.length() < 2) {
            return string;
        }
        for (String string3 : stringArray = ActionBrowserUtils.getKeywordArray(string2)) {
            if (string3.trim().length() < 2) continue;
            String string4 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
            String string5 = string2.toUpperCase();
            string = string.replaceAll(string5, "<FONT style='BACKGROUND-COLOR: #99FFFF'>" + string5 + "</FONT>");
            string = string.replaceAll(string3, "<FONT style='BACKGROUND-COLOR: #99FFFF'>" + string3 + "</FONT>");
            string = string.replaceAll(string4, "<FONT style='BACKGROUND-COLOR: #99FFFF'>" + string4 + "</FONT>");
        }
        return string;
    }

    public static void showHelpOnSelection(String string, Rectangle rectangle, AbstractActionTable abstractActionTable, HelpPopupLauncher helpPopupLauncher) {
        Rectangle rectangle2 = ActionBrowserUtils.getHelpPopupBounds(rectangle);
        if (abstractActionTable != null) {
            abstractActionTable.hideActionToolTip();
        }
        if (helpPopupLauncher == null || helpPopupLauncher.getParentComponent() == null) {
            HelpPopup.showHelp((JComponent)MatlabDesktopServices.getDesktop().getMainFrame().getRootPane(), ActionBrowserUtils.getHOSAccel(), rectangle2, string);
        } else {
            HelpPopup.showHelp(helpPopupLauncher.getParentComponent(), ActionBrowserUtils.getHOSAccel(), rectangle2, string);
        }
    }

    public static void showHelpOnSelection(URL uRL, Rectangle rectangle, AbstractActionTable abstractActionTable, HelpPopupLauncher helpPopupLauncher) {
        Rectangle rectangle2 = ActionBrowserUtils.getHelpPopupBounds(rectangle);
        if (abstractActionTable != null) {
            abstractActionTable.hideActionToolTip();
        }
        if (helpPopupLauncher == null || helpPopupLauncher.getParentComponent() == null) {
            HelpPopup.showHelp((JComponent)MatlabDesktopServices.getDesktop().getMainFrame().getRootPane(), ActionBrowserUtils.getHOSAccel(), rectangle2, uRL);
        } else {
            HelpPopup.showHelp(helpPopupLauncher.getParentComponent(), ActionBrowserUtils.getHOSAccel(), rectangle2, uRL);
        }
    }

    private static KeyStrokeList getHOSAccel() {
        ActionData actionData = MatlabKeyBindings.getManager().getActionData("help-on-selection");
        List list = DefaultKeyBindingSet.EMACS.getActionGlobalKeyBindings(actionData);
        if (!list.isEmpty()) {
            return (KeyStrokeList)list.get(0);
        }
        return null;
    }

    private static Rectangle getHelpPopupBounds(Rectangle rectangle) {
        Dimension dimension = new Dimension(520, 380);
        Rectangle rectangle2 = ActionBrowserUtils.getVirtualScreenBounds();
        Rectangle rectangle3 = new Rectangle(rectangle.x, rectangle.y - dimension.height, dimension.width, dimension.height);
        if (rectangle3.y < rectangle2.y) {
            rectangle3.y = rectangle.y + rectangle.height;
        }
        if (rectangle3.x + rectangle3.width > rectangle2.x + rectangle2.width) {
            rectangle3.x = rectangle2.x + rectangle2.width - rectangle3.width;
        }
        return rectangle3;
    }

    static Rectangle getVirtualScreenBounds() {
        Rectangle rectangle = WindowUtils.getVirtualScreenBounds();
        Rectangle rectangle2 = WindowUtils.getScreenBounds();
        return new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle2.height < rectangle.height ? rectangle2.height : rectangle.height);
    }

    static String correctUrlForFileDriveLetter(String string) {
        if (string != null && string.matches("^[a-zA-Z]:(.*)$")) {
            return "file:///" + string;
        }
        return string;
    }

    public static String correctUrlForFileProtocol(String string) {
        if ((string = ActionBrowserUtils.correctUrlForFileDriveLetter(string)) != null && string.matches("^//?[a-zA-Z](.*)$")) {
            return "file:///" + string;
        }
        return string;
    }
}

