/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.actionbrowser;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

class MouseDirectionFinder {
    private Point fLastMousePos = null;
    private long fTime = 0L;
    private static int TIMING_INTERVAL = 100;

    MouseDirectionFinder() {
    }

    boolean isInTooltipCone(int n, Component component, Dimension dimension) {
        Point point = MouseInfo.getPointerInfo().getLocation();
        if (point.equals(this.fLastMousePos)) {
            return true;
        }
        Rectangle rectangle = SwingUtilities.getWindowAncestor(component).getBounds();
        if (rectangle == null || this.fLastMousePos == null) {
            return false;
        }
        double d = n == 4 ? (double)(rectangle.x + rectangle.width - this.fLastMousePos.x) : (double)(-rectangle.x + this.fLastMousePos.x);
        double d2 = dimension.getHeight();
        double d3 = -dimension.getHeight();
        double d4 = d != 0.0 ? d2 / d : 0.0;
        double d5 = d != 0.0 ? d3 / d : 0.0;
        double d6 = n == 4 ? (double)(point.x - this.fLastMousePos.x) : (double)(-point.x + this.fLastMousePos.x);
        double d7 = -(point.y - this.fLastMousePos.y);
        double d8 = d6 != 0.0 ? d7 / d6 : 0.0;
        return Math.abs(d7) < 0.5 || d6 >= 1.0 && d8 < d4 && d8 > d5;
    }

    void update() {
        long l = System.currentTimeMillis();
        if (l - this.fTime < (long)TIMING_INTERVAL) {
            return;
        }
        this.fLastMousePos = MouseInfo.getPointerInfo().getLocation();
        this.fTime = System.currentTimeMillis();
    }
}

