/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.MatlabMCR;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.AbstractValueEditorProvider;
import com.mathworks.mlwidgets.array.ArrayPanel;
import com.mathworks.mlwidgets.array.ArrayTable;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.ExtractVariableAction;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mlwidgets.array.ISortProvider;
import com.mathworks.mlwidgets.array.ITableController;
import com.mathworks.mlwidgets.array.ITransposeProvider;
import com.mathworks.mlwidgets.array.MatlabArrayTableModel;
import com.mathworks.mlwidgets.array.brushing.IBrushableInfoProvider;
import com.mathworks.mlwidgets.graphics.IPlotPickerDisplayTrigger;
import com.mathworks.mlwidgets.graphics.PlotPickerOpener;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import com.mathworks.widgets.spreadsheet.AbstractSpreadsheetTable;
import com.mathworks.widgets.spreadsheet.IClipboardOpProvider;
import com.mathworks.widgets.spreadsheet.IRegionOpProvider;
import com.mathworks.widgets.spreadsheet.ISelectionOpProvider;
import com.mathworks.widgets.spreadsheet.ISpreadsheetSelectionController;
import com.mathworks.widgets.spreadsheet.IUndoOpProvider;
import com.mathworks.widgets.spreadsheet.RangeSelectionModel;
import com.mathworks.widgets.spreadsheet.format.FormattableDisplay;
import java.awt.Color;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionListener;

public final class ArrayEditorProvider
extends AbstractValueEditorProvider
implements IGraphableInfoProvider,
VariableIdentifierProvider,
ISpreadsheetSelectionController,
IRegionOpProvider,
ISelectionOpProvider,
IBrushableInfoProvider,
IPlotPickerDisplayTrigger,
ITransposeProvider,
ISortProvider,
INewVariableProvider {
    private ArrayPanel fPanel = null;
    private ArrayTable fTable = null;
    private MatlabArrayTableModel fModel = null;

    private ArrayEditorProvider(MatlabArrayTableModel matlabArrayTableModel, ArrayTable arrayTable, ArrayPanel arrayPanel) {
        super((JComponent)((Object)arrayPanel), arrayTable, (IClipboardOpProvider)arrayTable, (IUndoOpProvider)arrayTable, (FormattableDisplay)arrayTable, arrayTable, arrayTable);
        this.fModel = matlabArrayTableModel;
        this.fTable = arrayTable;
        this.fPanel = arrayPanel;
    }

    public static ArrayEditorProvider createProvider(WorkspaceVariable workspaceVariable) {
        MatlabArrayTableModel matlabArrayTableModel = new MatlabArrayTableModel(workspaceVariable);
        ArrayTable arrayTable = new ArrayTable(matlabArrayTableModel);
        arrayTable.setName("VariableTable");
        ArrayPanel arrayPanel = new ArrayPanel(arrayTable);
        arrayPanel.setName("ArrayPanel");
        ArrayEditorProvider arrayEditorProvider = new ArrayEditorProvider(matlabArrayTableModel, arrayTable, arrayPanel);
        arrayTable.setProvider(arrayEditorProvider);
        return arrayEditorProvider;
    }

    @Override
    public void rename(String string) {
        this.fModel.rename(string);
        this.fTable.rename(string);
    }

    @Override
    public void cleanup() {
        this.fPanel.cleanup();
        this.fTable.cleanup();
        this.fModel.cleanup();
        this.fPanel = null;
        this.fTable = null;
        this.fModel = null;
    }

    @Override
    public void setUseMinimalMenus(boolean bl) {
        this.fTable.setUseMinimalMenus(bl);
    }

    @Override
    public void setOpenActionListener(ActionListener actionListener) {
    }

    @Override
    public void addPlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fTable.addPlotPickerOpener(plotPickerOpener);
    }

    @Override
    public void removePlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fTable.removePlotPickerOpener(plotPickerOpener);
    }

    @Override
    public Action getPlotPickerAction() {
        return this.fTable.getPlotPickerAction();
    }

    @Override
    public Action getBrushModeAction() {
        return this.fTable.getBrushModeAction();
    }

    @Override
    public void addBrushingActions(MJMenu mJMenu) {
        this.fTable.addBrushingActions(mJMenu);
    }

    @Override
    public void setBrushMode(boolean bl, Color color) {
        this.fTable.setBrushMode(bl, color);
    }

    @Override
    public String[] getGraphableNames() {
        return this.fTable.getGraphableNames();
    }

    @Override
    public String[] getGraphableSizes() {
        return this.fTable.getGraphableSizes();
    }

    @Override
    public String[] getGraphableClasses() {
        return this.fTable.getGraphableClasses();
    }

    @Override
    public Action getMorePlotsAction() {
        return this.fTable.getMorePlotsAction();
    }

    @Override
    public void addGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fTable.addGraphableSelectionListener(listSelectionListener);
    }

    @Override
    public void removeGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fTable.removeGraphableSelectionListener(listSelectionListener);
    }

    public VariableIdentifier getVariableIdentifier() {
        return this.fTable.getVariableIdentifier();
    }

    public void addVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fTable.addVariableIdentifierListener(listSelectionListener);
    }

    public void removeVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fTable.removeVariableIdentifierListener(listSelectionListener);
    }

    public Action getInsertAction() {
        return this.fTable.getInsertAction();
    }

    public Action getDeleteAction() {
        return this.fTable.getDeleteAction();
    }

    public Action getInsertAction(IRegionOpProvider.Scope scope, int n) {
        return this.fTable.getInsertAction(scope, n);
    }

    public Action getDeleteAction(IRegionOpProvider.Scope scope, int n) {
        return this.fTable.getDeleteAction(scope, n);
    }

    public Action getClearContentsAction() {
        return this.fTable.getClearContentsAction();
    }

    public Action getSelectAllAction() {
        return this.fTable.getSelectAllAction();
    }

    public RangeSelectionModel getSpreadsheetRowSelectionModel() {
        return this.fTable.getSpreadsheetRowSelectionModel();
    }

    public RangeSelectionModel getSpreadsheetColumnSelectionModel() {
        return this.fTable.getSpreadsheetColumnSelectionModel();
    }

    MatlabArrayTableModel getTableModel() {
        return this.fModel;
    }

    @Override
    public void transposeVariable() {
        this.fModel.transpose();
    }

    @Override
    public void sortRows(ITableController.SortDirection sortDirection) {
        int[] nArray = this.fTable.getSelectedColumns();
        if (nArray.length > 0) {
            int[] nArray2 = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                nArray2[i] = nArray[i] + 1;
            }
            this.fModel.sortRows(nArray2, sortDirection);
        }
    }

    @Override
    public boolean isSortEnabledForSelection() {
        return this.fTable.isSortEnabledForSelection();
    }

    public List<IRegionOpProvider.Scope> getScopeSupportedForSelection() {
        ArrayList<IRegionOpProvider.Scope> arrayList = new ArrayList<IRegionOpProvider.Scope>();
        if (this.fTable.areOnlyEntireColumnsSelected()) {
            arrayList.add(IRegionOpProvider.Scope.COLUMNS);
        } else if (this.fTable.areOnlyEntireRowsSelected()) {
            arrayList.add(IRegionOpProvider.Scope.ROWS);
        } else {
            arrayList.add(IRegionOpProvider.Scope.ROWS);
            arrayList.add(IRegionOpProvider.Scope.COLUMNS);
            arrayList.add(IRegionOpProvider.Scope.CELLS);
        }
        return arrayList;
    }

    @Override
    public String getCreationLabel() {
        return null;
    }

    @Override
    public MJAbstractAction[] getCreationActions() {
        WorkspaceCommandsVarCreator workspaceCommandsVarCreator = new WorkspaceCommandsVarCreator();
        MJAbstractAction[] mJAbstractActionArray = new MJAbstractAction[3];
        boolean bl = this.fModel.getMatlabDataType() == 4;
        mJAbstractActionArray[0] = bl ? new CharArrayExtractAction(this, (AbstractSpreadsheetTable)this.fTable, workspaceCommandsVarCreator) : new ExtractVariableAction(this, ArrayUtils.getResource("dataset.newnumeric"), INewVariableProvider.CreationParams.ALL, (AbstractSpreadsheetTable)this.fTable, workspaceCommandsVarCreator);
        mJAbstractActionArray[1] = new ExtractVariableAction(this, ArrayUtils.getResource("variable.separateRow.label"), INewVariableProvider.CreationParams.ROWS, (AbstractSpreadsheetTable)this.fTable, workspaceCommandsVarCreator);
        mJAbstractActionArray[2] = new ExtractVariableAction(this, ArrayUtils.getResource("variable.separateColumn.label"), INewVariableProvider.CreationParams.COLUMNS, (AbstractSpreadsheetTable)this.fTable, workspaceCommandsVarCreator);
        return mJAbstractActionArray;
    }

    @Override
    public List<INewVariableProvider.CreationParams> getCreationParamsForSelection() {
        ArrayList<INewVariableProvider.CreationParams> arrayList = new ArrayList<INewVariableProvider.CreationParams>();
        arrayList.add(INewVariableProvider.CreationParams.ALL);
        if (this.fTable.getSelectedRowCount() > 1) {
            arrayList.add(INewVariableProvider.CreationParams.ROWS);
        }
        if (this.fTable.getSelectedColumnCount() > 1) {
            arrayList.add(INewVariableProvider.CreationParams.COLUMNS);
        }
        return arrayList;
    }

    private void setTableModel(MatlabArrayTableModel matlabArrayTableModel) {
        if (this.fModel != null) {
            this.fModel.cleanup();
        }
        this.fModel = matlabArrayTableModel;
    }

    private void setTable(ArrayTable arrayTable) {
        if (this.fTable != null) {
            this.fTable.cleanup();
        }
        this.fTable = arrayTable;
    }

    private static class WorkspaceCommandsVarCreator
    implements ExtractVariableAction.VariableCreatorInterface {
        private WorkspaceCommandsVarCreator() {
        }

        @Override
        public void createVariable(String string) {
            try {
                MatlabMCR.mtEval((String)string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private static class CharArrayExtractAction
    extends ExtractVariableAction {
        CharArrayExtractAction(VariableIdentifierProvider variableIdentifierProvider, AbstractSpreadsheetTable abstractSpreadsheetTable, ExtractVariableAction.VariableCreatorInterface variableCreatorInterface) {
            super(variableIdentifierProvider, ArrayUtils.getResource("variable.charArray.label"), INewVariableProvider.CreationParams.ALL, abstractSpreadsheetTable, variableCreatorInterface);
        }

        @Override
        protected void createVariablesOnMatlabThread(String string, String string2, List<int[]> list, List<int[]> list2) {
            Vector<String> vector = new Vector<String>();
            String string3 = CharArrayExtractAction.getFieldName(string);
            String string4 = string3 + CharArrayExtractAction.getUniqueVarNameSuffix(string3, vector);
            this.fVarCreator.createVariable(string4 + " = " + string + ";openvar " + string4);
        }
    }
}

