/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlwidgets.array.AbstractMatlabTable;
import com.mathworks.mlwidgets.array.ArrayEditorProvider;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.DatasetTable;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mlwidgets.array.ITableController;
import com.mathworks.mlwidgets.array.MatlabArrayTableModel;
import com.mathworks.mlwidgets.array.brushing.BrushingActionFactory;
import com.mathworks.mlwidgets.array.brushing.IBrushableInfoProvider;
import com.mathworks.mlwidgets.array.brushing.SpreadsheetTableBrushManager;
import com.mathworks.mlwidgets.graphics.IPlotPickerDisplayTrigger;
import com.mathworks.mlwidgets.graphics.PlotCatalog;
import com.mathworks.mlwidgets.graphics.PlotPickerOpener;
import com.mathworks.mlwidgets.workspace.graphics.GraphingActionFactory;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.mlwidgets.workspace.graphics.IGraphingActionListener;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import com.mathworks.widgets.spreadsheet.IDataBoundsSupplier;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class ArrayTable
extends AbstractMatlabTable
implements IGraphableInfoProvider,
VariableIdentifierProvider,
IBrushableInfoProvider,
IGraphingActionListener,
IPlotPickerDisplayTrigger {
    private MatlabArrayTableModel fMATModel;
    protected PlotCatalog fMorePlotsDlg = null;
    protected MJAbstractAction[] fGraphingActions = null;
    protected MJAbstractAction fCatalogAction;
    private List<ListSelectionListener> fGraphicListener = new Vector<ListSelectionListener>();
    private List<ListSelectionListener> fSimpleVariableListener = new Vector<ListSelectionListener>();
    private SpreadsheetTableBrushManager fBrushManager = null;
    private ListSelectionListener fLSL;
    private static final String[] ESA = new String[0];
    private MJAbstractAction fPlotPickerAction = null;
    private Collection<PlotPickerOpener> fPlotPickerOpeners = new ArrayList<PlotPickerOpener>();
    private MJMenu fSortMenu = null;
    private MJMenu fBrushMenu = null;
    private ArrayEditorProvider fProvider;
    private MJMenu fExtractMenu = null;
    private static boolean sDisableSaveOnFocusLoss = false;
    private boolean fBrushManagerAdded = false;

    public static boolean dsofl(boolean bl) {
        boolean bl2 = sDisableSaveOnFocusLoss;
        sDisableSaveOnFocusLoss = bl;
        return bl2;
    }

    public ArrayTable(MatlabArrayTableModel matlabArrayTableModel) {
        super(matlabArrayTableModel);
        TableCellRenderer tableCellRenderer;
        if (!sDisableSaveOnFocusLoss) {
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        }
        if ((tableCellRenderer = this.getDefaultRenderer(Object.class)) instanceof JComponent) {
            ((JComponent)((Object)tableCellRenderer)).putClientProperty("html.disable", Boolean.TRUE);
        }
        this.fMATModel = matlabArrayTableModel;
        this.createBrushMenu();
        this.fSelectionPopupMenu.add((Component)new JSeparator());
        MJMenuItem mJMenuItem = new MJMenuItem(ArrayUtils.getResource("transpose.Title"));
        mJMenuItem.setName("Transpose");
        mJMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ArrayTable.this.fMATModel.transpose();
            }
        });
        this.fSelectionPopupMenu.add((JMenuItem)mJMenuItem);
        this.fSortMenu = new MJMenu(ArrayUtils.getResource("sort.Title"));
        MJMenuItem mJMenuItem2 = new MJMenuItem(ArrayUtils.getResource("sort.Ascending"));
        MJMenuItem mJMenuItem3 = new MJMenuItem(ArrayUtils.getResource("sort.Descending"));
        this.fSortMenu.setName("Sort");
        mJMenuItem2.setName("Sort_Ascending");
        mJMenuItem3.setName("Sort_Descending");
        this.fSortMenu.add((JMenuItem)mJMenuItem2);
        this.fSortMenu.add((JMenuItem)mJMenuItem3);
        this.fSortMenu.setVisible(false);
        this.fSelectionPopupMenu.add((JMenuItem)this.fSortMenu);
        mJMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ArrayTable.this.restrictRowColumnSpecToValidRegion(ArrayTable.this.getColumnModel().getSelectedColumns(), 1);
                if (null != nArray) {
                    int n = 0;
                    while (n < nArray.length) {
                        int n2 = n++;
                        nArray[n2] = nArray[n2] + 1;
                    }
                }
                ArrayTable.this.fMATModel.sortRows(nArray, ITableController.SortDirection.ASCENDING);
            }
        });
        mJMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = ArrayTable.this.restrictRowColumnSpecToValidRegion(ArrayTable.this.getColumnModel().getSelectedColumns(), 1);
                if (null != nArray) {
                    int n = 0;
                    while (n < nArray.length) {
                        int n2 = n++;
                        nArray[n2] = nArray[n2] + 1;
                    }
                }
                ArrayTable.this.fMATModel.sortRows(nArray, ITableController.SortDirection.DESCENDING);
            }
        });
        this.fCatalogAction = new MorePlotsAction();
        this.fPlotPickerAction = new MJAbstractAction(ArrayUtils.getResource("menu.picker")){

            public void actionPerformed(ActionEvent actionEvent) {
                ArrayTable.this.firePlotPickerRequested();
            }
        };
        this.refreshObjectSpecificPopup();
        this.fLSL = new SelListener();
        this.getSelectionModel().addListSelectionListener(this.fLSL);
        this.getColumnModel().getSelectionModel().addListSelectionListener(this.fLSL);
        this.updateBrushMenu();
        GraphingActionFactory.addGraphingActionListener(this);
    }

    public void setProvider(ArrayEditorProvider arrayEditorProvider) {
        this.fProvider = arrayEditorProvider;
    }

    private void createBrushMenu() {
        if (this.fBrushMenu == null) {
            this.fBrushMenu = new MJMenu(ArrayUtils.getResource("menu.brushing"));
            this.fBrushMenu.setName("Brushing");
            this.fSelectionPopupMenu.add((JMenuItem)this.fBrushMenu);
        }
    }

    private void removeBrushMenu() {
        if (this.fBrushMenu != null) {
            this.fBrushMenu.removeAll();
            this.fSelectionPopupMenu.remove((Component)this.fBrushMenu);
            this.fBrushMenu = null;
            this.fBrushManagerAdded = false;
        }
    }

    private void updateBrushMenu() {
        if (this.fBrushManager == null) {
            this.fBrushManager = new SpreadsheetTableBrushManager(this.getVariableName(), this);
        }
        if (!this.fBrushManagerAdded) {
            this.fBrushMenu.add(this.fBrushManager.getBrushModeAction());
            this.addBrushingActions(this.fBrushMenu);
            this.fBrushManagerAdded = true;
        }
    }

    private void addExtractMenu(MJPopupMenu mJPopupMenu, MJAbstractAction[] mJAbstractActionArray) {
        this.removeExtractMenu();
        this.fExtractMenu = new MJMenu(ArrayUtils.getResource("Action.create-variable-from-selection.Label"));
        this.fExtractMenu.add((Action)mJAbstractActionArray[INewVariableProvider.CreationParams.ALL.ordinal()]);
        if (this.getSelectedRowCount() > 1) {
            this.fExtractMenu.add((Action)mJAbstractActionArray[INewVariableProvider.CreationParams.ROWS.ordinal()]);
        }
        if (this.getSelectedColumnCount() > 1) {
            this.fExtractMenu.add((Action)mJAbstractActionArray[INewVariableProvider.CreationParams.COLUMNS.ordinal()]);
        }
        mJPopupMenu.add((JMenuItem)this.fExtractMenu);
    }

    private void removeExtractMenu() {
        if (this.fExtractMenu != null) {
            this.fExtractMenu.removeAll();
            this.fSelectionPopupMenu.remove((Component)this.fExtractMenu);
        }
    }

    public void setDefaultRenderer(Class<?> clazz, TableCellRenderer tableCellRenderer) {
        if (tableCellRenderer instanceof JComponent) {
            ((JComponent)((Object)tableCellRenderer)).putClientProperty("html.disable", Boolean.TRUE);
        }
        super.setDefaultRenderer(clazz, tableCellRenderer);
    }

    public void rename(String string) {
        if (this.fBrushManager != null) {
            this.fBrushManager.clearBrushMode();
            this.fBrushManager.rename(string);
        }
        if (this.fBrushMenu != null) {
            this.fBrushMenu.removeAll();
            this.fBrushMenu.add(this.getBrushModeAction());
            BrushingActionFactory.addBrushingActions(this.fBrushMenu, string);
        }
    }

    @Override
    public void addBrushingActions(MJMenu mJMenu) {
        BrushingActionFactory.addBrushingActions(mJMenu, this.getVariableName());
    }

    @Override
    public Action getBrushModeAction() {
        return this.fBrushManager.getBrushModeAction();
    }

    @Override
    public void setBrushMode(boolean bl, Color color) {
        if (bl) {
            this.fBrushManager.setBrushMode(color);
        } else {
            this.fBrushManager.clearBrushMode();
        }
    }

    private void firePlotPickerRequested() {
        for (PlotPickerOpener plotPickerOpener : this.fPlotPickerOpeners) {
            plotPickerOpener.openPlotPicker();
        }
    }

    @Override
    public void addPlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fPlotPickerOpeners.add(plotPickerOpener);
    }

    @Override
    public void removePlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fPlotPickerOpeners.remove(plotPickerOpener);
    }

    @Override
    public Action getPlotPickerAction() {
        return this.fPlotPickerAction;
    }

    public void refreshObjectSpecificPopup() {
        if (this.fSelectionPopupMenu == null) {
            return;
        }
        if (this.getCellEditor() != null) {
            this.getCellEditor().cancelCellEditing();
        }
        this.fSortMenu.setVisible(this.isSortEnabledForSelection(this.getColumnModel()));
        if (this.useMinimalMenus()) {
            this.removeExtractMenu();
            this.removeBrushMenu();
        } else {
            if (this.fProvider != null) {
                this.addExtractMenu(this.fSelectionPopupMenu, this.fProvider.getCreationActions());
            }
            this.createBrushMenu();
            this.updateBrushMenu();
        }
    }

    @Override
    public String[] getGraphableNames() {
        String[] stringArray = ESA;
        if (this.useMinimalMenus()) {
            return stringArray;
        }
        String string = this.getSelectionNameString();
        if (string != null) {
            stringArray = new String[]{string};
        }
        return stringArray;
    }

    @Override
    public void graphingActionsChanged() {
        for (ListSelectionListener listSelectionListener : this.fGraphicListener) {
            listSelectionListener.valueChanged(new ListSelectionEvent(this, 0, this.getRowCount() - 1, false));
        }
    }

    @Override
    public String[] getGraphableSizes() {
        String[] stringArray = ESA;
        String string = this.getSelectionNameString();
        if (string != null) {
            stringArray = new String[]{this.getSelectionSizeString()};
        }
        return stringArray;
    }

    @Override
    public String[] getGraphableClasses() {
        String[] stringArray = ESA;
        String string = this.getSelectionNameString();
        if (string != null) {
            stringArray = new String[]{this.typeToString()};
        }
        return stringArray;
    }

    @Override
    public Action getMorePlotsAction() {
        return this.fCatalogAction;
    }

    @Override
    public void addGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fGraphicListener.add(listSelectionListener);
    }

    @Override
    public void removeGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fGraphicListener.remove(listSelectionListener);
    }

    public VariableIdentifier getVariableIdentifier() {
        String string = this.getSelectionNameString();
        return new VariableIdentifier(string, string, this.getVariable().getWorkspaceID());
    }

    public void addVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fSimpleVariableListener.add(listSelectionListener);
    }

    public void removeVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fSimpleVariableListener.remove(listSelectionListener);
    }

    private String getSelectionNameString() {
        String string = null;
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
        int[] nArray2 = this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1);
        if (nArray.length > 0 && nArray2.length > 0) {
            String string2;
            List list = DatasetTable.getSelectionIntervals((int[])nArray);
            List list2 = DatasetTable.getSelectionIntervals((int[])nArray2);
            TableModel tableModel = this.getModel();
            int n = -1;
            int n2 = -1;
            if (tableModel instanceof IDataBoundsSupplier) {
                n = ((IDataBoundsSupplier)tableModel).getLastDataRow() + 1;
                n2 = ((IDataBoundsSupplier)tableModel).getLastDataColumn() + 1;
            }
            string = (string2 = ArrayUtils.getSelectionString(list, n, list2, n2)).isEmpty() ? this.getVariableName() : this.getVariableName() + '(' + string2 + ')';
        }
        return string;
    }

    private String getSelectionSizeString() {
        String string = "0x0";
        int[] nArray = this.restrictRowColumnSpecToValidRegion(this.getSelectedRows(), 0);
        int[] nArray2 = this.restrictRowColumnSpecToValidRegion(this.getSelectedColumns(), 1);
        if (nArray.length > 0 && nArray2.length > 0) {
            string = nArray[nArray.length - 1] - nArray[0] + 1 + "x" + (nArray2[nArray2.length - 1] - nArray2[0] + 1);
        }
        return string;
    }

    public void cleanup() {
        if (this.fBrushManager != null) {
            this.fBrushManager.cleanup();
        }
        this.fBrushManager = null;
        if (this.fExtractMenu != null) {
            this.fExtractMenu.removeAll();
        }
        this.fSortMenu.removeAll();
        this.fSelectionPopupMenu.removeAll();
        this.getSelectionModel().removeListSelectionListener(this.fLSL);
        this.getColumnModel().getSelectionModel().removeListSelectionListener(this.fLSL);
        this.fLSL = null;
        GraphingActionFactory.removeGraphingActionListener(this);
        BrushingActionFactory.removeBrushingActions(this.getVariableName());
        this.fGraphicListener = null;
        this.fSimpleVariableListener = null;
        this.fCatalogAction = null;
        this.fPlotPickerOpeners.clear();
        super.cleanup();
    }

    protected boolean isCellNumeric(int n, int n2) {
        boolean bl = false;
        switch (this.fMATModel.getMatlabDataType()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                bl = true;
            }
        }
        return bl;
    }

    String typeToString() {
        return ArrayTable.typeToString(this.fMATModel.getMatlabDataType());
    }

    private static String typeToString(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "unknown";
                break;
            }
            case 1: {
                string = "cell";
                break;
            }
            case 2: {
                string = "struct";
                break;
            }
            case 3: {
                string = "logical";
                break;
            }
            case 4: {
                string = "char";
                break;
            }
            case 6: {
                string = "double";
                break;
            }
            case 7: {
                string = "single";
                break;
            }
            case 8: {
                string = "int8";
                break;
            }
            case 9: {
                string = "uint8";
                break;
            }
            case 10: {
                string = "int16";
                break;
            }
            case 11: {
                string = "uint16";
                break;
            }
            case 12: {
                string = "int32";
                break;
            }
            case 13: {
                string = "uint32";
                break;
            }
            case 14: {
                string = "int64";
                break;
            }
            case 15: {
                string = "uint64";
                break;
            }
            case 16: {
                string = "function_handle";
                break;
            }
            case 17: {
                string = "opaque";
                break;
            }
            case 18: {
                string = "unknown";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string;
    }

    protected void doRegionCopy(ActionEvent actionEvent) {
        this.populateClipboardFromIdentifier(this.getVariableIdentifier());
    }

    private class MorePlotsAction
    extends ArrayUtils.BaseAction {
        MorePlotsAction() {
            super("show-plot-catalog", "show-plot-catalog");
            ArrayTable.this.registerWithMapsUsingKeyBindingManager(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ArrayTable.this.fMorePlotsDlg == null) {
                ArrayTable.this.fMorePlotsDlg = PlotCatalog.getInstance();
            }
            String[] stringArray = ESA;
            String string = ArrayTable.this.getSelectionNameString();
            if (string != null) {
                stringArray = new String[]{string};
            }
            ArrayTable.this.fMorePlotsDlg.setPlottedVars(stringArray);
            ArrayTable.this.fMorePlotsDlg.show();
        }
    }

    private class SelListener
    implements ListSelectionListener {
        private SelListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                String[] stringArray = ArrayTable.this.getGraphableNames();
                ArrayTable.this.refreshObjectSpecificPopup();
                if (ArrayTable.this.fGraphicListener != null) {
                    for (ListSelectionListener listSelectionListener : ArrayTable.this.fGraphicListener) {
                        listSelectionListener.valueChanged(listSelectionEvent);
                    }
                }
                if (ArrayTable.this.fSimpleVariableListener != null) {
                    for (ListSelectionListener listSelectionListener : ArrayTable.this.fSimpleVariableListener) {
                        listSelectionListener.valueChanged(listSelectionEvent);
                    }
                }
                if (ArrayTable.this.fExtractMenu != null) {
                    ArrayTable.this.fExtractMenu.setEnabled(stringArray != null && stringArray.length > 0);
                }
            }
        }
    }
}

