/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLExecuteServices;
import com.mathworks.mlwidgets.array.ArrayDialog;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.InvertableRunnable;
import com.mathworks.mlwidgets.array.UndoableEditFromRunnables;
import com.mathworks.mlwidgets.array.UndoerCompletionObserver;
import com.mathworks.mlwidgets.array.ValueUpdateRegistry;
import com.mathworks.mlwidgets.array.WorkspaceUndoManager;
import com.mathworks.mlwidgets.workspace.WorkspaceMCRProvider;
import com.mathworks.mwswing.MJOptionPane;
import javax.swing.event.UndoableEditEvent;

public class MatlabEvalDoer
implements InvertableRunnable {
    private String iVarName;
    private String iCodeGenCmd;
    private WorkspaceUndoManager.UndoKey iKey;
    private WorkspaceUndoManager iUndoManager;
    private boolean iViaMatlab = false;
    private boolean iViaCommandLine = true;

    public MatlabEvalDoer(String string, String string2, boolean bl, boolean bl2, WorkspaceUndoManager workspaceUndoManager, WorkspaceUndoManager.UndoKey undoKey) {
        this.iVarName = string;
        this.iCodeGenCmd = string2;
        this.iKey = undoKey;
        this.iUndoManager = workspaceUndoManager;
        this.iViaMatlab = bl;
        this.iViaCommandLine = bl2;
    }

    @Override
    public void run() {
        if (this.iUndoManager != null) {
            this.iUndoManager.receiveNextUndoableEdit();
        }
        MatlabWorker<String> matlabWorker = new MatlabWorker<String>(){

            public String runOnMatlabThread() {
                try {
                    Matlab.mtEval((String)WorkspaceUndoManager.UndoKey.getStorageString(MatlabEvalDoer.this.iKey, MatlabEvalDoer.this.iVarName));
                    String string = null;
                    if (MatlabEvalDoer.this.iViaMatlab) {
                        Object object = Matlab.mtFeval((String)"eval", (Object[])new Object[]{MatlabEvalDoer.this.iCodeGenCmd}, (int)2);
                        if (object instanceof Object[]) {
                            Object[] objectArray = (Object[])object;
                            if (objectArray.length >= 2 && objectArray[1] != null && objectArray[1] instanceof String && ((String)objectArray[1]).length() > 0) {
                                MJOptionPane.showMessageDialog(null, (Object)objectArray[1], (String)ArrayUtils.getResource("alert.Title"), (int)2);
                            }
                            if (objectArray.length >= 1 && objectArray[0] != null && objectArray[0] instanceof String) {
                                string = (String)objectArray[0];
                            }
                        }
                    } else if (!MatlabEvalDoer.this.iViaCommandLine) {
                        Matlab.mtFeval((String)"eval", (Object[])new Object[]{MatlabEvalDoer.this.iCodeGenCmd}, (int)0);
                        this.fireWorkspaceEvent();
                    } else {
                        MLExecuteServices.executeCommand((String)MatlabEvalDoer.this.iCodeGenCmd);
                        this.fireWorkspaceEvent();
                    }
                    return string;
                }
                catch (Exception exception) {
                    MatlabEvalDoer.this.iUndoManager.doNotReceiveUndoableEdits();
                    ArrayDialog.showErrorDialog(exception.getMessage());
                    ValueUpdateRegistry.refreshClients();
                    return null;
                }
            }

            public void runOnAWTEventDispatchThread(String string) {
                if (string == null) {
                    return;
                }
                MLExecuteServices.executeCommand((String)string);
                this.fireWorkspaceEvent();
            }

            private void fireWorkspaceEvent() {
                Matlab.whenMatlabIdle((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ValueUpdateRegistry.refreshClients();
                            UndoableEditFromRunnables undoableEditFromRunnables = new UndoableEditFromRunnables(MatlabEvalDoer.this.getInverse());
                            UndoableEditEvent undoableEditEvent = new UndoableEditEvent(this, undoableEditFromRunnables);
                            MatlabEvalDoer.this.iUndoManager.undoableEditHappened(undoableEditEvent);
                        }
                        catch (Exception exception) {
                            MatlabEvalDoer.this.iUndoManager.doNotReceiveUndoableEdits();
                        }
                    }
                });
            }
        };
        matlabWorker.start();
    }

    @Override
    public InvertableRunnable getInverse() {
        return new MatlabEvalUndoer(this.iVarName, this.iCodeGenCmd, this.iViaMatlab, this.iViaCommandLine, this.iUndoManager, this.iKey);
    }

    private static class MatlabEvalUndoer
    implements InvertableRunnable {
        private String iVarName;
        private String iCodeGenCmd;
        private WorkspaceUndoManager.UndoKey iKey;
        private WorkspaceUndoManager iUndoManager;
        private boolean iViaMatlab = false;
        private boolean iViaCommandLine = true;

        MatlabEvalUndoer(String string, String string2, boolean bl, boolean bl2, WorkspaceUndoManager workspaceUndoManager, WorkspaceUndoManager.UndoKey undoKey) {
            this.iVarName = string;
            this.iCodeGenCmd = string2;
            this.iKey = undoKey;
            this.iUndoManager = workspaceUndoManager;
            this.iViaMatlab = bl;
            this.iViaCommandLine = bl2;
        }

        @Override
        public void run() {
            if (this.iUndoManager != null) {
                this.iUndoManager.receiveNextUndoableEdit();
            }
            WorkspaceMCRProvider.getMCRForUserActions().eval(WorkspaceUndoManager.UndoKey.getRetrieveAndClearValueString(this.iKey, this.iVarName), (CompletionObserver)new UndoerCompletionObserver(this.iUndoManager));
        }

        @Override
        public InvertableRunnable getInverse() {
            return new MatlabEvalDoer(this.iVarName, this.iCodeGenCmd, this.iViaMatlab, this.iViaCommandLine, this.iUndoManager, this.iKey);
        }
    }
}

