/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.AbstractValueEditorProvider;
import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.DatasetTable;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mlwidgets.array.ISortProvider;
import com.mathworks.mlwidgets.array.ITableController;
import com.mathworks.mlwidgets.array.TabularObjectPanel;
import com.mathworks.mlwidgets.array.TabularObjectTableModel;
import com.mathworks.mlwidgets.graphics.IPlotPickerDisplayTrigger;
import com.mathworks.mlwidgets.graphics.PlotPickerOpener;
import com.mathworks.mlwidgets.workspace.graphics.IGraphableInfoProvider;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import com.mathworks.widgets.spreadsheet.IClipboardOpProvider;
import com.mathworks.widgets.spreadsheet.IRegionOpProvider;
import com.mathworks.widgets.spreadsheet.ISelectionOpProvider;
import com.mathworks.widgets.spreadsheet.ISpreadsheetSelectionController;
import com.mathworks.widgets.spreadsheet.IUndoOpProvider;
import com.mathworks.widgets.spreadsheet.RangeSelectionModel;
import com.mathworks.widgets.spreadsheet.SpreadsheetUtils;
import com.mathworks.widgets.spreadsheet.format.FormattableDisplay;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionListener;

public final class TabularObjectEditorProvider
extends AbstractValueEditorProvider
implements IGraphableInfoProvider,
VariableIdentifierProvider,
IRegionOpProvider,
ISelectionOpProvider,
IPlotPickerDisplayTrigger,
INewVariableProvider,
ISpreadsheetSelectionController,
ISortProvider {
    private TabularObjectPanel fPanel = null;
    private DatasetTable fTable = null;
    private TabularObjectTableModel fModel = null;
    private RangeSelectionModel fColSelectionModel;

    private TabularObjectEditorProvider(TabularObjectTableModel tabularObjectTableModel, DatasetTable datasetTable, TabularObjectPanel tabularObjectPanel) {
        super((JComponent)((Object)tabularObjectPanel), datasetTable, (IClipboardOpProvider)datasetTable, (IUndoOpProvider)datasetTable, (FormattableDisplay)datasetTable, datasetTable, datasetTable);
        this.fModel = tabularObjectTableModel;
        this.fTable = datasetTable;
        this.fPanel = tabularObjectPanel;
    }

    @Override
    public void setOpenActionListener(ActionListener actionListener) {
    }

    @Override
    public void setUseMinimalMenus(boolean bl) {
        this.fTable.setUseMinimalMenus(bl);
    }

    public static TabularObjectEditorProvider createProvider(WorkspaceVariable workspaceVariable) {
        TabularObjectTableModel tabularObjectTableModel = new TabularObjectTableModel(workspaceVariable);
        DatasetTable datasetTable = new DatasetTable(tabularObjectTableModel);
        TabularObjectPanel tabularObjectPanel = new TabularObjectPanel(datasetTable);
        tabularObjectPanel.setName("ArrayPanel");
        return new TabularObjectEditorProvider(tabularObjectTableModel, datasetTable, tabularObjectPanel);
    }

    private static TabularObjectEditorProvider createProvider(WorkspaceVariable workspaceVariable, DatasetTable datasetTable, TabularObjectPanel tabularObjectPanel) {
        TabularObjectTableModel tabularObjectTableModel = new TabularObjectTableModel(workspaceVariable);
        tabularObjectPanel.setName("ArrayPanel");
        return new TabularObjectEditorProvider(tabularObjectTableModel, datasetTable, tabularObjectPanel);
    }

    @Override
    public void rename(String string) {
        this.fModel.rename(string);
    }

    @Override
    public void updateData() {
        super.updateData();
        this.fPanel.refreshRowHeader();
    }

    @Override
    public void cleanup() {
        this.fPanel.cleanup();
        this.fTable.cleanup();
        this.fModel.cleanup();
        this.fPanel = null;
        this.fTable = null;
        this.fModel = null;
    }

    @Override
    public void addPlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fTable.addPlotPickerOpener(plotPickerOpener);
    }

    @Override
    public void removePlotPickerOpener(PlotPickerOpener plotPickerOpener) {
        this.fTable.removePlotPickerOpener(plotPickerOpener);
    }

    @Override
    public Action getPlotPickerAction() {
        return this.fTable.getPlotPickerAction();
    }

    @Override
    public String[] getGraphableNames() {
        return this.fTable.getGraphableNames();
    }

    @Override
    public String[] getGraphableSizes() {
        return this.fTable.getGraphableSizes();
    }

    @Override
    public String[] getGraphableClasses() {
        return this.fTable.getGraphableClasses();
    }

    @Override
    public Action getMorePlotsAction() {
        return this.fTable.getMorePlotsAction();
    }

    @Override
    public void addGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fTable.addGraphableSelectionListener(listSelectionListener);
    }

    @Override
    public void removeGraphableSelectionListener(ListSelectionListener listSelectionListener) {
        this.fTable.removeGraphableSelectionListener(listSelectionListener);
    }

    public VariableIdentifier getVariableIdentifier() {
        return this.fTable.getVariableIdentifier();
    }

    public void addVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fTable.addVariableIdentifierListener(listSelectionListener);
    }

    public void removeVariableIdentifierListener(ListSelectionListener listSelectionListener) {
        this.fTable.removeVariableIdentifierListener(listSelectionListener);
    }

    public Action getInsertAction() {
        return this.fTable.getInsertAction();
    }

    public Action getInsertAction(IRegionOpProvider.Scope scope, int n) {
        return this.fTable.getInsertAction(scope, n);
    }

    public Action getDeleteAction() {
        return this.fTable.getDeleteAction();
    }

    public Action getDeleteAction(IRegionOpProvider.Scope scope, int n) {
        return this.fTable.getDeleteAction(scope, n);
    }

    public Action getClearContentsAction() {
        return this.fTable.getClearContentsAction();
    }

    public Action getSelectAllAction() {
        return this.fTable.getSelectAllAction();
    }

    public List<IRegionOpProvider.Scope> getScopeSupportedForSelection() {
        return this.fTable.getScopeSupportedForSelection();
    }

    @Override
    public String getCreationLabel() {
        return ArrayUtils.getResource("dataset.new.label");
    }

    @Override
    public MJAbstractAction[] getCreationActions() {
        return this.fTable.getCreationActions();
    }

    @Override
    public List<INewVariableProvider.CreationParams> getCreationParamsForSelection() {
        ArrayList<INewVariableProvider.CreationParams> arrayList = new ArrayList<INewVariableProvider.CreationParams>();
        return arrayList;
    }

    public RangeSelectionModel getSpreadsheetRowSelectionModel() {
        return this.fTable.getSpreadsheetRowSelectionModel();
    }

    public RangeSelectionModel getSpreadsheetColumnSelectionModel() {
        if (this.fColSelectionModel == null) {
            RangeSelectionModel rangeSelectionModel = this.fTable.getSpreadsheetColumnSelectionModel();
            this.fColSelectionModel = new ColumnSelectionModelProxy(rangeSelectionModel);
        }
        return this.fColSelectionModel;
    }

    @Override
    public void sortRows(ITableController.SortDirection sortDirection) {
        if (sortDirection == ITableController.SortDirection.ASCENDING) {
            this.fTable.sortAscending();
        } else {
            this.fTable.sortDescending();
        }
    }

    @Override
    public boolean isSortEnabledForSelection() {
        return this.fTable.isAllDatasetRowsSelected() && this.fTable.isSortEnabled();
    }

    private class ColumnSelectionModelProxy
    implements RangeSelectionModel {
        private final RangeSelectionModel fColSelModelFromTable;

        ColumnSelectionModelProxy(RangeSelectionModel rangeSelectionModel) {
            this.fColSelModelFromTable = rangeSelectionModel;
        }

        public String getSelectionRangeString() {
            int[] nArray = TabularObjectEditorProvider.this.fTable.getSelectedIndices();
            List list = SpreadsheetUtils.getSelectionIntervals((int[])nArray);
            return SpreadsheetUtils.getSelectionString((List)list, (int)-1);
        }

        public int getSelectionUpperLimit() {
            return this.fColSelModelFromTable.getSelectionUpperLimit();
        }

        public void addSelectionRangeListener(ChangeListener changeListener) {
            this.fColSelModelFromTable.addSelectionRangeListener(changeListener);
        }

        public void removeSelectionRangeListener(ChangeListener changeListener) {
            this.fColSelModelFromTable.removeSelectionRangeListener(changeListener);
        }

        public void setSelectionIntervals(List<int[]> list) {
            ArrayList<int[]> arrayList = new ArrayList<int[]>(list.size());
            for (int[] nArray : list) {
                arrayList.add(TabularObjectEditorProvider.this.fTable.getSelectionIntervalToSet(nArray[0], nArray[1]));
            }
            this.fColSelModelFromTable.setSelectionIntervals(arrayList);
        }
    }
}

