/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.mlservices.WorkspaceVariable;
import com.mathworks.mlwidgets.array.AggregatedComponents;
import com.mathworks.mlwidgets.array.MatlabArrayDTMenuBar;
import com.mathworks.mlwidgets.array.ValueEditorProvider;
import com.mathworks.mlwidgets.array.ValueEditorProviderRegistry;
import com.mathworks.mlwidgets.array.ValueMetaInfo;
import com.mathworks.mlwidgets.array.ValueMetaInfoRequester;
import com.mathworks.mlwidgets.array.ValueSummaryBar;
import com.mathworks.mlwidgets.array.VariableToolBar;
import com.mathworks.mlwidgets.array.VariableToolFactory;
import com.mathworks.mlwidgets.workspace.WorkspaceCommands;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.widgets.spreadsheet.SpreadsheetToolBar;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.FormattableDisplay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ValuePanel
extends MJPanel
implements FormattableDisplay {
    private AggregatedComponents fAggregatedComponents;
    private JComponent fDesiredFocusOwner;
    private MatlabArrayDTMenuBar fMenuBar;
    private VariableToolBar fToolBar;
    private TSToolSet fUnpopulatedToolSet;
    private TSToolSet fToolSet;
    private TSToolSet fViewToolSet;
    private ValueSummaryBar fSummaryBar;
    private boolean fMotionOnEnter;
    private int fMotionOnEnterDirection;
    private boolean fEditable;
    private boolean fEditableParents = true;
    private WorkspaceVariable fWorkspaceVariable;
    private boolean fCleanupInitiated = false;
    private ValueMetaInfoRequester fMetaInfoRequester;
    private FormatIdentifier fFormat = FormatIdentifier.SHORT;
    private ActionListener fMenuBarActionListener;
    private ActionListener fToolBarActionListener;
    private ToolSetUpdateListener fToolSetUpdateListener;
    private ActionListener fOpenActionListener;
    private boolean fUseMinimalMenus = false;
    private int fStopEditingCount = 0;

    public ValuePanel(WorkspaceVariable workspaceVariable) {
        this(workspaceVariable, true);
    }

    public ValuePanel(WorkspaceVariable workspaceVariable, boolean bl) {
        this.fWorkspaceVariable = workspaceVariable;
        this.setLayout(new BorderLayout());
        this.fSummaryBar = new ValueSummaryBar(workspaceVariable);
        this.fSummaryBar.update();
        this.add((Component)((Object)this.fSummaryBar), "North");
        UpdateListener updateListener = new UpdateListener();
        if (Matlab.isMatlabAvailable()) {
            this.fMetaInfoRequester = new ValueMetaInfoRequester(workspaceVariable, updateListener);
        } else {
            updateListener.actionPerformed(new ActionEvent(ValueMetaInfo.getNonExistentInstance(), 0, "create"));
        }
        this.setEditable(bl);
    }

    public void setUseMinimalMenus(boolean bl) {
        this.fUseMinimalMenus = bl;
        this.updateUseMinimalMenus();
    }

    private void updateUseMinimalMenus() {
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.getProvider().setUseMinimalMenus(this.fUseMinimalMenus);
        }
    }

    public void setSummaryBarGlassPane(JComponent jComponent) {
        this.fSummaryBar.setGlassPane(jComponent);
    }

    public void requestFocus() {
        super.requestFocus();
        this.requestFocusInWindow();
    }

    public void rename(WorkspaceVariable workspaceVariable) {
        this.fWorkspaceVariable = workspaceVariable;
        if (this.fMetaInfoRequester != null) {
            this.fMetaInfoRequester.cleanup();
        }
        UpdateListener updateListener = new UpdateListener();
        if (Matlab.isMatlabAvailable()) {
            this.fMetaInfoRequester = new ValueMetaInfoRequester(this.fWorkspaceVariable, updateListener);
        } else {
            updateListener.actionPerformed(new ActionEvent(ValueMetaInfo.getNonExistentInstance(), 0, "rename"));
        }
        this.fSummaryBar.setWorkspaceVariable(this.fWorkspaceVariable);
        ValueEditorProviderRegistry.renameValueEditorProvider(this.fWorkspaceVariable.getWorkspaceVariableNameTemp(), this.fAggregatedComponents.getProvider());
    }

    public void updateValueInformation() {
        this.fMetaInfoRequester.updateValueInformation();
    }

    public boolean requestFocusInWindow() {
        boolean bl = super.requestFocusInWindow();
        if (bl && this.fDesiredFocusOwner != null) {
            bl = this.fDesiredFocusOwner.requestFocusInWindow();
        }
        return bl;
    }

    public MatlabArrayDTMenuBar getMenuBar() {
        return this.fMenuBar;
    }

    public void addMenuBarActionListener(ActionListener actionListener) {
        this.fMenuBarActionListener = actionListener;
        if (this.fMenuBar != null) {
            this.fMenuBar.addActionListener(actionListener);
        }
    }

    public void removeMenuBarActionListener(ActionListener actionListener) {
        this.fMenuBarActionListener = null;
        if (this.fMenuBar != null) {
            this.fMenuBar.removeActionListener(actionListener);
        }
    }

    public SpreadsheetToolBar getToolBar() {
        return this.fToolBar;
    }

    public void addToolBarActionListener(ActionListener actionListener) {
        this.fToolBarActionListener = actionListener;
        if (this.fToolBar != null) {
            this.fToolBar.addActionListener(actionListener);
        }
    }

    public void removeToolBarActionListener(ActionListener actionListener) {
        this.fToolBarActionListener = null;
        if (this.fToolBar != null) {
            this.fToolBar.removeActionListener(actionListener);
        }
    }

    public void setToolSet(TSToolSet tSToolSet, TSToolSet tSToolSet2, ToolSetUpdateListener toolSetUpdateListener) {
        this.fToolSet = tSToolSet;
        this.fViewToolSet = tSToolSet2;
        this.fToolSetUpdateListener = toolSetUpdateListener;
    }

    public TSToolSet getToolSet() {
        return this.fToolSet;
    }

    public TSToolSet getViewToolSet() {
        return this.fViewToolSet;
    }

    private void setMenuBar(MatlabArrayDTMenuBar matlabArrayDTMenuBar) {
        if (this.fMenuBar != null) {
            this.fMenuBar.removeActionListener(this.fMenuBarActionListener);
        }
        if (matlabArrayDTMenuBar != null) {
            matlabArrayDTMenuBar.addActionListener(this.fMenuBarActionListener);
        }
        this.fMenuBar = matlabArrayDTMenuBar;
        if (this.fMenuBar != null) {
            this.fMenuBar.fireMenuBarChangedEvent();
        }
    }

    private void setToolBar(VariableToolBar variableToolBar) {
        if (this.fToolBar != null) {
            this.fToolBar.removeActionListener(this.fToolBarActionListener);
        }
        if (variableToolBar != null) {
            variableToolBar.addActionListener(this.fToolBarActionListener);
        }
        this.fToolBar = variableToolBar;
        if (this.fToolBar != null) {
            this.fToolBar.fireToolBarChangedEvent();
        }
    }

    public void setOpenActionHandler(ActionListener actionListener) {
        this.fOpenActionListener = actionListener;
        this.updateOpenActionListener();
    }

    private void updateOpenActionListener() {
        if (this.fAggregatedComponents != null && this.fAggregatedComponents.getProvider() != null) {
            this.fAggregatedComponents.getProvider().setOpenActionListener(this.fOpenActionListener);
        }
    }

    private void refreshData(AggregatedComponents aggregatedComponents) {
        if (aggregatedComponents != null) {
            aggregatedComponents.getProvider().updateData();
            this.updateReadOnlyStatus();
        }
    }

    private void updateReadOnlyStatus() {
        WorkspaceCommands.isParentIdentifierHierarchyReadOnly(this.fWorkspaceVariable, WorkspaceCommands.getParentIdentifierHierarchy(this.fWorkspaceVariable.getVariableName()), new ROML());
    }

    private void setHasROParent(boolean bl) {
        this.fEditableParents = !bl;
        this.setEditable(this.isEditable());
    }

    private void setAggregatedComponents(AggregatedComponents aggregatedComponents) {
        this.fAggregatedComponents = aggregatedComponents;
        this.updateUseMinimalMenus();
    }

    private void useOrRefreshViewer(AggregatedComponents aggregatedComponents) {
        AggregatedComponents aggregatedComponents2 = this.fAggregatedComponents;
        this.setAggregatedComponents(aggregatedComponents);
        if (this.fSummaryBar != null) {
            this.fSummaryBar.update();
        }
        if (!aggregatedComponents.equals(aggregatedComponents2)) {
            ContentsReplacer contentsReplacer = new ContentsReplacer(aggregatedComponents, aggregatedComponents2);
            if (SwingUtilities.isEventDispatchThread()) {
                contentsReplacer.run();
            } else {
                SwingUtilities.invokeLater(contentsReplacer);
            }
        } else {
            this.refreshData(aggregatedComponents);
        }
    }

    private AggregatedComponents setupAGFromProvider(ValueEditorProvider valueEditorProvider, ValueEditorProvider valueEditorProvider2) {
        if (valueEditorProvider2 != null && valueEditorProvider2.equals(valueEditorProvider)) {
            return this.fAggregatedComponents;
        }
        AggregatedComponents aggregatedComponents = new AggregatedComponents(valueEditorProvider, this, this.fWorkspaceVariable);
        aggregatedComponents.setFont(this.getFont());
        aggregatedComponents.setForeground(this.getForeground());
        aggregatedComponents.setBackground(this.getBackground());
        aggregatedComponents.setMotionOnEnterDirection(this.getMotionOnEnterDirection());
        aggregatedComponents.setMotionOnEnter(this.isMotionOnEnter());
        aggregatedComponents.setEditable(this.fEditable && this.fEditableParents);
        aggregatedComponents.setFormat(this.fFormat);
        this.setMenuBar(aggregatedComponents.getMenuBar());
        this.setToolBar(aggregatedComponents.getToolBar());
        if (Matlab.isMatlabAvailable()) {
            this.updateReadOnlyStatus();
        }
        if (this.fToolSet != null) {
            if (this.fUnpopulatedToolSet == null) {
                this.fUnpopulatedToolSet = new TSToolSet(this.fToolSet);
            } else {
                this.fToolSet = new TSToolSet(this.fUnpopulatedToolSet);
            }
            VariableToolFactory.getTools(this.fWorkspaceVariable.getWorkspaceVariableNameTemp(), valueEditorProvider, this.fToolSet, this.fViewToolSet);
            if (this.fToolSetUpdateListener != null) {
                this.fToolSetUpdateListener.toolsetUpdated(aggregatedComponents.getProvider());
            }
        }
        return aggregatedComponents;
    }

    private void setDesiredFocusOwner(JComponent jComponent, boolean bl) {
        this.fDesiredFocusOwner = jComponent;
        if (jComponent != null && bl) {
            jComponent.requestFocus();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setBackground(color);
        }
    }

    private static boolean anyChildHasFocus(Container container) {
        Component[] componentArray;
        if (container == null) {
            return false;
        }
        for (Component component : componentArray = container.getComponents()) {
            if (component.isFocusOwner()) {
                return true;
            }
            if (!(component instanceof Container) || !ValuePanel.anyChildHasFocus((Container)component)) continue;
            return true;
        }
        return false;
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setFont(font);
        }
    }

    public void setFormat(FormatIdentifier formatIdentifier) {
        this.fFormat = formatIdentifier;
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setFormat(formatIdentifier);
        }
    }

    public FormatIdentifier getFormat() {
        return this.fFormat;
    }

    public int getMotionOnEnterDirection() {
        return this.fMotionOnEnterDirection;
    }

    public void setMotionOnEnterDirection(int n) {
        this.fMotionOnEnterDirection = n;
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setMotionOnEnterDirection(n);
        }
    }

    public boolean isMotionOnEnter() {
        return this.fMotionOnEnter;
    }

    public void setMotionOnEnter(boolean bl) {
        this.fMotionOnEnter = bl;
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setMotionOnEnter(bl);
        }
    }

    public void setEditable(boolean bl) {
        this.fEditable = bl;
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.setEditable(bl && this.fEditableParents);
        }
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public void cleanup() {
        FocusListener[] focusListenerArray;
        this.fCleanupInitiated = true;
        if (this.fMetaInfoRequester != null) {
            this.fMetaInfoRequester.cleanup();
        }
        this.fMetaInfoRequester = null;
        this.removeAll();
        if (this.fMenuBar != null) {
            this.fMenuBar.removeActionListener(this.fMenuBarActionListener);
            this.fMenuBarActionListener = null;
            this.fMenuBar = null;
        }
        if (this.fSummaryBar != null) {
            this.fSummaryBar.cleanup();
            this.fSummaryBar = null;
        }
        if (this.fToolBar != null) {
            this.fToolBar.removeActionListener(this.fToolBarActionListener);
            this.fToolBarActionListener = null;
            this.fToolBar = null;
        }
        if (this.fAggregatedComponents != null) {
            this.fAggregatedComponents.stopEditing();
            this.fStopEditingCount = this.fAggregatedComponents.getStopEditingCount();
            this.fAggregatedComponents.cleanup();
        }
        this.setAggregatedComponents(null);
        for (FocusListener focusListener : focusListenerArray = this.getFocusListeners()) {
            this.removeFocusListener(focusListener);
        }
    }

    protected int getStopEditingCount() {
        return this.fStopEditingCount;
    }

    public boolean isCleanupInitiated() {
        return this.fCleanupInitiated;
    }

    private class ContentsReplacer
    implements Runnable {
        private AggregatedComponents iOldComponents;
        private AggregatedComponents iComponents;

        ContentsReplacer(AggregatedComponents aggregatedComponents, AggregatedComponents aggregatedComponents2) {
            this.iComponents = aggregatedComponents;
            this.iOldComponents = aggregatedComponents2;
        }

        @Override
        public void run() {
            if (this.iComponents != null) {
                boolean bl = ValuePanel.anyChildHasFocus(ValuePanel.this.fDesiredFocusOwner);
                Component component = ((BorderLayout)ValuePanel.this.getLayout()).getLayoutComponent("Center");
                if (component != null) {
                    ValuePanel.this.remove(component);
                }
                if (this.iOldComponents != null) {
                    this.iOldComponents.cleanup();
                }
                JComponent jComponent = this.iComponents.getProvider().getComponent();
                ValuePanel.this.add(jComponent, "Center");
                ValuePanel.this.validate();
                ValuePanel.this.setDesiredFocusOwner(jComponent, bl);
            }
        }
    }

    private class ROML
    implements MatlabListener {
        private ROML() {
        }

        public void matlabEvent(MatlabEvent matlabEvent) {
            if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) != 0) {
                ValuePanel.this.setHasROParent(false);
            } else {
                boolean[] blArray = (boolean[])matlabEvent.getResult();
                ValuePanel.this.setHasROParent(blArray[0]);
            }
        }
    }

    private class UpdateListener
    implements ActionListener {
        private UpdateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            ValueMetaInfo valueMetaInfo = (ValueMetaInfo)object;
            ValueEditorProvider valueEditorProvider = ValuePanel.this.fAggregatedComponents == null ? null : ValuePanel.this.fAggregatedComponents.getProvider();
            ValuePanel.this.useOrRefreshViewer(ValuePanel.this.setupAGFromProvider(ValueEditorProviderRegistry.getValueEditorProvider(ValuePanel.this.fWorkspaceVariable, valueMetaInfo, valueEditorProvider), valueEditorProvider));
            ValuePanel.this.updateOpenActionListener();
        }
    }

    public static interface ToolSetUpdateListener {
        public void toolsetUpdated(ValueEditorProvider var1);
    }
}

