/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.array;

import com.mathworks.mlwidgets.array.ArrayUtils;
import com.mathworks.mlwidgets.array.INewVariableProvider;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSButton;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.components.popups.ListActionEvent;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.factory.TSToolSet;
import com.mathworks.widgets.datatransfer.VariableIdentifier;
import com.mathworks.widgets.datatransfer.VariableIdentifierProvider;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class VariableCreationSupplier
implements TSToolSet.ToolSupplier,
ActionListener,
PopupListener,
ListActionListener {
    private Object fActionProvider = null;
    private MJAbstractAction fExtractAction = null;
    private MJAbstractAction[] fCreationActions;
    private static final int QUICK_ACCESS_BAR_SIZE = 16;
    private static final int TOOLSTRIP_SIZE = 24;

    public VariableCreationSupplier(Object object) {
        this.fActionProvider = object;
    }

    public JComponent createTool(TSToolSet.ToolLocation toolLocation) {
        TSButton tSButton;
        if (this.fActionProvider instanceof INewVariableProvider) {
            this.fCreationActions = ((INewVariableProvider)this.fActionProvider).getCreationActions();
            String string = ((INewVariableProvider)this.fActionProvider).getCreationLabel();
            this.fExtractAction = this.fCreationActions[0];
            if (this.fCreationActions.length == 1) {
                tSButton = this.createButton(string, toolLocation);
            } else {
                TSDropDownButton tSDropDownButton = this.createDropdownButton(string, toolLocation);
                tSDropDownButton.setPopupListener((PopupListener)this);
                tSButton = tSDropDownButton;
            }
        } else if (this.fActionProvider instanceof VariableIdentifierProvider) {
            this.fExtractAction = new DefaultExtractVariableAction((VariableIdentifierProvider)this.fActionProvider);
            tSButton = this.createDropdownButton(toolLocation);
        } else {
            tSButton = this.createButton(ArrayUtils.getResource("variable.new.label"), toolLocation);
            tSButton.setEnabled(false);
        }
        tSButton.setToolTipText(ArrayUtils.getResource("Action.create-variable-from-selection.Tooltip"));
        return tSButton;
    }

    private TSDropDownButton createDropdownButton(TSToolSet.ToolLocation toolLocation) {
        return this.createDropdownButton(null, toolLocation);
    }

    private TSDropDownButton createDropdownButton(String string, TSToolSet.ToolLocation toolLocation) {
        TSSplitButton tSSplitButton = string == null ? new TSSplitButton(ArrayUtils.getResource("variable.new.label")) : new TSSplitButton(string);
        tSSplitButton.setIcon((Icon)this.getIcon(toolLocation));
        tSSplitButton.addActionListener((ActionListener)this);
        return tSSplitButton;
    }

    private ImageIcon getIcon(TSToolSet.ToolLocation toolLocation) {
        StringBuilder stringBuilder = new StringBuilder("/com/mathworks/common/icons/resources/new_ts_");
        stringBuilder.append(toolLocation == TSToolSet.ToolLocation.QUICK_ACCESS_BAR ? 16 : 24);
        stringBuilder.append(".png");
        return new ImageIcon(this.getClass().getResource(stringBuilder.toString()));
    }

    private TSButton createButton(String string, TSToolSet.ToolLocation toolLocation) {
        TSButton tSButton = new TSButton(string == null ? ArrayUtils.getResource("variable.new.label") : string);
        tSButton.setIcon((Icon)this.getIcon(toolLocation));
        tSButton.addActionListener((ActionListener)this);
        return tSButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.fExtractAction.actionPerformed(actionEvent);
    }

    public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
        List<INewVariableProvider.CreationParams> list = ((INewVariableProvider)this.fActionProvider).getCreationParamsForSelection();
        ListItem[] listItemArray = new ListItem[list.isEmpty() ? this.fCreationActions.length : list.size()];
        int n = 0;
        if (list.contains((Object)INewVariableProvider.CreationParams.ALL) || list.isEmpty()) {
            listItemArray[n++] = ListItem.newItem((String)this.fCreationActions[0].getName(), (String)this.fCreationActions[0].getName());
        }
        if (list.contains((Object)INewVariableProvider.CreationParams.ROWS) || list.isEmpty()) {
            listItemArray[n++] = ListItem.newItem((String)this.fCreationActions[1].getName(), (String)this.fCreationActions[1].getName());
        }
        if (list.contains((Object)INewVariableProvider.CreationParams.COLUMNS) || list.isEmpty()) {
            listItemArray[n] = ListItem.newItem((String)this.fCreationActions[2].getName(), (String)this.fCreationActions[2].getName());
        }
        PopupList popupList = new PopupList(listItemArray);
        popupList.setListStyle(ListStyle.TEXT_ONLY);
        popupList.addListActionListener((ListActionListener)this);
        popupCallback.show((JComponent)popupList);
    }

    public void listItemSelected(ListActionEvent listActionEvent) {
        ListItem listItem = listActionEvent.getListItem();
        for (MJAbstractAction mJAbstractAction : this.fCreationActions) {
            if (!mJAbstractAction.getName().equals(listItem.getName())) continue;
            mJAbstractAction.actionPerformed((ActionEvent)listActionEvent);
        }
    }

    private class DefaultExtractVariableAction
    extends ArrayUtils.ExtractAction {
        DefaultExtractVariableAction(final VariableIdentifierProvider variableIdentifierProvider) {
            super(new ArrayUtils.CreateVariableActionProvider(){

                @Override
                public VariableIdentifier getVariableIdentifier() {
                    return variableIdentifierProvider.getVariableIdentifier();
                }

                @Override
                public void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction) {
                }
            });
            variableIdentifierProvider.addVariableIdentifierListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (!listSelectionEvent.getValueIsAdjusting()) {
                        DefaultExtractVariableAction.this.updateEnabled(variableIdentifierProvider);
                    }
                }
            });
            this.updateEnabled(variableIdentifierProvider);
        }

        private void updateEnabled(VariableIdentifierProvider variableIdentifierProvider) {
            VariableIdentifier variableIdentifier = variableIdentifierProvider.getVariableIdentifier();
            String string = variableIdentifier.getVariable();
            if (string == null) {
                string = variableIdentifier.getExpression();
            }
            this.setEnabled(string != null);
        }
    }
}

