/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer;

import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DocumentIcon;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.matlab.api.explorer.SearchCriteria;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlservices.MatlabDesktopServices;
import com.mathworks.mlwidgets.cwd.CwdComponentSet;
import com.mathworks.mlwidgets.explorer.model.AbstractFileList;
import com.mathworks.mlwidgets.explorer.model.ExplorerExtensionRegistry;
import com.mathworks.mlwidgets.explorer.model.ExplorerPrefs;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.PathModel;
import com.mathworks.mlwidgets.explorer.model.navigation.InvalidLocationException;
import com.mathworks.mlwidgets.explorer.model.navigation.NavigationContext;
import com.mathworks.mlwidgets.explorer.model.table.FileSystemExpansionProvider;
import com.mathworks.mlwidgets.explorer.model.table.IconColumn;
import com.mathworks.mlwidgets.explorer.model.table.NameColumn;
import com.mathworks.mlwidgets.explorer.model.table.PathAffordance;
import com.mathworks.mlwidgets.explorer.util.PrefUtils;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJSlider;
import com.mathworks.mwswing.MJSpinner;
import com.mathworks.services.settings.SettingAdapter;
import com.mathworks.services.settings.SettingChangeEvent;
import com.mathworks.services.settings.SettingException;
import com.mathworks.services.settings.SettingLevel;
import com.mathworks.services.settings.SettingListener;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import com.mathworks.widgets.HyperlinkTextLabel;
import com.mathworks.widgets.desk.Desktop;
import com.mathworks.widgets.grouptable.Affordance;
import com.mathworks.widgets.grouptable.GroupingTable;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTableConfiguration;
import com.mathworks.widgets.grouptable.GroupingTableModel;
import com.mathworks.widgets.grouptable.GroupingTablePair;
import com.mathworks.widgets.grouptable.GroupingTableTransaction;
import com.mathworks.widgets.grouptable.NonRectangularCellRenderer;
import com.mathworks.widgets.grouptable.ToolTipSupport;
import com.mathworks.widgets.prefs.PrefsEditorPanelV1;
import com.mathworks.widgets.prefs.PrefsHelp;
import com.mathworks.widgets.prefs.PrefsNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ExplorerPrefsPanel
implements PrefsEditorPanelV1 {
    private final MJPanel fComponent = new MJPanel((LayoutManager)new GridBagLayout());
    private final HistoryPanel fHistoryPanel;
    private final RefreshPanel fRefreshPanel;
    private final PathAffordancePanel fPathAffordancePanel;
    private final HiddenFilesPanel fHiddenFilesPanel;
    private final CustomizePanel fCustomizePanel;
    private static final String CUSTOMIZATION_PANEL_KEY = "documents.cwd";
    private static final SampleFileSystem sFileSystem = new SampleFileSystem();
    private static final FileSystemEntry sSampleMFile = sFileSystem.addFile(ExplorerResources.getString("prefs.sample.mfile"), false);
    private static final FileSystemEntry sOnPathFolder = sFileSystem.addFile(ExplorerResources.getString("prefs.sample.onpath"), true);
    private static final FileSystemEntry sNotOnPathFolder = sFileSystem.addFile(ExplorerResources.getString("prefs.sample.notonpath"), true);
    public static final String I18N_NAME = ResourceBundle.getBundle("com.mathworks.mde.desk.resources.RES_Desktop").getString("title.CurrentDirectory");

    public ExplorerPrefsPanel(Dimension dimension) {
        this.fComponent.getAccessibleContext().setAccessibleName(ExplorerResources.getString("prefacc.PrefPanel"));
        this.fComponent.setName("CurrentDirectoryPrefsPanel");
        this.fComponent.setLayout((LayoutManager)new FormLayout("fill:d:grow", "3dlu, p, 3dlu, p, 3dlu, p, 3dlu, " + (PlatformInfo.isUnix() ? "p, 3dlu, " : "") + " p, 3dlu, p, 3dlu:grow"));
        this.fHistoryPanel = new HistoryPanel();
        this.fRefreshPanel = new RefreshPanel();
        this.fPathAffordancePanel = new PathAffordancePanel();
        this.fHiddenFilesPanel = new HiddenFilesPanel();
        this.fCustomizePanel = new CustomizePanel();
        MJButton mJButton = new MJButton(ExplorerResources.getString("prefs.button.restore"));
        mJButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExplorerPrefsPanel.this.fHistoryPanel.restoreDefaults();
                ExplorerPrefsPanel.this.fRefreshPanel.restoreDefaults();
                ExplorerPrefsPanel.this.fPathAffordancePanel.restoreDefaults();
                ExplorerPrefsPanel.this.fHiddenFilesPanel.restoreDefaults();
            }
        });
        JPanel jPanel = ButtonBarFactory.buildLeftAlignedBar((JButton)mJButton);
        CellConstraints cellConstraints = new CellConstraints();
        this.fComponent.add((Component)((Object)this.fHistoryPanel), (Object)cellConstraints.xy(1, 2));
        this.fComponent.add((Component)((Object)this.fRefreshPanel), (Object)cellConstraints.xy(1, 4));
        this.fComponent.add((Component)((Object)this.fPathAffordancePanel), (Object)cellConstraints.xy(1, 6));
        this.fComponent.add((Component)((Object)this.fCustomizePanel), (Object)cellConstraints.xy(1, 8));
        if (PlatformInfo.isUnix()) {
            this.fComponent.add((Component)((Object)this.fHiddenFilesPanel), (Object)cellConstraints.xy(1, 10));
        }
        this.fComponent.add((Component)jPanel, (Object)cellConstraints.xy(1, PlatformInfo.isUnix() ? 12 : 10));
        this.cancelChanges(null);
    }

    public void commitChanges(PrefsNode prefsNode) {
        this.fHistoryPanel.save();
        this.fRefreshPanel.save();
        this.fPathAffordancePanel.save();
        if (PlatformInfo.isUnix()) {
            this.fHiddenFilesPanel.save();
        }
    }

    public boolean validateChanges(PrefsNode prefsNode) {
        return true;
    }

    public void cancelChanges(PrefsNode prefsNode) {
        this.fHistoryPanel.load();
        this.fRefreshPanel.load();
        this.fPathAffordancePanel.load();
        if (PlatformInfo.isUnix()) {
            this.fHiddenFilesPanel.load();
        }
    }

    public boolean canDetectPendingEdits(PrefsNode prefsNode) {
        return false;
    }

    public boolean hasPendingEdits(PrefsNode prefsNode) {
        return true;
    }

    public JComponent getComponent(PrefsNode prefsNode) {
        return this.fComponent;
    }

    public PrefsHelp getHelp() {
        return new PrefsHelp(MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_currentdirectory_prefs");
    }

    public void doHelp() {
        PrefsHelp prefsHelp = this.getHelp();
        MLHelpServices.displayTopic((String)prefsHelp.getHelpMapPath(), (String)prefsHelp.getHelpTopicKey());
    }

    public void dispose() {
    }

    private static void dependOnCheckBox(final MJCheckBox mJCheckBox, final Component ... componentArray) {
        for (Component component : componentArray) {
            component.setEnabled(mJCheckBox.isSelected());
        }
        mJCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                for (Component component : componentArray) {
                    component.setEnabled(mJCheckBox.isSelected());
                }
            }
        });
    }

    private static JComponent indent(JComponent jComponent) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("12dlu, fill:d", "p"));
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)jComponent, (Object)cellConstraints.xy(2, 1));
        return mJPanel;
    }

    private static JComponent createIndentedPair(MJLabel mJLabel, JComponent jComponent) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new FormLayout("14dlu, fill:d, 3dlu, fill:d", "p"));
        CellConstraints cellConstraints = new CellConstraints();
        mJPanel.add((Component)mJLabel, (Object)cellConstraints.xy(2, 1));
        mJPanel.add((Component)jComponent, (Object)cellConstraints.xy(4, 1));
        return mJPanel;
    }

    private static class SampleFileSystem
    implements FileSystem {
        private final Map<FileLocation, FileSystemEntry> fEntries = new HashMap<FileLocation, FileSystemEntry>();

        SampleFileSystem() {
        }

        public FileSystemEntry addFile(String string, boolean bl) {
            FileLocation fileLocation = new FileLocation(string);
            FileSystemEntry fileSystemEntry = new FileSystemEntry((FileSystem)this, fileLocation, false, bl, 0L, 0L, 0L);
            this.fEntries.put(fileLocation, fileSystemEntry);
            return fileSystemEntry;
        }

        public FileSystemEntry getEntry(FileLocation fileLocation) throws IOException {
            if (fileLocation.equals((Object)FileLocation.ROOT)) {
                return new FileSystemEntry((FileSystem)this, fileLocation, false, true, 0L, 0L, 0L);
            }
            FileSystemEntry fileSystemEntry = this.fEntries.get(fileLocation);
            if (fileSystemEntry == null) {
                throw new IOException();
            }
            return fileSystemEntry;
        }

        public InputStream getInputStream(FileLocation fileLocation) throws IOException {
            return new ByteArrayInputStream(new byte[0]);
        }

        public boolean exists(FileLocation fileLocation) {
            return this.fEntries.containsKey(fileLocation);
        }

        public FileSystemEntry followShortcutOrLink(FileSystemEntry fileSystemEntry) throws IOException {
            return fileSystemEntry;
        }

        public FileList getList(FileLocation fileLocation) throws IOException {
            FileSystemEntry fileSystemEntry = this.fEntries.get(fileLocation);
            if (fileSystemEntry == null) {
                fileSystemEntry = new FileSystemEntry((FileSystem)this, fileLocation, false, true, 0L, 0L, 0L);
            }
            return new AbstractFileList(this, fileSystemEntry){

                public void readFilesAndFolders(AsyncReceiver<FileSystemEntry> asyncReceiver) throws IOException {
                    FileSystemEntry fileSystemEntry;
                    Iterator iterator = SampleFileSystem.this.fEntries.values().iterator();
                    while (iterator.hasNext() && asyncReceiver.receive((Object)(fileSystemEntry = (FileSystemEntry)iterator.next()))) {
                    }
                    asyncReceiver.finished();
                }
            };
        }

        public FileList search(FileLocation fileLocation, SearchCriteria searchCriteria, Predicate<FileSystemEntry> predicate) throws IOException {
            throw new UnsupportedOperationException();
        }

        public boolean isReadOnly(FileLocation fileLocation) {
            return true;
        }

        public FileSystemTransaction createTransaction() throws IOException {
            throw new UnsupportedOperationException();
        }

        public String encodeName(String string) {
            return string;
        }

        public String decodeName(String string) {
            return string;
        }
    }

    private static class PreviewPane
    extends MJPanel {
        private final GroupingTable<FileSystemEntry> iTable;
        private final PathAffordance iPathAffordance;
        private Boolean iToolTipVisible;

        PreviewPane() {
            NavigationContext navigationContext;
            try {
                navigationContext = new NavigationContext(sFileSystem, ExplorerExtensionRegistry.getInstance(), FileLocation.ROOT);
            }
            catch (InvalidLocationException invalidLocationException) {
                throw new IllegalStateException(invalidLocationException);
            }
            FileSystemExpansionProvider fileSystemExpansionProvider = new FileSystemExpansionProvider(navigationContext);
            PathModel pathModel = new PathModel(){

                @Override
                public boolean isActive() {
                    return true;
                }

                @Override
                public FileLocation getCurrentFolder() {
                    return FileLocation.ROOT;
                }

                @Override
                public boolean contains(FileLocation fileLocation, boolean bl) {
                    return this.getPath().contains(fileLocation);
                }

                @Override
                public List<FileLocation> getPath() {
                    return Arrays.asList(sSampleMFile.getLocation(), sOnPathFolder.getLocation());
                }

                @Override
                public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }

                @Override
                public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                }

                @Override
                public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
                }

                @Override
                public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
                }
            };
            this.iPathAffordance = new PathAffordance(pathModel, fileSystemExpansionProvider){

                @Override
                protected boolean shouldEverShowAffordance(Map<FileLocation, FileSystemEntry> map, FileSystemEntry fileSystemEntry) {
                    return true;
                }

                @Override
                protected String getSpecialToolTip(Map<FileLocation, FileSystemEntry> map, FileSystemEntry fileSystemEntry) {
                    return null;
                }
            };
            IconColumn iconColumn = new IconColumn(fileSystemExpansionProvider);
            NameColumn nameColumn = new NameColumn();
            List<GroupingTableColumn> list = Arrays.asList(new IconColumn(fileSystemExpansionProvider).getColumn(), new NameColumn().getColumn());
            List<GroupingTablePair> list2 = Arrays.asList(new GroupingTablePair(iconColumn.getColumn(), nameColumn.getColumn()));
            GroupingTableConfiguration groupingTableConfiguration = new GroupingTableConfiguration(list, list2);
            groupingTableConfiguration.addAffordance((Affordance)this.iPathAffordance);
            GroupingTableModel groupingTableModel = new GroupingTableModel(groupingTableConfiguration, null);
            this.iTable = new GroupingTable<FileSystemEntry>(groupingTableModel){

                public void paint(Graphics graphics) {
                    super.paint(graphics);
                    int n = 0;
                    for (int i = 0; i < PreviewPane.this.iTable.getRowCount(); ++i) {
                        boolean bl;
                        NonRectangularCellRenderer nonRectangularCellRenderer = (NonRectangularCellRenderer)PreviewPane.this.iTable.getCellRenderer(i, PreviewPane.this.iTable.getColumnCount() - 1);
                        int n2 = 0;
                        Rectangle rectangle = PreviewPane.this.iTable.getCellRect(0, PreviewPane.this.iTable.getColumnCount() - 1, true);
                        int n3 = (int)rectangle.getHeight() / 2;
                        for (boolean bl2 = false; n2 < PreviewPane.this.iTable.getWidth() && ((bl = nonRectangularCellRenderer.allowRightClickSelection(new Point(n2, n3))) || !bl2); bl2 |= bl, n2 += 5) {
                        }
                        n = Math.max(n, n2 + 20);
                    }
                    n = Math.min(n, PreviewPane.this.iTable.getWidth() - DocumentIcon.TOOLTIP.getIcon().getIconWidth() - 2);
                    if (PreviewPane.this.iToolTipVisible == null && PathAffordance.isToolTipEnabled() || PreviewPane.this.iToolTipVisible != null && PreviewPane.this.iToolTipVisible.booleanValue()) {
                        DocumentIcon.TOOLTIP.getIcon().paintIcon((Component)((Object)this), graphics, n, 2);
                    }
                }
            };
            ToolTipSupport.uninstall(this.iTable);
            this.iTable.setEnabled(false);
            GroupingTableTransaction groupingTableTransaction = new GroupingTableTransaction();
            groupingTableTransaction.add(GroupingTableTransaction.Type.ADD, (Object)sNotOnPathFolder);
            groupingTableTransaction.add(GroupingTableTransaction.Type.ADD, (Object)sOnPathFolder);
            groupingTableTransaction.add(GroupingTableTransaction.Type.ADD, (Object)sSampleMFile);
            this.iTable.getGroupingModel().change(groupingTableTransaction);
            this.setLayout(new BorderLayout());
            this.add((Component)this.iTable, "Center");
            PrefUtils.manageFonts(this.iTable, I18N_NAME);
            PrefUtils.manageTextColor(this.iTable);
            PrefUtils.manageBackgroundColor(this.iTable);
        }

        public Dimension getPreferredSize() {
            return this.iTable.getPreferredSize();
        }

        public void setPercent(int n) {
            this.iPathAffordance.setPercent(n);
        }

        public void addNotify() {
            super.addNotify();
            this.revalidate();
            this.repaint();
        }

        public void setAffordanceVisible(boolean bl) {
            this.iTable.getConfiguration().removeAffordance((Affordance)this.iPathAffordance);
            if (bl) {
                this.iTable.getConfiguration().addAffordance((Affordance)this.iPathAffordance);
            }
        }

        public void setToolTipVisible(boolean bl) {
            this.iToolTipVisible = bl;
            this.revalidate();
            this.repaint();
        }
    }

    private static class PathAffordancePanel
    extends MJPanel {
        private final MJCheckBox iCheckBox;
        private final MJCheckBox iToolTipCheckBox;
        private final MJSlider iTransparencySlider;
        private final MJLabel iTransparencyLabel;
        private final PreviewPane iPreviewPane;

        PathAffordancePanel() {
            this.setBorder(new TitledBorder(ExplorerResources.getString("prefs.color.title")));
            this.iCheckBox = new MJCheckBox(ExplorerResources.getString("prefs.path.affordance"));
            this.iCheckBox.setName("currentfolder.path.affordance.ColorPicker");
            this.iPreviewPane = new PreviewPane(){

                @Override
                public Dimension getPreferredSize() {
                    if (PathAffordancePanel.this.iToolTipCheckBox == null) {
                        return super.getPreferredSize();
                    }
                    return new Dimension((int)Math.max(super.getPreferredSize().getWidth(), PathAffordancePanel.this.iToolTipCheckBox.getPreferredSize().getWidth()), (int)super.getPreferredSize().getHeight());
                }
            };
            this.iTransparencyLabel = new MJLabel(ExplorerResources.getString("prefs.path.affordance.transparency"));
            this.iTransparencySlider = new MJSlider(0, 90, 40){

                public Dimension getPreferredSize() {
                    if (PathAffordancePanel.this.iToolTipCheckBox == null) {
                        return super.getPreferredSize();
                    }
                    return new Dimension((int)Math.abs(PathAffordancePanel.this.iToolTipCheckBox.getPreferredSize().getWidth() - PathAffordancePanel.this.iTransparencyLabel.getPreferredSize().getWidth()) - 3, (int)super.getPreferredSize().getHeight());
                }
            };
            this.iTransparencySlider.setName("TransparencyField");
            this.iTransparencySlider.getAccessibleContext().setAccessibleName(ExplorerResources.getString("prefs.path.affordance.transparency"));
            this.iTransparencySlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    PathAffordancePanel.this.iPreviewPane.setPercent(PathAffordancePanel.this.iTransparencySlider.getValue());
                }
            });
            this.iToolTipCheckBox = new MJCheckBox(ExplorerResources.getString("prefs.path.affordance.tooltip"));
            this.iToolTipCheckBox.setSelected(PathAffordance.isToolTipEnabled());
            this.iToolTipCheckBox.setName("currentfolder.path.affordance.tooltip");
            this.iToolTipCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    PathAffordancePanel.this.iPreviewPane.setToolTipVisible(PathAffordancePanel.this.iCheckBox.isSelected() && PathAffordancePanel.this.iToolTipCheckBox.isSelected());
                }
            });
            this.setLayout((LayoutManager)new FormLayout("3dlu, fill:d, 3dlu", "3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu:grow"));
            CellConstraints cellConstraints = new CellConstraints();
            this.add((Component)this.iCheckBox, cellConstraints.xy(2, 2));
            this.add(ExplorerPrefsPanel.createIndentedPair(this.iTransparencyLabel, (JComponent)this.iTransparencySlider), cellConstraints.xy(2, 4));
            this.add(ExplorerPrefsPanel.indent((JComponent)this.iToolTipCheckBox), cellConstraints.xy(2, 6));
            this.add(ExplorerPrefsPanel.indent((JComponent)((Object)this.iPreviewPane)), cellConstraints.xy(2, 8));
            this.iCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    PathAffordancePanel.this.iTransparencySlider.setEnabled(PathAffordancePanel.this.iCheckBox.isSelected());
                    PathAffordancePanel.this.iToolTipCheckBox.setEnabled(PathAffordancePanel.this.iCheckBox.isSelected());
                    PathAffordancePanel.this.iTransparencyLabel.setEnabled(PathAffordancePanel.this.iCheckBox.isSelected());
                    PathAffordancePanel.this.iPreviewPane.setAffordanceVisible(PathAffordancePanel.this.iCheckBox.isSelected());
                    PathAffordancePanel.this.iPreviewPane.setToolTipVisible(PathAffordancePanel.this.iCheckBox.isSelected() && PathAffordancePanel.this.iToolTipCheckBox.isSelected());
                }
            });
        }

        void save() {
            try {
                ExplorerPrefs.PathAffordanceEnabled.set((Object)this.iCheckBox.isSelected());
                ExplorerPrefs.PathAffordanceTransparency.set((Object)this.iTransparencySlider.getValue());
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
            PathAffordance.setToolTipEnabled(this.iToolTipCheckBox.isSelected());
        }

        void load() {
            try {
                this.iCheckBox.setSelected(((Boolean)ExplorerPrefs.PathAffordanceEnabled.get()).booleanValue());
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
            this.iTransparencyLabel.setEnabled(this.iCheckBox.isSelected());
            this.iTransparencySlider.setEnabled(this.iCheckBox.isSelected());
            this.iToolTipCheckBox.setEnabled(this.iCheckBox.isSelected());
            try {
                this.iTransparencySlider.setValue(((Integer)ExplorerPrefs.PathAffordanceTransparency.get()).intValue());
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
            this.iPreviewPane.setAffordanceVisible(this.iCheckBox.isSelected());
            this.iPreviewPane.setToolTipVisible(this.iCheckBox.isSelected() && this.iToolTipCheckBox.isSelected());
            this.iToolTipCheckBox.setSelected(PathAffordance.isToolTipEnabled());
        }

        void restoreDefaults() {
            try {
                this.iCheckBox.setSelected(((Boolean)ExplorerPrefs.PathAffordanceEnabled.get(SettingLevel.FACTORY)).booleanValue());
                this.iTransparencySlider.setValue(((Integer)ExplorerPrefs.PathAffordanceTransparency.get(SettingLevel.FACTORY)).intValue());
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
            this.iToolTipCheckBox.setSelected(true);
        }
    }

    public static class CustomizePanel
    extends MJPanel {
        static final Desktop desk = MatlabDesktopServices.getDesktop();

        CustomizePanel() {
            this.setName("CustomizePanel");
            this.getAccessibleContext().setAccessibleName(ExplorerResources.getString("prefacc.CustomizePanel"));
            this.setBorder(BorderFactory.createTitledBorder(ExplorerResources.getString("prefs.customize.title")));
            HyperlinkTextLabel hyperlinkTextLabel = new HyperlinkTextLabel(ExplorerResources.getString("pref.customize.message"), new HyperlinkTextLabel.HyperlinkHandler(){

                public void processHyperlink(String string) {
                    desk.showToolBarCustomizationPanel(ExplorerPrefsPanel.CUSTOMIZATION_PANEL_KEY);
                }
            }, false, "CustomizePanel", ExplorerResources.getString("prefacc.CustomizePanel"));
            this.setLayout((LayoutManager)new FormLayout("3dlu, p:grow", "3dlu, p:grow, 3dlu"));
            CellConstraints cellConstraints = new CellConstraints();
            this.add(hyperlinkTextLabel.getComponent(), cellConstraints.xy(2, 2));
        }
    }

    private static class HiddenFilesPanel
    extends MJPanel {
        private final MJCheckBox iHiddenFilesCheck = new MJCheckBox(ExplorerResources.getString("prefs.hiddenfiles.check"));

        private HiddenFilesPanel() {
            this.iHiddenFilesCheck.setName("HiddenFilesCheck");
            this.iHiddenFilesCheck.getAccessibleContext().setAccessibleName(ExplorerResources.getString("prefs.hiddenfiles.check"));
            CellConstraints cellConstraints = new CellConstraints();
            this.setLayout((LayoutManager)new FormLayout("3dlu, fill:d, 3dlu:grow", "3dlu, p, 3dlu"));
            this.add((Component)this.iHiddenFilesCheck, cellConstraints.xy(2, 2));
            this.setBorder(BorderFactory.createTitledBorder(ExplorerResources.getString("prefs.hiddenfiles.title")));
        }

        void save() {
            try {
                ExplorerPrefs.ShowHiddenFiles.set((Object)this.iHiddenFilesCheck.isSelected());
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }

        void load() {
            try {
                this.iHiddenFilesCheck.setSelected(((Boolean)ExplorerPrefs.ShowHiddenFiles.get()).booleanValue());
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }

        void restoreDefaults() {
            try {
                this.iHiddenFilesCheck.setSelected(((Boolean)ExplorerPrefs.ShowHiddenFiles.get(SettingLevel.FACTORY)).booleanValue());
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }
    }

    private static class RefreshPanel
    extends MJPanel {
        private final MJCheckBox iAutoRefreshCheck;
        private final MJSpinner iRefreshIntervalField;

        private RefreshPanel() {
            this.setName("RefreshPanel");
            this.getAccessibleContext().setAccessibleName(ExplorerResources.getString("prefacc.RefreshPanel"));
            this.setBorder(BorderFactory.createTitledBorder(ExplorerResources.getString("prefs.autorefresh.title")));
            this.iAutoRefreshCheck = new MJCheckBox(ExplorerResources.getString("prefs.autorefresh.check"));
            this.iAutoRefreshCheck.setName("AutoRefreshCheck");
            this.iAutoRefreshCheck.getAccessibleContext().setAccessibleName(ExplorerResources.getString("prefs.autorefresh.check"));
            this.iRefreshIntervalField = new MJSpinner((SpinnerModel)new SpinnerNumberModel(3, 3, 120, 1));
            this.iRefreshIntervalField.setName("AutoRefreshIntervalField");
            this.iRefreshIntervalField.setDefaultEditorAccessibleName(ExplorerResources.getString("prefs.autorefresh.label"));
            this.setLayout((LayoutManager)new FormLayout("3dlu, fill:d, 3dlu:grow", "3dlu, p, 3dlu, p, 3dlu"));
            CellConstraints cellConstraints = new CellConstraints();
            MJLabel mJLabel = new MJLabel(ExplorerResources.getString("prefs.autorefresh.label"));
            this.add((Component)this.iAutoRefreshCheck, cellConstraints.xy(2, 2));
            this.add(ExplorerPrefsPanel.createIndentedPair(mJLabel, (JComponent)this.iRefreshIntervalField), cellConstraints.xy(2, 4));
            ExplorerPrefsPanel.dependOnCheckBox(this.iAutoRefreshCheck, new Component[]{mJLabel, this.iRefreshIntervalField});
        }

        void save() {
            try {
                ExplorerPrefs.AutoRefresh.set((Object)this.iAutoRefreshCheck.isSelected());
                ExplorerPrefs.AutoRefreshInterval.set((Object)((Integer)this.iRefreshIntervalField.getValue()));
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }

        void load() {
            try {
                this.iAutoRefreshCheck.setSelected(((Boolean)ExplorerPrefs.AutoRefresh.get()).booleanValue());
                this.iRefreshIntervalField.setValue(ExplorerPrefs.AutoRefreshInterval.get());
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }

        void restoreDefaults() {
            try {
                this.iAutoRefreshCheck.setSelected(((Boolean)ExplorerPrefs.AutoRefresh.get(SettingLevel.FACTORY)).booleanValue());
                this.iRefreshIntervalField.setValue(ExplorerPrefs.AutoRefreshInterval.get(SettingLevel.FACTORY));
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }
    }

    private static class HistoryPanel
    extends MJPanel {
        private MJSpinner iHistorySizeField;

        HistoryPanel() {
            this.setName("HistoryPanel");
            this.getAccessibleContext().setAccessibleName(ExplorerResources.getString("prefacc.HistoryPanel"));
            this.setBorder(BorderFactory.createTitledBorder(ExplorerResources.getString("prefs.history.title")));
            this.iHistorySizeField = new MJSpinner((SpinnerModel)new SpinnerNumberModel(10, 1, 100, 1));
            this.iHistorySizeField.setName("HistorySizeField");
            this.iHistorySizeField.setDefaultEditorAccessibleName(ExplorerResources.getString("prefs.history.label"));
            final MJButton mJButton = new MJButton(ExplorerResources.getString("prefs.history.clear"));
            mJButton.setName("HistoryClearButton");
            mJButton.getAccessibleContext().setAccessibleName(ExplorerResources.getString("prefs.history.clear"));
            mJButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    try {
                        ExplorerPrefs.History.set((Object)new String[0]);
                    }
                    catch (SettingException settingException) {
                        throw new RuntimeException(settingException);
                    }
                    CwdComponentSet.clearHistory();
                }
            });
            SettingAdapter settingAdapter = new SettingAdapter(){

                public void settingChanged(SettingChangeEvent settingChangeEvent) {
                    try {
                        String[] stringArray = (String[])ExplorerPrefs.History.get();
                        mJButton.setEnabled(stringArray.length != 0);
                    }
                    catch (SettingException settingException) {
                        throw new RuntimeException(settingException);
                    }
                }
            };
            try {
                ExplorerPrefs.History.addListener((SettingListener)settingAdapter);
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
            this.setLayout((LayoutManager)new FormLayout("3dlu, fill:d, 3dlu, fill:d, 3dlu:grow, fill:d, 3dlu", "3dlu, p, 3dlu"));
            CellConstraints cellConstraints = new CellConstraints();
            this.add((Component)new MJLabel(ExplorerResources.getString("prefs.history.label")), cellConstraints.xy(2, 2));
            this.add((Component)this.iHistorySizeField, cellConstraints.xy(4, 2));
            this.add((Component)mJButton, cellConstraints.xy(6, 2));
        }

        void save() {
            try {
                ExplorerPrefs.HistorySize.set((Object)((Integer)this.iHistorySizeField.getValue()));
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }

        void load() {
            try {
                this.iHistorySizeField.setValue(ExplorerPrefs.HistorySize.get());
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }

        void restoreDefaults() {
            try {
                this.iHistorySizeField.setValue(ExplorerPrefs.HistorySize.get(SettingLevel.FACTORY));
            }
            catch (SettingException settingException) {
                throw new RuntimeException(settingException);
            }
        }
    }
}

