/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.extensions.matlab;

import com.mathworks.jmi.Matlab;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mlwidgets.explorer.extensions.matlab.MATFileUtils;
import com.mathworks.mlwidgets.explorer.extensions.matlab.Variable;
import com.mathworks.mlwidgets.explorer.util.MLFileSystemUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.AsyncReceiver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class MATFileDetailPanelData {
    private FileSystemEntry fFile;
    private List<Variable> fVariables;
    private final List<ChangeListener> fListeners;

    MATFileDetailPanelData(FileSystemEntry fileSystemEntry) {
        this.fFile = fileSystemEntry;
        this.fVariables = new ArrayList<Variable>();
        this.fListeners = new ArrayList<ChangeListener>();
    }

    public Status startLoading() throws IOException {
        this.fVariables.clear();
        final Status status = new Status();
        Matlab.whenMatlabReady((Runnable)new Runnable(){

            @Override
            public void run() {
                if (status.isCancellationRequested()) {
                    status.markSuccessfullyCanceled();
                } else {
                    try {
                        final FileSystemEntry fileSystemEntry = MLFileSystemUtils.getMatlabAccessibleEntry(MATFileDetailPanelData.this.fFile);
                        File file = new File(fileSystemEntry.getLocation().toString());
                        MATFileUtils.read(file, new AsyncReceiver<Variable>(){

                            public boolean receive(Variable variable) {
                                MATFileDetailPanelData.this.addAndNotifyOnEDT(variable);
                                if (status.isCancellationRequested()) {
                                    status.markSuccessfullyCanceled();
                                    return false;
                                }
                                return true;
                            }

                            public void finished() {
                                MLFileSystemUtils.releaseMatlabAccessibleEntry(fileSystemEntry);
                                status.markCompleted();
                            }
                        });
                    }
                    catch (IOException iOException) {
                        status.markCompleted();
                    }
                }
            }
        });
        return status;
    }

    public List<Variable> getVariables() {
        assert (SwingUtilities.isEventDispatchThread());
        return new ArrayList<Variable>(this.fVariables);
    }

    public void addChangeListener(final ChangeListener changeListener) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MATFileDetailPanelData.this.fListeners.add(changeListener);
            }
        });
    }

    private void addAndNotifyOnEDT(final Variable variable) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MATFileDetailPanelData.this.fVariables.add(variable);
                for (ChangeListener changeListener : MATFileDetailPanelData.this.fListeners) {
                    changeListener.stateChanged(new ChangeEvent(variable));
                }
            }
        });
    }
}

