/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.model.realfs;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileList;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import java.util.concurrent.atomic.AtomicBoolean;

final class StatToEntryAdapter
extends AsyncReceiver<NativeJava.StatEntry> {
    private final AsyncReceiver<FileSystemEntry> fReceiver;
    private final AtomicBoolean fTerminator;
    private final FileLocation fParent;
    private final boolean fFoldersOnly;

    StatToEntryAdapter(FileLocation fileLocation, AtomicBoolean atomicBoolean, AsyncReceiver<FileSystemEntry> asyncReceiver) {
        this(false, fileLocation, atomicBoolean, asyncReceiver);
    }

    StatToEntryAdapter(boolean bl, FileLocation fileLocation, AtomicBoolean atomicBoolean, AsyncReceiver<FileSystemEntry> asyncReceiver) {
        this.fFoldersOnly = bl;
        this.fParent = fileLocation;
        this.fReceiver = asyncReceiver;
        this.fTerminator = atomicBoolean;
    }

    private static boolean isHidden(NativeJava.StatEntry statEntry) {
        return PlatformInfo.isWindows() && statEntry.isHidden() || PlatformInfo.isUnix() && statEntry.getName().startsWith(".");
    }

    private static boolean isMacResourceFork(NativeJava.StatEntry statEntry) {
        return PlatformInfo.isMacintosh() && statEntry.getName().startsWith("._");
    }

    public boolean receive(NativeJava.StatEntry statEntry) {
        return !this.fTerminator.get() && (!statEntry.s_isdir && this.fFoldersOnly || !RealFileList.shouldIncludeHiddenFiles() && StatToEntryAdapter.isHidden(statEntry) || StatToEntryAdapter.isMacResourceFork(statEntry) || this.fReceiver.receive((Object)new FileSystemEntry(RealFileSystem.getInstance(), new FileLocation(this.fParent, statEntry.getName()), statEntry, true)));
    }
}

