/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.util;

import com.mathworks.jmi.MLFileUtils;
import com.mathworks.jmi.MatlabLanguage;
import com.mathworks.matlab.api.explorer.FileList;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystem;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.matlab.api.explorer.FileSystemTransaction;
import com.mathworks.mlwidgets.explorer.model.ExplorerPrefs;
import com.mathworks.mlwidgets.explorer.model.ExplorerResources;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.model.vfs.VirtualFileSystem;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.mlwidgets.explorer.util.MLPathUtils;
import com.mathworks.mlwidgets.explorer.util.TransactionLogic;
import com.mathworks.mlwidgets.explorer.util.UiFileTransfer;
import com.mathworks.mlwidgets.explorer.util.UiFileTransferType;
import com.mathworks.mlwidgets.util.UIFileUtils;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.validation.Validity;
import com.mathworks.services.Prefs;
import com.mathworks.services.settings.SettingException;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.ThrowableClosure;
import com.mathworks.widgets.ValidityWithHelp;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class MLFileSystemUtils {
    private static final Object sTempFileLock = new Object();
    private static final List<FileLocation> sTempFiles = new ArrayList<FileLocation>();
    private static final Map<FileSystemEntry, FileLocation> sTempStubs = new HashMap<FileSystemEntry, FileLocation>();
    private static final Set<String> sExtensionsWithHardCodedTypeNames = new TreeSet<String>(Arrays.asList("m", "mat", "mex", "p", "fig", "asv", "mdl", "slx", "rtw", "tmf", "tlc", "cgt", "c", "cpp", "h", "hpp", "adb", "ads"));

    private MLFileSystemUtils() {
    }

    public static void delete(final Component component, final boolean bl, final List<FileSystemEntry> list, final AsyncReceiver<FileLocation> asyncReceiver) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                UiFileTransfer uiFileTransfer;
                List<File> list2 = FileSystemUtils.getRealFiles(list);
                final HashSet<File> hashSet = new HashSet<File>(list2);
                TreeSet<File> treeSet = new TreeSet<File>();
                final AsyncReceiver<File> asyncReceiver3 = MLPathUtils.prepareToSafelyDelete(MatlabPathModel.getInstance(), list2, treeSet);
                if (asyncReceiver3 == null) {
                    MLFileSystemUtils.showPathError(component, true, treeSet);
                    return;
                }
                AsyncReceiver<FileLocation> asyncReceiver2 = new AsyncReceiver<FileLocation>(){

                    public boolean receive(FileLocation fileLocation) {
                        File file = new File(fileLocation.toString());
                        if (hashSet.contains(file)) {
                            asyncReceiver3.receive((Object)file);
                        }
                        return asyncReceiver.receive((Object)fileLocation);
                    }

                    public void finished() {
                        asyncReceiver3.finished();
                        asyncReceiver.finished();
                    }
                };
                if (!list.isEmpty() && bl && (PlatformInfo.isMacintosh() || PlatformInfo.isWindows())) {
                    uiFileTransfer = new UiFileTransfer(component, UiFileTransferType.RECYCLE_OR_TRASH, null, null, list, asyncReceiver2);
                } else {
                    UiFileTransferType uiFileTransferType = UiFileTransferType.DELETE;
                    if (PlatformInfo.isUnix() && !PlatformInfo.isMacintosh() && bl && Prefs.getBooleanPref((String)"GeneralDeleteFunctionRecycles", (boolean)false)) {
                        uiFileTransferType = UiFileTransferType.RECYCLE_OR_TRASH;
                    }
                    uiFileTransfer = new UiFileTransfer(component, uiFileTransferType, null, null, list, asyncReceiver2);
                }
                uiFileTransfer.run();
            }
        }).start();
    }

    public static void move(final Component component, final FileSystem fileSystem, final FileLocation fileLocation, final List<FileSystemEntry> list, final AsyncReceiver<FileLocation> asyncReceiver) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                List<File> list2 = FileSystemUtils.getRealFiles(list);
                final HashSet<File> hashSet = new HashSet<File>(list2);
                TreeSet<File> treeSet = new TreeSet<File>();
                File file = new File(fileLocation.toString());
                final AsyncReceiver<File> asyncReceiver2 = MLPathUtils.prepareToSafelyMove(MatlabPathModel.getInstance(), list2, file, treeSet);
                if (asyncReceiver2 == null) {
                    MLFileSystemUtils.showPathError(component, false, treeSet);
                    asyncReceiver.finished();
                    return;
                }
                UiFileTransfer uiFileTransfer = new UiFileTransfer(component, UiFileTransferType.MOVE, fileSystem, fileLocation, list, new AsyncReceiver<FileLocation>(){

                    public boolean receive(FileLocation fileLocation) {
                        File file = new File(fileLocation.toString());
                        if (hashSet.contains(file)) {
                            asyncReceiver2.receive((Object)file);
                        }
                        return asyncReceiver.receive((Object)fileLocation);
                    }

                    public void finished() {
                        asyncReceiver2.finished();
                        asyncReceiver.finished();
                    }
                });
                uiFileTransfer.run();
            }
        }).start();
    }

    public static boolean checkWritePermission(File file) {
        return PlatformInfo.isWindows() || ExplorerPrefs.NO_PERMISSION_CHECK.getBoolean() || NativeJava.canWrite((File)file);
    }

    public static ValidityWithHelp validateRename(FileSystemEntry fileSystemEntry, String string) {
        if ((string = string.trim()).length() == 0) {
            return new ValidityWithHelp(Validity.INVALID, ExplorerResources.getString("rename.tip.notempty"));
        }
        string = MLFileSystemUtils.stripDotsIfNecessary(string);
        if (fileSystemEntry.getName().equals(string) || PlatformInfo.isWindows() && fileSystemEntry.getName().equalsIgnoreCase(string)) {
            return new ValidityWithHelp(Validity.VALID);
        }
        String string2 = UIFileUtils.validateNameChars(string);
        if (string2 != null) {
            return new ValidityWithHelp(Validity.INVALID, string2);
        }
        try {
            if (string.startsWith(".") && PlatformInfo.isUnix() && !((Boolean)ExplorerPrefs.ShowHiddenFiles.get()).booleanValue()) {
                return new ValidityWithHelp(Validity.INVALID, ExplorerResources.getString("rename.tip.hidden.unix"));
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
        try {
            if (string.endsWith(".m") && !fileSystemEntry.isFolder() && !MatlabLanguage.isValidVariableName((String)string.substring(0, string.length() - 2))) {
                return new ValidityWithHelp(Validity.WARNING, ExplorerResources.getString("rename.tip.invalidFilename"));
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        if (!FileSystemUtils.checkWritePermission(fileSystemEntry)) {
            return new ValidityWithHelp(Validity.INVALID, ExplorerResources.getString("rename.tip.permission"));
        }
        String string3 = string;
        FileLocation fileLocation = new FileLocation(fileSystemEntry.getLocation().getParent(), string3);
        if (fileSystemEntry.getSystem().exists(fileLocation)) {
            return new ValidityWithHelp(Validity.INVALID, VirtualFileSystem.getUnderlyingEntryIfMountPoint(fileSystemEntry).isFolder() ? ExplorerResources.getString("rename.tip.exists.folder") : ExplorerResources.getString("rename.tip.exists.file"));
        }
        if (!PlatformInfo.isWindows() && MLFileUtils.isMdlFile((String)string)) {
            FileLocation fileLocation2 = fileSystemEntry.getLocation().getParent();
            try {
                FileList fileList = fileSystemEntry.getSystem().getList(fileLocation2);
                List<FileSystemEntry> list = FileSystemUtils.readFilesAndFolders(fileList);
                for (FileSystemEntry fileSystemEntry2 : list) {
                    if (!fileSystemEntry2.getName().equalsIgnoreCase(string)) continue;
                    return new ValidityWithHelp(Validity.WARNING, ExplorerResources.getString("rename.tip.mdl.case"));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return new ValidityWithHelp(Validity.VALID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSystemEntry rename(Component component, FileSystemEntry fileSystemEntry, String string) throws IOException {
        string = string.trim();
        string = MLFileSystemUtils.stripDotsIfNecessary(string);
        if (fileSystemEntry.getName().equals(string)) {
            return fileSystemEntry;
        }
        FileSystemTransaction fileSystemTransaction = fileSystemEntry.getSystem().createTransaction();
        FileLocation fileLocation = new FileLocation(fileSystemEntry.getLocation().getParent(), string);
        AsyncReceiver<File> asyncReceiver = null;
        File file = null;
        if (fileSystemEntry.isReal()) {
            TreeSet<File> treeSet = new TreeSet<File>();
            File file2 = new File(fileSystemEntry.getLocation().toString());
            file = new File(fileLocation.toString());
            asyncReceiver = MLPathUtils.prepareToSafelyMove(MatlabPathModel.getInstance(), Arrays.asList(file2), file, treeSet);
            if (asyncReceiver == null) {
                MLFileSystemUtils.showPathError(component, false, treeSet);
                return fileSystemEntry;
            }
        }
        try {
            fileSystemTransaction.move(fileSystemEntry.getLocation(), fileLocation);
            if (asyncReceiver != null) {
                asyncReceiver.receive(file);
                asyncReceiver.finished();
            }
        }
        finally {
            fileSystemTransaction.close();
        }
        return fileSystemEntry.getSystem().getEntry(fileLocation);
    }

    public static String getDefaultTypeName(FileSystemEntry fileSystemEntry) {
        String string;
        String string2;
        if (!fileSystemEntry.isFolder() && (string2 = fileSystemEntry.getLocation().getExtension()) != null && sExtensionsWithHardCodedTypeNames.contains(string2)) {
            return ExplorerResources.getString("typename.default." + string2);
        }
        if ((PlatformInfo.isWindows() || PlatformInfo.isMacintosh()) && (string = NativeJava.getFileTypeDescription((String)(string2 = PlatformInfo.isWindows() ? NativeJava.getNormalizedWindowsPath((File)new File(fileSystemEntry.getLocation().toString())) : fileSystemEntry.getLocation().toString()), (boolean)fileSystemEntry.isFolder())) != null) {
            return string;
        }
        string2 = fileSystemEntry.getLocation().getExtension();
        return string2 == null ? "" : MessageFormat.format(ExplorerResources.getString("info.file.type"), string2.toUpperCase(Locale.getDefault()));
    }

    private static String stripDotsIfNecessary(String string) {
        if (PlatformInfo.isWindows()) {
            while (string.endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    private static void showPathError(Component component, boolean bl, Set<File> set) {
        String string = ExplorerResources.getString(bl ? "delete.error.title" : "move.error.title");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Iterator<File> iterator = set.iterator();
        for (int i = 0; i < Math.min(5, set.size()); ++i) {
            printWriter.println(iterator.next());
        }
        if (set.size() > 5) {
            printWriter.println(MessageFormat.format(ExplorerResources.getString("error.path.additional"), set.size() - 5));
        }
        printWriter.close();
        MJOptionPane.showMessageDialog((Component)component, (Object)MessageFormat.format(ExplorerResources.getString("error.path"), stringWriter), (String)string, (int)0);
    }

    public static FileSystemEntry getMatlabAccessibleEntry(FileSystemEntry fileSystemEntry) throws IOException {
        return MLFileSystemUtils.getMatlabAccessibleEntry(fileSystemEntry, true);
    }

    public static FileSystemEntry getMatlabAccessibleEntry(FileSystemEntry fileSystemEntry, boolean bl) throws IOException {
        if (fileSystemEntry.isReal()) {
            return fileSystemEntry;
        }
        return MLFileSystemUtils.getMatlabAccessibleEntry(fileSystemEntry.getSystem(), fileSystemEntry.getLocation(), bl);
    }

    public static FileSystemEntry getMatlabAccessibleEntry(FileSystem fileSystem, FileLocation fileLocation) throws IOException {
        return MLFileSystemUtils.getMatlabAccessibleEntry(fileSystem, fileLocation, true);
    }

    public static FileSystemEntry getMatlabAccessibleEntry(FileSystem fileSystem, FileLocation fileLocation, boolean bl) throws IOException {
        if (fileSystem.equals(RealFileSystem.getInstance())) {
            return fileSystem.getEntry(fileLocation);
        }
        FileLocation fileLocation2 = MLFileSystemUtils.copyToTemp(fileSystem, fileLocation, bl);
        return RealFileSystem.getInstance().getEntry(fileLocation2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileSystemEntry getMatlabAccessibleStub(FileSystemEntry fileSystemEntry) throws IOException {
        if (fileSystemEntry.isReal()) {
            return fileSystemEntry;
        }
        Object object = sTempFileLock;
        synchronized (object) {
            if (sTempStubs.containsKey(fileSystemEntry)) {
                return RealFileSystem.getInstance().getEntry(sTempStubs.get(fileSystemEntry));
            }
            File file = File.createTempFile("temp", "tmp");
            file.delete();
            file.mkdirs();
            FileLocation fileLocation = new FileLocation(file.getAbsolutePath());
            FileLocation fileLocation2 = new FileLocation(fileLocation, fileSystemEntry.getName());
            FileSystemTransaction fileSystemTransaction = RealFileSystem.getInstance().createTransaction();
            if (fileSystemEntry.isFolder()) {
                fileSystemTransaction.createDirectory(fileLocation2);
            } else {
                fileSystemTransaction.getOutputStream(fileLocation2).close();
            }
            sTempFiles.add(fileLocation2);
            sTempStubs.put(fileSystemEntry, fileLocation2);
            return RealFileSystem.getInstance().getEntry(fileLocation2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fillMatlabAccessibleStub(FileSystemEntry fileSystemEntry) throws IOException {
        Object object = sTempFileLock;
        synchronized (object) {
            FileLocation fileLocation = sTempStubs.get(fileSystemEntry);
            if (fileLocation != null) {
                FileSystemUtils.copy(fileSystemEntry.getSystem(), fileSystemEntry.getLocation(), RealFileSystem.getInstance(), fileLocation);
                FileSystemUtils.setWritableRecursively(RealFileSystem.getInstance().getEntry(fileLocation), false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseMatlabAccessibleStub(FileSystemEntry fileSystemEntry) throws IOException {
        Object object = sTempFileLock;
        synchronized (object) {
            FileLocation fileLocation = sTempStubs.remove(fileSystemEntry);
            if (fileLocation != null) {
                MLFileSystemUtils.releaseMatlabAccessibleEntry(RealFileSystem.getInstance().getEntry(fileLocation));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseAllMatlabAccessibleEntries() {
        Object object = sTempFileLock;
        synchronized (object) {
            for (FileLocation fileLocation : new ArrayList<FileLocation>(sTempFiles)) {
                MLFileSystemUtils.releaseMatlabAccessibleEntry(fileLocation);
            }
        }
    }

    public static void releaseMatlabAccessibleEntry(FileSystemEntry fileSystemEntry) {
        MLFileSystemUtils.releaseMatlabAccessibleEntry(fileSystemEntry.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseMatlabAccessibleEntry(final FileLocation fileLocation) {
        boolean bl = false;
        Object object = sTempFileLock;
        synchronized (object) {
            if (sTempFiles.remove(fileLocation)) {
                bl = true;
            }
        }
        if (bl) {
            try {
                FileSystemUtils.withTransaction(RealFileSystem.getInstance(), new TransactionLogic(){

                    @Override
                    public void run(FileSystemTransaction fileSystemTransaction) throws IOException {
                        FileSystemUtils.traverse(RealFileSystem.getInstance().getEntry(fileLocation), FileSystemUtils.TraversalMode.ITERATIVE, new ThrowableClosure<Void, FileSystemEntry, IOException>(){

                            public Void run(FileSystemEntry fileSystemEntry) throws IOException {
                                fileSystemEntry.getLocation().toFile().setWritable(true);
                                return null;
                            }
                        });
                        fileSystemTransaction.delete(fileLocation, false);
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileLocation copyToTemp(FileSystem fileSystem, FileLocation fileLocation, boolean bl) throws IOException {
        File file = File.createTempFile("temp", "tmp");
        file.delete();
        file.mkdirs();
        FileLocation fileLocation2 = new FileLocation(file.getAbsolutePath());
        FileLocation fileLocation3 = new FileLocation(fileLocation2, fileLocation.getName());
        FileSystemUtils.copy(fileSystem, fileLocation, RealFileSystem.getInstance(), fileLocation3);
        if (bl) {
            FileSystemUtils.setWritableRecursively(RealFileSystem.getInstance().getEntry(fileLocation3), false);
        }
        Object object = sTempFileLock;
        synchronized (object) {
            sTempFiles.add(fileLocation3);
        }
        return fileLocation3;
    }
}

