/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.explorer.util;

import com.mathworks.matlab.api.explorer.NewFileTemplate;
import com.mathworks.mlwidgets.explorer.model.ExplorerPrefs;
import com.mathworks.mlwidgets.explorer.widgets.table.FileTable;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJList;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.settings.SettingException;
import com.mathworks.util.AsyncReceiver;
import com.mathworks.util.Converter;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.RequestFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class MenuUtils {
    private MenuUtils() {
    }

    public static void createScrollingMenu(MJPopupMenu mJPopupMenu, List<MJMenuItem> list) {
        MenuUtils.createScrollingMenu(null, (JPopupMenu)mJPopupMenu, list, 0, true);
    }

    public static <T> void createScrollingMenu(Component component, final JPopupMenu jPopupMenu, ParameterRunnable<AsyncReceiver<T>> parameterRunnable, final Comparator<T> comparator, final Converter<T, MJMenuItem> converter, int n) {
        final Holder holder = new Holder();
        holder.set((Object)false);
        final PopupList popupList = new PopupList(component, jPopupMenu, n, true);
        final MJScrollPane mJScrollPane = new MJScrollPane((Component)((Object)popupList));
        mJScrollPane.setBorder(null);
        final Vector vector = new Vector();
        final HashMap hashMap = new HashMap();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final Holder holder2 = new Holder();
        final Holder holder3 = new Holder();
        holder2.set((Object)false);
        holder3.set((Object)false);
        final RequestFilter requestFilter = new RequestFilter(new Runnable(){

            @Override
            public void run() {
                try {
                    countDownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (((Boolean)holder3.get()).booleanValue()) {
                    return;
                }
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (((Boolean)holder.get()).booleanValue()) {
                            return;
                        }
                        MenuUtils.updateMenu(jPopupMenu, mJScrollPane, popupList, vector, hashMap, comparator, converter);
                    }
                });
            }
        }, 25);
        jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                holder.set((Object)true);
                popupList.dispose();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                holder.set((Object)true);
                popupList.dispose();
            }
        });
        parameterRunnable.run((Object)new AsyncReceiver<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean receive(T t) {
                List list = vector;
                synchronized (list) {
                    vector.add(t);
                }
                requestFilter.request();
                return (Boolean)holder.get() == false;
            }

            public void finished() {
                holder2.set((Object)true);
                requestFilter.request();
            }
        });
        if (((Boolean)holder2.get()).booleanValue()) {
            holder3.set((Object)true);
        }
        jPopupMenu.add((Component)mJScrollPane);
        if (((Boolean)holder3.get()).booleanValue() && SwingUtilities.isEventDispatchThread()) {
            MenuUtils.updateMenu(jPopupMenu, mJScrollPane, popupList, vector, hashMap, comparator, converter);
        } else {
            jPopupMenu.setPopupSize(0, 0);
        }
        countDownLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void updateMenu(JPopupMenu jPopupMenu, MJScrollPane mJScrollPane, PopupList popupList, List<T> list, Map<T, MJMenuItem> map, Comparator<T> comparator, Converter<T, MJMenuItem> converter) {
        try {
            if (list.size() >= (Integer)ExplorerPrefs.CurrentFolderSize.get() || map.size() + list.size() >= (Integer)ExplorerPrefs.CurrentFolderSize.get()) {
                jPopupMenu.setVisible(false);
                return;
            }
        }
        catch (SettingException settingException) {
            throw new RuntimeException(settingException);
        }
        Vector<MJMenuItem> vector = new Vector<MJMenuItem>();
        List<T> list2 = list;
        synchronized (list2) {
            if (comparator != null) {
                Collections.sort(list, comparator);
            }
            for (T t : list) {
                if (map.get(t) == null) {
                    map.put(t, (MJMenuItem)converter.convert(t));
                }
                vector.add(map.get(t));
            }
        }
        int n = popupList.getSelectedIndex();
        popupList.setListData(vector.toArray());
        popupList.setVisibleRowCount(Math.min(10, vector.size()));
        Object object = popupList.getPreferredScrollableViewportSize();
        if (vector.size() <= 10) {
            object = popupList.getPreferredSize();
        }
        double d = mJScrollPane.getVerticalScrollBar().getPreferredSize().getWidth() * 2.0;
        double d2 = jPopupMenu.getBorder().getBorderInsets((Component)jPopupMenu).top + jPopupMenu.getBorder().getBorderInsets((Component)jPopupMenu).bottom;
        ((Dimension)object).setSize((int)Math.max(100.0, popupList.getPreferredSize().getWidth() + d), (int)(((Dimension)object).getHeight() + d2));
        jPopupMenu.setPopupSize((Dimension)object);
        jPopupMenu.invalidate();
        jPopupMenu.repaint();
        if (n >= 0 && n < vector.size()) {
            popupList.setSelectedIndex(n);
        }
    }

    public static void createScrollingMenu(Component component, JPopupMenu jPopupMenu, List<MJMenuItem> list) {
        MenuUtils.createScrollingMenu(component, jPopupMenu, list, 0, true);
    }

    public static void createScrollingMenu(MJPopupMenu mJPopupMenu, List<MJMenuItem> list, int n) {
        MenuUtils.createScrollingMenu(null, (JPopupMenu)mJPopupMenu, list, n, true);
    }

    public static void createScrollingMenu(Component component, JPopupMenu jPopupMenu, List<MJMenuItem> list, int n, boolean bl) {
        PopupList popupList = new PopupList(component, jPopupMenu, n, bl);
        popupList.setListData(list.toArray());
        popupList.setVisibleRowCount(Math.min(10, list.size()));
        MJScrollPane mJScrollPane = new MJScrollPane((Component)((Object)popupList));
        if (list.isEmpty()) {
            mJScrollPane.setPreferredSize(popupList.getPreferredSize());
        }
        mJScrollPane.setBorder(null);
        jPopupMenu.add((Component)mJScrollPane);
    }

    public static List<MJAbstractAction> getNewFileOptions(final FileTable fileTable) {
        Vector<MJAbstractAction> vector = new Vector<MJAbstractAction>();
        for (final NewFileTemplate newFileTemplate : fileTable.getContext().getExtensions().getNewFileTemplates()) {
            MJAbstractAction mJAbstractAction = new MJAbstractAction(newFileTemplate.getName()){

                public void actionPerformed(ActionEvent actionEvent) {
                    fileTable.createNewFile(newFileTemplate);
                }
            };
            String string = newFileTemplate.getClass().getName();
            mJAbstractAction.setComponentName("new." + string.substring(string.lastIndexOf(46) + 1));
            vector.add(mJAbstractAction);
        }
        return vector;
    }

    private static void runScrollingMenuChoice(JPopupMenu jPopupMenu, MJList mJList) {
        MJMenuItem mJMenuItem = (MJMenuItem)mJList.getSelectedValue();
        if (mJMenuItem != null) {
            mJMenuItem.doClick();
            jPopupMenu.setVisible(false);
        }
    }

    private static class PopupList
    extends MJList {
        private final int fWidth;
        private final Component fParent;
        private final MouseMotionListener fMotionListener;
        private final MouseListener fClickListener;

        PopupList(Component component, final JPopupMenu jPopupMenu, int n, boolean bl) {
            this.fWidth = n;
            if (bl) {
                this.setBackground(jPopupMenu.getBackground());
            }
            this.setName("ScrollingMenuItemList");
            this.getSelectionModel().setSelectionMode(0);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        MenuUtils.runScrollingMenuChoice(jPopupMenu, PopupList.this);
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    PopupList.this.clearSelection();
                }
            });
            this.fClickListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    if (PopupList.this.isShowing()) {
                        MenuUtils.runScrollingMenuChoice(jPopupMenu, PopupList.this);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    if (PopupList.this.isShowing() && PopupList.this.fParent != null && mouseEvent.getComponent().equals(PopupList.this.fParent)) {
                        MenuUtils.runScrollingMenuChoice(jPopupMenu, PopupList.this);
                    }
                }
            };
            this.addMouseListener(this.fClickListener);
            this.fMotionListener = new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    this.mouseMoved(mouseEvent);
                }

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, (Component)((Object)PopupList.this));
                    if (PopupList.this.fParent != null && PopupList.this.fParent.equals(mouseEvent.getSource())) {
                        PopupList.this.dispatchEvent(mouseEvent2);
                    } else {
                        for (int i = 0; i < PopupList.this.getModel().getSize(); ++i) {
                            if (!PopupList.this.getCellBounds(i, i).contains(mouseEvent2.getPoint())) continue;
                            PopupList.this.setSelectedIndex(i);
                            return;
                        }
                        PopupList.this.setSelectedIndex(-1);
                    }
                }
            };
            this.fParent = component;
            if (this.fParent != null) {
                this.fParent.addMouseMotionListener(this.fMotionListener);
                this.fParent.addMouseListener(this.fClickListener);
            }
            this.addMouseMotionListener(this.fMotionListener);
            this.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    MJMenuItem mJMenuItem = (MJMenuItem)object;
                    this.setText(mJMenuItem.getText());
                    this.setIcon(mJMenuItem.getIcon());
                    this.setFont(mJMenuItem.getFont());
                    this.setIconTextGap(6);
                    this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                    if (bl) {
                        this.setBackground(jList.getSelectionBackground());
                        this.setForeground(jList.getSelectionForeground());
                    } else {
                        this.setBackground(jList.getBackground());
                        this.setForeground(jList.getForeground());
                    }
                    this.setEnabled(jList.isEnabled());
                    this.setOpaque(true);
                    return this;
                }
            });
            final KeyEventDispatcher keyEventDispatcher = new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                    if (PopupList.this.getSelectedValue() != null) {
                        PopupList.this.processKeyEvent(new KeyEvent((Component)((Object)PopupList.this), keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar()));
                        return true;
                    }
                    return false;
                }
            };
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    keyboardFocusManager.removeKeyEventDispatcher(keyEventDispatcher);
                    keyboardFocusManager.addKeyEventDispatcher(keyEventDispatcher);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                    keyboardFocusManager.removeKeyEventDispatcher(keyEventDispatcher);
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }

        public void processKeyEvent(KeyEvent keyEvent) {
            super.processKeyEvent(keyEvent);
        }

        void dispose() {
            if (this.fParent != null) {
                this.fParent.removeMouseMotionListener(this.fMotionListener);
                this.fParent.removeMouseListener(this.fClickListener);
            }
        }

        public Dimension getPreferredSize() {
            int n;
            int n2 = (int)super.getPreferredSize().getWidth();
            if (n2 > 700) {
                n2 = 700;
            }
            if (this.fWidth > 0 && n2 < this.fWidth) {
                n2 = this.fWidth;
            }
            if ((n = (int)super.getPreferredSize().getHeight()) < 20) {
                n = 20;
            }
            return new Dimension(n2, n);
        }
    }
}

