/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.graphics;

import com.mathworks.mlwidgets.graphics.AnimationTarget;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

class Animator
implements ActionListener {
    private boolean fIsInitialized;
    private long fStart;
    private Point fStartPoint;
    private Point fEndPoint;
    private AnimationTarget fAnimationTarget;
    private boolean fReverse = false;
    private static final double INITIAL_SPEED = -250.0;
    private static final double INITIAL_ACCELERATION = 3000.0;
    private static final double INITIAL_REVERSE_SPEED = 1000.0;
    private static final double INITIAL_REVERSE_ACCELERATION = -70.0;

    Animator(AnimationTarget animationTarget, Point point, Point point2) {
        this.fAnimationTarget = animationTarget;
        this.fStartPoint = point;
        this.fEndPoint = point2;
        this.fIsInitialized = false;
    }

    Animator(Window window, Point point, Point point2) {
        this.fAnimationTarget = new AnimationWindow(window);
        this.fStartPoint = point;
        this.fEndPoint = point2;
        this.fIsInitialized = false;
    }

    public void setReverse(boolean bl) {
        this.fReverse = bl;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl;
        if (!this.fIsInitialized) {
            this.fIsInitialized = true;
            this.fStart = System.currentTimeMillis();
        }
        this.fAnimationTarget.animationStart();
        long l = System.currentTimeMillis() - this.fStart;
        double d = (double)l / 1000.0;
        double d2 = -this.fStartPoint.x + this.fEndPoint.x;
        double d3 = -this.fStartPoint.y + this.fEndPoint.y;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        double d5 = d2 / d4;
        double d6 = d3 / d4;
        double d7 = (this.fReverse ? -70.0 : 3000.0) * d * d / 2.0 + (this.fReverse ? 1000.0 : -250.0) * d;
        int n = (int)(d7 * d5);
        int n2 = (int)(d7 * d6);
        if (this.fReverse) {
            bl = -Math.abs(d7) + d4 < 20.0;
        } else {
            boolean bl2 = bl = Math.abs(d7) >= d4;
        }
        if (bl) {
            ((Timer)actionEvent.getSource()).stop();
            this.fAnimationTarget.setAnimationLocation(this.fEndPoint);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Animator.this.fAnimationTarget.animationComplete();
                }
            });
            return;
        }
        this.fAnimationTarget.setAnimationLocation(new Point(this.fStartPoint.x + n, this.fStartPoint.y + n2));
    }

    static class AnimationWindow
    implements AnimationTarget {
        private Window iAnimationWindow;

        AnimationWindow(Window window) {
            this.iAnimationWindow = window;
        }

        @Override
        public void setAnimationLocation(Point point) {
            this.iAnimationWindow.setLocation(point);
        }

        @Override
        public void animationStart() {
            this.iAnimationWindow.setVisible(true);
        }

        @Override
        public void animationComplete() {
            this.iAnimationWindow.setVisible(false);
        }
    }
}

