/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.SearchHelper;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.reference.ReferenceData;
import com.mathworks.helpsearch.reference.ReferenceDataRetriever;
import com.mathworks.helpsearch.reference.ReferenceRequest;
import com.mathworks.helpsearch.reference.ReferenceRetrievalStrategy;
import com.mathworks.helpsearch.reference.SearchEngineReferenceStrategy;
import com.mathworks.mlwidgets.help.DocCenterSearchHelper;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class DocCenterReferenceRetrievalStrategy
implements ReferenceRetrievalStrategy {
    private final ReferenceRetrievalStrategy fRealStrategy;

    private DocCenterReferenceRetrievalStrategy(ReferenceRetrievalStrategy referenceRetrievalStrategy) {
        this.fRealStrategy = referenceRetrievalStrategy;
    }

    public static DocCenterReferenceRetrievalStrategy getInstance() {
        DocCenterSearchHelper docCenterSearchHelper = DocCenterSearchHelper.getInstance();
        return DocCenterReferenceRetrievalStrategy.getInstance((SearchHelper)docCenterSearchHelper);
    }

    public static DocCenterReferenceRetrievalStrategy getInstance(SearchHelper searchHelper) {
        EmptyReferenceRetrievalStrategy emptyReferenceRetrievalStrategy = DocCenterReferenceRetrievalStrategy.isSearchHelperValid(searchHelper) ? new SearchEngineReferenceStrategy(searchHelper.getSearchConfig(), searchHelper.getDocumentationSet()) : new EmptyReferenceRetrievalStrategy();
        return new DocCenterReferenceRetrievalStrategy(emptyReferenceRetrievalStrategy);
    }

    public static ReferenceDataRetriever createDataRetriever() {
        return new ReferenceDataRetriever((ReferenceRetrievalStrategy)DocCenterReferenceRetrievalStrategy.getInstance());
    }

    public static ReferenceDataRetriever createDataRetriever(SearchHelper searchHelper) {
        return new ReferenceDataRetriever((ReferenceRetrievalStrategy)DocCenterReferenceRetrievalStrategy.getInstance(searchHelper));
    }

    public List<ReferenceData> getReferenceData(ReferenceRequest referenceRequest) {
        return this.fRealStrategy.getReferenceData(referenceRequest);
    }

    public void close() throws IOException {
        this.fRealStrategy.close();
    }

    private static boolean isSearchHelperValid(SearchHelper searchHelper) {
        if (searchHelper.getDocumentationSet() == null) {
            return false;
        }
        SearchConfig searchConfig = searchHelper.getSearchConfig();
        if (searchConfig == null) {
            return false;
        }
        File file = searchConfig.getIndexDirectory();
        return file != null && file.exists() && file.isDirectory();
    }

    private static class EmptyReferenceRetrievalStrategy
    implements ReferenceRetrievalStrategy {
        private EmptyReferenceRetrievalStrategy() {
        }

        public List<ReferenceData> getReferenceData(ReferenceRequest referenceRequest) {
            return Collections.emptyList();
        }

        public void close() throws IOException {
        }
    }
}

