/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.help.helpui.HelpBrowserSearchHelper;
import com.mathworks.help.helpui.LocaleHelper;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.services.PrefEvent;
import com.mathworks.services.PrefListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;

public class DocCenterSearchHelper
extends HelpBrowserSearchHelper {
    private static String sLastKnownDocRoot;
    private static Collection<String> sLastKnownSelectedProducts;
    private static DocCenterSearchHelper sSingleton;
    private static PrefListener sDocCenterPrefsListener;

    private DocCenterSearchHelper(String string, Collection<String> collection) {
        super(string, (LocaleHelper)new MatlabLocaleHelper(), collection);
        this.addListeners();
    }

    private void addListeners() {
        sDocCenterPrefsListener = new DocCenterPrefsListener();
        HelpPrefs.addPrefsListeners(sDocCenterPrefsListener, "HelpDocCenterLocation", "HelpShowUninstalledProducts", "HelpSelectedInstalledProducts", "HelpSelectedUninstalledProducts", "HelpDocLanguage");
    }

    private static void removeListeners() {
        if (sDocCenterPrefsListener != null) {
            HelpPrefs.removePrefsListeners(sDocCenterPrefsListener, "HelpDocCenterLocation", "HelpShowUninstalledProducts", "HelpSelectedInstalledProducts", "HelpSelectedUninstalledProducts", "HelpDocLanguage");
        }
    }

    public static synchronized DocCenterSearchHelper getInstance() {
        String string = MLHelpServices.getDocRoot();
        if (sLastKnownDocRoot == null || !sLastKnownDocRoot.equals(string)) {
            return DocCenterSearchHelper.getInstance(true);
        }
        Collection<String> collection = HelpPrefs.getSelectedBaseCodes();
        if (sLastKnownSelectedProducts == null || DocCenterSearchHelper.selectedProductsHaveChanged(collection)) {
            return DocCenterSearchHelper.getInstance(true);
        }
        return DocCenterSearchHelper.getInstance(false);
    }

    private static synchronized DocCenterSearchHelper getInstance(boolean bl) {
        if (bl) {
            String string = MLHelpServices.getDocRoot();
            Collection<String> collection = HelpPrefs.getSelectedBaseCodes();
            DocCenterSearchHelper.populate(string, collection);
        }
        return sSingleton;
    }

    private static boolean selectedProductsHaveChanged(Collection<String> collection) {
        HashSet<String> hashSet = new HashSet<String>(collection);
        HashSet<String> hashSet2 = new HashSet<String>(sLastKnownSelectedProducts);
        return hashSet2.size() != hashSet.size() || !hashSet2.containsAll(hashSet);
    }

    private static synchronized void setInstance(String string, DocCenterSearchHelper docCenterSearchHelper, Collection<String> collection) {
        sLastKnownDocRoot = string;
        sSingleton = docCenterSearchHelper;
        sLastKnownSelectedProducts = collection;
    }

    private static void populate(String string, Collection<String> collection) {
        DocCenterSearchHelper.removeListeners();
        DocCenterSearchHelper docCenterSearchHelper = new DocCenterSearchHelper(string, collection);
        DocCenterSearchHelper.setInstance(string, docCenterSearchHelper, collection);
    }

    private class DocCenterPrefsListener
    implements PrefListener {
        private DocCenterPrefsListener() {
        }

        public void prefChanged(PrefEvent prefEvent) {
            DocCenterSearchHelper.getInstance(true);
        }
    }

    private static class MatlabLocaleHelper
    implements LocaleHelper {
        private MatlabLocaleHelper() {
        }

        public Locale getHelpLocale() {
            return HelpUtils.getLanguageLocale().getLocale();
        }
    }
}

