/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlwidgets.help.HelpDataObserver;
import com.mathworks.mlwidgets.help.HelpDataWorkerStrategy;
import javax.swing.SwingUtilities;

class HelpDataWorker<T> {
    private HelpDataWorkerStrategy<T> fCurrentStrategy = null;

    HelpDataWorker() {
    }

    void populate(HelpDataWorkerStrategy<T> helpDataWorkerStrategy) {
        this.setCurrentStrategy(helpDataWorkerStrategy);
        BeforePopulateRunnable beforePopulateRunnable = new BeforePopulateRunnable(helpDataWorkerStrategy);
        SwingUtilities.invokeLater(beforePopulateRunnable);
    }

    private synchronized void setCurrentStrategy(HelpDataWorkerStrategy<T> helpDataWorkerStrategy) {
        this.fCurrentStrategy = helpDataWorkerStrategy;
    }

    synchronized boolean isCurrentStrategy(HelpDataWorkerStrategy<T> helpDataWorkerStrategy) {
        return this.fCurrentStrategy != null && this.fCurrentStrategy.equals(helpDataWorkerStrategy);
    }

    private synchronized void populationComplete(HelpDataWorkerStrategy<T> helpDataWorkerStrategy) {
        if (this.isCurrentStrategy(helpDataWorkerStrategy)) {
            this.setCurrentStrategy(null);
        }
    }

    private class AfterPopulateRunnable
    implements Runnable {
        private final HelpDataWorkerStrategy<T> iStrategy;
        private final T iData;

        private AfterPopulateRunnable(HelpDataWorkerStrategy<T> helpDataWorkerStrategy, T t) {
            this.iStrategy = helpDataWorkerStrategy;
            this.iData = t;
        }

        @Override
        public void run() {
            if (HelpDataWorker.this.isCurrentStrategy(this.iStrategy)) {
                this.iStrategy.afterPopulateEdt(this.iData);
                HelpDataWorker.this.populationComplete(this.iStrategy);
            }
        }
    }

    private class PopulationCompleteObserver
    implements HelpDataObserver<T> {
        private final HelpDataWorkerStrategy<T> iStrategy;

        private PopulationCompleteObserver(HelpDataWorkerStrategy<T> helpDataWorkerStrategy) {
            this.iStrategy = helpDataWorkerStrategy;
        }

        @Override
        public void dataPopulated(T t) {
            if (HelpDataWorker.this.isCurrentStrategy(this.iStrategy)) {
                AfterPopulateRunnable afterPopulateRunnable = new AfterPopulateRunnable(this.iStrategy, t);
                SwingUtilities.invokeLater(afterPopulateRunnable);
            }
        }
    }

    private class PopulateRunnable
    implements Runnable {
        private final HelpDataWorkerStrategy<T> iStrategy;

        private PopulateRunnable(HelpDataWorkerStrategy<T> helpDataWorkerStrategy) {
            this.iStrategy = helpDataWorkerStrategy;
        }

        @Override
        public void run() {
            if (HelpDataWorker.this.isCurrentStrategy(this.iStrategy)) {
                PopulationCompleteObserver populationCompleteObserver = new PopulationCompleteObserver(this.iStrategy);
                this.iStrategy.populate(populationCompleteObserver);
            }
        }
    }

    private class BeforePopulateRunnable
    implements Runnable {
        private final HelpDataWorkerStrategy<T> iStrategy;

        private BeforePopulateRunnable(HelpDataWorkerStrategy<T> helpDataWorkerStrategy) {
            this.iStrategy = helpDataWorkerStrategy;
        }

        @Override
        public void run() {
            if (HelpDataWorker.this.isCurrentStrategy(this.iStrategy)) {
                this.iStrategy.beforePopulateEdt();
                PopulateRunnable populateRunnable = new PopulateRunnable(this.iStrategy);
                new Thread(populateRunnable).start();
            }
        }
    }
}

