/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help;

import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mlwidgets.help.ContentsData;
import com.mathworks.mlwidgets.help.ContentsItem;
import com.mathworks.mlwidgets.help.DemoInfoUtils;
import com.mathworks.mlwidgets.help.DemoTreeItem;
import com.mathworks.mlwidgets.help.DemosData;
import com.mathworks.mlwidgets.help.HelpInfo;
import com.mathworks.mlwidgets.help.HelpPanelSyncEvent;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.help.HelpSyncListener;
import com.mathworks.mlwidgets.help.HelpTreeItem;
import com.mathworks.mlwidgets.help.HelpTreeItemVisitor;
import com.mathworks.mlwidgets.help.HelpTreeUtils;
import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.ProductHelpTreeItem;
import com.mathworks.mlwidgets.help.ReferenceItem;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.mlwidgets.html.PageChangedListener;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;

public class HelpSynchronizer {
    private static SynchronizerHelpInfo sTestHelpInfo = null;
    private static SynchronizerContentsData sTestContentsData = null;
    private static Map<String, DemoTreeItem> fDemoMap = new HashMap<String, DemoTreeItem>(1009);
    private Set<HelpSyncListener> fHelpSyncListeners = Collections.synchronizedSet(new HashSet());
    private final PageChangedListener fPageChangedListener = new HelpSynchronizerPageChangedListener();
    private String fCurrentDemoId;
    private HelpTreeItem fHelpTreeItem;
    private SynchronizerHelpInfo fSynchronizerHelpInfo = HelpSynchronizer.getSynchronizerHelpInfo();
    private SynchronizerContentsData fSynchronizerContentsData = HelpSynchronizer.getSynchronizerContentsData();
    private HelpPanelSyncEvent fLastHelpPanelSyncEvent;
    private String fStreamingText;

    public void setCurrentDemoId(String string) {
        this.fCurrentDemoId = string;
    }

    public String getCurrentDemoId() {
        return this.fCurrentDemoId;
    }

    public void addHelpSyncListener(HelpSyncListener helpSyncListener) {
        this.addHelpSyncListener(helpSyncListener, false);
    }

    public void addHelpSyncListener(HelpSyncListener helpSyncListener, boolean bl) {
        this.fHelpSyncListeners.add(helpSyncListener);
        if (bl) {
            this.updateLastHelpPanelSyncEvent();
            helpSyncListener.syncToHelpPanelSyncEvent(this.fLastHelpPanelSyncEvent);
        }
    }

    public void removeHelpSyncListener(HelpSyncListener helpSyncListener) {
        for (HelpSyncListener helpSyncListener2 : this.fHelpSyncListeners) {
            if (!helpSyncListener2.equals(helpSyncListener)) continue;
            this.fHelpSyncListeners.remove(helpSyncListener);
            return;
        }
    }

    void notifyAllHelpSyncListeners(HelpPanelSyncEvent helpPanelSyncEvent) {
        this.notifyOtherHelpSyncListeners(helpPanelSyncEvent, null);
    }

    void notifyOtherHelpSyncListeners(final HelpPanelSyncEvent helpPanelSyncEvent, final HelpSyncListener helpSyncListener) {
        this.fLastHelpPanelSyncEvent = helpPanelSyncEvent;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                for (HelpSyncListener helpSyncListener2 : HelpSynchronizer.this.fHelpSyncListeners) {
                    if (helpSyncListener != null && helpSyncListener2.equals(helpSyncListener)) continue;
                    helpSyncListener2.syncToHelpPanelSyncEvent(helpPanelSyncEvent);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void helpOpened(boolean bl) {
        HelpPanelSyncEvent helpPanelSyncEvent = bl ? new HelpPanelSyncEvent(HelpPanelSyncEvent.SyncEventType.HELP_OPENED_SELECT_FIRST_PRODUCT) : new HelpPanelSyncEvent(HelpPanelSyncEvent.SyncEventType.HELP_OPENED);
        this.notifyAllHelpSyncListeners(helpPanelSyncEvent);
    }

    public void selectFirstProduct() {
        HelpPanelSyncEvent helpPanelSyncEvent = new HelpPanelSyncEvent(HelpPanelSyncEvent.SyncEventType.SELECT_FIRST_PRODUCT);
        this.notifyAllHelpSyncListeners(helpPanelSyncEvent);
    }

    public void resetTOC() {
        HelpPanelSyncEvent helpPanelSyncEvent = new HelpPanelSyncEvent(HelpPanelSyncEvent.SyncEventType.RESET_TOC);
        this.notifyAllHelpSyncListeners(helpPanelSyncEvent);
    }

    public void syncTOC() {
        HelpPanelSyncEvent helpPanelSyncEvent;
        String string = MLHelpServices.getCurrentLocation();
        if (string != null && string.trim().length() > 0 && !string.startsWith("text://") && (helpPanelSyncEvent = this.getSyncEventForUrl(string)) != null) {
            this.notifyAllHelpSyncListeners(helpPanelSyncEvent);
        }
    }

    public void syncToTreeNode(TreeNode treeNode) {
        HelpTreeItem helpTreeItem;
        if (treeNode != null && (helpTreeItem = HelpTreeUtils.getItemForTreeNode(treeNode)) != null) {
            if (helpTreeItem instanceof DemoTreeItem) {
                HelpSynchronizer.registerDemoTreeItem((DemoTreeItem)helpTreeItem);
            }
            if (HelpTreeUtils.isValidTreeNode(treeNode)) {
                this.fHelpTreeItem = helpTreeItem;
                HelpPanelSyncEvent helpPanelSyncEvent = new HelpPanelSyncEvent(HelpPanelSyncEvent.SyncEventType.CONTENTS_ITEM, this.fHelpTreeItem);
                this.notifyAllHelpSyncListeners(helpPanelSyncEvent);
            }
        }
    }

    public void syncToDemo(String string) {
        if (string != null && string.length() != 0) {
            DemoTreeItem demoTreeItem = DemosData.getItemById(string);
            this.syncToTreeNode(demoTreeItem);
        }
    }

    public PageChangedListener getPageChangedListener() {
        return this.fPageChangedListener;
    }

    private void updateLastHelpPanelSyncEvent() {
        HelpTreeItem helpTreeItem;
        if (this.fLastHelpPanelSyncEvent == null) {
            return;
        }
        if (this.fLastHelpPanelSyncEvent.isContentsItem() && !HelpPrefs.isProductSelected((helpTreeItem = this.fLastHelpPanelSyncEvent.getHelpTreeItem()).getProduct())) {
            this.fLastHelpPanelSyncEvent = new HelpPanelSyncEvent(HelpPanelSyncEvent.SyncEventType.SELECT_FIRST_PRODUCT);
        }
    }

    private HelpPanelSyncEvent getSyncEventForUrl(String string) {
        return this.getSyncEventForUrl(string, null);
    }

    private HelpPanelSyncEvent getSyncEventForUrl(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (this.showingCorrectHelpTreeItem(string)) {
            return null;
        }
        HelpTreeItemWrapper helpTreeItemWrapper = this.getHelpTreeItemForUrl(string);
        if (helpTreeItemWrapper == null) {
            helpTreeItemWrapper = this.getDemoTreeItemForUrl(string);
        }
        if (helpTreeItemWrapper != null && HelpTreeUtils.isValidTreeNode(helpTreeItemWrapper.getHelpTreeItem().getTreeNode())) {
            return new HelpPanelSyncEvent(HelpPanelSyncEvent.SyncEventType.CONTENTS_ITEM, helpTreeItemWrapper.getHelpTreeItem(), helpTreeItemWrapper.isSyncToTag());
        }
        if (this.isStreamingTextUrl(string)) {
            this.fStreamingText = MLHelpServices.getHtmlText();
        }
        return new HelpPanelSyncEvent(HelpPanelSyncEvent.SyncEventType.OTHER_ITEM, string2, string);
    }

    private boolean showingCorrectHelpTreeItem(String string) {
        boolean bl = false;
        if (this.fHelpTreeItem != null) {
            CompareVisitor compareVisitor = new CompareVisitor(string);
            this.fHelpTreeItem.accept(compareVisitor);
            if (compareVisitor.isEqual()) {
                bl = true;
            }
        }
        if (!bl && this.isStreamingTextUrl(string) && this.fStreamingText != null) {
            bl = this.compareStreamingText(this.fStreamingText);
        }
        this.setCurrentDemoId(null);
        this.fHelpTreeItem = null;
        this.fStreamingText = null;
        return bl;
    }

    private HelpTreeItemWrapper getHelpTreeItemForUrl(String string) {
        int n;
        String string2 = HTMLUtils.getAnchorFromURL(string);
        String string3 = HTMLUtils.getCanonicalUrl(string);
        String string4 = this.getCorrectUrlForProduct(string3);
        TreeNode treeNode = this.fSynchronizerContentsData.getNodeForFileName(string4, string2);
        if (treeNode != null) {
            return new HelpTreeItemWrapper(HelpTreeUtils.getItemForTreeNode(treeNode));
        }
        String string5 = HTMLUtils.getSource(string);
        if (string5 != null && (n = string5.indexOf("<!-- SYNCHTO")) != -1) {
            String string6;
            String string7 = string5.substring(n + 13, string5.indexOf("-->", n - 1)).trim();
            File file = new File(string4);
            String string8 = HTMLUtils.getFilenameFromURL(file.getParent() + "/" + string7);
            treeNode = this.fSynchronizerContentsData.getNodeForFileName(string8, string6 = HTMLUtils.getAnchorFromURL(string7));
            if (treeNode != null) {
                return new HelpTreeItemWrapper(HelpTreeUtils.getItemForTreeNode(treeNode), true);
            }
        }
        return null;
    }

    private HelpTreeItemWrapper getDemoTreeItemForUrl(String string) {
        String string2 = HTMLUtils.getCanonicalUrl(string);
        DemoTreeItem demoTreeItem = HelpSynchronizer.getDemoTreeItem(string2);
        if (demoTreeItem != null) {
            String string3 = demoTreeItem.getProduct();
            if (string3 != null && !this.fSynchronizerContentsData.isProductLoaded(string3)) {
                this.fSynchronizerContentsData.loadProductNodeInfo(string3);
            }
            return new HelpTreeItemWrapper(HelpTreeUtils.getItemForTreeNode(demoTreeItem));
        }
        return null;
    }

    private static void registerDemoTreeItem(DemoTreeItem demoTreeItem) {
        if (demoTreeItem == null) {
            return;
        }
        String string = DemoInfoUtils.getFileForDisplay(demoTreeItem, HelpUtils.getDemosDirectoryName());
        if (string != null && string.length() != 0) {
            string = HTMLUtils.getCanonicalUrl(string);
            HelpSynchronizer.addDemoTreeItem(string, demoTreeItem);
        }
    }

    private static void addDemoTreeItem(String string, DemoTreeItem demoTreeItem) {
        if (fDemoMap.containsKey(string)) {
            fDemoMap.remove(string);
        }
        fDemoMap.put(string, demoTreeItem);
    }

    private static DemoTreeItem getDemoTreeItem(String string) {
        return fDemoMap.get(string);
    }

    private String getCorrectUrlForProduct(String string) {
        String string2 = null;
        String string3 = this.fSynchronizerHelpInfo.getProductNameForFilename(string);
        if (string3 != null) {
            String string4 = this.fSynchronizerHelpInfo.getRelativePath(string);
            if (string4 != null && (string2 = this.fSynchronizerHelpInfo.getHelpLocation(string3)) != null) {
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                string2 = string2 + HTMLUtils.getFilenameFromURL(string4);
            }
        } else {
            string2 = HTMLUtils.getFilenameFromURL(string2);
        }
        return string2;
    }

    private static SynchronizerHelpInfo getSynchronizerHelpInfo() {
        if (sTestHelpInfo == null) {
            return new SynchronizerHelp();
        }
        return sTestHelpInfo;
    }

    private static SynchronizerContentsData getSynchronizerContentsData() {
        if (sTestContentsData == null) {
            return new SynchronizerContents();
        }
        return sTestContentsData;
    }

    private static void setTestHelpInfo(SynchronizerHelpInfo synchronizerHelpInfo) {
        sTestHelpInfo = synchronizerHelpInfo;
    }

    private static void setTestContentsData(SynchronizerContentsData synchronizerContentsData) {
        sTestContentsData = synchronizerContentsData;
    }

    private boolean compareStreamingText(String string) {
        String string2 = MLHelpServices.getHtmlText();
        return string2 != null && string2.equalsIgnoreCase(string);
    }

    private boolean isStreamingTextUrl(String string) {
        return string != null && string.startsWith("text:");
    }

    private static class SynchronizerContents
    implements SynchronizerContentsData {
        private SynchronizerContents() {
        }

        @Override
        public TreeNode getNodeForFileName(String string, String string2) {
            return ContentsData.getNodeForFileName(string, string2);
        }

        @Override
        public boolean isProductLoaded(String string) {
            return ContentsData.isProductLoaded(string);
        }

        @Override
        public void loadProductNodeInfo(String string) {
            ContentsData.loadProductNodeInfo(string);
        }
    }

    public static interface SynchronizerContentsData {
        public TreeNode getNodeForFileName(String var1, String var2);

        public boolean isProductLoaded(String var1);

        public void loadProductNodeInfo(String var1);
    }

    private static class SynchronizerHelp
    implements SynchronizerHelpInfo {
        private SynchronizerHelp() {
        }

        @Override
        public String getHelpLocation(String string) {
            return HelpInfo.getHelpLocation(string);
        }

        @Override
        public String getProductNameForFilename(String string) {
            return HelpInfo.getProductNameForFilename(string);
        }

        @Override
        public String getRelativePath(String string) {
            return HelpInfo.getRelativePath(string);
        }
    }

    public static interface SynchronizerHelpInfo {
        public String getHelpLocation(String var1);

        public String getProductNameForFilename(String var1);

        public String getRelativePath(String var1);
    }

    private class HelpSynchronizerPageChangedListener
    implements PageChangedListener {
        private HelpSynchronizerPageChangedListener() {
        }

        @Override
        public void pageChanged(PageChangedListener.PageChangedEvent pageChangedEvent) {
            if (pageChangedEvent == null) {
                return;
            }
            HelpPanelSyncEvent helpPanelSyncEvent = HelpSynchronizer.this.getSyncEventForUrl(pageChangedEvent.getFullUrl(), pageChangedEvent.getTitle());
            if (helpPanelSyncEvent != null) {
                HelpSynchronizer.this.notifyAllHelpSyncListeners(helpPanelSyncEvent);
            }
        }
    }

    private class CompareVisitor
    implements HelpTreeItemVisitor {
        private String iUrl;
        private boolean iEqual = false;

        CompareVisitor(String string) {
            this.iUrl = string;
        }

        @Override
        public void visit(ProductHelpTreeItem productHelpTreeItem) {
            String string = productHelpTreeItem.getFilename();
            if (string != null && string.equalsIgnoreCase(HelpSynchronizer.this.fSynchronizerHelpInfo.getRelativePath(this.iUrl))) {
                this.iEqual = true;
            }
        }

        @Override
        public void visit(ContentsItem contentsItem) {
            String string = contentsItem.getFilename();
            if (string != null && string.equalsIgnoreCase(HelpSynchronizer.this.fSynchronizerHelpInfo.getRelativePath(this.iUrl))) {
                this.iEqual = true;
            }
        }

        @Override
        public void visit(DemoTreeItem demoTreeItem) {
            if (DemoInfoUtils.getIdentifierForTreeNode(demoTreeItem).equalsIgnoreCase(HelpSynchronizer.this.fCurrentDemoId)) {
                this.iEqual = true;
            }
        }

        @Override
        public void visit(ReferenceItem referenceItem) {
            String string = referenceItem.getFilename();
            if (string != null && string.equalsIgnoreCase(HelpSynchronizer.this.fSynchronizerHelpInfo.getRelativePath(this.iUrl))) {
                this.iEqual = true;
            }
        }

        public boolean isEqual() {
            return this.iEqual;
        }
    }

    private static class HelpTreeItemWrapper {
        private final HelpTreeItem iHelpTreeItem;
        private final boolean iSyncToTag;

        HelpTreeItemWrapper(HelpTreeItem helpTreeItem) {
            this(helpTreeItem, false);
        }

        HelpTreeItemWrapper(HelpTreeItem helpTreeItem, boolean bl) {
            this.iHelpTreeItem = helpTreeItem;
            this.iSyncToTag = bl;
        }

        HelpTreeItem getHelpTreeItem() {
            return this.iHelpTreeItem;
        }

        boolean isSyncToTag() {
            return this.iSyncToTag;
        }
    }
}

