/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search;

import com.mathworks.mlwidgets.help.HelpUtils;
import com.mathworks.mlwidgets.help.search.SearchException;

public class SearchStringParseException
extends SearchException {
    public static final int MISMATCHED_QUOTES = 0;
    public static final int TOO_FEW_CHARS = 1;
    public static final int TOO_FEW_NONWILDCARD_CHARS = 2;
    public static final int UNKNOWN_ERROR = 3;
    public static final int WILDCARD_IN_EXACT_PHRASE = 4;
    public static final int STARTS_WITH_WILDCARD = 5;
    public static final int ILLEGAL_FIELD_WEIGHT = 6;
    public static final int UNKNOWN_SEARCH_FIELD = 7;

    public SearchStringParseException(int n) {
        super(SearchStringParseException.getErrorMessage(n), SearchStringParseException.getTopicKey(n));
    }

    public SearchStringParseException(int n, Throwable throwable) {
        super(SearchStringParseException.getErrorMessage(n), SearchStringParseException.getTopicKey(n), throwable);
    }

    private static String getErrorMessage(int n) {
        String string;
        switch (n) {
            case 0: {
                string = "search.error_mismatched_quotes";
                break;
            }
            case 1: {
                string = "search.error_too_few_chars";
                break;
            }
            case 2: {
                string = "search.error_too_few_nonwildcard_chars";
                break;
            }
            case 4: {
                string = "search.error_wildcard_in_exact_phrase";
                break;
            }
            case 5: {
                string = "search.error_starts_with_wildcard";
                break;
            }
            default: {
                string = "search.general_error";
            }
        }
        return HelpUtils.getLocalizedString(string);
    }

    private static String getTopicKey(int n) {
        switch (n) {
            case 0: {
                return "matlab_env_helpsearch_unmatched_quote";
            }
            case 1: {
                return "matlab_env_helpsearch_invalid_term";
            }
            case 2: {
                return "matlab_env_helpsearch_wildcard_error";
            }
            case 4: {
                return "matlab_env_helpsearch_wildcards_exact";
            }
            case 5: {
                return "matlab_env_helpsearch_wildcard_initialerror";
            }
        }
        return SearchStringParseException.getDefaultTopicKey();
    }
}

