/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.help.search.lucene;

import com.mathworks.mlwidgets.help.search.DocSearchField;
import com.mathworks.mlwidgets.html.LanguageLocale;
import java.io.Reader;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharTokenizer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;

public class AnalyzerSource {
    private Analyzer fAnalyzer;

    AnalyzerSource(LanguageLocale languageLocale) {
        this.fAnalyzer = AnalyzerSource.getAnalyzer(languageLocale);
    }

    private static Analyzer getAnalyzer(LanguageLocale languageLocale) {
        switch (languageLocale) {
            case JAPANESE: 
            case SIMPLIFIED_CHINESE: {
                return new HelpAnalyzer((Analyzer)new CJKAnalyzer());
            }
        }
        return new HelpAnalyzer(new EnglishAnalyzer());
    }

    Analyzer getIndexAnalyzer() {
        return this.fAnalyzer;
    }

    Analyzer getSearchAnalyzer() {
        return this.fAnalyzer;
    }

    private static class LetterDigitTokenizer
    extends CharTokenizer {
        private LetterDigitTokenizer(Reader reader) {
            super(reader);
        }

        protected boolean isTokenChar(char c) {
            return Character.isLetter(c) || Character.isDigit(c);
        }
    }

    private static class EnglishAnalyzer
    extends Analyzer {
        private EnglishAnalyzer() {
        }

        public TokenStream tokenStream(String string, Reader reader) {
            LetterDigitTokenizer letterDigitTokenizer = new LetterDigitTokenizer(reader);
            return new LowerCaseFilter((TokenStream)letterDigitTokenizer);
        }
    }

    private static class HelpAnalyzer
    extends Analyzer {
        private final Analyzer iBaseAnalyer;

        private HelpAnalyzer(Analyzer analyzer) {
            this.iBaseAnalyer = analyzer;
        }

        public TokenStream tokenStream(String string, Reader reader) {
            if (string.equals(DocSearchField.REFPAGE_ENTITY.getFieldName())) {
                WhitespaceTokenizer whitespaceTokenizer = new WhitespaceTokenizer(reader);
                return new LowerCaseFilter((TokenStream)whitespaceTokenizer);
            }
            return this.iBaseAnalyer.tokenStream(string, reader);
        }
    }
}

