/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.html;

import com.mathworks.help.helpui.HelpBrowserUtils;
import com.mathworks.help.helpui.SearchHelper;
import com.mathworks.helpsearch.DocSearchEngineFactory;
import com.mathworks.helpsearch.DocumentationQuery;
import com.mathworks.helpsearch.DocumentationSearchResult;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.SearchConfig;
import com.mathworks.helpsearch.SearchEngineDocSearcher;
import com.mathworks.helpsearch.SearchHighlight;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductFilter;
import com.mathworks.html.BrowserRequest;
import com.mathworks.html.RequestHandler;
import com.mathworks.mlwidgets.help.HelpPrefs;
import com.mathworks.mlwidgets.html.HTMLRenderer;
import com.mathworks.mlwidgets.html.HTMLUtils;
import com.mathworks.search.SearchEngine;
import com.mathworks.search.SearchResults;
import com.mathworks.search.SearchStringParseException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;

public class DocSearchRequestHandler
implements RequestHandler {
    private static final String INDEX_FILE = HelpBrowserUtils.getString((String)"helpbrowser.index.file");
    private static final String DOC_CENTER_FILE = HelpBrowserUtils.getString((String)"helpbrowser.doccenter.file");
    private static final String QUERY_STRING_QDOC_FIELD = "qdoc";
    private static final int SEARCH_RESULTS_START_POS = 0;
    private static final int NUM_SEARCH_RESULTS = 100;
    private static String sLocalhost = "localhost";
    private final HTMLRenderer fRenderer;
    private final SearchConfig fSearchConfig;
    private final DocumentationSet fDocumentationSet;
    private ProductFilter fProductFilter;
    private final String fBreadcrumbRoot;

    public DocSearchRequestHandler(HTMLRenderer hTMLRenderer, SearchHelper searchHelper, String string) {
        this.fRenderer = hTMLRenderer;
        this.fSearchConfig = searchHelper.getSearchConfig();
        this.fDocumentationSet = searchHelper.getDocumentationSet();
        this.fProductFilter = searchHelper.getProductFilter();
        this.fBreadcrumbRoot = string;
    }

    protected void handleMatchedUrl(String string) {
        string = HTMLUtils.getUrlStringFromLocation(sLocalhost, string);
        String string2 = HelpBrowserUtils.getQueryStringValue((String)string, (String)QUERY_STRING_QDOC_FIELD);
        String string3 = this.buildSearchPageHtml(string2);
        this.fRenderer.setHtmlText(string, string3, false);
    }

    private String buildSearchPageHtml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append("<head>");
        stringBuilder.append("<title>Search Results</title>");
        String string2 = "../includes/product/css/";
        stringBuilder.append("<link href='" + string2 + "ice_reset.css' rel='stylesheet' type='text/css'>");
        stringBuilder.append("<link href='" + string2 + "ice_960.css.css' rel='stylesheet' type='text/css'>");
        stringBuilder.append("<link href='" + string2 + "ice_site5.css' rel='stylesheet' type='text/css'>");
        stringBuilder.append("<link href='" + string2 + "ice_doc_center.css' rel='stylesheet' type='text/css'>");
        stringBuilder.append("</head>");
        stringBuilder.append("<body>");
        stringBuilder.append(this.buildSearchPage(string));
        stringBuilder.append("</body>");
        stringBuilder.append("</html>");
        return stringBuilder.toString();
    }

    public boolean handleRequest(BrowserRequest browserRequest) {
        String string = browserRequest.getUrl();
        String string2 = HelpBrowserUtils.getQueryStringValue((String)string, (String)QUERY_STRING_QDOC_FIELD);
        if (string.contains("searchresults.html") && string2 != null) {
            this.handleMatchedUrl(string);
            return true;
        }
        return false;
    }

    private String buildSearchPage(String string) {
        Object object;
        String string2;
        String string3;
        if (string == null) {
            return null;
        }
        try {
            string3 = URLDecoder.decode(string, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string3 = string;
        }
        String string4 = DocSearchRequestHandler.getSearchTerm(string);
        try {
            string2 = URLDecoder.decode(string4, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = string4;
        }
        SearchEngine searchEngine = DocSearchEngineFactory.createSearchEngine((SearchConfig)this.fSearchConfig, (DocumentationSet)this.fDocumentationSet);
        SearchEngineDocSearcher searchEngineDocSearcher = null;
        try {
            object = new DocumentationQuery(string3, this.fDocumentationSet.getFormat());
            searchEngineDocSearcher = new SearchEngineDocSearcher(this.fDocumentationSet, searchEngine, (DocumentationQuery)object);
            searchEngineDocSearcher.setMaxResults(100);
            if (this.fProductFilter != null) {
                searchEngineDocSearcher.addProductFilter(this.fProductFilter);
            }
        }
        catch (SearchStringParseException searchStringParseException) {
            try {
                searchEngine.closeIndex();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        object = new StringBuilder();
        try {
            searchEngineDocSearcher.doSearch();
            SearchResults searchResults = searchEngineDocSearcher.getSearchResults(0, 100);
            ((StringBuilder)object).append(this.getSearchFormHtml(string2));
            ((StringBuilder)object).append(this.getSearchResultHtml((SearchResults<DocumentationSearchResult>)searchResults));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ((StringBuilder)object).toString();
    }

    private String getSearchResultHtml(SearchResults<DocumentationSearchResult> searchResults) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = searchResults.getStart();
        int n2 = n + searchResults.getNumIncluded();
        stringBuilder.append("<div id='results_area'>");
        for (int i = n; i < n2; ++i) {
            stringBuilder.append(this.getResultHtml((DocumentationSearchResult)searchResults.getResult(i)));
        }
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    private String getSearchFormHtml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class='docsearch_container'>");
        stringBuilder.append("<div id='searchform_area'>");
        stringBuilder.append("<form id='docsearch_form' name='docsearch_form' method='get' action='searchresults.html'>");
        stringBuilder.append("<input name='qdoc' id='docsearch' class='textfield' autocomplete='off' value='" + string + "' type='text' />");
        stringBuilder.append("</form>");
        stringBuilder.append("</div>");
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    private String getResultHtml(DocumentationSearchResult documentationSearchResult) {
        List list;
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class='searchResult'>");
        DocProduct docProduct = documentationSearchResult.getProduct();
        String string2 = docProduct != null ? docProduct.getShortName() : "";
        String string3 = documentationSearchResult.getPath();
        String string4 = HelpBrowserUtils.buildDocumentationPath((String)HelpPrefs.getDocCenterRoot(), (DocProduct)docProduct, (String)string3);
        String string5 = this.getTitleHtml(documentationSearchResult.getTitle(), string4);
        stringBuilder.append(string5);
        String string6 = documentationSearchResult.getSummary();
        Boolean bl = string6 != null && string6.length() > 0;
        if (bl.booleanValue()) {
            string = this.getSummaryHtml(string6);
            stringBuilder.append(string);
        }
        string = "";
        String string7 = documentationSearchResult.getDescription();
        if (string7 != null && string7.length() > 0) {
            string = this.getDescriptionHtml(string7);
        } else {
            list = documentationSearchResult.getHighlights();
            string = this.getHighlightsHtml(list);
        }
        stringBuilder.append(string);
        list = documentationSearchResult.getBreadCrumbs();
        stringBuilder.append(this.getBreadcrumbsHtml(list, string2));
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    private String getBreadcrumbsHtml(List<ResultCategory> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class='searchBreadCrumb'>");
        for (ResultCategory resultCategory : list) {
            String string2 = this.getBreadcrumbHtml(resultCategory, string);
            stringBuilder.append(string2);
        }
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    private String getProductBreadcrumbHtml(String string) {
        DocProduct docProduct = this.fDocumentationSet.getProductByIndexString(string);
        return this.getBreadcrumbBasicHtml(docProduct.getDisplayName(), INDEX_FILE, string);
    }

    private String getBreadcrumbBasicHtml(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        String string4 = HelpBrowserUtils.buildDocumentationPath((String)HelpPrefs.getDocCenterRoot(), (DocProduct)this.fDocumentationSet.getProductByIndexString(string3), (String)string2);
        stringBuilder.append("<a href='" + string4 + "'>" + string + "</a>");
        return stringBuilder.toString();
    }

    private String getBreadcrumbHtml(ResultCategory resultCategory, String string) {
        ArrayList<Breadcrumb> arrayList = new ArrayList<Breadcrumb>();
        while (resultCategory != null) {
            arrayList.add(new Breadcrumb(resultCategory.getLabel(), resultCategory.getRelativePath(), string));
            resultCategory = resultCategory.getParent();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getProductBreadcrumbHtml(string));
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            stringBuilder.append(" > ");
            Breadcrumb breadcrumb = (Breadcrumb)arrayList.get(i);
            stringBuilder.append(this.getBreadcrumbBasicHtml(breadcrumb.getLabel(), breadcrumb.getRelativePath(), breadcrumb.getProductShortName()));
        }
        return stringBuilder.toString();
    }

    private String getHighlightsHtml(List<SearchHighlight> list) {
        if (list == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class='searchHighlight'>");
        for (SearchHighlight searchHighlight : list) {
            String string = this.getHighligtHtml(searchHighlight);
            stringBuilder.append(string);
        }
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    private String getHighligtHtml(SearchHighlight searchHighlight) {
        String string = searchHighlight.getHighlightText();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (SearchHighlight.Extent extent : searchHighlight.getExtents()) {
            stringBuilder.append(string.substring(n, extent.getStart()));
            stringBuilder.append("<b>");
            stringBuilder.append(extent.getText());
            stringBuilder.append("</b>");
            n = extent.getEnd();
        }
        stringBuilder.append(string.substring(n));
        return stringBuilder.toString();
    }

    private String getDescriptionHtml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<div class='searchHighlight'>");
        stringBuilder.append(string);
        stringBuilder.append("</div>");
        return stringBuilder.toString();
    }

    private String getSummaryHtml(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<span class='searchSummary'>");
        stringBuilder.append(" - " + string);
        stringBuilder.append("</span>");
        return stringBuilder.toString();
    }

    private String getTitleHtml(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<span class='searchTitle'>");
        stringBuilder.append("<a href='" + string2 + "'>");
        stringBuilder.append(string);
        stringBuilder.append("</a>");
        stringBuilder.append("</span>");
        return stringBuilder.toString();
    }

    private static String getSearchTerm(String string) {
        String[] stringArray;
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray = string.split("\\+")) {
            String[] stringArray2 = string2.split(":");
            if (stringArray2.length != 1) continue;
            stringBuilder.append(string2).append(" ");
        }
        return stringBuilder.toString().trim();
    }

    private static class Breadcrumb {
        private final String iLabel;
        private final String iRelativePath;
        private final String iProductShortName;

        private Breadcrumb(String string, String string2, String string3) {
            this.iLabel = string;
            this.iRelativePath = string2;
            this.iProductShortName = string3;
        }

        private String getLabel() {
            return this.iLabel;
        }

        private String getRelativePath() {
            return this.iRelativePath;
        }

        private String getProductShortName() {
            return this.iProductShortName;
        }
    }
}

