/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.inspector.types;

import com.jidesoft.icons.IconsFactory;
import com.mathworks.beans.editors.EditorContext;
import com.mathworks.beans.editors.EnhancedPropertyEditor;
import com.mathworks.beans.editors.IEditorContextSupport;
import com.mathworks.mlwidgets.inspector.HelpAction;
import com.mathworks.mlwidgets.inspector.Resources;
import com.mathworks.mlwidgets.inspector.colorarrayeditor.ColorArrayEditorDialog;
import com.mathworks.mlwidgets.inspector.types.ColorArray;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Action;

public class ColorArrayEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor,
IEditorContextSupport {
    private volatile EditorContext context;
    private volatile Frame frame;
    private static final Image icon = IconsFactory.getImageIcon(Resources.class, (String)"resources/ColorArrayIconColor16.gif").getImage();

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Object object = this.getColorArrayValue();
        if (object == null) {
            return;
        }
        assert (object instanceof ColorArray) : object.getClass().getName();
        List<Color> list = ((ColorArray)object).getColors();
        if (list.isEmpty()) {
            return;
        }
        Graphics graphics2 = graphics.create();
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.grow(-3, -2);
        if (list.size() <= 20 && rectangle2.width > 120) {
            rectangle2.width = 120;
        }
        int n = Math.min(list.size(), rectangle2.width);
        int n2 = rectangle2.width / n;
        int n3 = rectangle2.x + 1;
        for (Color color : list) {
            graphics2.setColor(color);
            graphics2.fillRect(n3, rectangle2.y + 1, n2, rectangle2.height - 2);
            n3 += n2;
        }
        graphics2.setColor(Color.black);
        graphics2.drawRect(rectangle2.x, rectangle2.y, n3 - rectangle2.x, rectangle2.height - 1);
        graphics2.setColor(Color.darkGray);
        graphics2.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height, n3, rectangle2.y + rectangle2.height);
        graphics2.drawLine(n3 + 1, rectangle2.y + rectangle2.height, n3 + 1, rectangle2.y + 1);
        graphics2.dispose();
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        Object object;
        Object object2 = this.getColorArrayValue();
        AtomicReference atomicReference = new AtomicReference();
        if (object2 != null) {
            assert (object2 instanceof ColorArray) : object2.getClass().getName();
            object = (ColorArray)object2;
            atomicReference.set(new ArrayList<Color>(((ColorArray)object).getColors()));
        } else {
            atomicReference.set(new ArrayList());
        }
        object = new AtomicReference();
        if (this.context != null && this.context.hasValue("propertyname") && this.context.hasValue("inspectedobjects")) {
            ((AtomicReference)object).set(new HelpAction(this.context.getValue("inspectedobjects"), (String)this.context.getValue("propertyname"), false));
        }
        assert (this.frame != null);
        ColorArrayEditorDialog colorArrayEditorDialog = ColorArrayEditorDialog.newInstance(this.frame, "", Dialog.ModalityType.APPLICATION_MODAL, (Action)((AtomicReference)object).get(), (List)atomicReference.get());
        if (((AtomicReference)object).get() != null) {
            ((HelpAction)((AtomicReference)object).get()).setOwner(colorArrayEditorDialog);
        }
        colorArrayEditorDialog.addWindowListener(new WindowAdapter((AtomicReference)object, colorArrayEditorDialog, object2, atomicReference){
            final /* synthetic */ AtomicReference val$helpActionRef;
            final /* synthetic */ ColorArrayEditorDialog val$dlg;
            final /* synthetic */ Object val$obj;
            final /* synthetic */ AtomicReference val$dataRef;
            {
                this.val$helpActionRef = atomicReference;
                this.val$dlg = colorArrayEditorDialog;
                this.val$obj = object;
                this.val$dataRef = atomicReference2;
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                ((HelpAction)this.val$helpActionRef.get()).setContextHelpWindowSize(this.val$dlg.getWidth(), this.val$dlg.getHeight());
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                if (this.val$dlg.getResult() == 0) {
                    List list;
                    List<Object> list2 = list = this.val$obj != null ? ((ColorArray)this.val$obj).getColors() : Collections.emptyList();
                    if (((Object)list).equals(this.val$dataRef.get())) {
                        return;
                    }
                    ColorArray colorArray = new ColorArray((List)this.val$dataRef.get());
                    ColorArrayEditor.this.setValue(colorArray);
                }
            }
        });
        return colorArrayEditorDialog;
    }

    protected Object getColorArrayValue() {
        return this.getValue();
    }

    public void setContext(EditorContext editorContext) {
        this.context = editorContext;
    }

    public Image getIcon() {
        return icon;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public boolean hasAttachedData() {
        return false;
    }

    public String getDataKey() {
        return null;
    }

    public void setData(Object object) {
    }

    static {
        assert (icon != null);
    }
}

