/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.mlservices.scc;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.common.icons.DialogIcon;
import com.mathworks.fl.i18n.XMLMessageSystem;
import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mlservices.MLHelpServices;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJMultilineLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;

public class SccPrefsPanel
extends MJPanel {
    private static final ResourceBundle sResources = ResourceBundle.getBundle("com.mathworks.mlwidgets.mlservices.scc.resources.RES_MWSCC");
    private static MJPanel sPrefsPanel;
    private static MJComboBox sSourceControlChoice;
    private static String CLEARCASE;
    private static String CHANGEMAN;
    private static String RCS;
    private static String CVS;
    private static final ResourceBundle myBundle;
    private static String sDefaultSystem;
    private static String[] sInternalUnixChoices;
    private static Matlab sMatlab;

    public static MJPanel createPrefsPanel() {
        Object object;
        if (sPrefsPanel != null) {
            sPrefsPanel = null;
        }
        sSourceControlChoice = new MJComboBox();
        sSourceControlChoice.setName("SourceControlCombo");
        sPrefsPanel = new SccPrefsPanel();
        sPrefsPanel.setLayout((LayoutManager)new FormLayout("p,3dlu,p:grow", "p, 4dlu, p, 3dlu, p, 3dlu, p"));
        if (PlatformInfo.isWindows()) {
            new MatlabWorker(){

                public Object runOnMatlabThread() throws Exception {
                    try {
                        return Matlab.mtFeval((String)"verctrl", (Object[])new Object[]{"all_systems"}, (int)1);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }

                public void runOnAWTEventDispatchThread(Object object) {
                    if (object == null) {
                        sSourceControlChoice.addItem((Object)sDefaultSystem);
                        sSourceControlChoice.setSelectedItem((Object)sDefaultSystem);
                    } else {
                        Object[] objectArray = (Object[])object;
                        for (int i = 0; i < objectArray.length; ++i) {
                            sSourceControlChoice.addItem(objectArray[i]);
                        }
                        sSourceControlChoice.addItem((Object)sDefaultSystem);
                        SccPrefsPanel.setSelectionForWindows();
                    }
                }
            }.start();
        } else {
            sSourceControlChoice.addItem((Object)sDefaultSystem);
            sSourceControlChoice.addItem((Object)CLEARCASE);
            sSourceControlChoice.addItem((Object)CVS);
            sSourceControlChoice.addItem((Object)CHANGEMAN);
            sSourceControlChoice.addItem((Object)RCS);
            sSourceControlChoice.addItem((Object)sResources.getString("prefs.customsystem"));
            object = Prefs.getStringPref((String)"SourceControlSystem", (String)sDefaultSystem);
            sSourceControlChoice.setSelectedItem((Object)SccPrefsPanel.translateInternalToDisplayString((String)object));
        }
        object = new CellConstraints();
        MJLabel mJLabel = new MJLabel(sResources.getString("prefs.system.label"));
        mJLabel.setName("SourceControlLabel");
        sPrefsPanel.add((Component)mJLabel, (Object)object.xy(1, 1));
        sPrefsPanel.add((Component)sSourceControlChoice, (Object)object.xy(3, 1));
        if (PlatformInfo.isWindows64()) {
            MJLabel mJLabel2 = new MJLabel((Icon)DialogIcon.WARNING_48x48.getIcon());
            mJLabel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
            sPrefsPanel.add((Component)mJLabel2, (Object)object.xy(1, 3, "right,top"));
            SccPrefsPanel.addWin64Message();
        }
        if (Matlab.isSimulinkAvailable() && PlatformInfo.isWindows() && !PlatformInfo.isWindows64()) {
            SccPrefsPanel.addPerforceMessage(object);
        }
        return sPrefsPanel;
    }

    private static void addPerforceMessage(final CellConstraints cellConstraints) {
        new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                try {
                    return Matlab.mtFeval((String)"winqueryreg", (Object[])new Object[]{"name", "HKEY_LOCAL_MACHINE", "SOFTWARE\\Wow6432Node\\SourceCodeControlProvider\\InstalledSCCProviders"}, (int)1);
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public void runOnAWTEventDispatchThread(Object object) {
                if (object != null) {
                    boolean bl = false;
                    Object[] objectArray = (Object[])object;
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (!String.valueOf(objectArray[i]).toUpperCase().contains("PERFORCE")) continue;
                        bl = true;
                    }
                    if (bl) {
                        MJLabel mJLabel = new MJLabel((Icon)DialogIcon.WARNING_48x48.getIcon());
                        mJLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 8));
                        sPrefsPanel.add((Component)mJLabel, (Object)cellConstraints.xy(1, 3, "right,top"));
                        CellConstraints cellConstraints2 = new CellConstraints();
                        String string = sResources.getString("warning.PerforceDetectedError");
                        MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(string, true);
                        mJMultilineLabel.setFont(mJMultilineLabel.getFont().deriveFont(1));
                        sPrefsPanel.add((Component)mJMultilineLabel, (Object)cellConstraints2.xy(3, 3));
                        sPrefsPanel.validate();
                    }
                }
            }
        }.start();
    }

    private static void addWin64Message() {
        new MatlabWorker(){

            public Object runOnMatlabThread() throws Exception {
                try {
                    return Matlab.mtFeval((String)"winqueryreg", (Object[])new Object[]{"name", "HKEY_LOCAL_MACHINE", "SOFTWARE\\Wow6432Node\\SourceCodeControlProvider\\InstalledSCCProviders"}, (int)1);
                }
                catch (Exception exception) {
                    return null;
                }
            }

            public void runOnAWTEventDispatchThread(Object object) {
                CellConstraints cellConstraints = new CellConstraints();
                String string = sResources.getString("prefs.win64message1");
                MJMultilineLabel mJMultilineLabel = new MJMultilineLabel(string, true);
                mJMultilineLabel.setFont(mJMultilineLabel.getFont().deriveFont(1));
                sPrefsPanel.add((Component)mJMultilineLabel, (Object)cellConstraints.xy(3, 3));
                if (object == null) {
                    string = sResources.getString("prefs.win64genericmessage2");
                    sPrefsPanel.add((Component)new MJMultilineLabel(string, true), (Object)cellConstraints.xy(3, 5));
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    Object[] objectArray = (Object[])object;
                    for (int i = 0; i < objectArray.length; ++i) {
                        stringBuffer.append(objectArray[i]);
                        stringBuffer.append("\n");
                    }
                    string = MessageFormat.format(sResources.getString("prefs.win64specificmessage2"), stringBuffer.toString());
                    sPrefsPanel.add((Component)new MJMultilineLabel(string, true), (Object)cellConstraints.xy(3, 5));
                }
                sPrefsPanel.validate();
            }
        }.start();
    }

    public static void commitPrefsChanges(boolean bl) {
        if (bl) {
            if (PlatformInfo.isUnix()) {
                Prefs.setStringPref((String)"SourceControlSystem", (String)SccPrefsPanel.translateDisplayToInternalString(sSourceControlChoice.getSelectedIndex()));
            } else {
                String string = (String)sSourceControlChoice.getSelectedItem();
                if (string.equals(sDefaultSystem)) {
                    Prefs.setStringPref((String)"SourceControlSystem", (String)sDefaultSystem);
                } else {
                    Prefs.setStringPref((String)"SourceControlSystem", (String)string);
                }
            }
        }
    }

    private static void setSelectionForWindows() {
        String string = Prefs.getStringPref((String)"SourceControlSystem", (String)sDefaultSystem);
        if (string.equals(sDefaultSystem)) {
            sSourceControlChoice.setSelectedItem((Object)sDefaultSystem);
        } else {
            sSourceControlChoice.setSelectedItem((Object)string);
            if (!sSourceControlChoice.getSelectedItem().equals(string)) {
                sSourceControlChoice.setSelectedItem((Object)sDefaultSystem);
            }
        }
    }

    private static String translateDisplayToInternalString(int n) {
        switch (n) {
            case 0: {
                return sInternalUnixChoices[0];
            }
            case 1: {
                return sInternalUnixChoices[1];
            }
            case 2: {
                return sInternalUnixChoices[2];
            }
            case 3: {
                return sInternalUnixChoices[3];
            }
            case 4: {
                return sInternalUnixChoices[4];
            }
            case 5: {
                return sInternalUnixChoices[5];
            }
        }
        return sInternalUnixChoices[0];
    }

    public static String[] returnUnixDisplayStrings() {
        return sInternalUnixChoices;
    }

    private static String translateInternalToDisplayString(String string) {
        if (string.compareTo("none") == 0) {
            return sDefaultSystem;
        }
        if (string.compareTo("clearcase") == 0) {
            return CLEARCASE;
        }
        if (string.compareTo("pvcs") == 0) {
            return CHANGEMAN;
        }
        if (string.compareTo("rcs") == 0) {
            return RCS;
        }
        if (string.compareTo("customverctrl") == 0) {
            return sResources.getString("prefs.customsystem");
        }
        if (string.compareTo("cvs") == 0) {
            return CVS;
        }
        return sDefaultSystem;
    }

    public static String[] getHelpInfo() {
        return new String[]{MLHelpServices.getMapfileName((String)"matlab", (String)"matlab_env"), "matlab_env_sourcecontrol_prefs"};
    }

    static {
        CLEARCASE = "IBM Rational ClearCase";
        CHANGEMAN = "ChangeMan (Serena)";
        RCS = "RCS";
        CVS = "CVS";
        myBundle = XMLMessageSystem.getBundle((String)"MATLAB:sourceControl");
        sDefaultSystem = myBundle.getString("none");
        sInternalUnixChoices = new String[]{"none", "clearcase", "cvs", "pvcs", "rcs", "customverctrl"};
        sMatlab = new Matlab();
    }
}

