/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mlwidgets.prefs.binding;

import com.jidesoft.shortcut.KeyboardShortcut;
import com.jidesoft.shortcut.ShortcutField;
import com.jidesoft.swing.OverlayTextField;
import com.mathworks.common.icons.MiscellaneousIcon;
import com.mathworks.mlwidgets.prefs.binding.TabActionHandler;
import com.mathworks.mwswing.ControlKeyOverride;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.PopupListener;
import com.mathworks.mwswing.binding.KeyStrokeList;
import com.mathworks.mwswing.binding.KeyStrokeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CustomShortcutField
extends ShortcutField {
    static final String SHORTCUT_FIELD_ACC_NAME = "Field for typing keyboard shortcut";
    private boolean fIgnoreFocusRequest = false;
    private final TabActionHandler fTabActionHandler;

    public CustomShortcutField(KeyStrokeList keyStrokeList, TabActionHandler tabActionHandler) {
        super(1);
        this.fTabActionHandler = tabActionHandler;
        this.setIcon(MiscellaneousIcon.KEYBOARD_KEY_WITH_DROPDOWN.getIcon());
        this.getAccessibleContext().setAccessibleName(SHORTCUT_FIELD_ACC_NAME);
        this.setMaximumAllowedKeystrokes(3);
        this.getTextField().setOpaque(false);
        this.typeKeyBinding(keyStrokeList);
    }

    protected void initComponent() {
        KeyStroke keyStroke = this.getContextMenuKeyStroke();
        super.initComponent();
        this.setContextMenuKeyStroke(keyStroke);
    }

    public void setNextFocusableComponent(Component component) {
        super.setNextFocusableComponent(component);
        this.getTextField().setNextFocusableComponent(component);
    }

    protected JTextField createTextField() {
        return new CustomOverlayTextField();
    }

    protected KeyboardShortcut createKeyboardShortcut() {
        return new CustomKeyboardShortcut();
    }

    void typeKeyBinding(KeyStrokeList keyStrokeList) {
        this.fIgnoreFocusRequest = true;
        this.clearShortcut();
        if (keyStrokeList != null) {
            if (!keyStrokeList.isMultiStroke()) {
                this.setAllowedKeystrokes(1);
            } else {
                assert (keyStrokeList.getKeyStrokes().size() <= 3) : "GUI doesn't support multi-stroke keybindings with more than 3 strokes";
                this.setAllowedKeystrokes(keyStrokeList.getKeyStrokes().size());
            }
            for (KeyStroke keyStroke : keyStrokeList.getKeyStrokes()) {
                this.addKeyStroke(keyStroke);
            }
        }
        this.fIgnoreFocusRequest = false;
    }

    private static class CustomKeyboardShortcut
    extends KeyboardShortcut {
        private CustomKeyboardShortcut() {
        }

        public String toString() {
            return KeyStrokeUtils.translateKeyStrokes((KeyStrokeList)new KeyStrokeList(this.getKeyStrokes()));
        }
    }

    private class CustomOverlayTextField
    extends OverlayTextField
    implements ControlKeyOverride {
        private CustomOverlayTextField() {
            String string = "custom-ctrl-tab";
            this.getInputMap(1).put(KeyStroke.getKeyStroke(9, 2), string);
            this.getActionMap().put(string, (Action)new MJAbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CustomShortcutField.this.addKeyStroke(KeyStroke.getKeyStroke(9, 2));
                }
            });
            this.setColumns(10);
            this.addMouseListener((MouseListener)new PopupListener(){

                public void showPopup(MouseEvent mouseEvent) {
                    CustomShortcutField.this.showContextMenu();
                }
            });
        }

        public void requestFocus() {
            if (!CustomShortcutField.this.fIgnoreFocusRequest) {
                super.requestFocus();
            }
        }

        protected void processKeyEvent(KeyEvent keyEvent) {
            CustomShortcutField.this.fTabActionHandler.handleKeyEvent(keyEvent);
            if (!keyEvent.isConsumed()) {
                super.processKeyEvent(keyEvent);
            }
        }

        public boolean wantKey(KeyStroke keyStroke, Component component) {
            return component == this && keyStroke.getKeyCode() == 9;
        }
    }
}

