/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.shared.controllib.databrowser;

import com.mathworks.jmi.Callback;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.page.plottool.ErrorHandler;
import com.mathworks.widgets.datatransfer.MLDataFlavor;
import com.mathworks.widgets.datatransfer.SimpleVariableDefinition;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;

public class FigureDropTargetListener
implements DropTargetListener {
    private final Callback fEventsToMATLAB = new Callback();

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        if (dropTargetDragEvent.isDataFlavorSupported(MLDataFlavor.simpleVariableListFlavor)) {
            dropTargetDragEvent.acceptDrag(1);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
        if (!dropTargetDragEvent.isDataFlavorSupported(new DataFlavor(UDDObject.class, "UDDObject"))) {
            dropTargetDragEvent.rejectDrag();
        }
        dropTargetDragEvent.acceptDrag(1);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (dropTargetDropEvent.isDataFlavorSupported(MLDataFlavor.simpleVariableListFlavor)) {
            SimpleVariableDefinition[] simpleVariableDefinitionArray;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                simpleVariableDefinitionArray = MLDataFlavor.decodeSimpleVariableListFlavor((Transferable)transferable);
            }
            catch (Exception exception) {
                ErrorHandler.showJavaException((String)"SelectionManager.DropListener.drop", (Exception)exception);
                return;
            }
            this.notifyMATLAB(new FigureDropEventData(simpleVariableDefinitionArray));
            return;
        }
        if (dropTargetDropEvent.isDataFlavorSupported(new DataFlavor(UDDObject.class, "UDDObject"))) {
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                String[] stringArray = (String[])transferable.getTransferData(new DataFlavor(String[].class, "StringArray"));
                UDDObject uDDObject = (UDDObject)transferable.getTransferData(new DataFlavor(UDDObject.class, "UDDObject"));
                FigureDropEventData figureDropEventData = new FigureDropEventData(stringArray, uDDObject);
                this.notifyMATLAB(figureDropEventData);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return;
        }
    }

    public Callback getEventsToMATLAB() {
        return this.fEventsToMATLAB;
    }

    public void notifyMATLAB(FigureDropEventData figureDropEventData) {
        this.fEventsToMATLAB.postCallback(new Object[]{figureDropEventData});
    }

    private class FigureDropEventData {
        public UDDObject graphicalcomponent;
        public String[] selected_variables;
        public SimpleVariableDefinition[] simplevariabledefinitions;

        private FigureDropEventData(String[] stringArray, UDDObject uDDObject) {
            this.selected_variables = stringArray;
            this.graphicalcomponent = uDDObject;
        }

        private FigureDropEventData(SimpleVariableDefinition[] simpleVariableDefinitionArray) {
            this.simplevariabledefinitions = simpleVariableDefinitionArray;
            this.selected_variables = null;
            this.graphicalcomponent = null;
        }
    }
}

