/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.system;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public class FileSystem {
    public static void destroy(File file, boolean bl) throws IOException {
        if (!file.exists() || file.delete()) {
            return;
        }
        ArrayList arrayList = bl ? new ArrayList() : null;
        FileSystem.destroyDir(file, arrayList);
        if (arrayList != null && arrayList.size() != 0) {
            StringBuffer stringBuffer = new StringBuffer("couldn't delete:");
            for (int i = 0; i < arrayList.size(); ++i) {
                stringBuffer.append('\n').append(arrayList.get(i));
            }
            throw new IOException(stringBuffer.toString());
        }
    }

    private static void destroyDir(File file, Collection collection) throws IOException {
        if (!file.isDirectory()) {
            FileSystem.handleError(collection, file);
            return;
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file, stringArray[i]);
            if (file2.delete()) continue;
            FileSystem.destroyDir(file2, collection);
        }
        if (!file.delete()) {
            FileSystem.handleError(collection, file);
        }
    }

    private static void handleError(Collection collection, File file) throws IOException {
        if (collection == null) {
            throw new IOException("couldn't delete " + file);
        }
        collection.add(file);
    }

    public static void ensureDir(String string) throws IllegalArgumentException {
        File file = new File(string);
        if (file.isDirectory()) {
            return;
        }
        if (file.exists()) {
            throw new IllegalArgumentException(string + " exists, but not a dir");
        }
        if (!file.mkdirs()) {
            throw new IllegalArgumentException(string + ": cannot create");
        }
    }
}

