/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public final class DiscoveryPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -3036978025008149170L;

    public DiscoveryPermission(String string) {
        super(string == null ? "" : string);
        if (string == null) {
            string = "";
        } else if (string.startsWith("*") && string.length() != 1 && (string.length() <= 2 || !string.startsWith("*."))) {
            throw new IllegalArgumentException("invalid group wildcard specification");
        }
    }

    public DiscoveryPermission(String string, String string2) {
        this(string);
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof DiscoveryPermission)) {
            return false;
        }
        String string = permission.getName();
        String string2 = this.getName();
        if (string2.startsWith("*")) {
            if (string2.length() == 1) {
                return true;
            }
            if (string.length() == 1) {
                return false;
            }
            return string.length() >= string2.length() && string2.regionMatches(false, 2, string, string.length() - string2.length() + 2, string2.length() - 2);
        }
        if (string.startsWith("*")) {
            return false;
        }
        return string2.equals(string);
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DiscoveryPermission && this.getName().equals(((DiscoveryPermission)object).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new Collection();
    }

    private static class Collection
    extends PermissionCollection {
        private static final long serialVersionUID = -6656227831159479611L;
        private final ArrayList perms = new ArrayList(3);

        private Collection() {
        }

        public synchronized void add(Permission permission) {
            if (this.isReadOnly()) {
                throw new SecurityException("collection is read-only");
            }
            if (this.perms.indexOf(permission) < 0) {
                this.perms.add(permission);
            }
        }

        public synchronized boolean implies(Permission permission) {
            int n = this.perms.size();
            while (--n >= 0) {
                if (!((Permission)this.perms.get(n)).implies(permission)) continue;
                return true;
            }
            return false;
        }

        public Enumeration elements() {
            return Collections.enumeration(this.perms);
        }
    }
}

