/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mvm;

import com.mathworks.mvm.MVM;
import com.mathworks.mvm.MvmImpl;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class MvmFactory {
    private FactoryType fType;
    private long fFactoryHandle;
    private static final Object LOCK = new Object();
    private static HashMap<Long, WeakReference<MVM>> sMvmMap = null;
    private static MvmFactory sLocalFactory = null;

    public FactoryType getType() {
        return this.fType;
    }

    public static MvmFactory get(FactoryType factoryType, Object object) {
        if (factoryType == FactoryType.LOCAL) {
            return MvmFactory.getLocal();
        }
        return new MvmFactory(factoryType, object);
    }

    private MvmFactory(FactoryType factoryType, Object object) {
        this.fFactoryHandle = MvmFactory.nativeCreateFactory(factoryType.getValue(), object);
        this.fType = factoryType;
        assert (factoryType != FactoryType.LOCAL || sLocalFactory == null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MvmFactory getLocal() {
        Class<MvmFactory> clazz = MvmFactory.class;
        synchronized (MvmFactory.class) {
            if (sLocalFactory != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return sLocalFactory;
            }
            sLocalFactory = new MvmFactory(FactoryType.LOCAL, null);
            // ** MonitorExit[var0] (shouldn't be in output)
            return sLocalFactory;
        }
    }

    public MVM getMVM(Object object) {
        long l = MvmFactory.nativeCreateMVM(this.fFactoryHandle, object);
        return MvmFactory.getOrCreate(l);
    }

    public static MVM getCurrentMVM() throws IllegalStateException {
        long l = MvmFactory.nativeGetCurrentMvmHandle();
        return MvmFactory.getOrCreate(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MVM getOrCreate(long l) {
        Object object = LOCK;
        synchronized (object) {
            MVM mVM = MvmFactory.getMVM(l);
            if (mVM == null) {
                mVM = new MvmImpl(l);
                MvmFactory.addToMap(l, mVM);
            }
            return mVM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MVM getMVM(long l) {
        Object object = LOCK;
        synchronized (object) {
            if (sMvmMap == null) {
                return null;
            }
            WeakReference<MVM> weakReference = sMvmMap.get(l);
            if (weakReference == null) {
                return null;
            }
            return (MVM)weakReference.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addToMap(long l, MVM mVM) {
        Object object = LOCK;
        synchronized (object) {
            if (sMvmMap == null) {
                sMvmMap = new HashMap(5);
            }
            WeakReference<MVM> weakReference = sMvmMap.put(l, new WeakReference<MVM>(mVM));
            assert (weakReference == null || weakReference.get() == null);
        }
    }

    private static native long nativeCreateFactory(int var0, Object var1);

    private static native long nativeCreateMVM(long var0, Object var2);

    private static native long nativeGetCurrentMvmHandle() throws IllegalStateException;

    static {
        MvmImpl.loadLibrary();
    }

    public static enum FactoryType {
        LOCAL(1),
        REMOTE(2),
        NETWORK(3);

        private final int fValue;

        private FactoryType(int n2) {
            this.fValue = n2;
        }

        int getValue() {
            return this.fValue;
        }
    }
}

