/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide;

import com.mathworks.hg.types.HGColor;
import com.mathworks.toolbox.matlab.guide.LayoutArea;
import java.util.Hashtable;

public class LayoutOptions {
    private Hashtable fOptionTable = new Hashtable(15);
    private LayoutArea fLayoutArea;
    public static String sAccessibility = "accessibility";
    public static String sCreateCallback = "callbacks";
    public static String sOverride = "override";
    public static String sReleaseNumber = "release";
    public static String sResizePolicy = "resize";
    public static String sSingleton = "singleton";
    public static String sUseSystemColor = "syscolorfig";
    static String sSystemColor = "systemcolor";
    public static String sUseMFile = "mfile";
    public static String ACCESSIBILITY_CALLBACK = "callback";
    public static String ACCESSIBILITY_ON = "on";
    public static String ACCESSIBILITY_OFF = "off";
    public static String ACCESSIBILITY_CUSTOM = "custom";
    public static String RESIZE_NONE = "none";
    public static String RESIZE_PROPORTIONAL = "simple";
    public static String RESIZE_SPECIFIED = "custom";

    public LayoutOptions(Object[] objectArray, Object[] objectArray2, LayoutArea layoutArea) {
        this.fLayoutArea = layoutArea;
        this.setOptions(objectArray, objectArray2);
    }

    public LayoutArea getLayoutArea() {
        return this.fLayoutArea;
    }

    public void setOptions(Object[] objectArray, Object[] objectArray2) {
        if (objectArray != null && objectArray2 != null && objectArray.length == objectArray2.length) {
            boolean bl = this.isUseSystemColor();
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray2[i] == null || objectArray[i] == null) continue;
                this.fOptionTable.put(objectArray[i], objectArray2[i]);
            }
            if (!bl && this.isUseSystemColor() && this.fLayoutArea != null) {
                this.fLayoutArea.fireOptionsChange();
            }
        }
    }

    public Object getOption(Object object) {
        return this.fOptionTable.get(object);
    }

    public boolean isUseSystemColor() {
        return this.returnBooleanOption(this.getOption(sUseSystemColor));
    }

    HGColor getSystemColor() {
        HGColor hGColor = null;
        double[] dArray = (double[])this.getOption(sSystemColor);
        if (dArray != null) {
            hGColor = new HGColor(dArray[0], dArray[1], dArray[2]);
        }
        return hGColor;
    }

    public boolean isCreateCallback() {
        return this.returnBooleanOption(this.getOption(sCreateCallback));
    }

    public boolean isSingleton() {
        return this.returnBooleanOption(this.getOption(sSingleton));
    }

    public boolean isMfileMode() {
        return this.returnBooleanOption(this.getOption(sUseMFile));
    }

    public boolean isOverride() {
        return this.returnBooleanOption(this.getOption(sOverride));
    }

    private boolean returnBooleanOption(Object object) {
        boolean bl = false;
        if (object != null) {
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                bl = dArray[0] != 0.0;
            } else {
                try {
                    double d = new Double(object.toString());
                    bl = d != 0.0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    public double getReleaseNumber() {
        double d = -1.0;
        Object object = this.getOption(sReleaseNumber);
        if (object != null) {
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                d = dArray[0];
            } else {
                try {
                    double d2;
                    d = d2 = new Double(object.toString()).doubleValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return d;
    }

    public String getResizePolicy() {
        String string = null;
        Object object = this.getOption(sResizePolicy);
        if (object != null && object instanceof String[] && ((String[])object).length > 0) {
            string = ((String[])object)[0];
        }
        return string;
    }

    public String getAccessibility() {
        String string = null;
        Object object = this.getOption(sAccessibility);
        if (object != null && object instanceof String[] && ((String[])object).length > 0) {
            string = ((String[])object)[0];
        }
        return string;
    }
}

