/*
 * Decompiled with CFR 0.152.
 */
package ice.scripters.js;

import ice.debug.Debug;
import ice.scripters.js.TheScripter;
import ice.storm.DynEnv;
import ice.storm.DynamicObject;
import ice.storm.Scripter;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.Wrapper;

final class EcmaEnv
extends DynEnv {
    private TheScripter OEAB;

    EcmaEnv(TheScripter theScripter) {
        this.OEAB = theScripter;
    }

    public Scripter getScripter() {
        return this.OEAB;
    }

    public RuntimeException wrapException(Exception exception) {
        return WrappedException.wrapException(exception);
    }

    public Integer wrapInt(int n) {
        return new Integer(n);
    }

    public Object wrapLong(long l) {
        return new Double(l);
    }

    public Object wrapDouble(double d) {
        return new Double(d);
    }

    public Object wrapMethod(DynamicObject dynamicObject, String string) {
        return this.OEAB.wrapDynamicMethod(dynamicObject, string);
    }

    public Object wrapDynamic(DynamicObject dynamicObject) {
        return this.OEAB.wrapDynamicObject(dynamicObject);
    }

    public Object wrapGeneralObject(Object object) {
        if (object instanceof DynamicObject) {
            Debug.bug();
        }
        if (object instanceof String) {
            Debug.bug();
        }
        return object;
    }

    public Object wrapVoid() {
        return null;
    }

    public Object wrapEventHandler(DynamicObject dynamicObject, Object object) {
        return this.OEAB.wrapEventHandler(dynamicObject, object);
    }

    public boolean toBoolean(Object object) {
        return ScriptRuntime.toBoolean(object);
    }

    public double toDouble(Object object) {
        return ScriptRuntime.toNumber(object);
    }

    public int toInt(Object object) {
        long l = this.toPossibleInt(object);
        if (l >= 0L) {
            return (int)l;
        }
        throw TheScripter.ecmaError("msg.conversion.not.allowed", ScriptRuntime.toString(object), "int");
    }

    public long toPossibleInt(Object object) {
        int n;
        double d;
        if (object != null && (d = this.toDouble(object)) == d && !Double.isInfinite(d) && (double)(n = (int)(d = d > 0.0 ? Math.floor(d) : Math.ceil(d))) == d) {
            return 0xFFFFFFFFL & (long)n;
        }
        return -1L;
    }

    public int checkBound(int n, int n2, int n3) {
        if (n2 <= n && n <= n3) {
            return n;
        }
        throw TheScripter.ecmaError("msg.conversion.not.allowed", Integer.toString(n), "int in [" + n2 + "," + n3 + "]");
    }

    public long toLong(Object object) {
        long l;
        double d = this.toDouble(object);
        if (d == d && !Double.isInfinite(d) && (double)(l = (long)(d = d > 0.0 ? Math.floor(d) : Math.ceil(d))) == d) {
            return l;
        }
        throw TheScripter.ecmaError("msg.conversion.not.allowed", ScriptRuntime.toString(object), "long");
    }

    public String toStr(Object object) {
        if (object == null || object == Undefined.instance) {
            return null;
        }
        return ScriptRuntime.toString(object);
    }

    public Object toNative(Object object) {
        if (object instanceof Wrapper) {
            object = ((Wrapper)object).unwrap();
        }
        return object;
    }

    public boolean toBoolean(Object[] objectArray, int n) {
        return n < objectArray.length ? this.toBoolean(objectArray[n]) : false;
    }

    public double toDouble(Object[] objectArray, int n) {
        return n < objectArray.length ? this.toDouble(objectArray[n]) : Double.NaN;
    }

    public int toInt(Object[] objectArray, int n) {
        return n < objectArray.length ? this.toInt(objectArray[n]) : 0;
    }

    public long toLong(Object[] objectArray, int n) {
        return n < objectArray.length ? this.toLong(objectArray[n]) : 0L;
    }

    public String toStr(Object[] objectArray, int n) {
        return n < objectArray.length ? this.toStr(objectArray[n]) : null;
    }

    public Object toNative(Object[] objectArray, int n) {
        return n < objectArray.length ? this.toNative(objectArray[n]) : null;
    }

    public Object getRawObject(Object[] objectArray, int n) {
        return n < objectArray.length ? objectArray[n] : Undefined.instance;
    }

    public int nativeIndexTest(Object object) {
        String string = ScriptRuntime.toString(object);
        double d = ScriptRuntime.toNumber(string);
        long l = ScriptRuntime.toUint32(d);
        if (l <= Integer.MAX_VALUE && (double)l == d && ScriptRuntime.numberToString(d, 10).equals(string)) {
            return (int)l;
        }
        return -1;
    }
}

