/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.jniwrapper.win32.ie.KeyFilter;
import com.mathworks.html.HtmlFindInPage;
import com.mathworks.html.jxbrowser.BrowserTypeConfig;
import com.mathworks.html.jxbrowser.IEFindInPage;
import com.mathworks.html.jxbrowser.JxBrowserKeyAdapter;
import com.mathworks.html.jxbrowser.JxBrowserPanel;
import com.mathworks.html.jxbrowser.JxBrowserSwingComponent;
import com.teamdev.jxbrowser.Browser;
import com.teamdev.jxbrowser.BrowserType;
import com.teamdev.jxbrowser.ie.IEBrowser;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class IEConfig
implements BrowserTypeConfig {
    private static final MessageFormat EVENT_LISTENER_FORMAT = new MessageFormat("{0}.attachEvent(''{1}'',{2});");

    @Override
    public void configureBrowser(JxBrowserPanel jxBrowserPanel) {
        JxBrowserKeyAdapter jxBrowserKeyAdapter = new JxBrowserKeyAdapter(jxBrowserPanel);
        IEBrowser iEBrowser = IEConfig.getIEBrowser(jxBrowserPanel.getBrowser());
        if (iEBrowser != null) {
            iEBrowser.getPeer().setKeyFilter((KeyFilter)new IEBrowserKeyFilter(jxBrowserPanel, jxBrowserKeyAdapter));
        }
    }

    @Override
    public HtmlFindInPage getFindInPage(JxBrowserPanel jxBrowserPanel) {
        return new IEFindInPage(jxBrowserPanel);
    }

    @Override
    public String getTextSelectionScript() {
        return "document.selection.createRange().text";
    }

    @Override
    public String createAddEventFunction(String string, String string2, String string3) {
        string2 = IEConfig.convertEventTypeForIE(string2);
        Object[] objectArray = new Object[]{string, string2, string3};
        return EVENT_LISTENER_FORMAT.format(objectArray);
    }

    private static String convertEventTypeForIE(String string) {
        if (string.equalsIgnoreCase("mouseup") || string.equalsIgnoreCase("mousedown")) {
            return "on" + string;
        }
        return string;
    }

    @Override
    public String getUrlEncodingCharset() {
        return Charset.defaultCharset().displayName();
    }

    private static IEBrowser getIEBrowser(Browser browser) {
        if (browser != null && browser.getType() == BrowserType.IE && browser instanceof IEBrowser) {
            return (IEBrowser)browser;
        }
        assert (false) : "Cannot cast " + browser + " to IEBrowser";
        return null;
    }

    private static class KeyEventProcessor
    implements Runnable {
        private final JxBrowserSwingComponent iComponent;
        private final KeyListener iListener;
        private final KeyFilter.KeyEvent iKeyEvent;

        private KeyEventProcessor(JxBrowserSwingComponent jxBrowserSwingComponent, KeyListener keyListener, KeyFilter.KeyEvent keyEvent) {
            this.iComponent = jxBrowserSwingComponent;
            this.iListener = keyListener;
            this.iKeyEvent = keyEvent;
        }

        @Override
        public void run() {
            int n = this.getModifiers();
            KeyStroke keyStroke = KeyStroke.getKeyStroke(this.iKeyEvent.getKeyCode(), n);
            KeyEvent keyEvent = new KeyEvent(this.iComponent, 401, System.currentTimeMillis(), n, keyStroke.getKeyCode(), keyStroke.getKeyChar());
            this.iListener.keyTyped(keyEvent);
        }

        private int getModifiers() {
            int n = 0;
            if (this.iKeyEvent.isAltPressed()) {
                n |= 0x200;
            }
            if (this.iKeyEvent.isControlPressed()) {
                n |= 0x80;
            }
            if (this.iKeyEvent.isShiftPressed()) {
                n |= 0x40;
            }
            return n;
        }
    }

    private static class IEBrowserKeyFilter
    implements KeyFilter {
        private final JxBrowserPanel iPanel;
        private final KeyListener iListener;

        private IEBrowserKeyFilter(JxBrowserPanel jxBrowserPanel, KeyListener keyListener) {
            this.iPanel = jxBrowserPanel;
            this.iListener = keyListener;
        }

        public boolean isFilter(KeyFilter.KeyEvent keyEvent) {
            KeySuppressOption keySuppressOption = IEBrowserKeyFilter.getKeySuppressOption(keyEvent);
            switch (keySuppressOption) {
                case SUPPRESS_FULLY: {
                    return true;
                }
                case SUPPRESS_IE_BEHAVIOR: {
                    SwingUtilities.invokeLater(new KeyEventProcessor(this.iPanel.getComponent(), this.iListener, keyEvent));
                    return true;
                }
            }
            return false;
        }

        private static KeySuppressOption getKeySuppressOption(KeyFilter.KeyEvent keyEvent) {
            boolean bl;
            boolean bl2 = bl = keyEvent.getKeyCode() == 70;
            if (keyEvent.isControlPressed() && bl) {
                return KeySuppressOption.SUPPRESS_IE_BEHAVIOR;
            }
            return KeySuppressOption.ALLOW;
        }
    }

    private static enum KeySuppressOption {
        SUPPRESS_FULLY,
        SUPPRESS_IE_BEHAVIOR,
        ALLOW;

    }
}

