/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.html.jxbrowser;

import com.mathworks.html.ProxySettings;
import com.teamdev.jxbrowser.BrowserServices;
import com.teamdev.jxbrowser.proxy.ProxyConfig;
import com.teamdev.jxbrowser.proxy.ProxyServer;
import com.teamdev.jxbrowser.proxy.ServerType;

public class JxBrowserProxyBridge {
    static void init() {
        ProxySettings proxySettings = ProxySettings.getCurrentSettings();
        JxBrowserProxyBridge.updateProxySettings(proxySettings);
        ProxySettings.addProxyListener(new ProxySettings.ProxySettingsListener(){

            @Override
            public void proxySettingsChanged(ProxySettings proxySettings) {
                JxBrowserProxyBridge.updateProxySettings(proxySettings);
            }
        });
    }

    private static void updateProxySettings(ProxySettings proxySettings) {
        ProxyConfig proxyConfig = BrowserServices.getInstance().getProxyConfig();
        if (proxySettings == null) {
            proxyConfig.setAutoDetectForNetwork(true);
        } else {
            ProxyServer proxyServer = JxBrowserProxyBridge.createProxyServer(proxySettings);
            for (ServerType serverType : ServerType.values()) {
                proxyConfig.setProxy(serverType, proxyServer);
            }
        }
    }

    private static ProxyServer createProxyServer(ProxySettings proxySettings) {
        if (proxySettings.getUsername() != null) {
            return new ProxyServer(proxySettings.getHost(), proxySettings.getPort(), proxySettings.getUsername(), proxySettings.getPassword());
        }
        return new ProxyServer(proxySettings.getHost(), proxySettings.getPort());
    }
}

